/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.utils;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateUtility {
    private static final String LOG_TAG = DateUtility.class.getSimpleName();
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZZZZZ";
    public static final String SHIPPING_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ssZZZZZ", "yyyy-MM-dd'T'HH:mm:ss.SSSZ"};

    public static SimpleDateFormat createDefaultDateFormat() {
        return new SimpleDateFormat(DEFAULT_DATE_PATTERN, Locale.US);
    }

    public static String toString(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(DEFAULT_DATE_PATTERN, Locale.US).format(date);
    }

    public static Date toDate(String dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(DEFAULT_DATE_PATTERN, Locale.US).parse(dateString);
        }
        catch (ParseException e) {
            Log.e((String)LOG_TAG, (String)("Could not parse date from string " + dateString));
            return null;
        }
    }

    public static class DateDeserializer
    implements JsonDeserializer<Date> {
        public Date deserialize(JsonElement jsonElement, Type typeOF, JsonDeserializationContext context) throws JsonParseException {
            for (String format : DATE_FORMATS) {
                try {
                    return new SimpleDateFormat(format, Locale.US).parse(jsonElement.getAsString());
                }
                catch (ParseException parseException) {
                }
            }
            return (Date)new Gson().fromJson(jsonElement, Date.class);
        }
    }
}

