/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.utils;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Base64;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.identity.intents.model.UserAddress;
import com.google.android.gms.wallet.Cart;
import com.google.android.gms.wallet.FullWallet;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.Wallet;
import com.shopify.buy.model.Address;
import com.shopify.buy.model.Cart;
import com.shopify.buy.model.Checkout;
import com.shopify.buy.model.LineItem;
import com.shopify.buy.model.PaymentToken;
import com.shopify.buy.model.Shop;
import com.shopify.buy.model.TaxLine;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class AndroidPayHelper {
    private static final int FIRST_NAME_PART = 0;
    private static final int LAST_NAME_PART = 1;
    public static final int REQUEST_CODE_MASKED_WALLET = 500;
    public static final int REQUEST_CODE_CHANGE_MASKED_WALLET = 501;
    public static final int REQUEST_CODE_FULL_WALLET = 502;

    public static com.google.android.gms.wallet.Cart createWalletCart(Cart shopifyCart, Shop shop) {
        if (shopifyCart == null) {
            throw new NullPointerException("shopifyCart cannot be null");
        }
        if (shop == null) {
            throw new NullPointerException("shop cannot be null");
        }
        Cart.Builder builder = com.google.android.gms.wallet.Cart.newBuilder();
        builder.setCurrencyCode(shop.getCurrency());
        BigDecimal totalPrice = new BigDecimal(0);
        for (LineItem lineItem : shopifyCart.getLineItems()) {
            com.google.android.gms.wallet.LineItem lineItem2 = AndroidPayHelper.createWalletLineItem(lineItem, shop.getCurrency());
            totalPrice = totalPrice.add(new BigDecimal(lineItem2.getTotalPrice()));
            builder.addLineItem(lineItem2);
        }
        builder.setTotalPrice(totalPrice.toString());
        return builder.build();
    }

    public static com.google.android.gms.wallet.Cart createWalletCart(Checkout checkout) {
        com.google.android.gms.wallet.LineItem lineItem;
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        Cart.Builder builder = com.google.android.gms.wallet.Cart.newBuilder();
        builder.setCurrencyCode(checkout.getCurrency());
        for (LineItem shopifyLineItem : checkout.getLineItems()) {
            lineItem = AndroidPayHelper.createWalletLineItem(shopifyLineItem, checkout.getCurrency());
            builder.addLineItem(lineItem);
        }
        if (checkout.getTaxLines().size() != 0) {
            for (TaxLine taxLine : checkout.getTaxLines()) {
                lineItem = com.google.android.gms.wallet.LineItem.newBuilder().setRole(1).setTotalPrice(taxLine.getPrice()).build();
                builder.addLineItem(lineItem);
            }
        }
        if (checkout.getShippingRate() != null) {
            com.google.android.gms.wallet.LineItem lineItem2 = com.google.android.gms.wallet.LineItem.newBuilder().setRole(2).setTotalPrice(checkout.getShippingRate().getPrice()).build();
            builder.addLineItem(lineItem2);
        }
        builder.setTotalPrice(checkout.getPaymentDue());
        return builder.build();
    }

    private static com.google.android.gms.wallet.LineItem createWalletLineItem(LineItem shopifyLineItem, String currencyCode) {
        BigDecimal lineTotal = new BigDecimal(shopifyLineItem.getPrice()).multiply(new BigDecimal(shopifyLineItem.getQuantity()));
        return com.google.android.gms.wallet.LineItem.newBuilder().setQuantity(Long.toString(shopifyLineItem.getQuantity())).setUnitPrice(shopifyLineItem.getPrice()).setTotalPrice(lineTotal.toString()).setDescription(shopifyLineItem.getTitle()).setCurrencyCode(currencyCode).setRole(0).build();
    }

    public static Address createShopifyAddress(UserAddress walletUserAddress) {
        if (walletUserAddress == null) {
            throw new NullPointerException("walletUserAddress cannot be null");
        }
        Address address = new Address();
        String[] nameParts = AndroidPayHelper.extractFirstAndLastNames(walletUserAddress.getName());
        address.setFirstName(nameParts[0]);
        address.setLastName(nameParts[1]);
        address.setAddress1(walletUserAddress.getAddress1());
        StringBuilder address2 = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)walletUserAddress.getAddress2())) {
            address2.append(walletUserAddress.getAddress2());
            address2.append(", ");
        }
        if (!TextUtils.isEmpty((CharSequence)walletUserAddress.getAddress3())) {
            address2.append(walletUserAddress.getAddress3());
            address2.append(", ");
        }
        if (!TextUtils.isEmpty((CharSequence)walletUserAddress.getAddress4())) {
            address2.append(walletUserAddress.getAddress4());
            address2.append(", ");
        }
        if (!TextUtils.isEmpty((CharSequence)walletUserAddress.getAddress5())) {
            address2.append(walletUserAddress.getAddress5());
        }
        address.setAddress2(address2.toString());
        address.setZip(walletUserAddress.getPostalCode());
        address.setCity(walletUserAddress.getLocality());
        address.setCountryCode(walletUserAddress.getCountryCode());
        address.setProvinceCode(walletUserAddress.getAdministrativeArea());
        address.setPhone(walletUserAddress.getPhoneNumber());
        return address;
    }

    private static String[] extractFirstAndLastNames(String name) {
        String[] firstAndLastName = new String[2];
        String[] nameParts = name.split(" ");
        if (nameParts.length > 0) {
            firstAndLastName[0] = nameParts[0];
        }
        int nameIndex = 1;
        String lastName = "";
        while (nameParts.length > nameIndex) {
            lastName = lastName + nameParts[nameIndex++];
        }
        firstAndLastName[1] = lastName.trim();
        return firstAndLastName;
    }

    public static MaskedWalletRequest createMaskedWalletRequest(String merchantName, Checkout checkout, String publicKey, boolean phoneNumberRequired) {
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("publicKey cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)merchantName)) {
            throw new IllegalArgumentException("merchantName cannot be empty");
        }
        PaymentMethodTokenizationParameters parameters = PaymentMethodTokenizationParameters.newBuilder().setPaymentMethodTokenizationType(2).addParameter("publicKey", publicKey).build();
        com.google.android.gms.wallet.Cart walletCart = AndroidPayHelper.createWalletCart(checkout);
        return MaskedWalletRequest.newBuilder().setMerchantName(merchantName).setPhoneNumberRequired(phoneNumberRequired).setShippingAddressRequired(checkout.isRequiresShipping()).setCurrencyCode(checkout.getCurrency()).setEstimatedTotalPrice(checkout.getPaymentDue()).setPaymentMethodTokenizationParameters(parameters).setCart(walletCart).setPhoneNumberRequired(phoneNumberRequired).build();
    }

    public static FullWalletRequest createFullWalletRequest(Checkout checkout, MaskedWallet maskedWallet) {
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        if (maskedWallet == null) {
            throw new NullPointerException("maskedWallet cannot be null");
        }
        return FullWalletRequest.newBuilder().setGoogleTransactionId(maskedWallet.getGoogleTransactionId()).setCart(AndroidPayHelper.createWalletCart(checkout)).build();
    }

    public static boolean isCheckoutUpdateRequired(Checkout checkout, MaskedWallet maskedWallet) {
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        if (maskedWallet == null) {
            throw new NullPointerException("maskedWallet cannot be null");
        }
        Address shippingAddress = AndroidPayHelper.createShopifyAddress(maskedWallet.getBuyerShippingAddress());
        Address billingAddress = AndroidPayHelper.createShopifyAddress(maskedWallet.getBuyerBillingAddress());
        return !shippingAddress.locationsAreEqual(checkout.getShippingAddress()) || !billingAddress.locationsAreEqual(checkout.getBillingAddress()) || !TextUtils.equals((CharSequence)maskedWallet.getEmail(), (CharSequence)checkout.getEmail());
    }

    public static void androidPayIsAvailable(Context context, GoogleApiClient apiClient, AndroidPayReadyCallback delegate) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        if (apiClient == null) {
            throw new NullPointerException("apiClient cannot be null");
        }
        if (delegate == null) {
            throw new NullPointerException("delegate cannot be null");
        }
        try {
            MessageDigest.getInstance("SHA-256");
            byte[] byArray = "foo".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            delegate.onResult(false);
            return;
        }
        if (!AndroidPayHelper.hasGooglePlayServices(context)) {
            delegate.onResult(false);
            return;
        }
        AndroidPayHelper.isReadyToPay(apiClient, delegate);
    }

    public static boolean hasGooglePlayServices(Context context) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
        int result = googleAPI.isGooglePlayServicesAvailable(context);
        return result == 0;
    }

    public static void isReadyToPay(GoogleApiClient apiClient, final AndroidPayReadyCallback delegate) {
        if (apiClient == null) {
            throw new NullPointerException("apiClient cannot be null");
        }
        if (delegate == null) {
            throw new NullPointerException("delegate cannot be null");
        }
        Wallet.Payments.isReadyToPay(apiClient).setResultCallback((ResultCallback)new ResultCallback<BooleanResult>(){

            public void onResult(@NonNull BooleanResult booleanResult) {
                if (booleanResult.getStatus().isSuccess()) {
                    delegate.onResult(booleanResult.getValue());
                } else {
                    delegate.onResult(false);
                }
            }
        });
    }

    public static PaymentToken getAndroidPaymentToken(FullWallet fullWallet, String androidPayPublicKey) {
        if (fullWallet == null) {
            throw new IllegalArgumentException("fullWallet cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)androidPayPublicKey)) {
            throw new IllegalArgumentException("androidPayPublicKey cannot be empty");
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] digest = messageDigest.digest(androidPayPublicKey.getBytes("UTF-8"));
            return PaymentToken.createAndroidPayPaymentToken(fullWallet.getPaymentMethodToken().getToken(), Base64.encodeToString((byte[])digest, (int)0));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    private AndroidPayHelper() {
    }

    public static interface AndroidPayReadyCallback {
        public void onResult(boolean var1);
    }
}

