/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.model;

import com.google.gson.annotations.SerializedName;
import com.shopify.buy.model.OptionValue;
import com.shopify.buy.model.ShopifyObject;
import com.shopify.buy.utils.DateUtility;
import java.util.Date;
import java.util.List;

public class ProductVariant
extends ShopifyObject {
    protected String title;
    protected String price;
    @SerializedName(value="option_values")
    protected List<OptionValue> optionValues;
    protected long grams;
    @SerializedName(value="compare_at_price")
    protected String compareAtPrice;
    protected String sku;
    @SerializedName(value="requires_shipping")
    protected Boolean requiresShipping;
    protected Boolean taxable;
    protected int position;
    protected Long productId;
    @SerializedName(value="created_at")
    protected Date createdAtDate;
    @SerializedName(value="updated_at")
    protected Date updatedAtDate;
    protected Boolean available;
    @SerializedName(value="product_title")
    protected String productTitle;
    @SerializedName(value="image_url")
    protected String imageUrl;

    @Override
    public Long getId() {
        return super.getId();
    }

    public String getTitle() {
        return this.title;
    }

    public List<OptionValue> getOptionValues() {
        return this.optionValues;
    }

    public String getPrice() {
        return this.price;
    }

    public long getGrams() {
        return this.grams;
    }

    public String getCompareAtPrice() {
        return this.compareAtPrice;
    }

    public String getSku() {
        return this.sku;
    }

    public boolean isRequiresShipping() {
        return this.requiresShipping != null && this.requiresShipping != false;
    }

    public boolean isTaxable() {
        return this.taxable != null && this.taxable != false;
    }

    public int getPosition() {
        return this.position;
    }

    public long getProductId() {
        return this.productId;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getProductTitle() {
        return this.productTitle;
    }

    @Deprecated
    public String getCreatedAt() {
        return this.createdAtDate == null ? null : DateUtility.createDefaultDateFormat().format(this.createdAtDate);
    }

    @Deprecated
    public String getUpdatedAt() {
        return this.updatedAtDate == null ? null : DateUtility.createDefaultDateFormat().format(this.updatedAtDate);
    }

    public boolean isAvailable() {
        return this.available != null && this.available != false;
    }

    public Date getCreatedAtDate() {
        return this.createdAtDate;
    }

    public Date getUpdatedAtDate() {
        return this.updatedAtDate;
    }
}

