/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.model;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.shopify.buy.dataprovider.BuyClientUtils;
import com.shopify.buy.model.Image;
import com.shopify.buy.model.Option;
import com.shopify.buy.model.OptionValue;
import com.shopify.buy.model.ProductVariant;
import com.shopify.buy.model.ShopifyObject;
import com.shopify.buy.utils.CollectionUtils;
import com.shopify.buy.utils.DateUtility;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Product
extends ShopifyObject {
    @SerializedName(value="product_id")
    protected Long productId;
    protected String title;
    protected String handle;
    @SerializedName(value="body_html")
    protected String bodyHtml;
    @SerializedName(value="published_at")
    protected Date publishedAtDate;
    @SerializedName(value="created_at")
    protected Date createdAtDate;
    @SerializedName(value="updated_at")
    protected Date updatedAtDate;
    protected String vendor;
    @SerializedName(value="product_type")
    protected String productType;
    protected List<ProductVariant> variants;
    protected List<Image> images;
    protected List<Option> options;
    protected String tags;
    protected Set<String> tagSet;
    protected Boolean available;
    protected Boolean published;
    private Set<String> prices;
    private String minimumPrice;

    public boolean isPublished() {
        return this.published != null && this.published != false;
    }

    public Long getProductId() {
        return this.productId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHandle() {
        return this.handle;
    }

    public String getBodyHtml() {
        return this.bodyHtml;
    }

    @Deprecated
    public String getPublishedAt() {
        return this.publishedAtDate == null ? null : DateUtility.createDefaultDateFormat().format(this.publishedAtDate);
    }

    @Deprecated
    public String getCreatedAt() {
        return this.createdAtDate == null ? null : DateUtility.createDefaultDateFormat().format(this.createdAtDate);
    }

    @Deprecated
    public String getUpdatedAt() {
        return this.updatedAtDate == null ? null : DateUtility.createDefaultDateFormat().format(this.updatedAtDate);
    }

    public Date getPublishedAtDate() {
        return this.publishedAtDate;
    }

    public Date getCreatedAtDate() {
        return this.createdAtDate;
    }

    public Date getUpdatedAtDate() {
        return this.updatedAtDate;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getProductType() {
        return this.productType;
    }

    public Set<String> getTags() {
        return this.tagSet;
    }

    public List<ProductVariant> getVariants() {
        return this.variants;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public String getFirstImageUrl() {
        Image image;
        if (this.hasImage() && (image = this.images.get(0)) != null) {
            return image.getSrc();
        }
        return null;
    }

    public boolean hasImage() {
        return this.images != null && !this.images.isEmpty();
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public boolean isAvailable() {
        return this.available != null && this.available != false;
    }

    public boolean hasDefaultVariant() {
        if (CollectionUtils.isEmpty(this.variants) || this.variants.size() != 1) {
            return false;
        }
        ProductVariant firstVariant = this.variants.get(0);
        List<OptionValue> optionValues = firstVariant.getOptionValues();
        return firstVariant.getTitle().equals("Default Title") && !CollectionUtils.isEmpty(optionValues) && (optionValues.get(0).getValue().equals("Default Title") || optionValues.get(0).getValue().equals("Default"));
    }

    public Image getImage(ProductVariant variant) {
        if (variant == null) {
            throw new NullPointerException("variant cannot be null");
        }
        List<Image> images = this.getImages();
        if (images == null || images.size() < 1) {
            return null;
        }
        for (Image image : images) {
            if (image.getVariantIds() == null || !image.getVariantIds().contains(variant.getId())) continue;
            return image;
        }
        return images.get(0);
    }

    public ProductVariant getVariant(List<OptionValue> optionValues) {
        if (optionValues == null) {
            return null;
        }
        int numOptions = optionValues.size();
        for (ProductVariant variant : this.variants) {
            for (int i = 0; i < numOptions && variant.getOptionValues().get(i).getValue().equals(optionValues.get(i).getValue()); ++i) {
                if (i != numOptions - 1) continue;
                return variant;
            }
        }
        return null;
    }

    public Set<String> getPrices() {
        if (this.prices != null) {
            return this.prices;
        }
        this.prices = new HashSet<String>();
        if (!CollectionUtils.isEmpty(this.variants)) {
            for (ProductVariant variant : this.variants) {
                this.prices.add(variant.getPrice());
            }
        }
        return this.prices;
    }

    public String getMinimumPrice() {
        if (this.minimumPrice != null) {
            return this.minimumPrice;
        }
        this.prices = this.getPrices();
        for (String price : this.prices) {
            if (this.minimumPrice == null) {
                this.minimumPrice = price;
            }
            if (!(Float.valueOf(price).floatValue() < Float.valueOf(this.minimumPrice).floatValue())) continue;
            this.minimumPrice = price;
        }
        return this.minimumPrice;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Product)) {
            return false;
        }
        Product product = (Product)o;
        return this.productId.equals(product.productId);
    }

    @Override
    public int hashCode() {
        return this.productId.hashCode();
    }

    public static Product fromJson(String json) {
        Gson gson = BuyClientUtils.createDefaultGson(Product.class);
        Product product = (Product)gson.fromJson(json, Product.class);
        List<ProductVariant> variants = product.getVariants();
        if (variants != null) {
            for (ProductVariant variant : variants) {
                variant.productId = product.productId;
                variant.productTitle = product.getTitle();
                Image image = product.getImage(variant);
                if (image == null) continue;
                variant.imageUrl = image.getSrc();
            }
        }
        product.tagSet = new HashSet<String>();
        if (!TextUtils.isEmpty((CharSequence)product.tags)) {
            for (String tag : product.tags.split(",")) {
                String myTag = tag.trim();
                product.tagSet.add(myTag);
            }
        }
        return product;
    }

    public static class ProductDeserializer
    implements JsonDeserializer<Product> {
        public Product deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Product.fromJson(json.toString());
        }
    }
}

