/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.model;

import com.google.gson.annotations.SerializedName;

public final class PaymentToken {
    @SerializedName(value="payment_session_id")
    private final String paymentSessionId;
    @SerializedName(value="payment_token")
    private final Wrapper wrapper;

    public static PaymentToken createCreditCardPaymentToken(String paymentSessionId) {
        return new PaymentToken(paymentSessionId);
    }

    public static PaymentToken createAndroidPayPaymentToken(String token, String publicKeyHash) {
        return new PaymentToken(token, "android_pay", publicKeyHash);
    }

    public static PaymentToken createEmptyPaymentToken() {
        return new PaymentToken(null, null, null);
    }

    private PaymentToken(String paymentSessionId) {
        this.paymentSessionId = paymentSessionId;
        this.wrapper = null;
    }

    private PaymentToken(String token, String type, String publicKeyHash) {
        this.paymentSessionId = null;
        this.wrapper = new Wrapper(token, type, publicKeyHash);
    }

    private static final class Wrapper {
        @SerializedName(value="payment_data")
        private final String paymentData;
        @SerializedName(value="type")
        private final String type;
        @SerializedName(value="identifier")
        private final String identifier;

        private Wrapper(String paymentData, String type, String identifier) {
            this.paymentData = paymentData;
            this.type = type;
            this.identifier = identifier;
        }
    }
}

