/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.model;

import com.google.gson.annotations.SerializedName;
import com.shopify.buy.model.LineItem;
import com.shopify.buy.model.ShopifyObject;
import com.shopify.buy.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Order
extends ShopifyObject {
    @SerializedName(value="order_number")
    protected String orderNumber;
    protected String name;
    @SerializedName(value="processed_at")
    protected Date processedAt;
    @SerializedName(value="status_url")
    protected String statusUrl;
    @SerializedName(value="order_status_url")
    protected String orderStatusUrl;
    protected String currency;
    @SerializedName(value="total_price")
    protected String totalPrice;
    protected Boolean cancelled;
    @SerializedName(value="cancel_reason")
    protected String cancelReason;
    @SerializedName(value="cancelled_at")
    protected Date cancelledAt;
    @SerializedName(value="fulfilled_line_items")
    protected List<LineItem> fulfilledLineItems;
    @SerializedName(value="unfulfilled_line_items")
    protected List<LineItem> unfulfilledLineItems;
    protected List<LineItem> lineItems;

    @Override
    public Long getId() {
        return super.getId();
    }

    public String getOrderStatusUrl() {
        return this.orderStatusUrl;
    }

    public String getStatusUrl() {
        return this.statusUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public Date getProcessedAt() {
        return this.processedAt;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getTotalPrice() {
        return this.totalPrice;
    }

    public Boolean isCancelled() {
        return this.cancelled != null && this.cancelled != false;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    public Date getCancelledAt() {
        return this.cancelledAt;
    }

    public List<LineItem> getFulfilledLineItems() {
        return this.fulfilledLineItems;
    }

    public List<LineItem> getUnfulfilledLineItems() {
        return this.unfulfilledLineItems;
    }

    public List<LineItem> getLineItems() {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
            if (!CollectionUtils.isEmpty(this.fulfilledLineItems)) {
                this.lineItems.addAll(this.fulfilledLineItems);
            }
            if (!CollectionUtils.isEmpty(this.unfulfilledLineItems)) {
                this.lineItems.addAll(this.unfulfilledLineItems);
            }
        }
        return this.lineItems;
    }
}

