/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.model;

import com.google.gson.annotations.SerializedName;
import com.shopify.buy.model.ProductVariant;
import java.util.HashMap;
import java.util.Map;

public class LineItem {
    protected long quantity;
    protected String id;
    protected String price;
    @SerializedName(value="requires_shipping")
    protected Boolean requiresShipping;
    @SerializedName(value="variant_id")
    protected Long variantId;
    protected String title;
    @SerializedName(value="product_id")
    protected String productId;
    @SerializedName(value="variant_title")
    protected String variantTitle;
    @SerializedName(value="line_price")
    protected String linePrice;
    @SerializedName(value="compare_at_price")
    protected String compareAtPrice;
    protected String sku;
    protected Boolean taxable;
    protected long grams;
    @SerializedName(value="fulfillment_service")
    protected String fulfillmentService;
    protected Map<String, Object> properties;
    @SerializedName(value="total_discount")
    protected String totalDiscount;

    protected LineItem() {
    }

    public LineItem(ProductVariant variant) {
        this.variantId = variant.getId();
        this.price = variant.getPrice();
        this.title = variant.getTitle();
        this.requiresShipping = variant.isRequiresShipping();
        this.quantity = 1L;
    }

    public LineItem(Long variantId, boolean requiresShipping, long quantity) {
        this.variantId = variantId;
        this.requiresShipping = requiresShipping;
        this.quantity = quantity;
    }

    public String getVariantTitle() {
        return this.variantTitle;
    }

    public String getLinePrice() {
        return this.linePrice;
    }

    public String getCompareAtPrice() {
        return this.compareAtPrice;
    }

    public String getSku() {
        return this.sku;
    }

    public boolean isTaxable() {
        return this.taxable != null && this.taxable != false;
    }

    public String getProductId() {
        return this.productId;
    }

    public long getGrams() {
        return this.grams;
    }

    public String getFulfillmentService() {
        return this.fulfillmentService;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public String getPrice() {
        return this.price;
    }

    public String getTitle() {
        return this.title;
    }

    public Long getVariantId() {
        return this.variantId;
    }

    public String getId() {
        return this.id;
    }

    public String getTotalDiscount() {
        return this.totalDiscount;
    }

    public boolean isRequiresShipping() {
        return this.requiresShipping != null && this.requiresShipping != false;
    }

    public boolean equals(Object o) {
        if (o instanceof LineItem) {
            Long otherVariantId = ((LineItem)o).getVariantId();
            return otherVariantId != null && otherVariantId.equals(this.variantId);
        }
        return false;
    }
}

