/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.model;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.shopify.buy.dataprovider.BuyClientUtils;
import com.shopify.buy.model.Address;
import com.shopify.buy.model.ShopifyObject;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Customer
extends ShopifyObject {
    private String email;
    @SerializedName(value="accepts_marketing")
    private Boolean acceptsMarketing;
    @SerializedName(value="created_at")
    private Date createdAtDate;
    @SerializedName(value="updated_at")
    private Date updatedAtDate;
    @SerializedName(value="first_name")
    private String firstName;
    @SerializedName(value="last_name")
    private String lastName;
    @SerializedName(value="orders_count")
    private Long ordersCount;
    private String state;
    @SerializedName(value="total_spent")
    private String totalSpent;
    private String note;
    @SerializedName(value="verified_email")
    private Boolean verifiedEmail;
    @SerializedName(value="multipass_identifier")
    private String multipassIdentifier;
    @SerializedName(value="tax_exempt")
    private Boolean taxExempt;
    private String tags;
    private Set<String> tagSet;
    @SerializedName(value="last_order_id")
    private Long lastOrderId;
    @SerializedName(value="last_order_name")
    private String lastOrderName;
    private List<Address> addresses;
    @SerializedName(value="default_address")
    private Address defaultAddress;

    @Override
    public Long getId() {
        return super.getId();
    }

    public String getEmail() {
        return this.email;
    }

    public boolean acceptsMarketing() {
        return this.acceptsMarketing != null && this.acceptsMarketing != false;
    }

    public Date getCreatedAtDate() {
        return this.createdAtDate;
    }

    public Date getUpdatedAtDate() {
        return this.updatedAtDate;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public long getOrdersCount() {
        return this.ordersCount;
    }

    public String getState() {
        return this.state;
    }

    public String getTotalSpent() {
        return this.totalSpent;
    }

    public String getNote() {
        return this.note;
    }

    public boolean isVerifiedEmail() {
        return this.verifiedEmail != null && this.verifiedEmail != false;
    }

    public String getMultipassIdenfier() {
        return this.multipassIdentifier;
    }

    public boolean isTaxExempt() {
        return this.taxExempt != null && this.taxExempt != false;
    }

    public Set<String> getTags() {
        return this.tagSet;
    }

    public Long getLastOrderId() {
        return this.lastOrderId;
    }

    public String getLastOrderName() {
        return this.lastOrderName;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public Address getDefaultAddress() {
        return this.defaultAddress;
    }

    public void setAcceptsMarketing(boolean acceptsMarketing) {
        this.acceptsMarketing = acceptsMarketing;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public void setTaxExempt(boolean taxExempt) {
        this.taxExempt = taxExempt;
    }

    public void setMultipassIdentifier(String multipassIdentifier) {
        this.multipassIdentifier = multipassIdentifier;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setTags(Set<String> tags) {
        this.tagSet = tags;
        this.tags = TextUtils.join((CharSequence)",", tags);
    }

    public static Customer fromJson(String json) {
        Gson gson = BuyClientUtils.createDefaultGson(Customer.class);
        Customer customer = (Customer)gson.fromJson(json, Customer.class);
        customer.tagSet = new HashSet<String>();
        if (!TextUtils.isEmpty((CharSequence)customer.tags)) {
            for (String tag : customer.tags.split(",")) {
                String myTag = tag.trim();
                customer.tagSet.add(myTag);
            }
        }
        return customer;
    }

    public static class CustomerDeserializer
    implements JsonDeserializer<Customer> {
        public Customer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Customer.fromJson(json.toString());
        }
    }
}

