/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.model;

import com.google.gson.annotations.SerializedName;
import com.shopify.buy.dataprovider.BuyClientUtils;
import com.shopify.buy.model.ShopifyObject;
import com.shopify.buy.model.internal.CollectionImage;
import java.util.Date;

public class Collection
extends ShopifyObject {
    protected String title;
    @SerializedName(value="body_html")
    protected String htmlDescription;
    protected String handle;
    protected Boolean published;
    @SerializedName(value="collection_id")
    protected Long collectionId;
    @SerializedName(value="created_at")
    protected Date createdAtDate;
    @SerializedName(value="updated_at")
    protected Date updatedAtDate;
    @SerializedName(value="published_at")
    protected Date publishedAtDate;
    protected CollectionImage image;

    public Date getCreatedAtDate() {
        return this.createdAtDate;
    }

    public Date getUpdatedAtDate() {
        return this.updatedAtDate;
    }

    public Date getPublishedAtDate() {
        return this.publishedAtDate;
    }

    public CollectionImage getImage() {
        return this.image;
    }

    public String getImageUrl() {
        if (this.image == null) {
            return null;
        }
        return this.image.getSrc();
    }

    public String getTitle() {
        return this.title;
    }

    public String getHtmlDescription() {
        return this.htmlDescription;
    }

    public String getHandle() {
        return this.handle;
    }

    @Deprecated
    public String getPublished() {
        return String.valueOf(this.published);
    }

    public boolean isPublished() {
        return this.published != null && this.published != false;
    }

    public Long getCollectionId() {
        return this.collectionId;
    }

    public static Collection fromJson(String json) {
        return (Collection)BuyClientUtils.createDefaultGson().fromJson(json, Collection.class);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection that = (Collection)o;
        return this.collectionId.equals(that.collectionId);
    }

    @Override
    public int hashCode() {
        return this.collectionId.hashCode();
    }

    public static enum SortOrder {
        COLLECTION_DEFAULT("collection-default"),
        BEST_SELLING("best-selling"),
        TITLE_ASCENDING("title-ascending"),
        TITLE_DESCENDING("title-descending"),
        PRICE_ASCENDING("price-ascending"),
        PRICE_DESCENDING("price-descending"),
        CREATED_ASCENDING("created-ascending"),
        CREATED_DESCENDING("created-descending");

        private final String order;

        private SortOrder(String s) {
            this.order = s;
        }

        public String toString() {
            return this.order;
        }
    }
}

