/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import com.shopify.buy.dataprovider.BuyClientExceptionHandler;
import com.shopify.buy.dataprovider.Callback;
import com.shopify.buy.dataprovider.CancellableTask;
import com.shopify.buy.dataprovider.CancellableTaskSubscriptionWrapper;
import com.shopify.buy.dataprovider.InternalCallbackSubscriber;
import com.shopify.buy.dataprovider.NetworkRetryPolicyProvider;
import com.shopify.buy.dataprovider.RetrofitSuccessHttpStatusCodeHandler;
import com.shopify.buy.dataprovider.StoreRetrofitService;
import com.shopify.buy.dataprovider.StoreService;
import com.shopify.buy.model.Shop;
import retrofit2.Response;
import retrofit2.Retrofit;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;

final class StoreServiceDefault
implements StoreService {
    final StoreRetrofitService retrofitService;
    final NetworkRetryPolicyProvider networkRetryPolicyProvider;
    final Scheduler callbackScheduler;

    StoreServiceDefault(Retrofit retrofit, NetworkRetryPolicyProvider networkRetryPolicyProvider, Scheduler callbackScheduler) {
        this.retrofitService = (StoreRetrofitService)retrofit.create(StoreRetrofitService.class);
        this.networkRetryPolicyProvider = networkRetryPolicyProvider;
        this.callbackScheduler = callbackScheduler;
    }

    @Override
    public CancellableTask getShop(Callback<Shop> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getShop().subscribe(new InternalCallbackSubscriber<Shop>(callback)));
    }

    @Override
    public Observable<Shop> getShop() {
        return this.retrofitService.getShop().retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).map((Func1)new Func1<Response<Shop>, Shop>(){

            public Shop call(Response<Shop> response) {
                return (Shop)response.body();
            }
        }).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }
}

