/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import android.text.TextUtils;
import com.shopify.buy.dataprovider.BuyClientExceptionHandler;
import com.shopify.buy.dataprovider.Callback;
import com.shopify.buy.dataprovider.CancellableTask;
import com.shopify.buy.dataprovider.CancellableTaskSubscriptionWrapper;
import com.shopify.buy.dataprovider.FirstListItemOrDefaultTransformer;
import com.shopify.buy.dataprovider.InternalCallbackSubscriber;
import com.shopify.buy.dataprovider.NetworkRetryPolicyProvider;
import com.shopify.buy.dataprovider.ProductRetrofitService;
import com.shopify.buy.dataprovider.ProductService;
import com.shopify.buy.dataprovider.RetrofitSuccessHttpStatusCodeHandler;
import com.shopify.buy.dataprovider.UnwrapRetrofitBodyTransformer;
import com.shopify.buy.model.Collection;
import com.shopify.buy.model.Product;
import com.shopify.buy.model.ProductTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import retrofit2.Retrofit;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;

final class ProductServiceDefault
implements ProductService {
    final ProductRetrofitService retrofitService;
    final String appId;
    final int pageSize;
    final NetworkRetryPolicyProvider networkRetryPolicyProvider;
    final Scheduler callbackScheduler;

    ProductServiceDefault(Retrofit retrofit, String appId, int pageSize, NetworkRetryPolicyProvider networkRetryPolicyProvider, Scheduler callbackScheduler) {
        this.retrofitService = (ProductRetrofitService)retrofit.create(ProductRetrofitService.class);
        this.appId = appId;
        this.pageSize = pageSize;
        this.networkRetryPolicyProvider = networkRetryPolicyProvider;
        this.callbackScheduler = callbackScheduler;
    }

    @Override
    public int getProductPageSize() {
        return this.pageSize;
    }

    @Override
    public CancellableTask getProducts(int page, Callback<List<Product>> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getProducts(page).subscribe(new InternalCallbackSubscriber<List<Product>>(callback)));
    }

    @Override
    public Observable<List<Product>> getProducts(int page) {
        return this.getProducts(page, (Set<String>)null);
    }

    @Override
    public CancellableTask getProductByHandle(String handle, Callback<Product> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getProductByHandle(handle).subscribe(new InternalCallbackSubscriber<Product>(callback)));
    }

    @Override
    public Observable<Product> getProductByHandle(String handle) {
        if (handle == null) {
            throw new NullPointerException("handle cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)handle)) {
            throw new IllegalArgumentException("handle cannot be empty");
        }
        return this.retrofitService.getProductByHandle(this.appId, handle).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).compose(new FirstListItemOrDefaultTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask getProduct(Long productId, Callback<Product> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getProduct(productId).subscribe(new InternalCallbackSubscriber<Product>(callback)));
    }

    @Override
    public Observable<Product> getProduct(Long productId) {
        if (productId == null) {
            throw new NullPointerException("productId cannot be null");
        }
        return this.retrofitService.getProducts(this.appId, String.valueOf(productId)).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).compose(new FirstListItemOrDefaultTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask getProducts(List<Long> productIds, Callback<List<Product>> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getProducts(productIds).subscribe(new InternalCallbackSubscriber<List<Product>>(callback)));
    }

    @Override
    public Observable<List<Product>> getProducts(List<Long> productIds) {
        if (productIds == null) {
            throw new NullPointerException("productIds List cannot be null");
        }
        if (productIds.size() < 1) {
            throw new IllegalArgumentException("productIds List cannot be empty");
        }
        String queryString = this.formatQueryString(productIds);
        return this.retrofitService.getProducts(this.appId, queryString).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask getCollectionByHandle(String handle, Callback<com.shopify.buy.model.Collection> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getCollectionByHandle(handle).subscribe(new InternalCallbackSubscriber<com.shopify.buy.model.Collection>(callback)));
    }

    @Override
    public Observable<com.shopify.buy.model.Collection> getCollectionByHandle(String handle) {
        if (handle == null) {
            throw new NullPointerException("handle cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)handle)) {
            throw new IllegalArgumentException("handle cannot be empty");
        }
        return this.retrofitService.getCollectionByHandle(this.appId, handle).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).compose(new FirstListItemOrDefaultTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask getCollections(int page, Callback<List<com.shopify.buy.model.Collection>> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getCollections(page).subscribe(new InternalCallbackSubscriber<List<com.shopify.buy.model.Collection>>(callback)));
    }

    @Override
    public Observable<List<com.shopify.buy.model.Collection>> getCollections(int page) {
        if (page < 1) {
            throw new IllegalArgumentException("page is a 1-based index, value cannot be less than 1");
        }
        return this.retrofitService.getCollectionPage(this.appId, page, this.pageSize).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask getProductTags(int page, Callback<List<String>> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getProductTags(page).subscribe(new InternalCallbackSubscriber<List<String>>(callback)));
    }

    @Override
    public Observable<List<String>> getProductTags(int page) {
        if (page < 1) {
            throw new IllegalArgumentException("page is a 1-based index, value cannot be less than 1");
        }
        return this.retrofitService.getProductTagPage(this.appId, page, this.pageSize).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).map(this.unwrapProductTags()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask getProducts(int page, Set<String> tags, Callback<List<Product>> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getProducts(page, tags).subscribe(new InternalCallbackSubscriber<List<Product>>(callback)));
    }

    @Override
    public Observable<List<Product>> getProducts(int page, Set<String> tags) {
        if (page < 1) {
            throw new IllegalArgumentException("page is a 1-based index, value cannot be less than 1");
        }
        String tagsQueryStr = this.formatQueryString(tags);
        return this.retrofitService.getProducts(this.appId, null, tagsQueryStr, null, page, this.pageSize).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask getProducts(int page, Long collectionId, Set<String> tags, Collection.SortOrder sortOrder, Callback<List<Product>> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getProducts(page, collectionId, tags, sortOrder).subscribe(new InternalCallbackSubscriber<List<Product>>(callback)));
    }

    @Override
    public Observable<List<Product>> getProducts(int page, Long collectionId, Set<String> tags, Collection.SortOrder sortOrder) {
        if (page < 1) {
            throw new IllegalArgumentException("page is a 1-based index, value cannot be less than 1");
        }
        if (collectionId == null) {
            throw new NullPointerException("collectionId cannot be null");
        }
        String sortOrderStr = sortOrder != null ? sortOrder.toString() : Collection.SortOrder.COLLECTION_DEFAULT.toString();
        String tagsQueryStr = this.formatQueryString(tags);
        return this.retrofitService.getProducts(this.appId, collectionId, tagsQueryStr, sortOrderStr, page, this.pageSize).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    private Func1<List<ProductTag>, List<String>> unwrapProductTags() {
        return new Func1<List<ProductTag>, List<String>>(){

            public List<String> call(List<ProductTag> productTags) {
                ArrayList<String> tags = new ArrayList<String>();
                if (productTags != null) {
                    for (ProductTag productTag : productTags) {
                        if (TextUtils.isEmpty((CharSequence)productTag.getTitle())) continue;
                        tags.add(productTag.getTitle());
                    }
                }
                return tags;
            }
        };
    }

    private String formatQueryString(Collection items) {
        if (items != null && !items.isEmpty()) {
            return TextUtils.join((CharSequence)",", (Object[])items.toArray());
        }
        return null;
    }
}

