/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import com.shopify.buy.dataprovider.BuyClientError;
import com.shopify.buy.dataprovider.PollingRequiredException;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;

final class PollingPolicyProvider {
    final long retryDelayMs;
    final long timeoutMs;

    PollingPolicyProvider(long retryDelayMs, long timeoutMs) {
        this.retryDelayMs = retryDelayMs;
        this.timeoutMs = timeoutMs;
    }

    Func1<Observable<? extends Throwable>, Observable<?>> provide() {
        return new PollingPolicy(this.retryDelayMs, this.timeoutMs);
    }

    private static final class PollingPolicy
    implements Func1<Observable<? extends Throwable>, Observable<?>> {
        private final long retryDelayMs;
        private final long timeoutMs;
        private volatile long pollingStartTime = -1L;

        PollingPolicy(long retryDelayMs, long timeoutMs) {
            this.retryDelayMs = retryDelayMs;
            this.timeoutMs = timeoutMs;
        }

        public Observable<?> call(Observable<? extends Throwable> failedAttempt) {
            return failedAttempt.flatMap(new Func1<Throwable, Observable<?>>(){

                public Observable<?> call(Throwable t) {
                    boolean pollingRequired = false;
                    if (t instanceof BuyClientError) {
                        BuyClientError buyClientError = (BuyClientError)t;
                        if (buyClientError.getRetrofitResponse() != null) {
                            pollingRequired = 202 == buyClientError.getRetrofitResponse().code();
                        }
                    } else if (t instanceof PollingRequiredException) {
                        pollingRequired = true;
                    }
                    if (pollingRequired) {
                        if (PollingPolicy.this.pollingStartTime == -1L) {
                            PollingPolicy.this.pollingStartTime = System.currentTimeMillis();
                        } else if (System.currentTimeMillis() - PollingPolicy.this.pollingStartTime > PollingPolicy.this.timeoutMs) {
                            pollingRequired = false;
                        }
                    }
                    if (pollingRequired) {
                        return Observable.timer((long)PollingPolicy.this.retryDelayMs, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                    return Observable.error((Throwable)t);
                }
            });
        }
    }
}

