/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import com.shopify.buy.dataprovider.BuyClientError;
import com.shopify.buy.dataprovider.BuyClientExceptionHandler;
import com.shopify.buy.dataprovider.Callback;
import com.shopify.buy.dataprovider.CancellableTask;
import com.shopify.buy.dataprovider.CancellableTaskSubscriptionWrapper;
import com.shopify.buy.dataprovider.CustomerService;
import com.shopify.buy.dataprovider.InternalCallbackSubscriber;
import com.shopify.buy.dataprovider.NetworkRetryPolicyProvider;
import com.shopify.buy.dataprovider.OrderRetrofitService;
import com.shopify.buy.dataprovider.OrderService;
import com.shopify.buy.dataprovider.RetrofitSuccessHttpStatusCodeHandler;
import com.shopify.buy.dataprovider.UnwrapRetrofitBodyTransformer;
import com.shopify.buy.model.CustomerToken;
import com.shopify.buy.model.Order;
import java.util.List;
import retrofit2.Retrofit;
import rx.Observable;
import rx.Scheduler;

final class OrderServiceDefault
implements OrderService {
    final OrderRetrofitService retrofitService;
    final NetworkRetryPolicyProvider networkRetryPolicyProvider;
    final Scheduler callbackScheduler;
    final CustomerService customerService;

    OrderServiceDefault(Retrofit retrofit, NetworkRetryPolicyProvider networkRetryPolicyProvider, Scheduler callbackScheduler, CustomerService customerService) {
        this.retrofitService = (OrderRetrofitService)retrofit.create(OrderRetrofitService.class);
        this.networkRetryPolicyProvider = networkRetryPolicyProvider;
        this.callbackScheduler = callbackScheduler;
        this.customerService = customerService;
    }

    @Override
    public CancellableTask getOrders(Callback<List<Order>> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getOrders().subscribe(new InternalCallbackSubscriber<List<Order>>(callback)));
    }

    @Override
    public Observable<List<Order>> getOrders() {
        CustomerToken customerToken = this.customerService.getCustomerToken();
        if (customerToken == null) {
            return Observable.error((Throwable)new BuyClientError(new IllegalStateException("customer must be logged in")));
        }
        return this.retrofitService.getOrders(customerToken.getCustomerId()).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask getOrder(Long orderId, Callback<Order> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getOrder(orderId).subscribe(new InternalCallbackSubscriber<Order>(callback)));
    }

    @Override
    public Observable<Order> getOrder(Long orderId) {
        if (orderId == null) {
            throw new NullPointerException("orderId cannot be null");
        }
        CustomerToken customerToken = this.customerService.getCustomerToken();
        if (customerToken == null) {
            return Observable.error((Throwable)new BuyClientError(new IllegalStateException("customer must be logged in")));
        }
        return this.retrofitService.getOrder(orderId, customerToken.getCustomerId()).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }
}

