/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;

final class NetworkRetryPolicyProvider {
    final int retryMaxCount;
    final long retryDelayMs;
    final float retryBackoffMultiplier;

    NetworkRetryPolicyProvider(int retryMaxCount, long retryDelayMs, float retryBackoffMultiplier) {
        this.retryMaxCount = retryMaxCount;
        this.retryDelayMs = retryDelayMs;
        this.retryBackoffMultiplier = retryBackoffMultiplier;
    }

    Func1<Observable<? extends Throwable>, Observable<?>> provide() {
        return new NetworkErrorRetryPolicy(this.retryMaxCount, this.retryDelayMs, this.retryBackoffMultiplier);
    }

    private static class NetworkErrorRetryPolicy
    implements Func1<Observable<? extends Throwable>, Observable<?>> {
        private final long delayBeforeRetryMs;
        private final float backoffMultiplier;
        private volatile int retryAttempt;
        private volatile long nextAttemptDelay;

        NetworkErrorRetryPolicy(int maxRetryCount, long delayMs, float backoffMultiplier) {
            this.retryAttempt = maxRetryCount;
            this.delayBeforeRetryMs = delayMs;
            this.backoffMultiplier = backoffMultiplier;
        }

        public Observable<?> call(Observable<? extends Throwable> failedAttempt) {
            return failedAttempt.flatMap(new Func1<Throwable, Observable<?>>(){

                public Observable<?> call(Throwable t) {
                    Observable resultObservable = Observable.error((Throwable)t);
                    if (t instanceof IOException && --NetworkErrorRetryPolicy.this.retryAttempt >= 0) {
                        NetworkErrorRetryPolicy.this.nextAttemptDelay = Math.max((long)(NetworkErrorRetryPolicy.this.backoffMultiplier * (float)NetworkErrorRetryPolicy.this.nextAttemptDelay), NetworkErrorRetryPolicy.this.delayBeforeRetryMs);
                        resultObservable = Observable.timer((long)NetworkErrorRetryPolicy.this.nextAttemptDelay, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                    return resultObservable;
                }
            });
        }
    }
}

