/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import android.text.TextUtils;
import com.shopify.buy.dataprovider.BuyClientError;
import com.shopify.buy.dataprovider.BuyClientExceptionHandler;
import com.shopify.buy.dataprovider.Callback;
import com.shopify.buy.dataprovider.CancellableTask;
import com.shopify.buy.dataprovider.CancellableTaskSubscriptionWrapper;
import com.shopify.buy.dataprovider.CustomerRetrofitService;
import com.shopify.buy.dataprovider.CustomerService;
import com.shopify.buy.dataprovider.InternalCallbackSubscriber;
import com.shopify.buy.dataprovider.NetworkRetryPolicyProvider;
import com.shopify.buy.dataprovider.RetrofitSuccessHttpStatusCodeHandler;
import com.shopify.buy.dataprovider.UnwrapRetrofitBodyTransformer;
import com.shopify.buy.model.AccountCredentials;
import com.shopify.buy.model.Customer;
import com.shopify.buy.model.CustomerToken;
import com.shopify.buy.model.internal.AccountCredentialsWrapper;
import com.shopify.buy.model.internal.CustomerWrapper;
import com.shopify.buy.model.internal.EmailWrapper;
import java.util.concurrent.atomic.AtomicReference;
import retrofit2.Response;
import retrofit2.Retrofit;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Action1;
import rx.functions.Func1;

final class CustomerServiceDefault
implements CustomerService {
    private static final String EMPTY_BODY = "";
    final CustomerRetrofitService retrofitService;
    final NetworkRetryPolicyProvider networkRetryPolicyProvider;
    final Scheduler callbackScheduler;
    final AtomicReference<CustomerToken> customerTokenRef = new AtomicReference();

    CustomerServiceDefault(Retrofit retrofit, CustomerToken customerToken, NetworkRetryPolicyProvider networkRetryPolicyProvider, Scheduler callbackScheduler) {
        this.retrofitService = (CustomerRetrofitService)retrofit.create(CustomerRetrofitService.class);
        this.customerTokenRef.set(customerToken);
        this.networkRetryPolicyProvider = networkRetryPolicyProvider;
        this.callbackScheduler = callbackScheduler;
    }

    @Override
    public CustomerToken getCustomerToken() {
        return this.customerTokenRef.get();
    }

    @Override
    public void setCustomerToken(CustomerToken customerToken) {
        this.customerTokenRef.set(customerToken);
    }

    @Override
    public CancellableTask createCustomer(AccountCredentials accountCredentials, Callback<Customer> callback) {
        return new CancellableTaskSubscriptionWrapper(this.createCustomer(accountCredentials).subscribe(new InternalCallbackSubscriber<Customer>(callback)));
    }

    @Override
    public Observable<Customer> createCustomer(final AccountCredentials accountCredentials) {
        if (accountCredentials == null) {
            throw new NullPointerException("accountCredentials cannot be null");
        }
        AccountCredentialsWrapper accountCredentialsWrapper = new AccountCredentialsWrapper(accountCredentials);
        return this.retrofitService.createCustomer(accountCredentialsWrapper).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).flatMap((Func1)new Func1<Customer, Observable<Customer>>(){

            public Observable<Customer> call(Customer customer) {
                return CustomerServiceDefault.this.loginCustomer(accountCredentials);
            }
        }).observeOn(this.callbackScheduler);
    }

    @Override
    @Deprecated
    public CancellableTask activateCustomer(Long customerId, String activationToken, AccountCredentials accountCredentials, Callback<Customer> callback) {
        return new CancellableTaskSubscriptionWrapper(this.activateCustomer(customerId, activationToken, accountCredentials).subscribe(new InternalCallbackSubscriber<Customer>(callback)));
    }

    @Override
    public Observable<Customer> activateCustomer(Long customerId, String activationToken, AccountCredentials accountCredentials) {
        if (customerId == null) {
            throw new NullPointerException("customerId cannot be null");
        }
        if (activationToken == null) {
            throw new NullPointerException("activationToken cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)activationToken)) {
            throw new IllegalArgumentException("activation token cannot be empty");
        }
        if (accountCredentials == null) {
            throw new NullPointerException("accountCredentials cannot be null");
        }
        AccountCredentialsWrapper accountCredentialsWrapper = new AccountCredentialsWrapper(accountCredentials);
        return this.retrofitService.activateCustomer(customerId, activationToken, accountCredentialsWrapper).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask resetPassword(Long customerId, String resetToken, AccountCredentials accountCredentials, Callback<Customer> callback) {
        return new CancellableTaskSubscriptionWrapper(this.resetPassword(customerId, resetToken, accountCredentials).subscribe(new InternalCallbackSubscriber<Customer>(callback)));
    }

    @Override
    public Observable<Customer> resetPassword(Long customerId, String resetToken, AccountCredentials accountCredentials) {
        if (customerId == null) {
            throw new NullPointerException("customerId cannot be null");
        }
        if (resetToken == null) {
            throw new NullPointerException("resetToken cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)resetToken)) {
            throw new IllegalArgumentException("reset token cannot be empty");
        }
        if (accountCredentials == null) {
            throw new NullPointerException("accountCredentials cannot be null");
        }
        AccountCredentialsWrapper accountCredentialsWrapper = new AccountCredentialsWrapper(accountCredentials);
        return this.retrofitService.resetPassword(customerId, resetToken, accountCredentialsWrapper).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask loginCustomer(AccountCredentials accountCredentials, Callback<Customer> callback) {
        return new CancellableTaskSubscriptionWrapper(this.loginCustomer(accountCredentials).subscribe(new InternalCallbackSubscriber<Customer>(callback)));
    }

    @Override
    public Observable<Customer> loginCustomer(AccountCredentials accountCredentials) {
        if (accountCredentials == null) {
            throw new NullPointerException("accountCredentials cannot be null");
        }
        AccountCredentialsWrapper accountCredentialsWrapper = new AccountCredentialsWrapper(accountCredentials);
        return this.retrofitService.getCustomerToken(accountCredentialsWrapper).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).doOnNext((Action1)new Action1<CustomerToken>(){

            public void call(CustomerToken token) {
                CustomerServiceDefault.this.customerTokenRef.set(token);
            }
        }).flatMap((Func1)new Func1<CustomerToken, Observable<Customer>>(){

            public Observable<Customer> call(CustomerToken customerToken) {
                return CustomerServiceDefault.this.getCustomer();
            }
        }).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask logoutCustomer(Callback<Void> callback) {
        return new CancellableTaskSubscriptionWrapper(this.logoutCustomer().subscribe(new InternalCallbackSubscriber<Void>(callback)));
    }

    @Override
    public Observable<Void> logoutCustomer() {
        CustomerToken customerToken = this.getCustomerToken();
        if (customerToken == null) {
            return Observable.error((Throwable)new BuyClientError(new IllegalStateException("customer must be logged in")));
        }
        return this.retrofitService.removeCustomerToken(customerToken.getCustomerId()).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).map((Func1)new Func1<Response<Void>, Void>(){

            public Void call(Response<Void> response) {
                return (Void)response.body();
            }
        }).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler).doOnNext((Action1)new Action1<Void>(){

            public void call(Void aVoid) {
                CustomerServiceDefault.this.customerTokenRef.set(null);
            }
        });
    }

    @Override
    public CancellableTask updateCustomer(Customer customer, Callback<Customer> callback) {
        return new CancellableTaskSubscriptionWrapper(this.updateCustomer(customer).subscribe(new InternalCallbackSubscriber<Customer>(callback)));
    }

    @Override
    public Observable<Customer> updateCustomer(Customer customer) {
        if (customer == null) {
            throw new NullPointerException("customer cannot be null");
        }
        CustomerToken customerToken = this.getCustomerToken();
        if (customerToken == null) {
            return Observable.error((Throwable)new BuyClientError(new IllegalStateException("customer must be logged in")));
        }
        return this.retrofitService.updateCustomer(customerToken.getCustomerId(), new CustomerWrapper(customer)).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask getCustomer(Callback<Customer> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getCustomer().subscribe(new InternalCallbackSubscriber<Customer>(callback)));
    }

    @Override
    public Observable<Customer> getCustomer() {
        CustomerToken customerToken = this.getCustomerToken();
        if (customerToken == null) {
            return Observable.error((Throwable)new BuyClientError(new IllegalStateException("customer must be logged in")));
        }
        return this.retrofitService.getCustomer(customerToken.getCustomerId()).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask renewCustomer(Callback<CustomerToken> callback) {
        return new CancellableTaskSubscriptionWrapper(this.renewCustomer().subscribe(new InternalCallbackSubscriber<CustomerToken>(callback)));
    }

    @Override
    public Observable<CustomerToken> renewCustomer() {
        CustomerToken customerToken = this.getCustomerToken();
        if (customerToken == null) {
            return Observable.error((Throwable)new BuyClientError(new IllegalStateException("customer must be logged in")));
        }
        return this.retrofitService.renewCustomerToken(EMPTY_BODY, customerToken.getCustomerId()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler).doOnNext((Action1)new Action1<CustomerToken>(){

            public void call(CustomerToken token) {
                CustomerServiceDefault.this.customerTokenRef.set(token);
            }
        });
    }

    @Override
    public CancellableTask recoverPassword(String email, Callback<Void> callback) {
        return new CancellableTaskSubscriptionWrapper(this.recoverPassword(email).subscribe(new InternalCallbackSubscriber<Void>(callback)));
    }

    @Override
    public Observable<Void> recoverPassword(String email) {
        if (email == null) {
            throw new NullPointerException("email cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)email)) {
            throw new IllegalArgumentException("email cannot be empty");
        }
        return this.retrofitService.recoverCustomer(new EmailWrapper(email)).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).map((Func1)new Func1<Response<Void>, Void>(){

            public Void call(Response<Void> response) {
                return (Void)response.body();
            }
        }).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }
}

