/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import com.shopify.buy.model.internal.AccountCredentialsWrapper;
import com.shopify.buy.model.internal.CustomerTokenWrapper;
import com.shopify.buy.model.internal.CustomerWrapper;
import com.shopify.buy.model.internal.EmailWrapper;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;

interface CustomerRetrofitService {
    @POST(value="api/customers.json")
    public Observable<Response<CustomerWrapper>> createCustomer(@Body AccountCredentialsWrapper var1);

    @PUT(value="api/customers/{customerId}/activate.json")
    public Observable<Response<CustomerWrapper>> activateCustomer(@Path(value="customerId") Long var1, @Query(value="token") String var2, @Body AccountCredentialsWrapper var3);

    @PUT(value="api/customers/{customerId}/reset.json")
    public Observable<Response<CustomerWrapper>> resetPassword(@Path(value="customerId") Long var1, @Query(value="token") String var2, @Body AccountCredentialsWrapper var3);

    @POST(value="api/customers/recover.json")
    public Observable<Response<Void>> recoverCustomer(@Body EmailWrapper var1);

    @GET(value="api/customers.json")
    public Observable<Response<CustomerWrapper>> getCustomer();

    @GET(value="api/customers/{customerId}.json")
    public Observable<Response<CustomerWrapper>> getCustomer(@Path(value="customerId") Long var1);

    @PUT(value="api/customers/{customerId}.json")
    public Observable<Response<CustomerWrapper>> updateCustomer(@Path(value="customerId") Long var1, @Body CustomerWrapper var2);

    @POST(value="api/customers/customer_token.json")
    public Observable<Response<CustomerTokenWrapper>> getCustomerToken(@Body AccountCredentialsWrapper var1);

    @DELETE(value="api/customers/{customerId}/customer_token.json")
    public Observable<Response<Void>> removeCustomerToken(@Path(value="customerId") Long var1);

    @PUT(value="api/customers/{customerId}/customer_token/renew.json")
    public Observable<Response<CustomerTokenWrapper>> renewCustomerToken(@Body String var1, @Path(value="customerId") Long var2);
}

