/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import android.text.TextUtils;
import com.shopify.buy.dataprovider.BuyClientExceptionHandler;
import com.shopify.buy.dataprovider.BuyClientUtils;
import com.shopify.buy.dataprovider.Callback;
import com.shopify.buy.dataprovider.CancellableTask;
import com.shopify.buy.dataprovider.CancellableTaskSubscriptionWrapper;
import com.shopify.buy.dataprovider.CheckoutRetrofitService;
import com.shopify.buy.dataprovider.CheckoutService;
import com.shopify.buy.dataprovider.InternalCallbackSubscriber;
import com.shopify.buy.dataprovider.NetworkRetryPolicyProvider;
import com.shopify.buy.dataprovider.PollingPolicyProvider;
import com.shopify.buy.dataprovider.PollingRequiredException;
import com.shopify.buy.dataprovider.RetrofitSuccessHttpStatusCodeHandler;
import com.shopify.buy.dataprovider.UnwrapRetrofitBodyTransformer;
import com.shopify.buy.model.Checkout;
import com.shopify.buy.model.CreditCard;
import com.shopify.buy.model.GiftCard;
import com.shopify.buy.model.PaymentToken;
import com.shopify.buy.model.ShippingRate;
import com.shopify.buy.model.internal.CheckoutWrapper;
import com.shopify.buy.model.internal.GiftCardWrapper;
import com.shopify.buy.model.internal.MarketingAttribution;
import com.shopify.buy.model.internal.PaymentSessionCheckout;
import com.shopify.buy.model.internal.PaymentSessionCheckoutWrapper;
import java.util.List;
import java.util.concurrent.TimeUnit;
import retrofit2.Response;
import retrofit2.Retrofit;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;

final class CheckoutServiceDefault
implements CheckoutService {
    public static final long POLLING_INTERVAL = TimeUnit.MILLISECONDS.toMillis(500L);
    public static final long POLLING_TIMEOUT = TimeUnit.SECONDS.toMillis(90L);
    final CheckoutRetrofitService retrofitService;
    final String apiKey;
    final String applicationName;
    final NetworkRetryPolicyProvider networkRetryPolicyProvider;
    final PollingPolicyProvider pollingRetryPolicyProvider;
    final Scheduler callbackScheduler;

    CheckoutServiceDefault(Retrofit retrofit, String apiKey, String applicationName, NetworkRetryPolicyProvider networkRetryPolicyProvider, Scheduler callbackScheduler) {
        this.retrofitService = (CheckoutRetrofitService)retrofit.create(CheckoutRetrofitService.class);
        this.apiKey = apiKey;
        this.applicationName = applicationName;
        this.networkRetryPolicyProvider = networkRetryPolicyProvider;
        this.callbackScheduler = callbackScheduler;
        this.pollingRetryPolicyProvider = new PollingPolicyProvider(POLLING_INTERVAL, POLLING_TIMEOUT);
    }

    @Override
    public CancellableTask createCheckout(Checkout checkout, Callback<Checkout> callback) {
        return new CancellableTaskSubscriptionWrapper(this.createCheckout(checkout).subscribe(new InternalCallbackSubscriber<Checkout>(callback)));
    }

    @Override
    public Observable<Checkout> createCheckout(Checkout checkout) {
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        Checkout safeCheckout = checkout.copy();
        safeCheckout.setMarketingAttribution(new MarketingAttribution(this.applicationName));
        safeCheckout.setSourceName("mobile_app");
        return this.retrofitService.createCheckout(new CheckoutWrapper(safeCheckout)).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask updateCheckout(Checkout checkout, Callback<Checkout> callback) {
        return new CancellableTaskSubscriptionWrapper(this.updateCheckout(checkout).subscribe(new InternalCallbackSubscriber<Checkout>(callback)));
    }

    @Override
    public Observable<Checkout> updateCheckout(Checkout checkout) {
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        Checkout safeCheckout = new Checkout(checkout.getToken());
        if (!TextUtils.isEmpty((CharSequence)checkout.getEmail())) {
            safeCheckout.setEmail(checkout.getEmail());
        }
        safeCheckout.setShippingAddress(checkout.getShippingAddress());
        safeCheckout.setBillingAddress(checkout.getBillingAddress());
        if (checkout.getLineItems() != null) {
            safeCheckout.setLineItems(checkout.getLineItems());
        }
        if (checkout.getDiscount() != null) {
            safeCheckout.setDiscountCode(checkout.getDiscount().getCode());
        }
        safeCheckout.setShippingRate(checkout.getShippingRate());
        if (checkout.getReservationTime() != null) {
            safeCheckout.setReservationTime(checkout.getReservationTime());
        }
        return this.retrofitService.updateCheckout(new CheckoutWrapper(safeCheckout), checkout.getToken()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask getShippingRates(String checkoutToken, Callback<List<ShippingRate>> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getShippingRates(checkoutToken).subscribe(new InternalCallbackSubscriber<List<ShippingRate>>(callback)));
    }

    @Override
    public Observable<List<ShippingRate>> getShippingRates(String checkoutToken) {
        if (checkoutToken == null) {
            throw new NullPointerException("checkoutToken cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)checkoutToken)) {
            throw new IllegalArgumentException("checkoutToken cannot be empty");
        }
        int[] successCodes = new int[]{200};
        return this.retrofitService.getShippingRates(checkoutToken).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler(successCodes)).retryWhen(this.pollingRetryPolicyProvider.provide()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask storeCreditCard(CreditCard card, Checkout checkout, Callback<PaymentToken> callback) {
        return new CancellableTaskSubscriptionWrapper(this.storeCreditCard(card, checkout).subscribe(new InternalCallbackSubscriber<PaymentToken>(callback)));
    }

    @Override
    public Observable<PaymentToken> storeCreditCard(CreditCard card, Checkout checkout) {
        if (card == null) {
            throw new NullPointerException("card cannot be null");
        }
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)checkout.getToken())) {
            throw new IllegalArgumentException("checkout token cannot be empty");
        }
        PaymentSessionCheckout paymentSessionCheckout = new PaymentSessionCheckout(checkout.getToken(), card, checkout.getBillingAddress());
        int[] successCodes = new int[]{200};
        return this.retrofitService.storeCreditCard(checkout.getPaymentUrl(), new PaymentSessionCheckoutWrapper(paymentSessionCheckout), BuyClientUtils.formatBasicAuthorization(this.apiKey)).doOnNext(new RetrofitSuccessHttpStatusCodeHandler(successCodes)).compose(new UnwrapRetrofitBodyTransformer()).map((Func1)new Func1<String, PaymentToken>(){

            public PaymentToken call(String sessionId) {
                return PaymentToken.createCreditCardPaymentToken(sessionId);
            }
        }).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask completeCheckout(PaymentToken paymentToken, String checkoutToken, Callback<Checkout> callback) {
        return new CancellableTaskSubscriptionWrapper(this.completeCheckout(paymentToken, checkoutToken).subscribe(new InternalCallbackSubscriber<Checkout>(callback)));
    }

    @Override
    public Observable<Checkout> completeCheckout(PaymentToken paymentToken, final String checkoutToken) {
        if (checkoutToken == null) {
            throw new NullPointerException("checkoutToken cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)checkoutToken)) {
            throw new IllegalArgumentException("checkout token cannot be empty");
        }
        PaymentToken paymentTokenToSend = paymentToken != null ? paymentToken : PaymentToken.createEmptyPaymentToken();
        return this.retrofitService.completeCheckout(paymentTokenToSend, checkoutToken).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).flatMap((Func1)new Func1<Response<Void>, Observable<Checkout>>(){

            public Observable<Checkout> call(Response<Void> voidResponse) {
                return CheckoutServiceDefault.this.getCompletedCheckout(checkoutToken);
            }
        }).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    private Observable<Checkout> getCompletedCheckout(final String checkoutToken) {
        return this.getCheckoutCompletionStatus(checkoutToken).flatMap((Func1)new Func1<Boolean, Observable<Checkout>>(){

            public Observable<Checkout> call(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    return CheckoutServiceDefault.this.getCheckout(checkoutToken);
                }
                return Observable.error((Throwable)new PollingRequiredException());
            }
        }).retryWhen(this.pollingRetryPolicyProvider.provide());
    }

    @Override
    public CancellableTask getCheckoutCompletionStatus(String checkoutToken, Callback<Boolean> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getCheckoutCompletionStatus(checkoutToken).subscribe(new InternalCallbackSubscriber<Boolean>(callback)));
    }

    @Override
    public Observable<Boolean> getCheckoutCompletionStatus(String checkoutToken) {
        if (checkoutToken == null) {
            throw new NullPointerException("checkoutToken cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)checkoutToken)) {
            throw new IllegalArgumentException("checkoutToken cannot be empty");
        }
        return this.retrofitService.getCheckoutCompletionStatus(checkoutToken).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).map((Func1)new Func1<Response<Void>, Boolean>(){

            public Boolean call(Response<Void> voidResponse) {
                return 200 == voidResponse.code();
            }
        }).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask getCheckout(String checkoutToken, Callback<Checkout> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getCheckout(checkoutToken).subscribe(new InternalCallbackSubscriber<Checkout>(callback)));
    }

    @Override
    public Observable<Checkout> getCheckout(String checkoutToken) {
        if (checkoutToken == null) {
            throw new NullPointerException("checkoutToken cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)checkoutToken)) {
            throw new IllegalArgumentException("checkoutToken cannot be empty");
        }
        return this.retrofitService.getCheckout(checkoutToken).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask applyGiftCard(String giftCardCode, Checkout checkout, Callback<Checkout> callback) {
        return new CancellableTaskSubscriptionWrapper(this.applyGiftCard(giftCardCode, checkout).subscribe(new InternalCallbackSubscriber<Checkout>(callback)));
    }

    @Override
    public Observable<Checkout> applyGiftCard(String giftCardCode, Checkout checkout) {
        if (giftCardCode == null) {
            throw new NullPointerException("giftCardCode cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)giftCardCode)) {
            throw new IllegalArgumentException("giftCardCode cannot be empty");
        }
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)checkout.getToken())) {
            throw new IllegalArgumentException("checkout token cannot be empty");
        }
        final Checkout safeCheckout = checkout.copy();
        GiftCard giftCard = new GiftCard(giftCardCode);
        return this.retrofitService.applyGiftCard(new GiftCardWrapper(giftCard), checkout.getToken()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).map((Func1)new Func1<GiftCard, Checkout>(){

            public Checkout call(GiftCard giftCard) {
                if (giftCard != null) {
                    safeCheckout.addGiftCard(giftCard);
                    safeCheckout.setPaymentDue(giftCard.getCheckout().getPaymentDue());
                }
                return safeCheckout;
            }
        }).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask removeGiftCard(Long giftCardId, Checkout checkout, Callback<Checkout> callback) {
        return new CancellableTaskSubscriptionWrapper(this.removeGiftCard(giftCardId, checkout).subscribe(new InternalCallbackSubscriber<Checkout>(callback)));
    }

    @Override
    public Observable<Checkout> removeGiftCard(Long giftCardId, Checkout checkout) {
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)checkout.getToken())) {
            throw new IllegalArgumentException("checkout token cannot be empty");
        }
        if (giftCardId == null) {
            throw new NullPointerException("giftCard cannot be null");
        }
        final Checkout safeCheckout = checkout.copy();
        return this.retrofitService.removeGiftCard(giftCardId, safeCheckout.getToken()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).map((Func1)new Func1<GiftCard, Checkout>(){

            public Checkout call(GiftCard giftCard) {
                if (giftCard != null) {
                    safeCheckout.removeGiftCard(giftCard);
                    safeCheckout.setPaymentDue(giftCard.getCheckout().getPaymentDue());
                }
                return safeCheckout;
            }
        }).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask removeProductReservationsFromCheckout(String checkoutToken, Callback<Checkout> callback) {
        return new CancellableTaskSubscriptionWrapper(this.removeProductReservationsFromCheckout(checkoutToken).subscribe(new InternalCallbackSubscriber<Checkout>(callback)));
    }

    @Override
    public Observable<Checkout> removeProductReservationsFromCheckout(String checkoutToken) {
        if (checkoutToken == null) {
            throw new NullPointerException("checkoutToken cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)checkoutToken)) {
            throw new IllegalArgumentException("checkoutToken cannot be empty");
        }
        Checkout expiredCheckout = new Checkout(checkoutToken);
        expiredCheckout.setReservationTime(0L);
        return this.updateCheckout(expiredCheckout);
    }
}

