/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import android.util.Base64;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.shopify.buy.model.Checkout;
import com.shopify.buy.model.Customer;
import com.shopify.buy.model.Product;
import com.shopify.buy.utils.DateUtility;
import java.nio.charset.Charset;
import java.util.Date;

public final class BuyClientUtils {
    public static Gson createDefaultGson() {
        return BuyClientUtils.createDefaultGson(null);
    }

    public static Gson createDefaultGson(Class forClass) {
        GsonBuilder builder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZZZ").registerTypeAdapter(Date.class, (Object)new DateUtility.DateDeserializer());
        if (!Product.class.equals((Object)forClass)) {
            builder.registerTypeAdapter(Product.class, (Object)new Product.ProductDeserializer());
        }
        if (!Customer.class.equals((Object)forClass)) {
            builder.registerTypeAdapter(Customer.class, (Object)new Customer.CustomerDeserializer());
        }
        if (!Checkout.class.equals((Object)forClass)) {
            builder.registerTypeAdapter(Checkout.class, (Object)new Checkout.CheckoutSerializer());
            builder.registerTypeAdapter(Checkout.class, (Object)new Checkout.CheckoutDeserializer());
        }
        return builder.create();
    }

    public static String formatBasicAuthorization(String token) {
        return String.format("Basic %s", Base64.encodeToString((byte[])token.getBytes(Charset.forName("UTF-8")), (int)2));
    }

    private BuyClientUtils() {
    }
}

