/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import android.text.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Response;

public final class BuyClientError
extends RuntimeException {
    public static final int ERROR_TYPE_API = -2;
    public static final int ERROR_TYPE_NETWORK = -1;
    public static final int ERROR_TYPE_UNKNOWN = 0;
    private final int type;
    private final Response retrofitResponse;
    private final String retrofitErrorBody;
    private final JSONObject errorsRootJsonObject;

    public BuyClientError(Throwable throwable) {
        super(throwable);
        this.retrofitResponse = null;
        this.retrofitErrorBody = "";
        if (throwable instanceof IOException) {
            this.type = -1;
            this.errorsRootJsonObject = null;
        } else {
            this.type = 0;
            this.errorsRootJsonObject = null;
        }
    }

    public BuyClientError(Response retrofitResponse) {
        this.retrofitResponse = retrofitResponse;
        if (retrofitResponse != null) {
            this.type = -2;
            this.retrofitErrorBody = this.extractRetrofitErrorBody(retrofitResponse);
            this.errorsRootJsonObject = this.parseRetrofitErrorResponse(this.retrofitErrorBody);
        } else {
            this.type = 0;
            this.errorsRootJsonObject = null;
            this.retrofitErrorBody = "";
        }
    }

    public int getType() {
        return this.type;
    }

    public Response getRetrofitResponse() {
        return this.retrofitResponse;
    }

    public String getRetrofitErrorBody() {
        return this.retrofitErrorBody;
    }

    public Map<String, String> getErrors(String ... path) {
        if (this.errorsRootJsonObject == null) {
            return null;
        }
        if (path == null || path.length == 0) {
            return null;
        }
        Iterator<String> pathIterator = Arrays.asList(path).iterator();
        JSONObject rootJsonObject = this.errorsRootJsonObject;
        try {
            String pathElement;
            while (pathIterator.hasNext() && rootJsonObject.has(pathElement = pathIterator.next())) {
                if (pathIterator.hasNext()) {
                    rootJsonObject = rootJsonObject.getJSONObject(pathElement);
                    continue;
                }
                return this.parseErrorMessages(rootJsonObject.getJSONArray(pathElement));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public List<Map<String, String>> getLineItemErrors(String property) {
        if (this.errorsRootJsonObject == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)property)) {
            return null;
        }
        Iterator<String> pathIterator = Arrays.asList("checkout", "line_items").iterator();
        JSONObject rootJsonObject = this.errorsRootJsonObject;
        try {
            JSONArray lineItemJsonErrors = null;
            while (pathIterator.hasNext()) {
                String pathElement = pathIterator.next();
                if (rootJsonObject.has(pathElement)) {
                    if (pathIterator.hasNext()) {
                        rootJsonObject = rootJsonObject.getJSONObject(pathElement);
                        continue;
                    }
                    lineItemJsonErrors = rootJsonObject.getJSONArray(pathElement);
                    continue;
                }
                return null;
            }
            if (lineItemJsonErrors == null) {
                return null;
            }
            ArrayList<Map<String, String>> lineItemErrors = new ArrayList<Map<String, String>>();
            for (int i = 0; i < lineItemJsonErrors.length(); ++i) {
                JSONObject lineItemError;
                lineItemErrors.add(null);
                if (lineItemJsonErrors.isNull(i) || !(lineItemError = lineItemJsonErrors.getJSONObject(i)).has(property)) continue;
                try {
                    lineItemErrors.set(i, this.parseErrorMessages(lineItemError.getJSONArray(property)));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return lineItemErrors;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String extractRetrofitErrorBody(Response retrofitResponse) {
        try {
            return retrofitResponse.errorBody().string();
        }
        catch (Exception e) {
            return "";
        }
    }

    private JSONObject parseRetrofitErrorResponse(String retrofitErrorBody) {
        if (TextUtils.isEmpty((CharSequence)retrofitErrorBody)) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(retrofitErrorBody);
            if (jsonObject.has("errors")) {
                return jsonObject.getJSONObject("errors");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    private Map<String, String> parseErrorMessages(JSONArray errors) throws JSONException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < errors.length(); ++i) {
            JSONObject error = errors.getJSONObject(i);
            result.put(error.getString("code"), error.getString("message"));
        }
        return result;
    }
}

