/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.shopify.buy.dataprovider.AddressService;
import com.shopify.buy.dataprovider.AddressServiceDefault;
import com.shopify.buy.dataprovider.BuyClient;
import com.shopify.buy.dataprovider.BuyClientUtils;
import com.shopify.buy.dataprovider.Callback;
import com.shopify.buy.dataprovider.CancellableTask;
import com.shopify.buy.dataprovider.CheckoutService;
import com.shopify.buy.dataprovider.CheckoutServiceDefault;
import com.shopify.buy.dataprovider.CustomerService;
import com.shopify.buy.dataprovider.CustomerServiceDefault;
import com.shopify.buy.dataprovider.NetworkRetryPolicyProvider;
import com.shopify.buy.dataprovider.OrderService;
import com.shopify.buy.dataprovider.OrderServiceDefault;
import com.shopify.buy.dataprovider.ProductService;
import com.shopify.buy.dataprovider.ProductServiceDefault;
import com.shopify.buy.dataprovider.StoreService;
import com.shopify.buy.dataprovider.StoreServiceDefault;
import com.shopify.buy.model.AccountCredentials;
import com.shopify.buy.model.Address;
import com.shopify.buy.model.Checkout;
import com.shopify.buy.model.Collection;
import com.shopify.buy.model.CreditCard;
import com.shopify.buy.model.Customer;
import com.shopify.buy.model.CustomerToken;
import com.shopify.buy.model.Order;
import com.shopify.buy.model.PaymentToken;
import com.shopify.buy.model.Product;
import com.shopify.buy.model.ShippingRate;
import com.shopify.buy.model.Shop;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;
import rx.Observable;
import rx.Scheduler;
import rx.schedulers.Schedulers;

final class BuyClientDefault
implements BuyClient {
    private static final String CUSTOMER_TOKEN_HEADER = "X-Shopify-Customer-Access-Token";
    private final String shopDomain;
    private final String apiKey;
    private final String appId;
    private final String applicationName;
    final StoreService storeService;
    final AddressService addressService;
    final CheckoutService checkoutService;
    final CustomerService customerService;
    final OrderService orderService;
    final ProductService productService;

    BuyClientDefault(final String apiKey, String appId, final String applicationName, String shopDomain, CustomerToken customerToken, Scheduler callbackScheduler, int productPageSize, int networkRequestRetryMaxCount, long networkRequestRetryDelayMs, float networkRequestRetryBackoffMultiplier, long httpConnectionTimeoutMs, long httpReadWriteTimeoutMs, Interceptor ... interceptors) {
        this.apiKey = apiKey;
        this.appId = appId;
        this.applicationName = applicationName;
        this.shopDomain = shopDomain;
        Interceptor requestInterceptor = new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request.Builder builder = original.newBuilder().method(original.method(), original.body());
                builder.header("Authorization", BuyClientUtils.formatBasicAuthorization(apiKey));
                CustomerToken customerToken = BuyClientDefault.this.customerService.getCustomerToken();
                if (customerToken != null && !TextUtils.isEmpty((CharSequence)customerToken.getAccessToken())) {
                    builder.header(BuyClientDefault.CUSTOMER_TOKEN_HEADER, customerToken.getAccessToken());
                }
                builder.header("User-Agent", "Mobile Buy SDK Android/2.0.2/" + applicationName);
                return chain.proceed(builder.build());
            }
        };
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(httpConnectionTimeoutMs, TimeUnit.MILLISECONDS).readTimeout(httpReadWriteTimeoutMs, TimeUnit.MILLISECONDS).writeTimeout(httpReadWriteTimeoutMs, TimeUnit.MILLISECONDS).addInterceptor(requestInterceptor);
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                builder.addInterceptor(interceptor);
            }
        }
        OkHttpClient httpClient = builder.build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://" + shopDomain + "/").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)BuyClientUtils.createDefaultGson())).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.createWithScheduler((Scheduler)Schedulers.io())).client(httpClient).build();
        NetworkRetryPolicyProvider networkRetryPolicyProvider = new NetworkRetryPolicyProvider(networkRequestRetryMaxCount, networkRequestRetryDelayMs, networkRequestRetryBackoffMultiplier);
        this.storeService = new StoreServiceDefault(retrofit, networkRetryPolicyProvider, callbackScheduler);
        this.checkoutService = new CheckoutServiceDefault(retrofit, apiKey, applicationName, networkRetryPolicyProvider, callbackScheduler);
        this.customerService = new CustomerServiceDefault(retrofit, customerToken, networkRetryPolicyProvider, callbackScheduler);
        this.addressService = new AddressServiceDefault(retrofit, networkRetryPolicyProvider, callbackScheduler, this.customerService);
        this.orderService = new OrderServiceDefault(retrofit, networkRetryPolicyProvider, callbackScheduler, this.customerService);
        this.productService = new ProductServiceDefault(retrofit, appId, productPageSize, networkRetryPolicyProvider, callbackScheduler);
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getShopDomain() {
        return this.shopDomain;
    }

    @Override
    public CancellableTask getShop(Callback<Shop> callback) {
        return this.storeService.getShop(callback);
    }

    @Override
    public Observable<Shop> getShop() {
        return this.storeService.getShop();
    }

    @Override
    public CancellableTask createCheckout(Checkout checkout, Callback<Checkout> callback) {
        return this.checkoutService.createCheckout(checkout, callback);
    }

    @Override
    public Observable<Checkout> createCheckout(Checkout checkout) {
        return this.checkoutService.createCheckout(checkout);
    }

    @Override
    public CancellableTask updateCheckout(Checkout checkout, Callback<Checkout> callback) {
        return this.checkoutService.updateCheckout(checkout, callback);
    }

    @Override
    public Observable<Checkout> updateCheckout(Checkout checkout) {
        return this.checkoutService.updateCheckout(checkout);
    }

    @Override
    public CancellableTask getShippingRates(String checkoutToken, Callback<List<ShippingRate>> callback) {
        return this.checkoutService.getShippingRates(checkoutToken, callback);
    }

    @Override
    public Observable<List<ShippingRate>> getShippingRates(String checkoutToken) {
        return this.checkoutService.getShippingRates(checkoutToken);
    }

    @Override
    public CancellableTask storeCreditCard(CreditCard card, Checkout checkout, Callback<PaymentToken> callback) {
        return this.checkoutService.storeCreditCard(card, checkout, callback);
    }

    @Override
    public Observable<PaymentToken> storeCreditCard(CreditCard card, Checkout checkout) {
        return this.checkoutService.storeCreditCard(card, checkout);
    }

    @Override
    public CancellableTask getCheckoutCompletionStatus(String checkoutToken, Callback<Boolean> callback) {
        return this.checkoutService.getCheckoutCompletionStatus(checkoutToken, callback);
    }

    @Override
    public Observable<Boolean> getCheckoutCompletionStatus(String checkoutToken) {
        return this.checkoutService.getCheckoutCompletionStatus(checkoutToken);
    }

    @Override
    public Observable<Checkout> completeCheckout(PaymentToken paymentToken, String checkoutToken) {
        return this.checkoutService.completeCheckout(paymentToken, checkoutToken);
    }

    @Override
    public CancellableTask completeCheckout(PaymentToken paymentToken, String checkoutToken, Callback<Checkout> callback) {
        return this.checkoutService.completeCheckout(paymentToken, checkoutToken, callback);
    }

    @Override
    public CancellableTask getCheckout(String checkoutToken, Callback<Checkout> callback) {
        return this.checkoutService.getCheckout(checkoutToken, callback);
    }

    @Override
    public Observable<Checkout> getCheckout(String checkoutToken) {
        return this.checkoutService.getCheckout(checkoutToken);
    }

    @Override
    public CancellableTask applyGiftCard(String giftCardCode, Checkout checkout, Callback<Checkout> callback) {
        return this.checkoutService.applyGiftCard(giftCardCode, checkout, callback);
    }

    @Override
    public Observable<Checkout> applyGiftCard(String giftCardCode, Checkout checkout) {
        return this.checkoutService.applyGiftCard(giftCardCode, checkout);
    }

    @Override
    public CancellableTask removeGiftCard(Long giftCardId, Checkout checkout, Callback<Checkout> callback) {
        return this.checkoutService.removeGiftCard(giftCardId, checkout, callback);
    }

    @Override
    public Observable<Checkout> removeGiftCard(Long giftCardId, Checkout checkout) {
        return this.checkoutService.removeGiftCard(giftCardId, checkout);
    }

    @Override
    public CancellableTask removeProductReservationsFromCheckout(String checkoutToken, Callback<Checkout> callback) {
        return this.checkoutService.removeProductReservationsFromCheckout(checkoutToken, callback);
    }

    @Override
    public Observable<Checkout> removeProductReservationsFromCheckout(String checkoutToken) {
        return this.checkoutService.removeProductReservationsFromCheckout(checkoutToken);
    }

    @Override
    public CustomerToken getCustomerToken() {
        return this.customerService.getCustomerToken();
    }

    @Override
    public void setCustomerToken(CustomerToken customerToken) {
        this.customerService.setCustomerToken(customerToken);
    }

    @Override
    public CancellableTask createCustomer(AccountCredentials accountCredentials, Callback<Customer> callback) {
        return this.customerService.createCustomer(accountCredentials, callback);
    }

    @Override
    public Observable<Customer> createCustomer(AccountCredentials accountCredentials) {
        return this.customerService.createCustomer(accountCredentials);
    }

    @Override
    public CancellableTask activateCustomer(Long customerId, String activationToken, AccountCredentials accountCredentials, Callback<Customer> callback) {
        return this.customerService.activateCustomer(customerId, activationToken, accountCredentials, callback);
    }

    @Override
    public Observable<Customer> activateCustomer(Long customerId, String activationToken, AccountCredentials accountCredentials) {
        return this.customerService.activateCustomer(customerId, activationToken, accountCredentials);
    }

    @Override
    public CancellableTask resetPassword(Long customerId, String resetToken, AccountCredentials accountCredentials, Callback<Customer> callback) {
        return this.customerService.resetPassword(customerId, resetToken, accountCredentials, callback);
    }

    @Override
    public Observable<Customer> resetPassword(Long customerId, String resetToken, AccountCredentials accountCredentials) {
        return this.customerService.resetPassword(customerId, resetToken, accountCredentials);
    }

    @Override
    public CancellableTask loginCustomer(AccountCredentials accountCredentials, Callback<Customer> callback) {
        return this.customerService.loginCustomer(accountCredentials, callback);
    }

    @Override
    public Observable<Customer> loginCustomer(AccountCredentials accountCredentials) {
        return this.customerService.loginCustomer(accountCredentials);
    }

    @Override
    public CancellableTask logoutCustomer(Callback<Void> callback) {
        return this.customerService.logoutCustomer(callback);
    }

    @Override
    public Observable<Void> logoutCustomer() {
        return this.customerService.logoutCustomer();
    }

    @Override
    public CancellableTask updateCustomer(Customer customer, Callback<Customer> callback) {
        return this.customerService.updateCustomer(customer, callback);
    }

    @Override
    public Observable<Customer> updateCustomer(Customer customer) {
        return this.customerService.updateCustomer(customer);
    }

    @Override
    public CancellableTask getCustomer(Callback<Customer> callback) {
        return this.customerService.getCustomer(callback);
    }

    @Override
    public Observable<Customer> getCustomer() {
        return this.customerService.getCustomer();
    }

    @Override
    public CancellableTask renewCustomer(Callback<CustomerToken> callback) {
        return this.customerService.renewCustomer(callback);
    }

    @Override
    public Observable<CustomerToken> renewCustomer() {
        return this.customerService.renewCustomer();
    }

    @Override
    public CancellableTask recoverPassword(String email, Callback<Void> callback) {
        return this.customerService.recoverPassword(email, callback);
    }

    @Override
    public Observable<Void> recoverPassword(String email) {
        return this.customerService.recoverPassword(email);
    }

    @Override
    public CancellableTask getOrders(Callback<List<Order>> callback) {
        return this.orderService.getOrders(callback);
    }

    @Override
    public Observable<List<Order>> getOrders() {
        return this.orderService.getOrders();
    }

    @Override
    public CancellableTask getOrder(Long orderId, Callback<Order> callback) {
        return this.orderService.getOrder(orderId, callback);
    }

    @Override
    public Observable<Order> getOrder(Long orderId) {
        return this.orderService.getOrder(orderId);
    }

    @Override
    public CancellableTask createAddress(Address address, Callback<Address> callback) {
        return this.addressService.createAddress(address, callback);
    }

    @Override
    public Observable<Address> createAddress(Address address) {
        return this.addressService.createAddress(address);
    }

    @Override
    public CancellableTask getAddresses(Callback<List<Address>> callback) {
        return this.addressService.getAddresses(callback);
    }

    @Override
    public Observable<List<Address>> getAddresses() {
        return this.addressService.getAddresses();
    }

    @Override
    public CancellableTask getAddress(Long addressId, Callback<Address> callback) {
        return this.addressService.getAddress(addressId, callback);
    }

    @Override
    public Observable<Address> getAddress(Long addressId) {
        return this.addressService.getAddress(addressId);
    }

    @Override
    public CancellableTask updateAddress(Address address, Callback<Address> callback) {
        return this.addressService.updateAddress(address, callback);
    }

    @Override
    public CancellableTask deleteAddress(Long addressId, Callback<Void> callback) {
        return this.addressService.deleteAddress(addressId, callback);
    }

    @Override
    public Observable<Void> deleteAddress(Long addressId) {
        return this.addressService.deleteAddress(addressId);
    }

    @Override
    public Observable<Address> updateAddress(Address address) {
        return this.addressService.updateAddress(address);
    }

    @Override
    public int getProductPageSize() {
        return this.productService.getProductPageSize();
    }

    @Override
    public CancellableTask getProducts(int page, Callback<List<Product>> callback) {
        return this.productService.getProducts(page, callback);
    }

    @Override
    public Observable<List<Product>> getProducts(int page) {
        return this.productService.getProducts(page);
    }

    @Override
    public CancellableTask getProductByHandle(String handle, Callback<Product> callback) {
        return this.productService.getProductByHandle(handle, callback);
    }

    @Override
    public Observable<Product> getProductByHandle(String handle) {
        return this.productService.getProductByHandle(handle);
    }

    @Override
    public CancellableTask getProduct(Long productId, Callback<Product> callback) {
        return this.productService.getProduct(productId, callback);
    }

    @Override
    public Observable<Product> getProduct(Long productId) {
        return this.productService.getProduct(productId);
    }

    @Override
    public CancellableTask getProducts(List<Long> productIds, Callback<List<Product>> callback) {
        return this.productService.getProducts(productIds, callback);
    }

    @Override
    public Observable<List<Product>> getProducts(List<Long> productIds) {
        return this.productService.getProducts(productIds);
    }

    @Override
    public CancellableTask getCollections(int page, Callback<List<Collection>> callback) {
        return this.productService.getCollections(page, callback);
    }

    @Override
    public CancellableTask getCollectionByHandle(String handle, Callback<Collection> callback) {
        return this.productService.getCollectionByHandle(handle, callback);
    }

    @Override
    public Observable<Collection> getCollectionByHandle(String handle) {
        return this.productService.getCollectionByHandle(handle);
    }

    @Override
    public Observable<List<Collection>> getCollections(int page) {
        return this.productService.getCollections(page);
    }

    @Override
    public CancellableTask getProductTags(int page, Callback<List<String>> callback) {
        return this.productService.getProductTags(page, callback);
    }

    @Override
    public Observable<List<String>> getProductTags(int page) {
        return this.productService.getProductTags(page);
    }

    @Override
    public CancellableTask getProducts(int page, Set<String> tags, Callback<List<Product>> callback) {
        return this.productService.getProducts(page, tags, callback);
    }

    @Override
    public Observable<List<Product>> getProducts(int page, Set<String> tags) {
        return this.productService.getProducts(page, tags);
    }

    @Override
    public CancellableTask getProducts(int page, Long collectionId, Set<String> tags, Collection.SortOrder sortOrder, Callback<List<Product>> callback) {
        return this.productService.getProducts(page, collectionId, tags, sortOrder, callback);
    }

    @Override
    public Observable<List<Product>> getProducts(int page, Long collectionId, Set<String> tags, Collection.SortOrder sortOrder) {
        return this.productService.getProducts(page, collectionId, tags, sortOrder);
    }
}

