/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import android.text.TextUtils;
import com.shopify.buy.dataprovider.BuyClient;
import com.shopify.buy.dataprovider.BuyClientDefault;
import com.shopify.buy.model.CustomerToken;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import rx.Scheduler;
import rx.android.schedulers.AndroidSchedulers;

public final class BuyClientBuilder {
    public static final int MAX_PAGE_SIZE = 250;
    public static final int MIN_PAGE_SIZE = 1;
    public static final int DEFAULT_PAGE_SIZE = 25;
    public static final long DEFAULT_HTTP_CONNECTION_TIME_OUT_MS = TimeUnit.SECONDS.toMillis(30L);
    public static final long DEFAULT_HTTP_READ_WRITE_TIME_OUT_MS = TimeUnit.SECONDS.toMillis(60L);
    public static final long MIN_NETWORK_RETRY_DELAY = TimeUnit.MILLISECONDS.toMillis(500L);
    private String shopDomain;
    private String apiKey;
    private String appId;
    private String applicationName;
    private CustomerToken customerToken;
    private Scheduler callbackScheduler = AndroidSchedulers.mainThread();
    private Interceptor[] interceptors;
    private int productPageSize = 25;
    private int networkRequestRetryMaxCount;
    private long networkRequestRetryDelayMs;
    private float networkRequestRetryBackoffMultiplier;
    private long httpConnectionTimeoutMs = DEFAULT_HTTP_CONNECTION_TIME_OUT_MS;
    private long httpReadWriteTimeoutMs = DEFAULT_HTTP_READ_WRITE_TIME_OUT_MS;

    public BuyClientBuilder shopDomain(String shopDomain) {
        this.shopDomain = shopDomain;
        return this;
    }

    public BuyClientBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public BuyClientBuilder appId(String appId) {
        this.appId = appId;
        return this;
    }

    public BuyClientBuilder applicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public BuyClientBuilder customerToken(CustomerToken customerToken) {
        this.customerToken = customerToken;
        return this;
    }

    public BuyClientBuilder callbackScheduler(Scheduler callbackScheduler) {
        this.callbackScheduler = callbackScheduler;
        return this;
    }

    public BuyClientBuilder interceptors(Interceptor ... interceptors) {
        this.interceptors = interceptors;
        return this;
    }

    public BuyClientBuilder productPageSize(int productPageSize) {
        this.productPageSize = Math.max(Math.min(productPageSize, 250), 1);
        return this;
    }

    public BuyClientBuilder networkRequestRetryPolicy(int networkRequestRetryMaxCount, long networkRequestRetryDelayMs, float networkRequestRetryBackoffMultiplier) {
        this.networkRequestRetryMaxCount = networkRequestRetryMaxCount;
        this.networkRequestRetryDelayMs = Math.max(networkRequestRetryDelayMs, MIN_NETWORK_RETRY_DELAY);
        this.networkRequestRetryBackoffMultiplier = networkRequestRetryBackoffMultiplier;
        return this;
    }

    public BuyClientBuilder httpTimeout(long httpConnectionTimeoutMs, long httpReadWriteTimeoutMs) {
        this.httpConnectionTimeoutMs = httpConnectionTimeoutMs;
        this.httpReadWriteTimeoutMs = httpReadWriteTimeoutMs;
        return this;
    }

    public BuyClient build() {
        if (TextUtils.isEmpty((CharSequence)this.shopDomain) || this.shopDomain.contains(":") || this.shopDomain.contains("/") || !this.shopDomain.contains(".myshopify.com")) {
            throw new IllegalArgumentException("shopDomain is not set or invalid. shopDomain must be of the form 'shopname.myshopify.com' and cannot start with 'http://'");
        }
        if (TextUtils.isEmpty((CharSequence)this.apiKey)) {
            throw new IllegalArgumentException("apiKey is not set or invalid. apiKey must be provided, and cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            throw new IllegalArgumentException("appId is not set or invalid. appId must be provided, and cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.applicationName)) {
            throw new IllegalArgumentException("applicationName is not set or invalid. applicationName must be provided, and cannot be empty");
        }
        return new BuyClientDefault(this.apiKey, this.appId, this.applicationName, this.shopDomain, this.customerToken, this.callbackScheduler, this.productPageSize, this.networkRequestRetryMaxCount, this.networkRequestRetryDelayMs, this.networkRequestRetryBackoffMultiplier, this.httpConnectionTimeoutMs, this.httpReadWriteTimeoutMs, this.interceptors);
    }
}

