/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import com.shopify.buy.dataprovider.AddressRetrofitService;
import com.shopify.buy.dataprovider.AddressService;
import com.shopify.buy.dataprovider.BuyClientError;
import com.shopify.buy.dataprovider.BuyClientExceptionHandler;
import com.shopify.buy.dataprovider.Callback;
import com.shopify.buy.dataprovider.CancellableTask;
import com.shopify.buy.dataprovider.CancellableTaskSubscriptionWrapper;
import com.shopify.buy.dataprovider.CustomerService;
import com.shopify.buy.dataprovider.InternalCallbackSubscriber;
import com.shopify.buy.dataprovider.NetworkRetryPolicyProvider;
import com.shopify.buy.dataprovider.RetrofitSuccessHttpStatusCodeHandler;
import com.shopify.buy.dataprovider.UnwrapRetrofitBodyTransformer;
import com.shopify.buy.model.Address;
import com.shopify.buy.model.CustomerToken;
import com.shopify.buy.model.internal.AddressWrapper;
import java.util.List;
import retrofit2.Response;
import retrofit2.Retrofit;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;

final class AddressServiceDefault
implements AddressService {
    final AddressRetrofitService retrofitService;
    final NetworkRetryPolicyProvider networkRetryPolicyProvider;
    final Scheduler callbackScheduler;
    final CustomerService customerService;

    AddressServiceDefault(Retrofit retrofit, NetworkRetryPolicyProvider networkRetryPolicyProvider, Scheduler callbackScheduler, CustomerService customerService) {
        this.retrofitService = (AddressRetrofitService)retrofit.create(AddressRetrofitService.class);
        this.networkRetryPolicyProvider = networkRetryPolicyProvider;
        this.callbackScheduler = callbackScheduler;
        this.customerService = customerService;
    }

    @Override
    public CancellableTask createAddress(Address address, Callback<Address> callback) {
        return new CancellableTaskSubscriptionWrapper(this.createAddress(address).subscribe(new InternalCallbackSubscriber<Address>(callback)));
    }

    @Override
    public Observable<Address> createAddress(Address address) {
        if (address == null) {
            throw new NullPointerException("address cannot be null");
        }
        CustomerToken customerToken = this.customerService.getCustomerToken();
        if (customerToken == null) {
            return Observable.error((Throwable)new BuyClientError(new IllegalStateException("customer must be logged in")));
        }
        return this.retrofitService.createAddress(customerToken.getCustomerId(), new AddressWrapper(address)).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask deleteAddress(Long addressId, Callback<Void> callback) {
        return new CancellableTaskSubscriptionWrapper(this.deleteAddress(addressId).subscribe(new InternalCallbackSubscriber<Void>(callback)));
    }

    @Override
    public Observable<Void> deleteAddress(Long addressId) {
        if (addressId == null) {
            throw new NullPointerException("addressId cannot be null");
        }
        CustomerToken customerToken = this.customerService.getCustomerToken();
        if (customerToken == null) {
            return Observable.error((Throwable)new BuyClientError(new IllegalStateException("customer must be logged in")));
        }
        int[] successCodes = new int[]{204};
        return this.retrofitService.deleteAddress(customerToken.getCustomerId(), addressId).doOnNext(new RetrofitSuccessHttpStatusCodeHandler(successCodes)).map((Func1)new Func1<Response<Void>, Void>(){

            public Void call(Response<Void> voidResponse) {
                return (Void)voidResponse.body();
            }
        }).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask getAddresses(Callback<List<Address>> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getAddresses().subscribe(new InternalCallbackSubscriber<List<Address>>(callback)));
    }

    @Override
    public Observable<List<Address>> getAddresses() {
        if (this.customerService.getCustomerToken() == null) {
            return Observable.error((Throwable)new BuyClientError(new IllegalStateException("customer must be logged in")));
        }
        return this.retrofitService.getAddresses(this.customerService.getCustomerToken().getCustomerId()).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask getAddress(Long addressId, Callback<Address> callback) {
        return new CancellableTaskSubscriptionWrapper(this.getAddress(addressId).subscribe(new InternalCallbackSubscriber<Address>(callback)));
    }

    @Override
    public Observable<Address> getAddress(Long addressId) {
        if (addressId == null) {
            throw new NullPointerException("addressId cannot be null");
        }
        CustomerToken customerToken = this.customerService.getCustomerToken();
        if (customerToken == null) {
            return Observable.error((Throwable)new BuyClientError(new IllegalStateException("customer must be logged in")));
        }
        return this.retrofitService.getAddress(customerToken.getCustomerId(), addressId).retryWhen(this.networkRetryPolicyProvider.provide()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }

    @Override
    public CancellableTask updateAddress(Address address, Callback<Address> callback) {
        return new CancellableTaskSubscriptionWrapper(this.updateAddress(address).subscribe(new InternalCallbackSubscriber<Address>(callback)));
    }

    @Override
    public Observable<Address> updateAddress(Address address) {
        if (address == null) {
            throw new NullPointerException("address cannot be null");
        }
        CustomerToken customerToken = this.customerService.getCustomerToken();
        if (customerToken == null) {
            return Observable.error((Throwable)new BuyClientError(new IllegalStateException("customer must be logged in")));
        }
        return this.retrofitService.updateAddress(customerToken.getCustomerId(), new AddressWrapper(address), address.getId()).doOnNext(new RetrofitSuccessHttpStatusCodeHandler()).compose(new UnwrapRetrofitBodyTransformer()).onErrorResumeNext(new BuyClientExceptionHandler()).observeOn(this.callbackScheduler);
    }
}

