/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.utils;

import android.net.Uri;
import android.util.Log;
import android.widget.ImageView;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import java.net.URI;

public class ImageUtility {
    private static final String LOG_TAG = ImageUtility.class.getSimpleName();

    public static String getSizedImageUrl(String featuredImageUrl, int imageTargetWidthPx, int imageTargetHeightPx) {
        if (featuredImageUrl == null) {
            return null;
        }
        try {
            URI originalUri = new URI(featuredImageUrl);
            String path = originalUri.getPath();
            String sizeSuffix = ImageUtility.getImageSuffixForDimensions(imageTargetWidthPx, imageTargetHeightPx);
            int extensionSeparatorPos = path.lastIndexOf(46);
            String suffixedPath = -1 == extensionSeparatorPos ? path + sizeSuffix : path.substring(0, extensionSeparatorPos) + sizeSuffix + path.substring(extensionSeparatorPos);
            return Uri.parse((String)featuredImageUrl).buildUpon().path(suffixedPath).toString();
        }
        catch (Exception e) {
            Log.v((String)LOG_TAG, (String)"Getting sized image URL", (Throwable)e);
            return null;
        }
    }

    public static void loadRemoteImageIntoViewWithoutSize(Picasso imageLoader, String imageSrc, ImageView imageView, int parentWidth, int parentHeight, boolean crop, Callback callback) {
        String imageUrl = ImageUtility.getSizedImageUrl(imageSrc, parentWidth, parentHeight);
        RequestCreator c = imageLoader.load(imageUrl).fit();
        c = crop ? c.centerCrop() : c.centerInside();
        c.into(imageView, callback);
    }

    private static String getImageSuffixForDimensions(int width, int height) {
        int pixels = Math.max(width, height);
        if (pixels <= 16) {
            return "_pico";
        }
        if (pixels <= 32) {
            return "_icon";
        }
        if (pixels <= 50) {
            return "_thumb";
        }
        if (pixels <= 100) {
            return "_small";
        }
        if (pixels <= 160) {
            return "_compact";
        }
        if (pixels <= 240) {
            return "_medium";
        }
        if (pixels <= 480) {
            return "_large";
        }
        if (pixels <= 600) {
            return "_grande";
        }
        if (pixels <= 1024) {
            return "_1024x1024";
        }
        return "_2048x2048";
    }
}

