/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CurrencyFormatter {
    private static final String DEFAULT_CURRENCY = "USD";
    private static final Map<FormatterAttributes, NumberFormat> cache = new HashMap<FormatterAttributes, NumberFormat>();

    public static NumberFormat getFormatter(Locale displayLocale, String currencyToFormat) {
        return CurrencyFormatter.getFormatter(displayLocale, currencyToFormat, true, true);
    }

    public static NumberFormat getFormatter(Locale displayLocale, String currencyToFormat, boolean withSymbol, boolean includeGroupingSeparator) {
        Currency currency;
        FormatterAttributes cacheKey = new FormatterAttributes(displayLocale.toString(), currencyToFormat, withSymbol, includeGroupingSeparator);
        if (cache.containsKey(cacheKey)) {
            return cache.get(cacheKey);
        }
        try {
            currency = Currency.getInstance(currencyToFormat);
        }
        catch (IllegalArgumentException iae) {
            currency = Currency.getInstance(DEFAULT_CURRENCY);
        }
        DecimalFormat formatter = !withSymbol ? CurrencyFormatter.getNoSymbolFormatter(displayLocale) : CurrencyFormatter.getFormatterWithSymbol(displayLocale, currency);
        formatter.setMinimumFractionDigits(currency.getDefaultFractionDigits());
        formatter.setMaximumFractionDigits(currency.getDefaultFractionDigits());
        formatter.setMinimumIntegerDigits(1);
        formatter.setGroupingUsed(includeGroupingSeparator);
        String pattern = formatter.toPattern();
        int subpatternBoundaryPos = pattern.indexOf(59);
        if (subpatternBoundaryPos != -1) {
            formatter.applyPattern(pattern.substring(0, subpatternBoundaryPos));
        }
        cache.put(cacheKey, formatter);
        return formatter;
    }

    private static DecimalFormat getFormatterWithSymbol(Locale displayLocale, Currency currency) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getCurrencyInstance(displayLocale);
        formatter.setCurrency(currency);
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        String currencySymbol = CurrencyFormatter.getCountryCodeFreeCurrencySymbol(currency);
        symbols.setCurrencySymbol(currencySymbol);
        formatter.setDecimalFormatSymbols(symbols);
        return formatter;
    }

    private static DecimalFormat getNoSymbolFormatter(Locale displayLocale) {
        return (DecimalFormat)DecimalFormat.getInstance(displayLocale);
    }

    public static String getCurrencySymbol(NumberFormat formatter) {
        DecimalFormatSymbols symbols = ((DecimalFormat)formatter).getDecimalFormatSymbols();
        return symbols.getCurrencySymbol();
    }

    public static String getCountryCodeFreeCurrencySymbol(Currency currency) {
        String currencySymbol = currency.getSymbol();
        if (currencySymbol == null) {
            currencySymbol = "";
        } else if (currencySymbol.indexOf(36) != -1) {
            currencySymbol = "$";
        }
        return currencySymbol;
    }

    private static class FormatterAttributes {
        private final String locale;
        private final String currency;
        private final boolean withSymbol;
        private final boolean includeGroupingSeparator;

        public FormatterAttributes(String locale, String currency, boolean withSymbol, boolean includeGroupingSeparator) {
            this.locale = locale;
            this.currency = currency;
            this.withSymbol = withSymbol;
            this.includeGroupingSeparator = includeGroupingSeparator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FormatterAttributes that = (FormatterAttributes)o;
            if (this.includeGroupingSeparator != that.includeGroupingSeparator) {
                return false;
            }
            if (this.withSymbol != that.withSymbol) {
                return false;
            }
            if (!this.currency.equals(that.currency)) {
                return false;
            }
            return this.locale.equals(that.locale);
        }

        public int hashCode() {
            int result = this.locale.hashCode();
            result = 31 * result + this.currency.hashCode();
            result = 31 * result + (this.withSymbol ? 1 : 0);
            result = 31 * result + (this.includeGroupingSeparator ? 1 : 0);
            return result;
        }
    }
}

