/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.shopify.buy.R;
import com.shopify.buy.model.Option;
import com.shopify.buy.model.OptionValue;
import com.shopify.buy.model.Product;
import com.shopify.buy.model.ProductVariant;
import com.shopify.buy.ui.ProductDetailsTheme;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class VariantSelectionController {
    private final Activity activity;
    private final Product product;
    private final ProductDetailsTheme theme;
    private final NumberFormat currencyFormat;
    private final SparseArray<String> checkmarkValues;
    private final ArrayList<ProductVariant> possibleVariants = new ArrayList();
    private ProductVariant variant;
    private OnVariantSelectedListener listener;

    public VariantSelectionController(Activity activity, ViewGroup rootView, final Product product, ProductVariant variant, ProductDetailsTheme theme, NumberFormat currencyFormat) {
        this.activity = activity;
        this.product = product;
        this.variant = variant;
        this.theme = theme;
        this.currencyFormat = currencyFormat;
        View variantContainerView = rootView.findViewById(R.id.product_variant_selection_container);
        this.checkmarkValues = new SparseArray();
        this.initCheckmarkValues();
        if (product.getOptions().isEmpty() || product.hasDefaultVariant() || product.getVariants().isEmpty()) {
            variantContainerView.setVisibility(8);
            rootView.findViewById(R.id.divider1).setVisibility(8);
            return;
        }
        if (product.getVariants().size() > 1) {
            variantContainerView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    VariantSelectionController.this.possibleVariants.addAll(product.getVariants());
                    VariantSelectionController.this.showVariantSelectionDialog(0, new ArrayList());
                }
            });
        }
    }

    private void initCheckmarkValues() {
        int i = 0;
        for (OptionValue optionValue : this.variant.getOptionValues()) {
            this.checkmarkValues.put(i, (Object)optionValue.getValue());
            ++i;
        }
    }

    public void setListener(OnVariantSelectedListener listener) {
        this.listener = listener;
    }

    private void showVariantSelectionDialog(final int optionIndex, final ArrayList<String> selectedValues) {
        if (optionIndex >= this.product.getOptions().size()) {
            this.setVariant(this.possibleVariants.get(0));
            return;
        }
        Option option = this.product.getOptions().get(optionIndex);
        final List<String> optionValues = this.getOptionValues(optionIndex);
        Map<String, ColoredText> extras = this.getExtras(optionIndex);
        String checkmarkValue = this.checkmarkValues.size() > optionIndex ? (String)this.checkmarkValues.valueAt(optionIndex) : null;
        OptionDialogAdapter adapter = new OptionDialogAdapter((Context)this.activity, optionValues, checkmarkValue, extras);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
        builder.setCancelable(true);
        builder.setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                String value = (String)optionValues.get(which);
                selectedValues.add(value);
                if (!TextUtils.equals((CharSequence)value, (CharSequence)((CharSequence)VariantSelectionController.this.checkmarkValues.get(optionIndex)))) {
                    for (int i = VariantSelectionController.this.checkmarkValues.size() - 1; i >= optionIndex; --i) {
                        VariantSelectionController.this.checkmarkValues.remove(i);
                    }
                }
                VariantSelectionController.this.checkmarkValues.put(optionIndex, (Object)value);
                VariantSelectionController.this.filterPossibleVariants(selectedValues);
                VariantSelectionController.this.showVariantSelectionDialog(optionIndex + 1, selectedValues);
            }
        });
        builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (optionIndex > 0) {
                    selectedValues.remove(selectedValues.size() - 1);
                    VariantSelectionController.this.possibleVariants.addAll(VariantSelectionController.this.product.getVariants());
                    VariantSelectionController.this.filterPossibleVariants(selectedValues);
                    VariantSelectionController.this.showVariantSelectionDialog(optionIndex - 1, selectedValues);
                } else {
                    VariantSelectionController.this.initCheckmarkValues();
                }
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setCustomTitle(this.createDialogTitleView(option, dialog, optionIndex));
        dialog.show();
        try {
            int titleDividerId = this.activity.getResources().getIdentifier("titleDivider", "id", "android");
            View titleDivider = dialog.getWindow().getDecorView().findViewById(titleDividerId);
            titleDivider.setVisibility(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dialog.getListView().setBackgroundColor(this.theme.getBackgroundColor(this.activity.getResources()));
        dialog.getListView().setDivider(null);
    }

    private Map<String, ColoredText> getExtras(int optionIndex) {
        if (optionIndex < this.product.getOptions().size() - 1) {
            return null;
        }
        HashMap<String, ColoredText> extras = new HashMap<String, ColoredText>();
        for (ProductVariant variant : this.possibleVariants) {
            ColoredText coloredText = new ColoredText();
            coloredText.text = variant.isAvailable() ? this.currencyFormat.format(Double.parseDouble(variant.getPrice())) : this.activity.getString(R.string.sold_out);
            coloredText.color = variant.isAvailable() ? this.theme.getCompareAtPriceColor(this.activity.getResources()) : this.activity.getResources().getColor(R.color.error_background);
            extras.put(variant.getOptionValues().get(optionIndex).getValue(), coloredText);
        }
        return extras;
    }

    private String getBreadcrumbText(int optionIndex) {
        StringBuilder breadcrumbs = new StringBuilder(this.activity.getString(R.string.selected));
        breadcrumbs.append(": ");
        for (int i = 0; i < optionIndex; ++i) {
            breadcrumbs.append((String)this.checkmarkValues.get(i));
            if (i >= optionIndex - 1) continue;
            breadcrumbs.append(" \u2022 ");
        }
        return breadcrumbs.toString();
    }

    private void setVariant(final ProductVariant variant) {
        this.variant = variant;
        this.initCheckmarkValues();
        if (this.listener != null) {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    VariantSelectionController.this.listener.onVariantSelected(variant);
                }
            });
        }
    }

    private void filterPossibleVariants(List<String> selectedValues) {
        for (int i = 0; i < selectedValues.size(); ++i) {
            String optionValue = selectedValues.get(i);
            for (int j = this.possibleVariants.size() - 1; j >= 0; --j) {
                ProductVariant variant = this.possibleVariants.get(j);
                if (TextUtils.equals((CharSequence)variant.getOptionValues().get(i).getValue(), (CharSequence)optionValue)) continue;
                this.possibleVariants.remove(j);
            }
        }
    }

    private List<String> getOptionValues(int optionIndex) {
        HashSet<String> optionValues = new HashSet<String>();
        for (ProductVariant variant : this.possibleVariants) {
            optionValues.add(variant.getOptionValues().get(optionIndex).getValue());
        }
        return new ArrayList<String>(optionValues);
    }

    private View createDialogTitleView(Option option, final AlertDialog dialog, int optionIndex) {
        View titleView = this.activity.getLayoutInflater().inflate(R.layout.variant_dialog_title_view, null);
        titleView.setBackgroundResource(R.drawable.rounded_top_corners);
        ((GradientDrawable)titleView.getBackground()).setColor(this.theme.getAccentColor());
        ImageView button = (ImageView)titleView.findViewById(R.id.dialog_title_button);
        button.setBackgroundDrawable(this.getDialogTitleButtonDrawable(optionIndex));
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.cancel();
            }
        });
        TextView titleTextView = (TextView)titleView.findViewById(R.id.dialog_title_text_view);
        titleTextView.setText((CharSequence)option.getName());
        titleTextView.setTextColor(this.theme.getDialogTitleColor(this.activity.getResources()));
        TextView breadcrumbTextView = (TextView)titleView.findViewById(R.id.dialog_breadcrumbs_text_view);
        if (optionIndex > 0) {
            breadcrumbTextView.setVisibility(0);
            breadcrumbTextView.setBackgroundColor(this.theme.getVariantBreadcrumbBackgroundColor(this.activity.getResources()));
            breadcrumbTextView.setText((CharSequence)this.getBreadcrumbText(optionIndex));
        } else {
            breadcrumbTextView.setVisibility(8);
        }
        return titleView;
    }

    private Drawable getDialogTitleButtonDrawable(int optionIndex) {
        if (this.theme.getStyle() == ProductDetailsTheme.Style.DARK) {
            return this.activity.getResources().getDrawable(optionIndex == 0 ? R.drawable.ic_close_black_24dp : R.drawable.ic_arrow_back_black_24dp);
        }
        return this.activity.getResources().getDrawable(optionIndex == 0 ? R.drawable.ic_close_white_24dp : R.drawable.ic_arrow_back_white_24dp);
    }

    private class ColoredText {
        private String text;
        private int color;

        private ColoredText() {
        }
    }

    private class OptionDialogAdapter
    extends ArrayAdapter<String> {
        private final LayoutInflater inflater;
        private final String checkmarkValue;
        private final Map<String, ColoredText> extras;

        public OptionDialogAdapter(Context context, List<String> objects, String checkmarkValue, Map<String, ColoredText> extras) {
            super(context, 0, objects);
            this.inflater = VariantSelectionController.this.activity.getLayoutInflater();
            this.checkmarkValue = checkmarkValue;
            this.extras = extras;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View view = convertView;
            if (view == null) {
                view = this.inflater.inflate(R.layout.variant_dialog_list_item, null);
            }
            if (position < this.getCount() - 1) {
                view.setBackgroundColor(VariantSelectionController.this.theme.getBackgroundColor(VariantSelectionController.this.activity.getResources()));
            } else {
                view.setBackgroundResource(R.drawable.rounded_bottom_corners);
                ((GradientDrawable)view.getBackground()).setColor(VariantSelectionController.this.theme.getBackgroundColor(VariantSelectionController.this.activity.getResources()));
            }
            view.findViewById(R.id.dialog_list_item_container).setBackgroundDrawable(VariantSelectionController.this.theme.getBackgroundSelectorDrawable(VariantSelectionController.this.activity.getResources()));
            String value = (String)this.getItem(position);
            TextView text = (TextView)view.findViewById(R.id.dialog_list_item_name);
            text.setText((CharSequence)value);
            text.setTextColor(VariantSelectionController.this.theme.getDialogListItemColor(VariantSelectionController.this.activity.getResources()));
            text = (TextView)view.findViewById(R.id.dialog_list_item_extra);
            if (this.extras != null && this.extras.containsKey(value)) {
                text.setText((CharSequence)this.extras.get(value).text);
                text.setTextColor(this.extras.get(value).color);
                text.setVisibility(0);
            } else {
                text.setVisibility(8);
            }
            ImageView checkmark = (ImageView)view.findViewById(R.id.dialog_list_item_checkmark);
            if (TextUtils.equals((CharSequence)this.checkmarkValue, (CharSequence)value)) {
                checkmark.setImageDrawable(VariantSelectionController.this.theme.getCheckmarkDrawable(this.getContext()));
                checkmark.setVisibility(0);
            } else {
                checkmark.setVisibility(8);
            }
            return view;
        }
    }

    public static interface OnVariantSelectedListener {
        public void onVariantSelected(ProductVariant var1);
    }
}

