/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.support.v4.view.ViewPager;
import android.support.v7.graphics.Palette;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.shopify.buy.R;
import com.shopify.buy.model.Image;
import com.shopify.buy.ui.ViewPagerAdapter;
import com.shopify.buy.utils.ImageUtility;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Picasso;
import java.util.Arrays;
import java.util.List;

public class ProductImagePagerAdapter
extends ViewPagerAdapter {
    private final int maxWidth;
    private final int maxHeight;
    private final List<Image> images;
    private final BackgroundColorListener bgColorListener;
    private final int defaultBackgroundColor;
    private Bitmap[] bitmaps = null;

    public ProductImagePagerAdapter(List<Image> images, int maxWidth, int maxHeight, BackgroundColorListener bgColorListener, int defaultBackgroundColor) {
        this.images = images;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.bgColorListener = bgColorListener;
        this.defaultBackgroundColor = defaultBackgroundColor;
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    private String stripQueryFromUrl(String url) {
        return url.substring(0, url.lastIndexOf(63));
    }

    public List<Image> getImages() {
        return this.images;
    }

    @Override
    public View getView(final int pos, ViewPager pager) {
        boolean needBitmap;
        Context context = pager.getContext();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        ViewGroup layout2 = (ViewGroup)inflater.inflate(R.layout.view_product_image, (ViewGroup)pager, false);
        layout2.setTag((Object)pos);
        final View imageLoadingIndicator = layout2.findViewById(R.id.image_loading_indicator);
        final ImageView imageView = (ImageView)layout2.findViewById(R.id.image);
        if (this.bitmaps == null) {
            this.bitmaps = new Bitmap[this.images.size()];
            Arrays.fill(this.bitmaps, null);
        }
        boolean bl = needBitmap = this.bitmaps[pos] == null;
        if (!needBitmap) {
            imageLoadingIndicator.setVisibility(4);
            imageView.setImageBitmap(this.bitmaps[pos]);
        } else {
            String imageUrl = this.stripQueryFromUrl(this.images.get(pos).getSrc());
            ImageUtility.loadRemoteImageIntoViewWithoutSize(Picasso.with((Context)context), imageUrl, imageView, this.maxWidth, this.maxHeight, false, new Callback(){

                public void onSuccess() {
                    ((ProductImagePagerAdapter)ProductImagePagerAdapter.this).bitmaps[pos] = ((BitmapDrawable)imageView.getDrawable()).getBitmap();
                    imageLoadingIndicator.setVisibility(4);
                    ProductImagePagerAdapter.this.addBackgroundColor(pos);
                }

                public void onError() {
                    imageLoadingIndicator.setVisibility(0);
                }
            });
        }
        return layout2;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        Context context = container.getContext();
        if (context != null) {
            View view = container.findViewWithTag((Object)position);
            ImageView imageView = (ImageView)view.findViewById(R.id.image);
            Picasso.with((Context)context).cancelRequest(imageView);
        }
        super.destroyItem(container, position, object);
    }

    public int getCount() {
        if (this.images == null) {
            return 0;
        }
        return this.images.size();
    }

    private void addBackgroundColor(final int position) {
        if (this.bgColorListener != null) {
            if (!this.bgColorListener.shouldShowBackgroundColor()) {
                return;
            }
            try {
                Palette.from((Bitmap)this.bitmaps[position]).generate(new Palette.PaletteAsyncListener(){

                    public void onGenerated(Palette palette) {
                        int color2 = palette.getDarkMutedColor(0);
                        if (color2 == 0) {
                            color2 = palette.getDarkVibrantColor(0);
                        }
                        if (color2 == 0) {
                            color2 = palette.getLightMutedColor(0);
                        }
                        if (color2 == 0) {
                            color2 = palette.getLightVibrantColor(0);
                        }
                        if (color2 == 0) {
                            color2 = ProductImagePagerAdapter.this.defaultBackgroundColor;
                        }
                        ProductImagePagerAdapter.this.bgColorListener.onBackgroundColorFound(color2, position);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface BackgroundColorListener {
        public void onBackgroundColorFound(int var1, int var2);

        public boolean shouldShowBackgroundColor();
    }
}

