/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.ui;

import android.content.res.Resources;
import android.view.View;
import android.widget.TableLayout;
import android.widget.TextView;
import com.shopify.buy.R;
import com.shopify.buy.model.OptionValue;
import com.shopify.buy.ui.ProductDetailsTheme;

class ProductDetailsVariantOptionView {
    private final Resources resources;
    private final int index;
    private final TableLayout parentTable;
    private TextView name;
    private TextView value;

    public ProductDetailsVariantOptionView(View rootView, int index, Resources resources, ProductDetailsTheme theme) {
        this.resources = resources;
        this.index = index;
        this.parentTable = (TableLayout)rootView.findViewById(R.id.product_variant_selection_container);
        this.parentTable.setBackgroundDrawable(theme.getBackgroundSelectorDrawable(resources));
        switch (index) {
            case 0: {
                this.name = (TextView)rootView.findViewById(R.id.product_option_name_0);
                this.value = (TextView)rootView.findViewById(R.id.product_option_value_0);
                break;
            }
            case 1: {
                this.name = (TextView)rootView.findViewById(R.id.product_option_name_1);
                this.value = (TextView)rootView.findViewById(R.id.product_option_value_1);
                break;
            }
            case 2: {
                this.name = (TextView)rootView.findViewById(R.id.product_option_name_2);
                this.value = (TextView)rootView.findViewById(R.id.product_option_value_2);
            }
        }
    }

    public void setTheme(ProductDetailsTheme theme) {
        if (this.name == null || this.value == null) {
            return;
        }
        this.name.setTextColor(theme.getVariantOptionNameColor(this.resources));
        this.value.setTextColor(theme.getAccentColor());
    }

    public void setOptionValue(OptionValue optionValue) {
        if (this.name == null || this.value == null) {
            return;
        }
        this.name.setText((CharSequence)optionValue.getName());
        this.value.setText((CharSequence)optionValue.getValue());
        this.parentTable.setColumnShrinkable(this.index, true);
        this.parentTable.setColumnCollapsed(this.index, false);
        this.parentTable.requestLayout();
    }

    public void hide() {
        if (this.name == null || this.value == null) {
            return;
        }
        this.name.setVisibility(8);
        this.value.setVisibility(8);
        this.parentTable.setColumnCollapsed(this.index, true);
    }
}

