/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import com.shopify.buy.R;

public class ProductDetailsTheme
implements Parcelable {
    private Style style;
    private int accentColor = -1;
    private boolean showProductImageBackground;
    public static final Parcelable.Creator<ProductDetailsTheme> CREATOR = new Parcelable.Creator<ProductDetailsTheme>(){

        public ProductDetailsTheme createFromParcel(Parcel in) {
            return new ProductDetailsTheme(in);
        }

        public ProductDetailsTheme[] newArray(int size) {
            return new ProductDetailsTheme[size];
        }
    };

    public ProductDetailsTheme(Resources res) {
        this.style = Style.LIGHT;
        this.accentColor = res.getColor(R.color.default_accent);
        this.showProductImageBackground = true;
    }

    public ProductDetailsTheme(Style style, int accentColor, boolean showProductImageBackground) {
        this.style = style;
        this.accentColor = accentColor;
        this.showProductImageBackground = showProductImageBackground;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public int getAccentColor() {
        return this.accentColor;
    }

    public void setAccentColor(int accentColor) {
        this.accentColor = accentColor;
    }

    public void setShowProductImageBackground(boolean showProductImageBackground) {
        this.showProductImageBackground = showProductImageBackground;
    }

    public boolean shouldShowProductImageBackground() {
        return this.showProductImageBackground;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.style.ordinal());
        out.writeInt(this.accentColor);
        out.writeInt(this.showProductImageBackground ? 1 : 0);
    }

    private ProductDetailsTheme(Parcel in) {
        this.style = Style.values()[in.readInt()];
        this.accentColor = in.readInt();
        this.showProductImageBackground = in.readInt() != 0;
    }

    int getBackgroundColor(Resources res) {
        switch (this.style) {
            case DARK: {
                return res.getColor(R.color.dark_background);
            }
        }
        return res.getColor(R.color.light_background);
    }

    int getAppBarBackgroundColor(Resources res) {
        switch (this.style) {
            case DARK: {
                return res.getColor(R.color.dark_low_contrast_background);
            }
        }
        return res.getColor(R.color.light_low_contrast_background);
    }

    int getProductTitleColor(Resources res) {
        switch (this.style) {
            case DARK: {
                return res.getColor(R.color.dark_product_title);
            }
        }
        return res.getColor(R.color.light_product_title);
    }

    int getVariantOptionNameColor(Resources res) {
        switch (this.style) {
            case DARK: {
                return res.getColor(R.color.dark_low_contrast_grey);
            }
        }
        return res.getColor(R.color.light_low_contrast_grey);
    }

    int getCompareAtPriceColor(Resources res) {
        switch (this.style) {
            case DARK: {
                return res.getColor(R.color.body_grey);
            }
        }
        return res.getColor(R.color.body_grey);
    }

    int getProductDescriptionColor(Resources res) {
        switch (this.style) {
            case DARK: {
                return res.getColor(R.color.body_grey);
            }
        }
        return res.getColor(R.color.body_grey);
    }

    int getDividerColor(Resources res) {
        switch (this.style) {
            case DARK: {
                return res.getColor(R.color.dark_low_contrast_grey);
            }
        }
        return res.getColor(R.color.light_low_contrast_grey);
    }

    int getDialogTitleColor(Resources res) {
        switch (this.style) {
            case DARK: {
                return res.getColor(R.color.dark_dialog_title);
            }
        }
        return res.getColor(R.color.light_dialog_title);
    }

    int getVariantBreadcrumbBackgroundColor(Resources res) {
        switch (this.style) {
            case DARK: {
                return res.getColor(R.color.dark_low_contrast_grey);
            }
        }
        return res.getColor(R.color.light_low_contrast_grey);
    }

    int getDialogListItemColor(Resources res) {
        switch (this.style) {
            case DARK: {
                return res.getColor(R.color.body_grey);
            }
        }
        return res.getColor(R.color.body_grey);
    }

    int getCheckoutLabelColor(Resources res) {
        switch (this.style) {
            case DARK: {
                return res.getColor(R.color.dark_dialog_title);
            }
        }
        return res.getColor(R.color.light_dialog_title);
    }

    Drawable getCheckmarkDrawable(Context context) {
        Drawable checkmark;
        switch (this.style) {
            case DARK: {
                checkmark = context.getResources().getDrawable(R.drawable.ic_check_white_24dp);
                break;
            }
            default: {
                checkmark = context.getResources().getDrawable(R.drawable.ic_check_black_24dp);
            }
        }
        checkmark.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.accentColor, PorterDuff.Mode.SRC_IN));
        return checkmark;
    }

    Drawable getBackgroundSelectorDrawable(Resources res) {
        switch (this.style) {
            case DARK: {
                return res.getDrawable(R.drawable.dark_background_selector);
            }
        }
        return res.getDrawable(R.drawable.light_background_selector);
    }

    public static enum Style {
        DARK,
        LIGHT;

    }
}

