/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.ui;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.shopify.buy.ui.ScrollFlingGestureListener;

class ProductDetailsImageAreaTouchHandler
implements View.OnTouchListener,
ScrollFlingGestureListener.ScrollFlingGestureCallback {
    private final GestureDetector detector;
    private final ImageAreaCallback callback;
    private boolean isFlingingUp = false;
    private boolean isFlingingDown = false;

    public ProductDetailsImageAreaTouchHandler(Context context, ImageAreaCallback callback) {
        this.detector = new GestureDetector(context, (GestureDetector.OnGestureListener)new ScrollFlingPlusSingleTap(this));
        this.callback = callback;
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.detector.onTouchEvent(event);
        if (this.isFlingingUp) {
            this.isFlingingUp = false;
            this.callback.setImageAreaSize(false);
            return true;
        }
        if (this.isFlingingDown) {
            this.isFlingingDown = false;
            this.callback.setImageAreaSize(true);
            return true;
        }
        return false;
    }

    @Override
    public void isFlingingUp() {
        this.isFlingingUp = true;
    }

    @Override
    public void isFlingingDown() {
        this.isFlingingDown = true;
    }

    class ScrollFlingPlusSingleTap
    extends ScrollFlingGestureListener {
        public ScrollFlingPlusSingleTap(ScrollFlingGestureListener.ScrollFlingGestureCallback callback) {
            super(callback);
        }

        public boolean onSingleTapUp(MotionEvent e) {
            ProductDetailsImageAreaTouchHandler.this.callback.toggleImageAreaSize();
            return true;
        }
    }

    public static interface ImageAreaCallback {
        public void toggleImageAreaSize();

        public void setImageAreaSize(boolean var1);
    }
}

