/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.TabLayout;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.util.LongSparseArray;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Html;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.shopify.buy.R;
import com.shopify.buy.model.Image;
import com.shopify.buy.model.OptionValue;
import com.shopify.buy.model.Product;
import com.shopify.buy.model.ProductVariant;
import com.shopify.buy.ui.ProductDetailsFragment;
import com.shopify.buy.ui.ProductDetailsImageAreaTouchHandler;
import com.shopify.buy.ui.ProductDetailsTheme;
import com.shopify.buy.ui.ProductDetailsVariantOptionView;
import com.shopify.buy.ui.ProductImagePagerAdapter;
import com.shopify.buy.utils.ColorBlender;
import com.shopify.buy.utils.DeviceUtils;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;

public class ProductDetailsFragmentView
extends RelativeLayout
implements ProductDetailsImageAreaTouchHandler.ImageAreaCallback,
ViewPager.OnPageChangeListener,
ProductImagePagerAdapter.BackgroundColorListener,
AppBarLayout.OnOffsetChangedListener {
    private static final int VIEW_PAGER_POSITION_NOT_AVAILABLE = -1;
    private static final String INSTANCE_STATE_SUPER = "superInstanceState";
    private static final String INSTANCE_STATE_TOOLBAR_COLLAPSED = "restoredStateToolBarCollapsed";
    private static final String INSTANCE_STATE_IMAGE_INDEX = "restoredStateImageIndex";
    private static final long IMAGE_AREA_FEATURES_ANIMATION_DURATION = 300L;
    private boolean restoredStateAppbarIsCollapsed = false;
    private int restoredStateImageIndex = -1;
    private int imageAreaHeight;
    private ViewGroup imageAreaWrapper;
    private Drawable imageOverlayBackgroundDrawable;
    private ViewGroup checkoutButtonContainer;
    private ViewPager imagePager;
    private int[] backgroundColors;
    private TabLayout pagingIndicator;
    private ProductDetailsImageAreaTouchHandler imageAreaTouchHandler;
    private boolean isViewPagerBeingDragged = false;
    private boolean imageAreaIsExpanded = false;
    private boolean appBarIsCollapsed = false;
    private boolean viewsAreConfigured = false;
    private final LongSparseArray<ProductDetailsVariantOptionView> visibleOptionViews = new LongSparseArray();
    private NumberFormat currencyFormat;
    private ProductDetailsFragment fragment;
    private ActionBar actionBar;
    private boolean dropShadowIsShowing;
    private TextView toolbarTitle;
    private int homeDrawable;
    private AppBarLayout appBarLayout;
    private Product product;
    private ProductVariant variant;
    private ProductDetailsTheme theme;

    public ProductDetailsFragmentView(Context context) {
        super(context);
    }

    public ProductDetailsFragmentView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATE_SUPER, super.onSaveInstanceState());
        bundle.putBoolean(INSTANCE_STATE_TOOLBAR_COLLAPSED, this.appBarIsCollapsed);
        bundle.putInt(INSTANCE_STATE_IMAGE_INDEX, this.getCurrentProductImageIndex());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.restoredStateAppbarIsCollapsed = bundle.getBoolean(INSTANCE_STATE_TOOLBAR_COLLAPSED);
            this.restoredStateImageIndex = bundle.getInt(INSTANCE_STATE_IMAGE_INDEX, -1);
            state = bundle.getParcelable(INSTANCE_STATE_SUPER);
        }
        super.onRestoreInstanceState(state);
    }

    public void onProductAvailable(ProductDetailsFragment fragment, Product product, ProductVariant variant) {
        this.fragment = fragment;
        this.product = product;
        this.variant = variant;
        this.doViewConfiguration();
    }

    public void setVariant(ProductVariant variant) {
        this.variant = variant;
        this.updateProductDetails();
        this.setCurrentImage(this.product.getImage(variant));
    }

    private void populateSubviews() {
        Resources res = this.getResources();
        List<Image> images = this.product.getImages();
        this.pagingIndicator.setVisibility(images.size() > 1 ? 0 : 4);
        this.imageAreaWrapper.setBackgroundColor(this.theme.getBackgroundColor(this.getResources()));
        Point displaySize = this.getDisplaySize();
        this.imagePager.setAdapter((PagerAdapter)new ProductImagePagerAdapter(images, displaySize.x, displaySize.y, this, this.theme.getBackgroundColor(res)));
        if (this.restoredStateImageIndex != -1 && this.product.hasImage()) {
            this.setCurrentImage(this.product.getImages().get(this.restoredStateImageIndex));
        } else {
            this.setCurrentImage(this.product.getImage(this.variant));
        }
        this.pagingIndicator.setupWithViewPager(this.imagePager);
        this.pagingIndicator.setSelectedTabIndicatorColor(this.theme.getAccentColor());
        this.pagingIndicator.setBackgroundColor(this.theme.getBackgroundColor(res));
        for (int i = 2; i >= 0; --i) {
            ProductDetailsVariantOptionView optionView = new ProductDetailsVariantOptionView((View)this, i, res, this.theme);
            if (i >= this.product.getOptions().size()) {
                optionView.hide();
                continue;
            }
            this.visibleOptionViews.put(this.product.getOptions().get(i).getId().longValue(), (Object)optionView);
            optionView.setTheme(this.theme);
        }
        this.findViewById(R.id.divider1).setBackgroundColor(this.theme.getDividerColor(res));
        this.findViewById(R.id.divider2).setBackgroundColor(this.theme.getDividerColor(res));
        this.updateProductDetails();
        if (this.restoredStateAppbarIsCollapsed) {
            this.appBarLayout.setExpanded(false);
        }
        this.toolbarTitle.setText((CharSequence)this.product.getTitle());
        int minimumHeight = displaySize.y - this.checkoutButtonContainer.getLayoutParams().height - this.getActionBarHeightPixels() - this.getStatusBarHeight() + 2;
        this.findViewById(R.id.product_details_container).setMinimumHeight(minimumHeight);
    }

    private int getStatusBarHeight() {
        int result = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    private void doViewConfiguration() {
        if (this.viewsAreConfigured) {
            return;
        }
        this.viewsAreConfigured = true;
        this.initializeImageArea();
        this.initializeActionBar();
        this.initializeImageOverlay();
        this.initializeCheckoutButton();
        this.populateSubviews();
        this.fragment.dismissProgressDialog();
    }

    private Point getDisplaySize() {
        Point pt = new Point();
        if (DeviceUtils.isTablet(this.getResources())) {
            pt.x = this.fragment.getActivity().getWindow().getAttributes().width;
            pt.y = this.fragment.getActivity().getWindow().getAttributes().height;
        } else {
            WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
            Display display = wm.getDefaultDisplay();
            display.getSize(pt);
        }
        return pt;
    }

    private int getActionBarHeightPixels() {
        TypedValue tv = new TypedValue();
        if (this.getContext().getTheme().resolveAttribute(16843499, tv, true)) {
            return TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)this.getResources().getDisplayMetrics());
        }
        return 0;
    }

    private void initializeImageArea() {
        this.imageAreaWrapper = (ViewGroup)this.findViewById(R.id.product_details_image_wrapper);
        WindowManager windowManager = (WindowManager)this.getContext().getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        int screenWidth = metrics.widthPixels;
        int screenHeight = metrics.heightPixels;
        if (DeviceUtils.isTablet(this.getResources())) {
            screenHeight = this.fragment.getActivity().getWindow().getAttributes().height;
            screenWidth = this.fragment.getActivity().getWindow().getAttributes().width;
        }
        int minDetailsHeightInPx = Math.round((float)screenHeight * 0.4f);
        boolean hasImage = this.product != null && this.product.hasImage();
        int maxHeightInPx = hasImage ? screenHeight - minDetailsHeightInPx : this.getActionBarHeightPixels();
        this.imageAreaHeight = Math.min(screenWidth, maxHeightInPx);
        this.imagePager = (ViewPager)this.findViewById(R.id.image_pager);
        this.imagePager.setAdapter((PagerAdapter)new ProductImagePagerAdapter(null, screenWidth, this.imageAreaHeight, this, 0));
        this.imagePager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.imageAreaTouchHandler = new ProductDetailsImageAreaTouchHandler(this.getContext(), this);
        this.imagePager.setOnTouchListener((View.OnTouchListener)this.imageAreaTouchHandler);
        this.pagingIndicator = (TabLayout)this.findViewById(R.id.indicator);
        ViewGroup.LayoutParams params = this.imageAreaWrapper.getLayoutParams();
        params.height = this.imageAreaHeight;
    }

    @Override
    public void toggleImageAreaSize() {
        this.setImageAreaSize(!this.imageAreaIsExpanded);
    }

    @Override
    public void setImageAreaSize(final boolean grow) {
        int finalHeight;
        int n = finalHeight = grow ? this.getHeight() : this.imageAreaHeight;
        if (grow && !this.imageAreaIsExpanded) {
            this.hideCheckoutButton(300L);
        } else if (!grow && this.imageAreaIsExpanded) {
            this.showCheckoutButton(300L);
        }
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{this.imageAreaWrapper.getHeight(), finalHeight});
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams containerLayoutParams = ProductDetailsFragmentView.this.imageAreaWrapper.getLayoutParams();
                containerLayoutParams.height = val;
                ProductDetailsFragmentView.this.imageAreaWrapper.setLayoutParams(containerLayoutParams);
            }
        });
        anim.setDuration(300L);
        this.imagePager.setOnTouchListener(null);
        anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                ProductDetailsFragmentView.this.imagePager.setOnTouchListener((View.OnTouchListener)ProductDetailsFragmentView.this.imageAreaTouchHandler);
                if (grow) {
                    ProductDetailsFragmentView.this.onExpandImageArea();
                } else {
                    ProductDetailsFragmentView.this.onCollapseImageArea();
                }
            }
        });
        anim.start();
    }

    public void hideCheckoutButton(long duration) {
        this.checkoutButtonContainer.animate().setDuration(duration).y((float)this.getHeight()).start();
    }

    public void showCheckoutButton(long duration) {
        this.checkoutButtonContainer.animate().setDuration(duration).y((float)(this.getHeight() - this.checkoutButtonContainer.getHeight())).start();
    }

    private void onExpandImageArea() {
        this.imageAreaIsExpanded = true;
        this.setActionBarIconBack();
    }

    private void onCollapseImageArea() {
        this.imageAreaIsExpanded = false;
        this.setActionBarIconClose();
    }

    private void setActionBarIconClose() {
        this.actionBar.setHomeAsUpIndicator(this.homeDrawable);
    }

    private void setActionBarIconBack() {
        this.actionBar.setHomeAsUpIndicator(R.drawable.ic_arrow_back_white_24dp);
    }

    private void initializeActionBar() {
        Resources res = this.getResources();
        AppCompatActivity activity = (AppCompatActivity)this.fragment.getActivity();
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.custom_action_bar);
        this.toolbarTitle = (TextView)this.findViewById(R.id.toolbar_title);
        this.toolbarTitle.setTextColor(this.theme.getProductTitleColor(res));
        this.appBarLayout = (AppBarLayout)this.findViewById(R.id.app_bar);
        CoordinatorLayout.LayoutParams layoutParams = (CoordinatorLayout.LayoutParams)this.appBarLayout.getLayoutParams();
        layoutParams.setBehavior((CoordinatorLayout.Behavior)new ScrollFlingAppBarLayoutBehavior());
        this.appBarLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.appBarLayout.addOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this);
        activity.setSupportActionBar(toolbar);
        this.actionBar = activity.getSupportActionBar();
        this.actionBar.setDisplayHomeAsUpEnabled(true);
        this.actionBar.setElevation(8.0f);
        this.homeDrawable = R.drawable.ic_close_white_24dp;
        if (this.imageAreaIsExpanded) {
            this.setActionBarIconBack();
        } else {
            this.setActionBarIconClose();
        }
    }

    public void onOffsetChanged(AppBarLayout appBarLayout, int offset) {
        float ratio;
        int maxScroll = appBarLayout.getTotalScrollRange();
        float f = ratio = this.product.hasImage() ? (float)Math.abs(offset) / (float)maxScroll : 1.0f;
        if (this.theme.getStyle() == ProductDetailsTheme.Style.LIGHT) {
            if ((double)ratio < 0.5) {
                if (this.homeDrawable != R.drawable.ic_close_white_24dp) {
                    this.homeDrawable = R.drawable.ic_close_white_24dp;
                    this.actionBar.setHomeAsUpIndicator(this.homeDrawable);
                }
            } else if (this.homeDrawable != R.drawable.ic_close_black_24dp) {
                this.homeDrawable = R.drawable.ic_close_black_24dp;
                this.actionBar.setHomeAsUpIndicator(this.homeDrawable);
            }
        }
        if (ratio == 1.0f) {
            this.showDropShadow();
            this.appBarIsCollapsed = true;
        } else if (ratio >= 0.0f) {
            this.hideDropShadow();
            this.appBarIsCollapsed = false;
        }
        if (ratio > 0.0f) {
            if (!this.imagePager.isFakeDragging()) {
                this.imagePager.beginFakeDrag();
            }
        } else if (this.imagePager.isFakeDragging()) {
            this.imagePager.endFakeDrag();
        }
        int alpha = Math.round(ratio * 255.0f);
        this.imageOverlayBackgroundDrawable.setAlpha(alpha);
        this.toolbarTitle.setAlpha(ratio);
    }

    private void hideDropShadow() {
        if (!this.dropShadowIsShowing) {
            return;
        }
        this.dropShadowIsShowing = false;
        if (Build.VERSION.SDK_INT < 21) {
            View dropShadow = this.findViewById(R.id.toolbar_drop_shadow);
            dropShadow.setVisibility(4);
        }
    }

    private void showDropShadow() {
        if (this.dropShadowIsShowing) {
            return;
        }
        this.dropShadowIsShowing = true;
        if (Build.VERSION.SDK_INT < 21) {
            View dropShadow = this.findViewById(R.id.toolbar_drop_shadow);
            dropShadow.setVisibility(0);
        }
    }

    private void initializeImageOverlay() {
        View imageOverlay = this.findViewById(R.id.image_overlay);
        this.imageOverlayBackgroundDrawable = new ColorDrawable(this.theme.getAppBarBackgroundColor(this.getResources()));
        this.imageOverlayBackgroundDrawable.setAlpha(0);
        imageOverlay.setBackgroundDrawable(this.imageOverlayBackgroundDrawable);
    }

    private void initializeCheckoutButton() {
        this.checkoutButtonContainer = (ViewGroup)this.findViewById(R.id.checkout_button_container);
        this.checkoutButtonContainer.setBackgroundColor(this.theme.getAccentColor());
        Button checkoutButton = (Button)this.findViewById(R.id.checkout_button);
        int disabledTextAlpha = 64;
        checkoutButton.setTextColor(new ColorStateList((int[][])new int[][]{{-16842910}, {16842910}}, new int[]{ColorUtils.setAlphaComponent((int)this.theme.getCheckoutLabelColor(this.getResources()), (int)disabledTextAlpha), this.theme.getCheckoutLabelColor(this.getResources())}));
    }

    private void updateProductDetails() {
        Resources res = this.getResources();
        this.findViewById(R.id.product_details_container).setBackgroundColor(this.theme.getBackgroundColor(res));
        TextView textViewTitle = (TextView)this.findViewById(R.id.product_title);
        textViewTitle.setText((CharSequence)this.product.getTitle());
        textViewTitle.setTextColor(this.theme.getProductTitleColor(res));
        TextView textViewPrice = (TextView)this.findViewById(R.id.product_price);
        String priceWithCurrency = this.currencyFormat.format(Double.parseDouble(this.variant.getPrice()));
        textViewPrice.setText((CharSequence)priceWithCurrency);
        textViewPrice.setTextColor(this.theme.getAccentColor());
        TextView textViewCompareAtPrice = (TextView)this.findViewById(R.id.product_compare_at_price);
        if (!this.variant.isAvailable()) {
            textViewCompareAtPrice.setVisibility(0);
            textViewCompareAtPrice.setText((CharSequence)this.getResources().getString(R.string.sold_out));
            textViewCompareAtPrice.setTextColor(this.getResources().getColor(R.color.error_background));
            textViewCompareAtPrice.setPaintFlags(0);
        } else if (!TextUtils.isEmpty((CharSequence)this.variant.getCompareAtPrice())) {
            textViewCompareAtPrice.setVisibility(0);
            String compareAtPriceWithCurrency = this.currencyFormat.format(Double.parseDouble(this.variant.getCompareAtPrice()));
            textViewCompareAtPrice.setText((CharSequence)compareAtPriceWithCurrency);
            textViewCompareAtPrice.setTextColor(this.theme.getCompareAtPriceColor(res));
            textViewCompareAtPrice.setPaintFlags(textViewCompareAtPrice.getPaintFlags() | 0x10);
        } else {
            textViewCompareAtPrice.setVisibility(8);
        }
        List<OptionValue> optionValues = this.variant.getOptionValues();
        for (OptionValue optionValue : optionValues) {
            ProductDetailsVariantOptionView optionView = (ProductDetailsVariantOptionView)this.visibleOptionViews.get(Long.valueOf(optionValue.getOptionId()).longValue());
            if (optionView == null) continue;
            optionView.setOptionValue(optionValue);
        }
        TextView textViewDescription = (TextView)this.findViewById(R.id.product_description);
        textViewDescription.setText((CharSequence)Html.fromHtml((String)this.product.getBodyHtml()), TextView.BufferType.SPANNABLE);
        textViewDescription.setTextColor(this.theme.getProductDescriptionColor(res));
        textViewDescription.setMovementMethod(LinkMovementMethod.getInstance());
    }

    private void setCurrentImage(Image image) {
        if (image == null) {
            return;
        }
        ProductImagePagerAdapter adapter = (ProductImagePagerAdapter)this.imagePager.getAdapter();
        List<Image> images = adapter.getImages();
        if (images != null) {
            for (int i = 0; i < images.size(); ++i) {
                if (!images.get(i).equals(image)) continue;
                this.imagePager.setCurrentItem(i, true);
                break;
            }
        }
    }

    public int getCurrentProductImageIndex() {
        if (this.imagePager != null) {
            return this.imagePager.getCurrentItem();
        }
        return -1;
    }

    @Override
    public void onBackgroundColorFound(int color2, int position) {
        if (!this.theme.shouldShowProductImageBackground()) {
            return;
        }
        if (this.backgroundColors == null) {
            this.backgroundColors = new int[this.product.getImages().size()];
            Arrays.fill(this.backgroundColors, 0);
        }
        this.backgroundColors[position] = color2;
        if (this.getCurrentProductImageIndex() == position) {
            this.imageAreaWrapper.setBackgroundColor(this.backgroundColors[position]);
        }
    }

    @Override
    public boolean shouldShowBackgroundColor() {
        return this.theme.shouldShowProductImageBackground();
    }

    public void onPageSelected(int i) {
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (!this.theme.shouldShowProductImageBackground()) {
            return;
        }
        if (this.backgroundColors == null || this.backgroundColors.length <= position + 1) {
            return;
        }
        int color1 = this.backgroundColors[position];
        int color2 = this.backgroundColors[position + 1];
        if (color1 == 0 || color2 == 0) {
            return;
        }
        this.imageAreaWrapper.setBackgroundColor(ColorBlender.getBlendedColor(color1, color2, positionOffset));
    }

    public void onPageScrollStateChanged(int state) {
        if (state == 1 && !this.isViewPagerBeingDragged) {
            this.isViewPagerBeingDragged = true;
            this.imagePager.setOnTouchListener(null);
        }
        if ((state == 2 || state == 0) && this.isViewPagerBeingDragged) {
            this.isViewPagerBeingDragged = false;
            this.imagePager.setOnTouchListener((View.OnTouchListener)this.imageAreaTouchHandler);
        }
    }

    public void setTheme(ProductDetailsTheme theme) {
        this.theme = theme;
        this.setBackgroundColor(theme.getBackgroundColor(this.getResources()));
    }

    public void setCurrencyFormat(NumberFormat currencyFormat) {
        this.currencyFormat = currencyFormat;
    }

    public boolean isImageAreaExpanded() {
        return this.imageAreaIsExpanded;
    }

    public class ScrollFlingAppBarLayoutBehavior
    extends AppBarLayout.Behavior {
        public boolean onInterceptTouchEvent(CoordinatorLayout parent, AppBarLayout child, MotionEvent ev) {
            return false;
        }
    }
}

