/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.ui;

import android.app.Activity;
import android.app.Fragment;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.customtabs.CustomTabsIntent;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.shopify.buy.R;
import com.shopify.buy.customTabs.CustomTabActivityHelper;
import com.shopify.buy.dataprovider.BuyClient;
import com.shopify.buy.dataprovider.BuyClientFactory;
import com.shopify.buy.model.Cart;
import com.shopify.buy.model.Checkout;
import com.shopify.buy.model.Product;
import com.shopify.buy.model.ProductVariant;
import com.shopify.buy.model.Shop;
import com.shopify.buy.ui.ProductDetailsFragmentView;
import com.shopify.buy.ui.ProductDetailsListener;
import com.shopify.buy.ui.ProductDetailsTheme;
import com.shopify.buy.ui.VariantSelectionController;
import com.shopify.buy.utils.CurrencyFormatter;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import retrofit.Callback;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class ProductDetailsFragment
extends Fragment {
    private ProductDetailsListener productDetailsListener;
    private ProductDetailsFragmentView view;
    private ProgressDialog progressDialog;
    private Product product;
    private ProductVariant variant;
    private String productId;
    private BuyClient buyClient;
    private Shop shop;
    private ProductDetailsTheme theme;
    private Button checkoutButton;
    private boolean viewCreated;
    private final AtomicBoolean cancelledCheckout = new AtomicBoolean(false);
    private final VariantSelectionController.OnVariantSelectedListener onVariantSelectedListener = new VariantSelectionController.OnVariantSelectedListener(){

        @Override
        public void onVariantSelected(ProductVariant variant) {
            ProductDetailsFragment.this.variant = variant;
            ProductDetailsFragment.this.view.setVariant(variant);
            ProductDetailsFragment.this.checkoutButton.setEnabled(variant.isAvailable());
        }
    };

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.view = (ProductDetailsFragmentView)inflater.inflate(R.layout.fragment_product_details, container, false);
        return this.view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.viewCreated = true;
        this.initTheme();
        this.configureCheckoutButton();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
        this.initializeBuyClient();
        this.initializeProgressDialog();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            if (this.view.isImageAreaExpanded()) {
                this.view.setImageAreaSize(false);
            } else {
                this.productDetailsListener.onCancel(null);
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onStart() {
        super.onStart();
        if (this.product == null && !TextUtils.isEmpty((CharSequence)this.productId)) {
            this.fetchProduct(this.productId);
        }
        if (this.shop == null) {
            this.fetchShop();
        }
        this.showProductIfReady();
    }

    public void onResume() {
        super.onResume();
        this.checkoutButton.setEnabled(true);
        this.cancelledCheckout.set(false);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.productDetailsListener = (ProductDetailsListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement OnProductDetailsCompletedListener");
        }
    }

    private void initTheme() {
        Parcelable bundleTheme;
        Bundle arguments = this.getArguments();
        if (arguments != null && (bundleTheme = arguments.getParcelable("com.shopify.buy.ui.THEME")) != null && bundleTheme instanceof ProductDetailsTheme) {
            this.theme = (ProductDetailsTheme)bundleTheme;
        }
        if (this.theme == null) {
            this.theme = new ProductDetailsTheme(this.getResources());
        }
        this.view.setTheme(this.theme);
    }

    private void configureCheckoutButton() {
        this.checkoutButton = (Button)this.view.findViewById(R.id.checkout_button);
        this.checkoutButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ProductDetailsFragment.this.view.setVariant(ProductDetailsFragment.this.variant);
                ProductDetailsFragment.this.checkoutButton.setEnabled(false);
                ProductDetailsFragment.this.cancelledCheckout.set(false);
                ProductDetailsFragment.this.createWebCheckout();
                ProductDetailsFragment.this.showProgressDialog(ProductDetailsFragment.this.getString(R.string.loading), ProductDetailsFragment.this.getString(R.string.loading_checkout_page), new Runnable(){

                    @Override
                    public void run() {
                        ProductDetailsFragment.this.checkoutButton.setEnabled(true);
                        ProductDetailsFragment.this.cancelledCheckout.set(true);
                    }
                });
            }
        });
    }

    private void initializeBuyClient() {
        Bundle bundle = this.getArguments();
        String apiKey = bundle.getString("com.shopify.buy.ui.API_KEY");
        String shopDomain = bundle.getString("com.shopify.buy.ui.SHOP_DOMAIN");
        String channelId = bundle.getString("com.shopify.buy.ui.CHANNEL_ID");
        String applicationName = bundle.getString("com.shopify.buy.ui.SHOP_APPLICATION_NAME");
        this.productId = bundle.getString("com.shopify.buy.ui.PRODUCT_ID");
        if (bundle.containsKey("com.shopify.buy.ui.PRODUCT")) {
            this.product = Product.fromJson(bundle.getString("com.shopify.buy.ui.PRODUCT"));
            this.variant = this.product.getVariants().get(0);
        }
        if (bundle.containsKey("com.shopify.buy.ui.SHOP")) {
            this.shop = Shop.fromJson(bundle.getString("com.shopify.buy.ui.SHOP"));
        }
        String webReturnToUrl = bundle.getString("com.shopify.buy.ui.WEB_RETURN_TO_URL");
        String webReturnToLabel = bundle.getString("com.shopify.buy.ui.WEB_RETURN_TO_LABEL");
        this.buyClient = BuyClientFactory.getBuyClient(shopDomain, apiKey, channelId, applicationName);
        if (!TextUtils.isEmpty((CharSequence)webReturnToUrl)) {
            this.buyClient.setWebReturnToUrl(webReturnToUrl);
        }
        if (!TextUtils.isEmpty((CharSequence)webReturnToLabel)) {
            this.buyClient.setWebReturnToLabel(webReturnToLabel);
        }
    }

    private void initializeProgressDialog() {
        this.progressDialog = new ProgressDialog((Context)this.getActivity());
        this.progressDialog.setIndeterminate(true);
        this.progressDialog.setCancelable(true);
    }

    private void showProgressDialog(final String title, final String message, final Runnable onCancel) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (ProductDetailsFragment.this.progressDialog.isShowing()) {
                    ProductDetailsFragment.this.progressDialog.dismiss();
                }
                ProductDetailsFragment.this.progressDialog.setCanceledOnTouchOutside(false);
                ProductDetailsFragment.this.progressDialog.setTitle((CharSequence)title);
                ProductDetailsFragment.this.progressDialog.setMessage((CharSequence)message);
                ProductDetailsFragment.this.progressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        onCancel.run();
                    }
                });
                ProductDetailsFragment.this.progressDialog.show();
            }
        });
    }

    void dismissProgressDialog() {
        this.progressDialog.dismiss();
    }

    private void fetchShop() {
        this.buyClient.getShop(new Callback<Shop>(){

            public void success(Shop shop, Response response) {
                ProductDetailsFragment.this.shop = shop;
                ProductDetailsFragment.this.showProductIfReady();
            }

            public void failure(RetrofitError error) {
                ProductDetailsFragment.this.productDetailsListener.onFailure(ProductDetailsFragment.this.createErrorBundle(1, BuyClient.getErrorBody(error)));
            }
        });
    }

    private void fetchProduct(final String productId) {
        this.buyClient.getProduct(productId, new Callback<Product>(){

            public void success(Product product, Response response) {
                if (product != null) {
                    ProductVariant variant = product.getVariants().get(0);
                    ProductDetailsFragment.this.product = product;
                    ProductDetailsFragment.this.variant = variant;
                    ProductDetailsFragment.this.showProductIfReady();
                } else {
                    ProductDetailsFragment.this.productDetailsListener.onFailure(ProductDetailsFragment.this.createErrorBundle(2, "Product id not found: " + productId));
                }
            }

            public void failure(RetrofitError error) {
                ProductDetailsFragment.this.productDetailsListener.onFailure(ProductDetailsFragment.this.createErrorBundle(2, BuyClient.getErrorBody(error)));
            }
        });
    }

    private Bundle createErrorBundle(int errorCode, String errorMessage) {
        Bundle bundle = new Bundle();
        bundle.putInt("com.shopify.buy.ui.ERROR_CODE", errorCode);
        bundle.putString("com.shopify.buy.ui.ERROR_MESSAGE", errorMessage);
        return bundle;
    }

    private void showProductIfReady() {
        if (!this.viewCreated || this.product == null || this.shop == null) {
            if (!this.progressDialog.isShowing()) {
                this.showProgressDialog(this.getString(R.string.loading), this.getString(R.string.loading_product_details), new Runnable(){

                    @Override
                    public void run() {
                        ProductDetailsFragment.this.getActivity().finish();
                    }
                });
            }
            return;
        }
        NumberFormat currencyFormat = CurrencyFormatter.getFormatter(Locale.getDefault(), this.shop.getCurrency());
        VariantSelectionController variantSelectionController = new VariantSelectionController(this.getActivity(), (ViewGroup)this.view, this.product, this.variant, this.theme, currencyFormat);
        variantSelectionController.setListener(this.onVariantSelectedListener);
        this.view.setCurrencyFormat(currencyFormat);
        this.view.onProductAvailable(this, this.product, this.variant);
        this.checkoutButton.setEnabled(this.variant.isAvailable());
    }

    private void createWebCheckout() {
        Cart cart = new Cart();
        cart.addVariant(this.variant);
        this.buyClient.createCheckout(new Checkout(cart), new Callback<Checkout>(){

            public void success(Checkout checkout, Response response) {
                if (response.getStatus() == 201) {
                    ProductDetailsFragment.this.launchWebCheckout(checkout);
                } else {
                    ProductDetailsFragment.this.onCheckoutFailure();
                }
            }

            public void failure(RetrofitError error) {
                ProductDetailsFragment.this.onCheckoutFailure();
            }
        });
    }

    private void onCheckoutFailure() {
        this.dismissProgressDialog();
        CoordinatorLayout snackbarLayout = (CoordinatorLayout)this.view.findViewById(R.id.snackbar_location);
        Snackbar snackbar = Snackbar.make((View)snackbarLayout, (int)R.string.default_checkout_error, (int)-1);
        View snackbarView = snackbar.getView();
        snackbarView.setBackgroundColor(this.getResources().getColor(R.color.error_background));
        snackbar.setCallback(new Snackbar.Callback(){

            public void onShown(Snackbar snackbar) {
                super.onShown(snackbar);
                ProductDetailsFragment.this.checkoutButton.setEnabled(false);
            }

            public void onDismissed(Snackbar snackbar, int event) {
                super.onDismissed(snackbar, event);
                ProductDetailsFragment.this.checkoutButton.setEnabled(true);
            }
        });
        snackbar.show();
    }

    private void launchWebCheckout(Checkout checkout) {
        if (this.cancelledCheckout.getAndSet(false)) {
            return;
        }
        this.dismissProgressDialog();
        String uri = checkout.getWebUrl();
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().setToolbarColor(this.theme.getAppBarBackgroundColor(this.getResources())).setShowTitle(true).build();
        CustomTabActivityHelper.openCustomTab(this.getActivity(), customTabsIntent, Uri.parse((String)uri), new BrowserFallback());
        Bundle bundle = new Bundle();
        bundle.putString("com.shopify.buy.ui.CHECKOUT", checkout.toJsonString());
        this.productDetailsListener.onSuccess(bundle);
    }

    private class BrowserFallback
    implements CustomTabActivityHelper.CustomTabFallback {
        private BrowserFallback() {
        }

        @Override
        public void openUri(Activity activity, Uri uri) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10008000);
            intent.setData(uri);
            try {
                intent.setPackage("com.android.chrome");
                ProductDetailsFragment.this.startActivity(intent);
            }
            catch (Exception launchChromeException) {
                try {
                    intent.setPackage(null);
                    ProductDetailsFragment.this.startActivity(intent);
                }
                catch (Exception launchOtherException) {
                    ProductDetailsFragment.this.onCheckoutFailure();
                    return;
                }
            }
        }
    }
}

