/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.ui;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.shopify.buy.dataprovider.BuyClient;
import com.shopify.buy.model.Product;
import com.shopify.buy.model.Shop;
import com.shopify.buy.ui.ProductDetailsActivity;
import com.shopify.buy.ui.ProductDetailsConfig;
import com.shopify.buy.ui.ProductDetailsTheme;

public class ProductDetailsBuilder {
    private final Context context;
    private final ProductDetailsConfig productDetailsConfig = new ProductDetailsConfig();

    public ProductDetailsBuilder(Context context) {
        this.context = context;
    }

    public ProductDetailsBuilder(Context context, BuyClient client) {
        this.context = context;
        this.productDetailsConfig.setShopDomain(client.getShopDomain());
        this.productDetailsConfig.setApiKey(client.getApiKey());
        this.productDetailsConfig.setApplicationName(client.getApplicationName());
        this.productDetailsConfig.setChannelId(client.getChannelId());
        this.productDetailsConfig.setWebReturnToUrl(client.getWebReturnToUrl());
        this.productDetailsConfig.setWebReturnToLabel(client.getWebReturnToLabel());
    }

    public ProductDetailsBuilder setShopDomain(String shopDomain) {
        this.productDetailsConfig.setShopDomain(shopDomain);
        return this;
    }

    public ProductDetailsBuilder setApiKey(String apiKey) {
        this.productDetailsConfig.setApiKey(apiKey);
        return this;
    }

    public ProductDetailsBuilder setChannelid(String channelId) {
        this.productDetailsConfig.setChannelId(channelId);
        return this;
    }

    public ProductDetailsBuilder setApplicationName(String applicationName) {
        this.productDetailsConfig.setApplicationName(applicationName);
        return this;
    }

    public ProductDetailsBuilder setProductId(String productId) {
        this.productDetailsConfig.setProductId(productId);
        return this;
    }

    public ProductDetailsBuilder setProduct(Product product) {
        this.productDetailsConfig.setProduct(product);
        return this;
    }

    public ProductDetailsBuilder setWebReturnToUrl(String webReturnToUrl) {
        this.productDetailsConfig.setWebReturnToUrl(webReturnToUrl);
        return this;
    }

    public ProductDetailsBuilder setWebReturnToLabel(String webReturnToLabel) {
        this.productDetailsConfig.setWebReturnToLabel(webReturnToLabel);
        return this;
    }

    public ProductDetailsBuilder setShop(Shop shop) {
        this.productDetailsConfig.setShop(shop);
        return this;
    }

    public ProductDetailsBuilder setTheme(ProductDetailsTheme theme) {
        this.productDetailsConfig.setTheme(theme);
        return this;
    }

    public Intent build() {
        if (TextUtils.isEmpty((CharSequence)this.productDetailsConfig.getShopShopDomain())) {
            throw new IllegalArgumentException("shopDomain must be provided, and cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.productDetailsConfig.getApiKey())) {
            throw new IllegalArgumentException("apiKey must be provided, and cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.productDetailsConfig.getApplicationName())) {
            throw new IllegalArgumentException("applicationName must be provided, and cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.productDetailsConfig.getChannelId())) {
            throw new IllegalArgumentException("channelId must be provided, and cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.productDetailsConfig.getProductId()) && this.productDetailsConfig.getProduct() == null) {
            throw new IllegalArgumentException("One of productId or product must be provided, and cannot be empty");
        }
        Intent intent = new Intent(this.context, ProductDetailsActivity.class);
        intent.putExtras(this.productDetailsConfig.toBundle());
        return intent;
    }
}

