/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.ui;

import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.shopify.buy.R;
import com.shopify.buy.ui.ProductDetailsFragment;
import com.shopify.buy.ui.ProductDetailsListener;
import com.shopify.buy.utils.DeviceUtils;

public class ProductDetailsActivity
extends AppCompatActivity
implements ProductDetailsListener {
    protected ProductDetailsFragment productDetailsFragment;

    protected void onCreate(Bundle savedInstanceState) {
        if (DeviceUtils.isTablet(this.getResources())) {
            this.makeActivityDialog();
        }
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            this.productDetailsFragment = this.getFragment();
            Intent intent = this.getIntent();
            if (intent != null) {
                this.productDetailsFragment.setArguments(intent.getExtras());
            }
            this.getFragmentManager().beginTransaction().add(R.id.product_details_activity, (Fragment)this.productDetailsFragment).commit();
        } else {
            this.productDetailsFragment = (ProductDetailsFragment)this.getFragmentManager().findFragmentById(R.id.product_details_activity);
        }
        this.initContentView();
    }

    private ProductDetailsFragment getFragment() {
        if (this.productDetailsFragment == null) {
            this.productDetailsFragment = new ProductDetailsFragment();
        }
        return this.productDetailsFragment;
    }

    private void initContentView() {
        this.setContentView(R.layout.activity_product_details);
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        if (savedInstanceState == null) {
            this.onNewIntent(this.getIntent());
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    @Override
    public void onSuccess(Bundle bundle) {
        this.setResult(-1, bundle);
    }

    @Override
    public void onFailure(Bundle bundle) {
        this.setResult(0, bundle);
        this.finish();
    }

    @Override
    public void onCancel(Bundle bundle) {
        this.setResult(0, bundle);
        this.finish();
    }

    private void setResult(int resultCode, Bundle bundle) {
        Intent intent = this.getIntent();
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        this.setResult(resultCode, intent);
    }

    private void makeActivityDialog() {
        this.setRequestedOrientation(10);
        WindowManager windowManager = (WindowManager)this.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        int screenWidth = metrics.widthPixels;
        int screenHeight = metrics.heightPixels;
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        if (screenHeight > screenWidth) {
            params.width = Math.round((float)screenWidth * 0.8f);
            params.height = Math.min(Math.round((float)params.width * 1.25f), screenHeight);
        } else {
            params.height = Math.round((float)screenHeight * 0.85f);
            params.width = Math.min(Math.round((float)params.height * 0.8f), screenWidth);
        }
        this.getWindow().setAttributes(params);
    }
}

