/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.model;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.shopify.buy.model.Image;
import com.shopify.buy.model.Option;
import com.shopify.buy.model.OptionValue;
import com.shopify.buy.model.ProductVariant;
import com.shopify.buy.model.ShopifyObject;
import com.shopify.buy.utils.DateUtility;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Product
extends ShopifyObject {
    @SerializedName(value="product_id")
    private String productId;
    @SerializedName(value="channel_id")
    private String channelId;
    private String title;
    private String handle;
    @SerializedName(value="body_html")
    private String bodyHtml;
    @SerializedName(value="published_at")
    private Date publishedAtDate;
    @SerializedName(value="created_at")
    private Date createdAtDate;
    @SerializedName(value="updated_at")
    private Date updatedAtDate;
    private String vendor;
    @SerializedName(value="product_type")
    private String productType;
    private List<ProductVariant> variants;
    private List<Image> images;
    private List<Option> options;
    private String tags;
    private Set<String> tagSet;
    private boolean available;
    private boolean published;

    public boolean isPublished() {
        return this.published;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHandle() {
        return this.handle;
    }

    public String getBodyHtml() {
        return this.bodyHtml;
    }

    @Deprecated
    public String getPublishedAt() {
        return this.publishedAtDate == null ? null : DateUtility.createDefaultDateFormat().format(this.publishedAtDate);
    }

    @Deprecated
    public String getCreatedAt() {
        return this.createdAtDate == null ? null : DateUtility.createDefaultDateFormat().format(this.createdAtDate);
    }

    @Deprecated
    public String getUpdatedAt() {
        return this.updatedAtDate == null ? null : DateUtility.createDefaultDateFormat().format(this.updatedAtDate);
    }

    public Date getPublishedAtDate() {
        return this.publishedAtDate;
    }

    public Date getCreatedAtDate() {
        return this.createdAtDate;
    }

    public Date getUpdatedAtDate() {
        return this.updatedAtDate;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getProductType() {
        return this.productType;
    }

    public Set<String> getTags() {
        return this.tagSet;
    }

    public List<ProductVariant> getVariants() {
        return this.variants;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public boolean hasImage() {
        return this.images != null && !this.images.isEmpty();
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean hasDefaultVariant() {
        return this.variants != null && this.variants.size() == 1 && this.variants.get(0).getTitle().equals("Default Title");
    }

    public Image getImage(ProductVariant variant) {
        if (variant == null) {
            throw new NullPointerException("variant cannot be null");
        }
        List<Image> images = this.getImages();
        if (images == null || images.size() < 1) {
            return null;
        }
        for (Image image : images) {
            if (image.getVariantIds() == null || !image.getVariantIds().contains(variant.getId())) continue;
            return image;
        }
        return images.get(0);
    }

    public ProductVariant getVariant(List<OptionValue> optionValues) {
        if (optionValues == null) {
            return null;
        }
        int numOptions = optionValues.size();
        for (ProductVariant variant : this.variants) {
            for (int i = 0; i < numOptions && variant.getOptionValues().get(i).getValue().equals(optionValues.get(i).getValue()); ++i) {
                if (i != numOptions - 1) continue;
                return variant;
            }
        }
        return null;
    }

    public static Product fromJson(String json) {
        Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateUtility.DateDeserializer()).create();
        Product product = (Product)gson.fromJson(json, Product.class);
        List<ProductVariant> variants = product.getVariants();
        if (variants != null) {
            for (ProductVariant variant : variants) {
                variant.productId = Long.parseLong(product.productId);
                variant.productTitle = product.getTitle();
            }
        }
        product.tagSet = new HashSet<String>();
        if (!TextUtils.isEmpty((CharSequence)product.tags)) {
            for (String tag : product.tags.split(",")) {
                String myTag = tag.trim();
                product.tagSet.add(myTag);
            }
        }
        return product;
    }

    public static class ProductDeserializer
    implements JsonDeserializer<Product> {
        public Product deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Product.fromJson(json.toString());
        }
    }
}

