/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.model;

import com.google.gson.annotations.SerializedName;
import com.shopify.buy.model.ProductVariant;
import java.util.HashMap;
import java.util.Map;

public class LineItem {
    private long quantity;
    private String id;
    private String price;
    @SerializedName(value="requires_shipping")
    private boolean requiresShipping;
    @SerializedName(value="variant_id")
    private Long variantId;
    private String title;
    @SerializedName(value="product_id")
    private String productId;
    @SerializedName(value="variant_title")
    private String variantTitle;
    @SerializedName(value="line_price")
    private String linePrice;
    @SerializedName(value="compare_at_price")
    private String compareAtPrice;
    private String sku;
    private boolean taxable;
    private long grams;
    @SerializedName(value="fulfillment_service")
    private String fulfillmentService;
    private Map<String, String> properties;

    public LineItem(ProductVariant variant) {
        this.variantId = variant.getId();
        this.price = variant.getPrice();
        this.title = variant.getTitle();
        this.requiresShipping = variant.isRequiresShipping();
        this.quantity = 1L;
    }

    public String getVariantTitle() {
        return this.variantTitle;
    }

    public String getLinePrice() {
        return this.linePrice;
    }

    public String getCompareAtPrice() {
        return this.compareAtPrice;
    }

    public String getSku() {
        return this.sku;
    }

    public boolean isTaxable() {
        return this.taxable;
    }

    public String getProductId() {
        return this.productId;
    }

    public long getGrams() {
        return this.grams;
    }

    public String getFulfillmentService() {
        return this.fulfillmentService;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public String getPrice() {
        return this.price;
    }

    public String getTitle() {
        return this.title;
    }

    public Long getVariantId() {
        return this.variantId;
    }

    public String getId() {
        return this.id;
    }

    public void setQuantity(long quantity) {
        this.quantity = quantity;
    }

    public boolean isRequiresShipping() {
        return this.requiresShipping;
    }

    public boolean equals(Object o) {
        if (o instanceof LineItem) {
            Long otherVariantId = ((LineItem)o).getVariantId();
            return otherVariantId != null && otherVariantId.equals(this.variantId);
        }
        return false;
    }
}

