/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.model;

import com.google.gson.annotations.SerializedName;
import com.shopify.buy.dataprovider.BuyClientFactory;
import com.shopify.buy.model.Address;
import com.shopify.buy.model.Cart;
import com.shopify.buy.model.CartLineItem;
import com.shopify.buy.model.CreditCard;
import com.shopify.buy.model.Discount;
import com.shopify.buy.model.GiftCard;
import com.shopify.buy.model.LineItem;
import com.shopify.buy.model.Order;
import com.shopify.buy.model.ShippingRate;
import com.shopify.buy.model.ShopifyObject;
import com.shopify.buy.model.TaxLine;
import com.shopify.buy.model.internal.MarketingAttribution;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Checkout
extends ShopifyObject {
    private String email;
    protected String token;
    @Deprecated
    @SerializedName(value="order_id")
    private Long orderId;
    private Order order;
    @SerializedName(value="requires_shipping")
    private Boolean requiresShipping;
    @SerializedName(value="taxes_included")
    private Boolean taxesIncluded;
    private String currency;
    @SerializedName(value="subtotal_price")
    private String subtotalPrice;
    @SerializedName(value="total_tax")
    private String totalTax;
    @SerializedName(value="total_price")
    private String totalPrice;
    @SerializedName(value="payment_session_id")
    private String paymentSessionId;
    @SerializedName(value="payment_url")
    private String paymentUrl;
    @SerializedName(value="payment_due")
    private String paymentDue;
    @SerializedName(value="reservation_time")
    private Long reservationTime;
    @SerializedName(value="reservation_time_left")
    private Long reservationTimeLeft;
    @SerializedName(value="line_items")
    private List<LineItem> lineItems;
    @SerializedName(value="tax_lines")
    private List<TaxLine> taxLines;
    private Discount discount;
    @SerializedName(value="billing_address")
    private Address billingAddress;
    @SerializedName(value="shipping_address")
    private Address shippingAddress;
    @SerializedName(value="shipping_rate")
    private ShippingRate shippingRate;
    @SerializedName(value="shipping_rate_id")
    private String shippingRateId;
    @SerializedName(value="marketing_attribution")
    private MarketingAttribution marketingAttribution;
    @SerializedName(value="channel_id")
    private String channelId;
    @SerializedName(value="web_url")
    private String webUrl;
    @SerializedName(value="web_return_to_url")
    private String webReturnToUrl;
    @SerializedName(value="web_return_to_label")
    private String webReturnToLabel;
    private final String channel = "mobile_app";
    @SerializedName(value="gift_cards")
    private List<GiftCard> giftCards;
    @Deprecated
    @SerializedName(value="order_status_url")
    private String orderStatusUrl;
    @SerializedName(value="created_at")
    private Date createdAtDate;
    @SerializedName(value="credit_card")
    private CreditCard creditCard;
    @SerializedName(value="customer_id")
    private String customerId;
    @SerializedName(value="privacy_policy_url")
    private String privacyPolicyUrl;
    @SerializedName(value="refund_policy_url")
    private String refundPolicyUrl;
    @SerializedName(value="terms_of_service_url")
    private String termsOfServiceUrl;
    @SerializedName(value="source_name")
    private String sourceName;
    @SerializedName(value="source_identifier")
    private String sourceIdentifier;
    private String note;

    public Checkout(Cart cart) {
        this.lineItems = new ArrayList<CartLineItem>(cart.getLineItems());
    }

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getTermsOfServiceUrl() {
        return this.termsOfServiceUrl;
    }

    public String getRefundPolicyUrl() {
        return this.refundPolicyUrl;
    }

    public String getPrivacyPolicyUrl() {
        return this.privacyPolicyUrl;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public Date getCreatedAtDate() {
        return this.createdAtDate;
    }

    public CreditCard getCreditCard() {
        return this.creditCard;
    }

    public String getOrderStatusUrl() {
        return this.orderStatusUrl;
    }

    public String getEmail() {
        return this.email;
    }

    public String getToken() {
        return this.token;
    }

    public Long getOrderId() {
        return this.orderId;
    }

    public Order getOrder() {
        return this.order;
    }

    public Boolean isRequiresShipping() {
        return this.requiresShipping;
    }

    public Boolean isTaxesIncluded() {
        return this.taxesIncluded;
    }

    public String getCurrency() {
        return this.currency;
    }

    public List<GiftCard> getGiftCards() {
        return this.giftCards;
    }

    public String getSubtotalPrice() {
        return this.subtotalPrice;
    }

    public String getTotalTax() {
        return this.totalTax;
    }

    public String getTotalPrice() {
        return this.totalPrice;
    }

    public String getPaymentSessionId() {
        return this.paymentSessionId;
    }

    public String getPaymentUrl() {
        return this.paymentUrl;
    }

    public String getPaymentDue() {
        return this.paymentDue;
    }

    public Long getReservationTime() {
        return this.reservationTime;
    }

    public Long getReservationTimeLeft() {
        return this.reservationTimeLeft;
    }

    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public List<TaxLine> getTaxLines() {
        return this.taxLines;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public ShippingRate getShippingRate() {
        return this.shippingRate;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public String getNote() {
        return this.note;
    }

    public MarketingAttribution getMarketingAttribution() {
        return this.marketingAttribution;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public void setReservationTime(long reservationTime) {
        this.reservationTime = reservationTime;
    }

    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public void setShippingRate(ShippingRate shippingRate) {
        this.shippingRate = shippingRate;
    }

    public void setPaymentSessionId(String paymentSessionId) {
        this.paymentSessionId = paymentSessionId;
    }

    public void setPaymentDue(String paymentDue) {
        this.paymentDue = paymentDue;
    }

    public void setDiscountCode(String code) {
        this.discount = new Discount(code);
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setMarketingAttribution(MarketingAttribution marketingAttribution) {
        this.marketingAttribution = marketingAttribution;
    }

    public void setWebReturnToUrl(String webReturnToUrl) {
        this.webReturnToUrl = webReturnToUrl;
    }

    public void setWebReturnToLabel(String webReturnToLabel) {
        this.webReturnToLabel = webReturnToLabel;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void addGiftCard(GiftCard giftCard) {
        if (this.giftCards == null) {
            this.giftCards = new ArrayList<GiftCard>();
        }
        if (giftCard != null) {
            this.giftCards.add(giftCard);
        }
    }

    public void removeGiftCard(GiftCard giftCard) {
        if (this.giftCards != null && giftCard != null) {
            this.giftCards.remove(giftCard);
        }
    }

    public static Checkout fromJson(String json) {
        return (Checkout)BuyClientFactory.createDefaultGson().fromJson(json, Checkout.class);
    }
}

