/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.model;

import com.shopify.buy.model.CartLineItem;
import com.shopify.buy.model.LineItem;
import com.shopify.buy.model.ProductVariant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Cart {
    private final List<CartLineItem> lineItems = new ArrayList<CartLineItem>();
    private final Set<ProductVariant> productVariants = new HashSet<ProductVariant>();

    public void addVariant(ProductVariant variant) {
        this.productVariants.add(variant);
        for (CartLineItem lineItem : this.lineItems) {
            if (!lineItem.getVariantId().equals(variant.getId())) continue;
            lineItem.setQuantity(lineItem.getQuantity() + 1L);
            return;
        }
        this.lineItems.add(new CartLineItem(variant));
    }

    public void decrementVariant(ProductVariant variant) {
        for (CartLineItem lineItem : this.lineItems) {
            if (!lineItem.getVariantId().equals(variant.getId()) || lineItem.getQuantity() <= 0L) continue;
            lineItem.setQuantity(lineItem.getQuantity() - 1L);
            if (lineItem.getQuantity() == 0L) {
                this.lineItems.remove(lineItem);
                this.productVariants.remove(variant);
            }
            return;
        }
    }

    public void setVariantQuantity(ProductVariant variant, int quantity) {
        if (quantity <= 0) {
            this.productVariants.remove(variant);
        } else {
            this.productVariants.add(variant);
        }
        for (CartLineItem lineItem : this.lineItems) {
            if (!lineItem.getVariantId().equals(variant.getId())) continue;
            if (quantity <= 0) {
                this.lineItems.remove(lineItem);
            } else {
                lineItem.setQuantity(quantity);
            }
            return;
        }
        if (quantity > 0) {
            CartLineItem lineItem = new CartLineItem(variant);
            lineItem.setQuantity(quantity);
            this.lineItems.add(lineItem);
        }
    }

    public List<CartLineItem> getLineItems() {
        return this.lineItems;
    }

    public ProductVariant getProductVariant(LineItem lineItem) {
        for (ProductVariant variant : this.productVariants) {
            if (!variant.getId().equals(lineItem.getVariantId())) continue;
            return variant;
        }
        return null;
    }

    public int getSize() {
        return this.lineItems.size();
    }

    public boolean isEmpty() {
        return this.lineItems.isEmpty();
    }

    public void clear() {
        this.lineItems.clear();
    }
}

