/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import android.text.TextUtils;
import android.util.Base64;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.shopify.buy.BuildConfig;
import com.shopify.buy.dataprovider.BuyClient;
import com.shopify.buy.dataprovider.BuyRetrofitService;
import com.shopify.buy.model.Product;
import com.shopify.buy.utils.DateUtility;
import com.squareup.okhttp.OkHttpClient;
import java.util.Date;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class BuyClientFactory {
    public static BuyClient getBuyClient(String shopDomain, final String apiKey, String channelId, String applicationName) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)shopDomain) || shopDomain.contains(":") || shopDomain.contains("/") || !shopDomain.contains(".myshopify.com")) {
            throw new IllegalArgumentException("shopDomain must be of the form 'shopname.myshopify.com' and cannot start with 'http://'");
        }
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            throw new IllegalArgumentException("apiKey must be provided, and cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)channelId)) {
            throw new IllegalArgumentException("channelId must be provided, and cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)applicationName)) {
            throw new IllegalArgumentException("applicationName must be provided, and cannot be empty");
        }
        RequestInterceptor requestInterceptor = new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("Authorization", "Basic " + Base64.encodeToString((byte[])apiKey.getBytes(), (int)2));
                request.addHeader("User-Agent", "Mobile Buy SDK Android/1.2.2");
            }
        };
        OkHttpClient httpClient = new OkHttpClient();
        RestAdapter adapter = new RestAdapter.Builder().setEndpoint("https://" + shopDomain).setConverter((Converter)new GsonConverter(BuyClientFactory.createDefaultGson())).setClient((Client)new OkClient(httpClient)).setLogLevel(BuildConfig.RETROFIT_LOG_LEVEL).setRequestInterceptor(requestInterceptor).build();
        return new BuyClient((BuyRetrofitService)adapter.create(BuyRetrofitService.class), apiKey, channelId, applicationName, shopDomain, httpClient);
    }

    public static Gson createDefaultGson() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZZZ").registerTypeAdapter(Product.class, (Object)new Product.ProductDeserializer()).registerTypeAdapter(Date.class, (Object)new DateUtility.DateDeserializer()).create();
    }
}

