/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.dataprovider;

import android.text.TextUtils;
import android.util.Base64;
import com.google.gson.Gson;
import com.shopify.buy.dataprovider.BuyRetrofitService;
import com.shopify.buy.model.Checkout;
import com.shopify.buy.model.Collection;
import com.shopify.buy.model.CreditCard;
import com.shopify.buy.model.GiftCard;
import com.shopify.buy.model.Product;
import com.shopify.buy.model.ShippingRate;
import com.shopify.buy.model.Shop;
import com.shopify.buy.model.internal.CheckoutWrapper;
import com.shopify.buy.model.internal.CollectionPublication;
import com.shopify.buy.model.internal.GiftCardWrapper;
import com.shopify.buy.model.internal.MarketingAttribution;
import com.shopify.buy.model.internal.PaymentSessionCheckout;
import com.shopify.buy.model.internal.PaymentSessionCheckoutWrapper;
import com.shopify.buy.model.internal.ProductPublication;
import com.shopify.buy.model.internal.ShippingRatesWrapper;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit.Callback;
import retrofit.ResponseCallback;
import retrofit.RetrofitError;
import retrofit.mime.TypedByteArray;

public class BuyClient {
    public static final int MAX_PAGE_SIZE = 250;
    public static final int MIN_PAGE_SIZE = 1;
    public static final int DEFAULT_PAGE_SIZE = 25;
    private static final MediaType jsonMediateType = MediaType.parse((String)"application/json; charset=utf-8");
    private final BuyRetrofitService retrofitService;
    private final OkHttpClient httpClient;
    private int pageSize = 25;
    private final String shopDomain;
    private final String apiKey;
    private final String channelId;
    private final String applicationName;
    private String webReturnToUrl;
    private String webReturnToLabel;

    public String getApiKey() {
        return this.apiKey;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getWebReturnToUrl() {
        return this.webReturnToUrl;
    }

    public String getWebReturnToLabel() {
        return this.webReturnToLabel;
    }

    public String getShopDomain() {
        return this.shopDomain;
    }

    BuyClient(BuyRetrofitService retrofitService, String apiKey, String channelId, String applicationName, String shopDomain, OkHttpClient httpClient) {
        this.retrofitService = retrofitService;
        this.apiKey = apiKey;
        this.channelId = channelId;
        this.applicationName = applicationName;
        this.shopDomain = shopDomain;
        this.httpClient = httpClient;
    }

    public void addInterceptor(Interceptor interceptor) {
        this.httpClient.interceptors().add(interceptor);
    }

    public void setWebReturnToUrl(String webReturnToUrl) {
        this.webReturnToUrl = webReturnToUrl;
    }

    public void setWebReturnToLabel(String webReturnToLabel) {
        this.webReturnToLabel = webReturnToLabel;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = Math.max(Math.min(pageSize, 250), 1);
    }

    public void getShop(Callback<Shop> callback) {
        this.retrofitService.getShop(callback);
    }

    public void getProductPage(int page, final Callback<List<Product>> callback) {
        if (page < 1) {
            throw new IllegalArgumentException("page is a 1-based index, value cannot be less than 1");
        }
        this.retrofitService.getProductPage(this.channelId, page, this.pageSize, new Callback<ProductPublication>(){

            public void success(ProductPublication productPage, retrofit.client.Response response) {
                List<Product> products = null;
                if (productPage != null) {
                    products = productPage.getProducts();
                }
                callback.success(products, response);
            }

            public void failure(RetrofitError error) {
                callback.failure(error);
            }
        });
    }

    public void getProduct(String productId, final Callback<Product> callback) {
        if (productId == null) {
            throw new NullPointerException("productId cannot be null");
        }
        this.retrofitService.getProducts(this.channelId, productId, new Callback<ProductPublication>(){

            public void success(ProductPublication productPublications, retrofit.client.Response response) {
                List<Product> products;
                Product product = null;
                if (productPublications != null && (products = productPublications.getProducts()) != null && products.size() > 0) {
                    product = products.get(0);
                }
                callback.success(product, response);
            }

            public void failure(RetrofitError error) {
                callback.failure(error);
            }
        });
    }

    public void getProducts(List<String> productIds, final Callback<List<Product>> callback) {
        if (productIds == null) {
            throw new NullPointerException("productIds List cannot be null");
        }
        if (productIds.size() < 1) {
            throw new IllegalArgumentException("productIds List cannot be empty");
        }
        String queryString = TextUtils.join((CharSequence)",", (Object[])productIds.toArray());
        this.retrofitService.getProducts(this.channelId, queryString, new Callback<ProductPublication>(){

            public void success(ProductPublication productPublications, retrofit.client.Response response) {
                List<Product> products = null;
                if (productPublications != null) {
                    products = productPublications.getProducts();
                }
                callback.success(products, response);
            }

            public void failure(RetrofitError error) {
                callback.failure(error);
            }
        });
    }

    public void getProducts(int page, String collectionId, Callback<List<Product>> callback) {
        this.getProducts(page, collectionId, Collection.SortOrder.COLLECTION_DEFAULT, callback);
    }

    public void getProducts(int page, String collectionId, Collection.SortOrder sortOrder, final Callback<List<Product>> callback) {
        if (page < 1) {
            throw new IllegalArgumentException("page is a 1-based index, value cannot be less than 1");
        }
        if (collectionId == null) {
            throw new IllegalArgumentException("collectionId cannot be null");
        }
        this.retrofitService.getProducts(this.channelId, collectionId, this.pageSize, page, sortOrder.toString(), new Callback<ProductPublication>(){

            public void success(ProductPublication productPublications, retrofit.client.Response response) {
                List<Product> products = null;
                if (productPublications != null) {
                    products = productPublications.getProducts();
                }
                callback.success(products, response);
            }

            public void failure(RetrofitError error) {
                callback.failure(error);
            }
        });
    }

    public void getCollections(final Callback<List<Collection>> callback) {
        this.retrofitService.getCollections(this.channelId, new Callback<CollectionPublication>(){

            public void success(CollectionPublication collectionPublication, retrofit.client.Response response) {
                List<Collection> collections = null;
                if (collectionPublication != null) {
                    collections = collectionPublication.getCollections();
                }
                callback.success(collections, response);
            }

            public void failure(RetrofitError error) {
                callback.failure(error);
            }
        });
    }

    public void createCheckout(Checkout checkout, final Callback<Checkout> callback) {
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        checkout.setChannelId(this.channelId);
        checkout.setMarketingAttribution(new MarketingAttribution(this.applicationName));
        checkout.setSourceName("mobile_app");
        checkout.setSourceIdentifier(this.channelId);
        if (this.webReturnToUrl != null) {
            checkout.setWebReturnToUrl(this.webReturnToUrl);
        }
        if (this.webReturnToLabel != null) {
            checkout.setWebReturnToLabel(this.webReturnToLabel);
        }
        this.retrofitService.createCheckout(new CheckoutWrapper(checkout), new Callback<CheckoutWrapper>(){

            public void success(CheckoutWrapper checkoutWrapper, retrofit.client.Response response) {
                callback.success((Object)checkoutWrapper.getCheckout(), response);
            }

            public void failure(RetrofitError error) {
                callback.failure(error);
            }
        });
    }

    public void updateCheckout(Checkout checkout, final Callback<Checkout> callback) {
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        this.retrofitService.updateCheckout(new CheckoutWrapper(checkout), checkout.getToken(), new Callback<CheckoutWrapper>(){

            public void success(CheckoutWrapper checkoutWrapper, retrofit.client.Response response) {
                callback.success((Object)checkoutWrapper.getCheckout(), response);
            }

            public void failure(RetrofitError error) {
                callback.failure(error);
            }
        });
    }

    public void getShippingRates(String checkoutToken, final Callback<List<ShippingRate>> callback) {
        if (checkoutToken == null) {
            throw new NullPointerException("checkoutToken cannot be null");
        }
        this.retrofitService.getShippingRates(checkoutToken, new Callback<ShippingRatesWrapper>(){

            public void success(ShippingRatesWrapper shippingRatesWrapper, retrofit.client.Response response) {
                if (200 == response.getStatus() && shippingRatesWrapper != null) {
                    callback.success(shippingRatesWrapper.getShippingRates(), response);
                } else {
                    callback.success(null, response);
                }
            }

            public void failure(RetrofitError error) {
                callback.failure(error);
            }
        });
    }

    public void storeCreditCard(final CreditCard card, final Checkout checkout, final Callback<Checkout> callback) {
        if (card == null) {
            throw new NullPointerException("card cannot be null");
        }
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                PaymentSessionCheckoutWrapper dataWrapper = new PaymentSessionCheckoutWrapper();
                PaymentSessionCheckout data = new PaymentSessionCheckout();
                data.setToken(checkout.getToken());
                data.setCreditCard(card);
                data.setBillingAddress(checkout.getBillingAddress());
                dataWrapper.setCheckout(data);
                RequestBody body = RequestBody.create((MediaType)jsonMediateType, (String)new Gson().toJson((Object)dataWrapper));
                Request request = new Request.Builder().url(checkout.getPaymentUrl()).post(body).addHeader("Authorization", "Basic " + Base64.encodeToString((byte[])BuyClient.this.apiKey.getBytes(), (int)2)).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
                try {
                    Response httpResponse = BuyClient.this.httpClient.newCall(request).execute();
                    String paymentSessionId = BuyClient.this.parsePaymentSessionResponse(httpResponse);
                    checkout.setPaymentSessionId(paymentSessionId);
                    retrofit.client.Response retrofitResponse = new retrofit.client.Response(request.urlString(), httpResponse.code(), httpResponse.message(), Collections.emptyList(), null);
                    callback.success((Object)checkout, retrofitResponse);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    callback.failure(RetrofitError.unexpectedError((String)request.urlString(), (Throwable)e));
                }
            }
        }).start();
    }

    public void completeCheckout(Checkout checkout, final Callback<Checkout> callback) {
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        HashMap<String, String> requestBodyMap = new HashMap<String, String>();
        String paymentSessionId = checkout.getPaymentSessionId();
        if (!TextUtils.isEmpty((CharSequence)paymentSessionId)) {
            requestBodyMap.put("payment_session_id", checkout.getPaymentSessionId());
        }
        this.retrofitService.completeCheckout(requestBodyMap, checkout.getToken(), new Callback<CheckoutWrapper>(){

            public void success(CheckoutWrapper checkoutWrapper, retrofit.client.Response response) {
                callback.success((Object)checkoutWrapper.getCheckout(), response);
            }

            public void failure(RetrofitError error) {
                callback.failure(error);
            }
        });
    }

    public void getCheckoutCompletionStatus(Checkout checkout, final Callback<Boolean> callback) {
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        this.retrofitService.getCheckoutCompletionStatus(checkout.getToken(), new ResponseCallback(){

            public void success(retrofit.client.Response response) {
                if (200 == response.getStatus()) {
                    callback.success((Object)true, response);
                } else {
                    callback.success((Object)false, response);
                }
            }

            public void failure(RetrofitError error) {
                callback.failure(error);
            }
        });
    }

    public void getCheckout(String checkoutToken, final Callback<Checkout> callback) {
        if (checkoutToken == null) {
            throw new NullPointerException("checkoutToken cannot be null");
        }
        this.retrofitService.getCheckout(checkoutToken, new Callback<CheckoutWrapper>(){

            public void success(CheckoutWrapper checkoutWrapper, retrofit.client.Response response) {
                callback.success((Object)checkoutWrapper.getCheckout(), response);
            }

            public void failure(RetrofitError error) {
                callback.failure(error);
            }
        });
    }

    public void applyGiftCard(String giftCardCode, final Checkout checkout, final Callback<Checkout> callback) {
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        GiftCard giftCard = new GiftCard(giftCardCode);
        this.retrofitService.applyGiftCard(new GiftCardWrapper(giftCard), checkout.getToken(), new Callback<GiftCardWrapper>(){

            public void success(GiftCardWrapper giftCardWrapper, retrofit.client.Response response) {
                GiftCard updatedGiftCard = giftCardWrapper.getGiftCard();
                checkout.addGiftCard(updatedGiftCard);
                checkout.setPaymentDue(updatedGiftCard.getCheckout().getPaymentDue());
                callback.success((Object)checkout, response);
            }

            public void failure(RetrofitError error) {
                callback.failure(error);
            }
        });
    }

    public void removeGiftCard(GiftCard giftCard, final Checkout checkout, final Callback<Checkout> callback) {
        if (checkout == null) {
            throw new NullPointerException("checkout cannot be null");
        }
        if (giftCard == null) {
            throw new NullPointerException("giftCard cannot be null");
        }
        this.retrofitService.removeGiftCard(giftCard.getId(), checkout.getToken(), new Callback<GiftCardWrapper>(){

            public void success(GiftCardWrapper giftCardWrapper, retrofit.client.Response response) {
                GiftCard updatedGiftCard = giftCardWrapper.getGiftCard();
                checkout.removeGiftCard(updatedGiftCard);
                checkout.setPaymentDue(updatedGiftCard.getCheckout().getPaymentDue());
                callback.success((Object)checkout, response);
            }

            public void failure(RetrofitError error) {
                callback.failure(error);
            }
        });
    }

    public void removeProductReservationsFromCheckout(Checkout checkout, Callback<Checkout> callback) {
        if (checkout == null || TextUtils.isEmpty((CharSequence)checkout.getToken())) {
            callback.failure(null);
        } else {
            checkout.setReservationTime(0L);
            this.updateCheckout(checkout, callback);
        }
    }

    public void testIntegration(final Callback<Void> callback) {
        this.retrofitService.testIntegration(this.apiKey, this.channelId, new Callback<Void>(){

            public void success(Void aVoid, retrofit.client.Response response) {
                callback.success((Object)aVoid, response);
            }

            public void failure(RetrofitError error) {
                callback.failure(error);
            }
        });
    }

    public static String getErrorBody(RetrofitError error) {
        String json = null;
        try {
            json = new String(((TypedByteArray)error.getResponse().getBody()).getBytes());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return json;
    }

    private String parsePaymentSessionResponse(Response response) throws IOException {
        String paymentSessionId = null;
        if (response.isSuccessful()) {
            String jsonString = response.body().string();
            try {
                JSONObject json = new JSONObject(jsonString);
                paymentSessionId = (String)json.get("id");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return paymentSessionId;
    }
}

