/*
 * Decompiled with CFR 0.152.
 */
package com.shizhefei.task;

import android.text.TextUtils;
import com.shizhefei.mvc.IAsyncDataSource;
import com.shizhefei.mvc.IDataSource;
import com.shizhefei.mvc.RequestHandle;
import com.shizhefei.task.AsyncTaskV25;
import com.shizhefei.task.Code;
import com.shizhefei.task.IAsyncTask;
import com.shizhefei.task.ICacheConfig;
import com.shizhefei.task.ICacheStore;
import com.shizhefei.task.ICallback;
import com.shizhefei.task.ISuperTask;
import com.shizhefei.task.ITask;
import com.shizhefei.task.TaskExecutor;
import com.shizhefei.task.TaskExecutors;
import com.shizhefei.task.TaskHandle;
import com.shizhefei.task.imp.MemoryCacheStore;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

public class TaskHelper<BASE_DATA>
implements RequestHandle {
    private ICacheStore cacheStore;
    private Set<ICallback<BASE_DATA>> registerCallBacks = new LinkedHashSet<ICallback<BASE_DATA>>();
    private List<MultiTaskBindProxyCallBack<?, BASE_DATA>> taskImps = new LinkedList();
    private Executor executor;

    public TaskHelper() {
        this(new MemoryCacheStore(100));
    }

    public TaskHelper(ICacheStore cacheStore) {
        this.cacheStore = cacheStore;
        this.executor = AsyncTaskV25.THREAD_POOL_EXECUTOR;
    }

    public ICacheStore getCacheStore() {
        return this.cacheStore;
    }

    public void setThreadExecutor(Executor executor) {
        this.executor = executor;
    }

    public <DATA extends BASE_DATA> TaskHandle execute(ITask<DATA> task, ICallback<DATA> callBack) {
        return this.executeImp(null, task, true, callBack);
    }

    public <DATA extends BASE_DATA> TaskHandle execute(IDataSource<DATA> dataSource, ICallback<DATA> callBack) {
        return this.executeImp(null, dataSource, true, callBack);
    }

    public <DATA extends BASE_DATA> TaskHandle execute(IDataSource<DATA> dataSource, boolean isExeRefresh, ICallback<DATA> callBack) {
        return this.executeImp(null, dataSource, isExeRefresh, callBack);
    }

    public <DATA extends BASE_DATA> TaskHandle execute(IAsyncDataSource<DATA> dataSource, ICallback<DATA> callBack) {
        return this.executeImp(null, dataSource, true, callBack);
    }

    public <DATA extends BASE_DATA> TaskHandle execute(IAsyncDataSource<DATA> dataSource, boolean isExeRefresh, ICallback<DATA> callBack) {
        return this.executeImp(null, dataSource, isExeRefresh, callBack);
    }

    public <DATA extends BASE_DATA> TaskHandle execute(IAsyncTask<DATA> task, ICallback<DATA> callBack) {
        return this.executeImp(null, task, true, callBack);
    }

    public <DATA extends BASE_DATA> TaskHandle executeCache(IAsyncDataSource<DATA> task, ICallback<DATA> callBack, ICacheConfig<DATA> cacheConfig) {
        return this.executeImp(cacheConfig, task, true, callBack);
    }

    public <DATA extends BASE_DATA> TaskHandle executeCache(ITask<DATA> task, ICallback<DATA> callBack, ICacheConfig<DATA> cacheConfig) {
        return this.executeImp(cacheConfig, task, true, callBack);
    }

    public <DATA extends BASE_DATA> TaskHandle executeCache(IAsyncTask<DATA> task, ICallback<DATA> callBack, ICacheConfig<DATA> cacheConfig) {
        return this.executeImp(cacheConfig, task, true, callBack);
    }

    public <DATA extends BASE_DATA> TaskHandle executeCache(IDataSource<DATA> task, ICallback<DATA> callBack, ICacheConfig<DATA> cacheConfig) {
        return this.executeImp(cacheConfig, task, true, callBack);
    }

    private <DATA extends BASE_DATA> MultiTaskBindProxyCallBack<DATA, BASE_DATA> getTaskImpByTask(String taskKey) {
        for (MultiTaskBindProxyCallBack<?, BASE_DATA> multiTaskBindProxyCallBack : this.taskImps) {
            if (!taskKey.equals(((MultiTaskBindProxyCallBack)multiTaskBindProxyCallBack).taskKey)) continue;
            return multiTaskBindProxyCallBack;
        }
        return null;
    }

    private <DATA extends BASE_DATA> TaskHandle executeImp(ICacheConfig<DATA> cacheConfig, ISuperTask<DATA> task, boolean isExeRefresh, ICallback<DATA> callBack) {
        TaskHandle requestHandle;
        MultiTaskBindProxyCallBack<DATA, BASE_DATA> multiTaskBindProxyCallBack;
        if (task == null) {
            throw new RuntimeException("task\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (cacheConfig != null) {
            String taskKey = cacheConfig.getTaskKey(task);
            if (TextUtils.isEmpty((CharSequence)taskKey)) {
                throw new RuntimeException("ICacheConfig \u8fd4\u56de\u7684taskkey\u4e0d\u80fd\u4e3a\u7a7a");
            }
            multiTaskBindProxyCallBack = this.getTaskImpByTask(taskKey);
            if (multiTaskBindProxyCallBack != null) {
                callBack.onPreExecute(task);
                multiTaskBindProxyCallBack.addCallBack(task, callBack);
                return new TaskHandle(3, task, multiTaskBindProxyCallBack);
            }
        }
        if ((requestHandle = this.loadCache(cacheConfig, task, callBack)) == null) {
            MultiTaskBindProxyCallBack<DATA, BASE_DATA> callback = multiTaskBindProxyCallBack = new MultiTaskBindProxyCallBack<DATA, BASE_DATA>(cacheConfig, task, callBack, this.registerCallBacks, this.taskImps, this.cacheStore);
            TaskExecutor taskExecutor = task instanceof IDataSource ? TaskExecutors.create((IDataSource)task, isExeRefresh, callback, this.executor) : (task instanceof IAsyncDataSource ? TaskExecutors.create((IAsyncDataSource)task, isExeRefresh, callback) : (task instanceof ITask ? TaskExecutors.create((ITask)task, callback, this.executor) : TaskExecutors.create((IAsyncTask)task, callback)));
            ((MultiTaskBindProxyCallBack)multiTaskBindProxyCallBack).taskExecutor = taskExecutor;
            this.taskImps.add(multiTaskBindProxyCallBack);
            taskExecutor.execute();
            requestHandle = new TaskHandle(1, task, multiTaskBindProxyCallBack);
        }
        return requestHandle;
    }

    private <DATA extends BASE_DATA> TaskHandle loadCache(ICacheConfig<DATA> cacheConfig, Object task, ICallback<DATA> callBack) {
        if (cacheConfig != null) {
            Object data;
            String taskKey = cacheConfig.getTaskKey(task);
            ICacheStore.Cache cache = this.cacheStore.getCache(taskKey);
            if (cache != null && cacheConfig.isUsefulCacheData(task, cache.requestTime, cache.saveTime, data = cache.data)) {
                callBack.onPreExecute(task);
                callBack.onPostExecute(task, Code.SUCCESS, null, data);
                return new TaskHandle(2, callBack, null);
            }
            return null;
        }
        return null;
    }

    public void cancel(Object task) {
        if (task == null) {
            return;
        }
        if (task instanceof TaskHandle) {
            TaskHandle handle = (TaskHandle)task;
            handle.cancle();
            return;
        }
        for (MultiTaskBindProxyCallBack<?, BASE_DATA> taskImp : this.taskImps) {
            if (taskImp.cancel(task)) break;
        }
    }

    public void cancelAllWithTaskKey(String taskKey) {
        if (TextUtils.isEmpty((CharSequence)taskKey)) {
            return;
        }
        MultiTaskBindProxyCallBack taskImp = this.getTaskImpByTask(taskKey);
        if (taskImp != null) {
            taskImp.cancelAllTaskBinder();
        }
    }

    public void registerCallBack(ICallback<BASE_DATA> callback) {
        this.registerCallBacks.add(callback);
    }

    public void unRegisterCallBack(ICallback<BASE_DATA> callback) {
        this.registerCallBacks.remove(callback);
    }

    public void cancelAll() {
        if (this.taskImps.isEmpty()) {
            return;
        }
        HashSet temp = new HashSet(this.taskImps);
        for (MultiTaskBindProxyCallBack<?, BASE_DATA> entry : temp) {
            entry.cancelAllTaskBinder();
        }
        this.taskImps.clear();
    }

    public void destroy() {
        this.cancelAll();
    }

    @Override
    public void cancle() {
        this.cancelAll();
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    public static <DATA> TaskExecutor<DATA> createExecutor(IDataSource<DATA> dataSource, boolean isExeRefresh, ICallback<DATA> callback) {
        return TaskExecutors.create(dataSource, isExeRefresh, callback);
    }

    public static <DATA> TaskExecutor<DATA> createExecutor(IAsyncDataSource<DATA> dataSource, boolean isExeRefresh, ICallback<DATA> callback) {
        return TaskExecutors.create(dataSource, isExeRefresh, callback);
    }

    public static <DATA> TaskExecutor<DATA> createExecutor(ITask<DATA> task, ICallback<DATA> callback) {
        return TaskExecutors.create(task, callback);
    }

    public static <DATA> TaskExecutor<DATA> createExecutor(IAsyncTask<DATA> task, ICallback<DATA> callback) {
        return TaskExecutors.create(task, callback);
    }

    public static <DATA> TaskExecutor<DATA> create(IDataSource<DATA> dataSource, boolean isExeRefresh, ICallback<DATA> callback, Executor executor) {
        return TaskExecutors.create(dataSource, isExeRefresh, callback, executor);
    }

    public static <DATA> TaskExecutor<DATA> create(ITask<DATA> task, ICallback<DATA> callback, Executor executor) {
        return TaskExecutors.create(task, callback, executor);
    }

    static class MultiTaskBindProxyCallBack<DATA extends BASE_DATA, BASE_DATA>
    implements ICallback<DATA> {
        private ICallback<DATA> callback;
        private long requestTime;
        private Set<ICallback<BASE_DATA>> registerCallbacks;
        private Map<Object, ICallback<DATA>> bindCallBacks = new LinkedHashMap<Object, ICallback<DATA>>();
        private List<MultiTaskBindProxyCallBack<?, BASE_DATA>> taskImps;
        private ICacheStore cacheStore;
        private String taskKey;
        private ICacheConfig<DATA> cacheConfig;
        private Object realTask;
        private TaskExecutor<DATA> taskExecutor;

        public MultiTaskBindProxyCallBack(ICacheConfig<DATA> cacheConfig, Object realTask, ICallback<DATA> callback, Set<ICallback<BASE_DATA>> registerCallbacks, List<MultiTaskBindProxyCallBack<?, BASE_DATA>> taskImps, ICacheStore cacheStore) {
            this.cacheConfig = cacheConfig;
            this.requestTime = System.currentTimeMillis();
            if (cacheConfig != null) {
                this.taskKey = cacheConfig.getTaskKey(realTask);
            }
            this.callback = callback;
            this.registerCallbacks = registerCallbacks;
            this.taskImps = taskImps;
            this.cacheStore = cacheStore;
            this.realTask = realTask;
        }

        @Override
        public void onPreExecute(Object task) {
            for (Map.Entry<Object, ICallback<DATA>> entry : this.bindCallBacks.entrySet()) {
                Object aTask = entry.getKey();
                ICallback<DATA> aCallback = entry.getValue();
                aCallback.onPreExecute(aTask);
            }
            if (this.callback != null) {
                this.callback.onPreExecute(task);
            }
            for (ICallback iCallback : this.registerCallbacks) {
                iCallback.onPreExecute(task);
            }
        }

        @Override
        public void onProgress(Object task, int percent, long current, long total, Object extraData) {
            for (Map.Entry<Object, ICallback<DATA>> entry : this.bindCallBacks.entrySet()) {
                Object aTask = entry.getKey();
                ICallback<DATA> aCallback = entry.getValue();
                aCallback.onProgress(aTask, percent, current, total, extraData);
            }
            if (this.callback != null) {
                this.callback.onProgress(task, percent, current, total, extraData);
            }
            for (ICallback iCallback : this.registerCallbacks) {
                iCallback.onProgress(task, percent, current, total, extraData);
            }
        }

        @Override
        public void onPostExecute(Object task, Code code, Exception exception, DATA data) {
            long saveTime;
            for (Map.Entry<Object, ICallback<DATA>> entry : this.bindCallBacks.entrySet()) {
                Object aTask = entry.getKey();
                ICallback<DATA> aCallback = entry.getValue();
                aCallback.onPostExecute(aTask, code, exception, data);
            }
            if (this.callback != null) {
                this.callback.onPostExecute(task, code, exception, data);
            }
            for (ICallback iCallback : this.registerCallbacks) {
                iCallback.onPostExecute(task, code, exception, data);
            }
            this.taskImps.remove(this);
            if (code == Code.SUCCESS && this.cacheConfig != null && this.cacheConfig.isNeedSave(task, this.requestTime, saveTime = System.currentTimeMillis(), data)) {
                String taskKey = this.cacheConfig.getTaskKey(task);
                this.cacheStore.saveCache(taskKey, this.requestTime, saveTime, data);
            }
            this.cacheStore = null;
            this.registerCallbacks = null;
            this.cacheConfig = null;
            this.taskExecutor = null;
            this.taskImps = null;
            this.callback = null;
            this.bindCallBacks = null;
            this.realTask = null;
            this.taskKey = null;
        }

        public Map<Object, ICallback<DATA>> getRegisterCallbacks() {
            return this.bindCallBacks;
        }

        public void addCallBack(Object task, ICallback<DATA> callBack) {
            if (this.bindCallBacks != null) {
                this.bindCallBacks.put(task, callBack);
            }
        }

        public void cancelAllTaskBinder() {
            if (this.taskExecutor != null) {
                this.taskExecutor.cancle();
            }
        }

        public boolean cancel(Object task) {
            Map<Object, ICallback<DATA>> callbacks = this.getRegisterCallbacks();
            if (callbacks == null) {
                return false;
            }
            if (task.equals(this.realTask)) {
                if (!callbacks.isEmpty()) {
                    if (this.callback != null) {
                        this.callback.onPostExecute(this.realTask, Code.CANCEL, null, null);
                    }
                    this.callback = null;
                } else {
                    this.cancelAllTaskBinder();
                }
                return true;
            }
            Iterator<Map.Entry<Object, ICallback<DATA>>> iterator = callbacks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, ICallback<DATA>> data = iterator.next();
                Object ct = data.getKey();
                if (!task.equals(ct)) continue;
                iterator.remove();
                data.getValue().onPostExecute(ct, Code.CANCEL, null, null);
                return true;
            }
            return false;
        }

        public boolean isRunning() {
            if (this.taskExecutor != null) {
                return this.taskExecutor.isRunning();
            }
            return false;
        }
    }
}

