/*
 * Decompiled with CFR 0.152.
 */
package com.shizhefei.task;

import android.os.Handler;
import android.os.Looper;
import com.shizhefei.mvc.IAsyncDataSource;
import com.shizhefei.mvc.IDataSource;
import com.shizhefei.mvc.ProgressSender;
import com.shizhefei.mvc.RequestHandle;
import com.shizhefei.mvc.ResponseSender;
import com.shizhefei.task.AsyncTaskV25;
import com.shizhefei.task.Code;
import com.shizhefei.task.IAsyncTask;
import com.shizhefei.task.ICallback;
import com.shizhefei.task.ISuperTask;
import com.shizhefei.task.ITask;
import com.shizhefei.task.TaskExecutor;
import com.shizhefei.utils.TaskLogUtil;
import java.util.concurrent.Executor;

class TaskExecutors {
    TaskExecutors() {
    }

    public static <DATA> TaskExecutor<DATA> create(IDataSource<DATA> dataSource, boolean isExeRefresh, ICallback<DATA> callback) {
        return TaskExecutors.create(dataSource, isExeRefresh, callback, AsyncTaskV25.THREAD_POOL_EXECUTOR);
    }

    public static <DATA> TaskExecutor<DATA> create(IDataSource<DATA> dataSource, boolean isExeRefresh, ICallback<DATA> callback, Executor executor) {
        return new SyncDataSourceExecutor<DATA>(dataSource, isExeRefresh, callback, executor);
    }

    public static <DATA> TaskExecutor<DATA> create(IAsyncDataSource<DATA> dataSource, boolean isExeRefresh, ICallback<DATA> callback) {
        return new AsyncDataSourceExecutor<DATA>(dataSource, isExeRefresh, callback);
    }

    public static <DATA> TaskExecutor<DATA> create(ITask<DATA> task, ICallback<DATA> callback) {
        return TaskExecutors.create(task, callback, AsyncTaskV25.THREAD_POOL_EXECUTOR);
    }

    public static <DATA> TaskExecutor<DATA> create(ITask<DATA> task, ICallback<DATA> callback, Executor executor) {
        return new SyncTaskExecutor<DATA>(task, callback, executor);
    }

    public static <DATA> TaskExecutor<DATA> create(IAsyncTask<DATA> task, ICallback<DATA> callback) {
        return new AsyncTaskExecutor<DATA>(task, callback);
    }

    private static class TaskHasCallbackResponseSender<DATA>
    implements TaskResponseSender<DATA> {
        private Handler handler = new Handler(Looper.getMainLooper());
        private ICallback<DATA> callback;
        private Object realTask;
        private volatile boolean isRunning;

        @Override
        public void sendPreExecute(Object realTask, ICallback<DATA> callback) {
            this.realTask = realTask;
            this.callback = callback;
            this.isRunning = true;
            this.onPreExecute();
        }

        @Override
        public void sendError(Exception exception) {
            this.onPostExecute(Code.EXCEPTION, exception, null);
        }

        @Override
        public void sendData(DATA data) {
            this.onPostExecute(Code.SUCCESS, null, data);
        }

        @Override
        public void sendCancel() {
            this.onPostExecute(Code.CANCEL, null, null);
        }

        @Override
        public void sendProgress(long current, long total, Object extraData) {
            int percent = current == 0L ? 0 : (total == 0L ? 0 : (int)(100L * current / total));
            this.onProgress(percent, current, total, extraData);
        }

        @Override
        public boolean isRunning() {
            return this.isRunning;
        }

        private void onPreExecute() {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        TaskHasCallbackResponseSender.this.onPreExecuteMainThread();
                    }
                });
            } else {
                this.onPreExecuteMainThread();
            }
        }

        private void onProgress(final int percent, final long current, final long total, final Object extraData) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        TaskHasCallbackResponseSender.this.onProgressMainThread(percent, current, total, extraData);
                    }
                });
            } else {
                this.onProgressMainThread(percent, current, total, extraData);
            }
        }

        private void onPostExecute(final Code code, final Exception exception, final DATA data) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        TaskHasCallbackResponseSender.this.onPostExecuteMainThread(code, exception, data);
                    }
                });
            } else {
                this.onPostExecuteMainThread(code, exception, data);
            }
        }

        private void onPreExecuteMainThread() {
            ICallback<DATA> c = this.callback;
            if (c != null) {
                c.onPreExecute(this.realTask);
            }
        }

        private void onProgressMainThread(int percent, long current, long total, Object extraData) {
            ICallback<DATA> c = this.callback;
            if (c != null) {
                c.onProgress(this.realTask, percent, current, total, extraData);
            }
        }

        private void onPostExecuteMainThread(Code code, Exception exception, DATA data) {
            if (!this.isRunning) {
                return;
            }
            this.isRunning = false;
            if (exception == null) {
                TaskLogUtil.d("{} task={} code={} data={}", new Object[]{"\u6267\u884c\u7ed3\u679c", this.realTask, code, data});
            } else {
                TaskLogUtil.e(exception, "{} task={} code={} exception={}", new Object[]{"\u6267\u884c\u7ed3\u679c", this.realTask, code});
            }
            ICallback<DATA> c = this.callback;
            if (c != null) {
                c.onPostExecute(this.realTask, code, exception, data);
            }
            this.realTask = null;
            this.callback = null;
        }
    }

    private static class TaskNoCallbackResponseSender<DATA>
    implements TaskResponseSender<DATA> {
        private volatile boolean isRunning;

        private TaskNoCallbackResponseSender() {
        }

        @Override
        public void sendPreExecute(Object realTask, ICallback<DATA> callback) {
            this.isRunning = true;
        }

        @Override
        public boolean isRunning() {
            return this.isRunning;
        }

        @Override
        public void sendError(Exception exception) {
            this.isRunning = false;
        }

        @Override
        public void sendData(DATA data) {
            this.isRunning = false;
        }

        @Override
        public void sendProgress(long current, long total, Object extraData) {
        }

        @Override
        public void sendCancel() {
            this.isRunning = false;
        }
    }

    private static interface TaskResponseSender<DATA>
    extends ResponseSender<DATA> {
        public void sendCancel();

        public void sendPreExecute(Object var1, ICallback<DATA> var2);

        public boolean isRunning();
    }

    private static class SyncTaskExecutor<DATA>
    extends AbsSyncTaskExecutor<DATA> {
        private ITask<DATA> task;

        public SyncTaskExecutor(ITask<DATA> task, ICallback<DATA> callback, Executor executor) {
            super(task, callback, executor);
            this.task = task;
        }

        @Override
        protected DATA executeImp(ProgressSender sender) throws Exception {
            return this.task.execute(sender);
        }

        @Override
        protected void cancelImp() {
            this.task.cancel();
        }

        @Override
        public boolean isExeRefresh() {
            return true;
        }
    }

    private static class SyncDataSourceExecutor<DATA>
    extends AbsSyncTaskExecutor<DATA> {
        private final boolean isExeRefresh;
        private IDataSource<DATA> task;

        public SyncDataSourceExecutor(IDataSource<DATA> task, boolean isExeRefresh, ICallback<DATA> callback, Executor executor) {
            super(task, callback, executor);
            this.task = task;
            this.isExeRefresh = isExeRefresh;
        }

        @Override
        protected DATA executeImp(ProgressSender sender) throws Exception {
            if (this.isExeRefresh) {
                return this.task.refresh();
            }
            return this.task.loadMore();
        }

        @Override
        protected void cancelImp() {
        }

        @Override
        public boolean isExeRefresh() {
            return this.isExeRefresh;
        }
    }

    private static class AsyncTaskExecutor<DATA>
    extends AbsAsyncTaskExecutor<DATA> {
        private IAsyncTask<DATA> task;

        public AsyncTaskExecutor(IAsyncTask<DATA> task, ICallback<DATA> callback) {
            super(task, callback);
            this.task = task;
        }

        @Override
        protected RequestHandle executeImp(ResponseSender<DATA> responseSender) throws Exception {
            return this.task.execute(responseSender);
        }

        @Override
        public boolean isExeRefresh() {
            return true;
        }
    }

    private static class AsyncDataSourceExecutor<DATA>
    extends AbsAsyncTaskExecutor<DATA> {
        private final boolean isExeRefresh;
        private IAsyncDataSource<DATA> dataSource;

        public AsyncDataSourceExecutor(IAsyncDataSource<DATA> dataSource, boolean isExeRefresh, ICallback<DATA> callback) {
            super(dataSource, callback);
            this.dataSource = dataSource;
            this.isExeRefresh = isExeRefresh;
        }

        @Override
        protected RequestHandle executeImp(ResponseSender<DATA> responseSender) throws Exception {
            if (this.isExeRefresh) {
                return this.dataSource.refresh(responseSender);
            }
            return this.dataSource.loadMore(responseSender);
        }

        @Override
        public boolean isExeRefresh() {
            return this.isExeRefresh;
        }
    }

    private static abstract class AbsSyncTaskExecutor<DATA>
    extends AsyncTaskV25<Object, Object, DATA>
    implements TaskExecutor<DATA> {
        private final ISuperTask<DATA> realTask;
        private final TaskResponseSender<DATA> responseSender;
        private final Executor executor;
        private ICallback<DATA> callback;

        public AbsSyncTaskExecutor(ISuperTask<DATA> task, ICallback<DATA> callback, Executor executor) {
            this.callback = callback;
            this.realTask = task;
            this.executor = executor;
            this.responseSender = callback == null ? new TaskNoCallbackResponseSender() : new TaskHasCallbackResponseSender();
        }

        @Override
        public RequestHandle execute() {
            this.responseSender.sendPreExecute(this.realTask, this.callback);
            this.executeOnExecutor(this.executor, Boolean.TRUE);
            return this;
        }

        @Override
        protected DATA doInBackground(Object ... params) {
            try {
                return this.executeImp(this.responseSender);
            }
            catch (Exception e) {
                this.responseSender.sendError(e);
                return null;
            }
        }

        protected abstract DATA executeImp(ProgressSender var1) throws Exception;

        @Override
        protected void onPostExecute(DATA result) {
            super.onPostExecute(result);
            this.responseSender.sendData(result);
        }

        @Override
        public void cancle() {
            this.cancelImp();
            this.cancel(true);
            this.responseSender.sendCancel();
        }

        protected abstract void cancelImp();

        @Override
        public boolean isRunning() {
            return this.responseSender.isRunning();
        }

        @Override
        public ICallback<DATA> getCallback() {
            return this.callback;
        }

        @Override
        public ISuperTask<DATA> getTask() {
            return this.realTask;
        }
    }

    private static abstract class AbsAsyncTaskExecutor<DATA>
    implements TaskExecutor<DATA> {
        private final ISuperTask<DATA> realTask;
        private ICallback<DATA> callback;
        private RequestHandle requestHandle;
        private TaskResponseSender<DATA> responseSender;

        public AbsAsyncTaskExecutor(ISuperTask<DATA> task, ICallback<DATA> callback) {
            this.realTask = task;
            this.callback = callback;
            this.responseSender = callback == null ? new TaskNoCallbackResponseSender() : new TaskHasCallbackResponseSender();
        }

        @Override
        public final RequestHandle execute() {
            this.responseSender.sendPreExecute(this.realTask, this.callback);
            try {
                this.requestHandle = this.executeImp(this.responseSender);
            }
            catch (Exception e) {
                this.responseSender.sendError(e);
            }
            return this;
        }

        protected abstract RequestHandle executeImp(ResponseSender<DATA> var1) throws Exception;

        @Override
        public void cancle() {
            if (this.requestHandle != null) {
                this.requestHandle.cancle();
            }
            this.responseSender.sendCancel();
        }

        @Override
        public ICallback<DATA> getCallback() {
            return this.callback;
        }

        @Override
        public ISuperTask<DATA> getTask() {
            return this.realTask;
        }

        @Override
        public boolean isRunning() {
            return this.responseSender.isRunning();
        }
    }
}

