/*
 * Decompiled with CFR 0.152.
 */
package com.shizhefei.task;

import android.os.AsyncTask;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.support.annotation.MainThread;
import android.util.Log;
import java.util.ArrayDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

abstract class AsyncTaskV25<Params, Progress, Result> {
    private static final String LOG_TAG = "AsyncTaskV25";
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = Math.max(2, Math.min(CPU_COUNT - 1, 4));
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int KEEP_ALIVE_SECONDS = 30;
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "AsyncTaskV25 #" + this.mCount.getAndIncrement());
        }
    };
    private static final BlockingQueue<Runnable> sPoolWorkQueue = new LinkedBlockingQueue<Runnable>(128);
    public static final Executor THREAD_POOL_EXECUTOR;
    public static final Executor SERIAL_EXECUTOR;
    private static final int MESSAGE_POST_RESULT = 1;
    private static final int MESSAGE_POST_PROGRESS = 2;
    private static volatile Executor sDefaultExecutor;
    private static InternalHandler sHandler;
    private final WorkerRunnable<Params, Result> mWorker;
    private final FutureTask<Result> mFuture;
    private volatile Status mStatus = Status.PENDING;
    private final AtomicBoolean mCancelled = new AtomicBoolean();
    private final AtomicBoolean mTaskInvoked = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Handler getHandler() {
        Class<AsyncTaskV25> clazz = AsyncTaskV25.class;
        synchronized (AsyncTaskV25.class) {
            if (sHandler == null) {
                sHandler = new InternalHandler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sHandler;
        }
    }

    public static void setDefaultExecutor(Executor exec) {
        sDefaultExecutor = exec;
    }

    public AsyncTaskV25() {
        this.mWorker = new WorkerRunnable<Params, Result>(){

            @Override
            public Result call() throws Exception {
                AsyncTaskV25.this.mTaskInvoked.set(true);
                Object result = null;
                try {
                    Process.setThreadPriority((int)10);
                    result = AsyncTaskV25.this.doInBackground(this.mParams);
                    Binder.flushPendingCommands();
                }
                catch (Throwable tr) {
                    AsyncTaskV25.this.mCancelled.set(true);
                    throw tr;
                }
                finally {
                    AsyncTaskV25.this.postResult(result);
                }
                return result;
            }
        };
        this.mFuture = new FutureTask<Result>(this.mWorker){

            @Override
            protected void done() {
                try {
                    AsyncTaskV25.this.postResultIfNotInvoked(this.get());
                }
                catch (InterruptedException e) {
                    Log.w((String)AsyncTaskV25.LOG_TAG, (Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("An error occurred while executing doInBackground()", e.getCause());
                }
                catch (CancellationException e) {
                    AsyncTaskV25.this.postResultIfNotInvoked(null);
                }
            }
        };
    }

    private void postResultIfNotInvoked(Result result) {
        boolean wasTaskInvoked = this.mTaskInvoked.get();
        if (!wasTaskInvoked) {
            this.postResult(result);
        }
    }

    private Result postResult(Result result) {
        Message message = AsyncTaskV25.getHandler().obtainMessage(1, new AsyncTaskResult<Object>(this, result));
        message.sendToTarget();
        return result;
    }

    public final Status getStatus() {
        return this.mStatus;
    }

    protected abstract Result doInBackground(Params ... var1);

    protected void onPreExecute() {
    }

    protected void onPostExecute(Result result) {
    }

    protected void onProgressUpdate(Progress ... values) {
    }

    protected void onCancelled(Result result) {
        this.onCancelled();
    }

    protected void onCancelled() {
    }

    public final boolean isCancelled() {
        return this.mCancelled.get();
    }

    public final boolean cancel(boolean mayInterruptIfRunning) {
        this.mCancelled.set(true);
        return this.mFuture.cancel(mayInterruptIfRunning);
    }

    public final Result get() throws InterruptedException, ExecutionException {
        return this.mFuture.get();
    }

    public final Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.mFuture.get(timeout, unit);
    }

    @MainThread
    public final AsyncTaskV25<Params, Progress, Result> execute(Params ... params) {
        return this.executeOnExecutor(sDefaultExecutor, params);
    }

    public final AsyncTaskV25<Params, Progress, Result> executeOnExecutor(Executor exec, Params ... params) {
        if (this.mStatus != Status.PENDING) {
            switch (this.mStatus) {
                case RUNNING: {
                    throw new IllegalStateException("Cannot execute task: the task is already running.");
                }
                case FINISHED: {
                    throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
                }
            }
        }
        this.mStatus = Status.RUNNING;
        this.onPreExecute();
        this.mWorker.mParams = params;
        exec.execute(this.mFuture);
        return this;
    }

    public static void execute(Runnable runnable) {
        sDefaultExecutor.execute(runnable);
    }

    protected final void publishProgress(Progress ... values) {
        if (!this.isCancelled()) {
            AsyncTaskV25.getHandler().obtainMessage(2, new AsyncTaskResult<Progress>(this, values)).sendToTarget();
        }
    }

    private void finish(Result result) {
        if (this.isCancelled()) {
            this.onCancelled(result);
        } else {
            this.onPostExecute(result);
        }
        this.mStatus = Status.FINISHED;
    }

    static {
        if (Build.VERSION.SDK_INT >= 11) {
            THREAD_POOL_EXECUTOR = AsyncTask.THREAD_POOL_EXECUTOR;
            SERIAL_EXECUTOR = AsyncTask.SERIAL_EXECUTOR;
        } else {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 30L, TimeUnit.SECONDS, sPoolWorkQueue, sThreadFactory);
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            THREAD_POOL_EXECUTOR = threadPoolExecutor;
            SERIAL_EXECUTOR = new SerialExecutor();
        }
        sDefaultExecutor = SERIAL_EXECUTOR;
    }

    private static class AsyncTaskResult<Data> {
        final AsyncTaskV25 mTask;
        final Data[] mData;

        AsyncTaskResult(AsyncTaskV25 task, Data ... data) {
            this.mTask = task;
            this.mData = data;
        }
    }

    private static abstract class WorkerRunnable<Params, Result>
    implements Callable<Result> {
        Params[] mParams;

        private WorkerRunnable() {
        }
    }

    private static class InternalHandler
    extends Handler {
        public InternalHandler() {
            super(Looper.getMainLooper());
        }

        public void handleMessage(Message msg) {
            AsyncTaskResult result = (AsyncTaskResult)msg.obj;
            switch (msg.what) {
                case 1: {
                    result.mTask.finish(result.mData[0]);
                    break;
                }
                case 2: {
                    result.mTask.onProgressUpdate(result.mData);
                }
            }
        }
    }

    public static enum Status {
        PENDING,
        RUNNING,
        FINISHED;

    }

    private static class SerialExecutor
    implements Executor {
        final ArrayDeque<Runnable> mTasks = new ArrayDeque();
        Runnable mActive;

        private SerialExecutor() {
        }

        @Override
        public synchronized void execute(final Runnable r) {
            this.mTasks.offer(new Runnable(){

                @Override
                public void run() {
                    try {
                        r.run();
                    }
                    finally {
                        SerialExecutor.this.scheduleNext();
                    }
                }
            });
            if (this.mActive == null) {
                this.scheduleNext();
            }
        }

        protected synchronized void scheduleNext() {
            this.mActive = this.mTasks.poll();
            if (this.mActive != null) {
                THREAD_POOL_EXECUTOR.execute(this.mActive);
            }
        }
    }
}

