package com.shitu.epathmap.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

/**
 * author:lfei
 */

public class ImageScaleView extends View {
    float wide = 40;
    float height = 10;
    float textSize = 35;

    public ImageScaleView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ImageScaleView(Context context) {
        super(context);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        Paint paint = new Paint();
        paint.setTextSize(10);
        paint.setColor(Color.BLACK);
        paint.setStrokeWidth(5);
        paint.setTextSize(textSize);
        paint.setAntiAlias(true);

        Paint paint2 = new Paint();
        paint2.setColor(Color.BLACK);
        paint2.setStrokeWidth(5);
        paint2.setTextSize(textSize);
        paint2.setAntiAlias(true);

        Paint paint3 = new Paint();
        paint3.setColor(Color.BLACK);
        paint3.setStrokeWidth((float) 2.5);
        paint3.setAntiAlias(true);

//        paint.setShadowLayer(5, 10, 10, Color.GREEN);
        canvas.drawText("比例", 10, textSize + 2, paint);

        // 画直线
        canvas.drawLine(0, textSize, 0, height + textSize + 5, paint2);
        float y = 20 + wide;
        canvas.drawLine(0, height + textSize + 5, y, height + textSize + 5, paint);
        canvas.drawLine(y, textSize, y, height + textSize + 5, paint3);
        // 画斜线
    }

    public void setHeight(int height) {
        this.height = height;
        invalidate();
    }

    public void setWide(float wide) {
        this.wide = wide;
        invalidate();
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
        invalidate();
    }
}
