package com.shitu.epathmap.ui.activity;

import android.Manifest;
import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.support.design.widget.BottomSheetBehavior;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;

import com.shitu.epathmap.BuildConfig;
import com.shitu.epathmap.EpathMapSDK;
import com.shitu.epathmap.R;
import com.shitu.epathmap.base.BaseEpathActivity;
import com.shitu.epathmap.model.bean.CarCheckData;
import com.shitu.epathmap.model.bean.Configs;
import com.shitu.epathmap.model.bean.EpathUserInfo;
import com.shitu.epathmap.presenter.IView.EpathView;
import com.shitu.epathmap.presenter.EpathPresenter;
import com.shitu.epathmap.service.NavContentHandler;
import com.shitu.epathmap.service.NavigationData;
import com.shitu.epathmap.service.NavigationHandler;
import com.shitu.epathmap.ui.adapter.BaseRecyclerAdapter;
import com.shitu.epathmap.ui.item.AndroidLSRDataItem;
import com.shitu.epathmap.ui.utils.BitmapUtils;
import com.shitu.epathmap.ui.utils.DeviceUtils;
import com.shitu.epathmap.ui.utils.ImageLoader;
import com.shitu.epathmap.ui.utils.StatusBarCompat;
import com.shitu.epathmap.ui.widget.CenterDialog;
import com.shitu.epathmap.ui.widget.ConfirmCenterDialog;
import com.shitu.epathmap.ui.widget.ConfirmDialog;
import com.shitu.epathmap.ui.widget.FindCarCenterDialog;
import com.shitu.epathmap.ui.widget.LocShareDialog2;
import com.shitu.epathmap.ui.widget.LocShareJoinDialog;
import com.shitu.epathmap.ui.widget.LocShareNameDialog;
import com.shitu.epathmap.ui.widget.MyLocationDialog;
import com.shitu.epathmap.ui.widget.NavBottomNewDialog;
import com.shitu.epathmap.ui.widget.NavFinishBottomDialog;
import com.shitu.epathmap.ui.widget.NavFinishTopDialog;
import com.shitu.epathmap.ui.widget.NavPreBottomDialog;
import com.shitu.epathmap.ui.widget.NavPreTopDialog;
import com.shitu.epathmap.ui.widget.NavTopDialog;
import com.shitu.epathmap.ui.widget.ProgressDialog;
import com.shitu.epathmap.ui.widget.RegionDialog;
import com.shitu.epathmap.ui.widget.RegionSearchDialog;
import com.shitu.epathmap.ui.widget.RotateXImageView;
import com.shitu.epathmap.ui.widget.ScanfBluetoothDialog;
import com.shitu.epathmap.ui.widget.ShadeLayout;
import com.shitu.epathmap.ui.widget.ShareDialog;
import com.shitu.epathmap.ui.widget.StopCarCenterDialog;
import com.shitu.epathmap.ui.widget.VerifyCompassDialog;
import com.shitu.epathmap.ui.widget.camera.CameraPreview;
import com.shitu.epathmap.ui.widget.wheelview.WheelPicker;
import com.shitu.location.epathmap.EpathLocationSDK;
import com.shitu.location.epathmap.model.bean.AndroidLSRData;
import com.shitu.location.epathmap.model.bean.DataHolder;
import com.shitu.location.epathmap.model.bean.Floor;
import com.shitu.location.epathmap.model.bean.LocationRegionData;
import com.shitu.location.epathmap.model.bean.PhotoData;
import com.shitu.location.epathmap.model.parse.FeedBack;
import com.shitu.location.epathmap.model.parse.LocationShare;
import com.shitu.location.epathmap.model.parse.POI;
import com.shitu.location.epathmap.model.parse.Project;
import com.shitu.location.epathmap.utils.Constants;
import com.shitu.location.epathmap.utils.DateUtils;
import com.shitu.location.epathmap.utils.DensityUtils;
import com.shitu.location.epathmap.utils.EpConstants;
import com.shitu.location.epathmap.utils.EpUtils;
import com.shitu.location.epathmap.utils.JsonToArrayListUtils;
import com.shitu.location.epathmap.utils.L;
import com.shitu.location.epathmap.utils.MixpanelConstants;
import com.shitu.location.epathmap.utils.MixpanelEvent;
import com.shitu.location.epathmap.utils.SpUtils;
import com.shitu.location.epathmap.utils.T;
import com.shitu.location.uploadlocation.IntentWrapper;
import com.google.gson.Gson;
import com.parse.GetDataCallback;
import com.parse.ParseException;
import com.parse.ParseFile;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.SaveCallback;
import com.sails.engine.LocationRegion;
import com.sails.engine.LocationSignalPlayerListener;
import com.sails.engine.MarkerManager;
import com.sails.engine.PathRoutingManager;
import com.sails.engine.SAILS;
import com.sails.engine.SAILSMapView;
import com.sails.engine.SensorElement;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.overlay.ListOverlay;
import com.sails.engine.overlay.Marker;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.ScreenDensity;
import com.sails.engine.overlay.TextOverlay;
import com.tencent.bugly.crashreport.CrashReport;

import org.json.JSONArray;
import org.json.JSONException;

import java.io.File;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import static android.graphics.Color.GRAY;
import static com.shitu.epathmap.service.NavigationData.INDEX_NEXT_FLOOR;
import static com.shitu.epathmap.service.NavigationData.INDEX_TURN_ROUND;
import static com.shitu.epathmap.service.NavigationData.INDEX_UPDOWN;
import static com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE;
import static com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET;
//import static com.shitu.location.epathmap.utils.EpConstants.DELAY_ON_PAUSE_TO_CENTER;
import static com.shitu.location.epathmap.utils.EpConstants.DIRECTION_NEAR_DESTINATION;
import static com.shitu.location.epathmap.utils.EpConstants.NAV_MODE_BLE_GPS;
import static com.shitu.location.epathmap.utils.EpConstants.NAV_MODE_SIMULATION;
import static com.shitu.location.epathmap.utils.EpConstants.NAV_MODE_WIFI_GPS;
import static com.shitu.location.epathmap.utils.EpConstants.NAV_STATUS_DEFAULT;
import static com.shitu.location.epathmap.utils.EpConstants.NAV_STATUS_FINISH;
import static com.shitu.location.epathmap.utils.EpConstants.NAV_STATUS_NAVIGATING;
import static com.shitu.location.epathmap.utils.EpConstants.NAV_STATUS_NAVIGATING_PAUSE;
import static com.shitu.location.epathmap.utils.EpConstants.NAV_STATUS_SHOW_PRE_INFO;
import static com.shitu.location.epathmap.utils.EpConstants.NAV_STATUS_SHOW_REGION_INFO;
import static com.shitu.location.epathmap.utils.EpConstants.NAV_STATUS_SHOW_SEARCH_RESULT;
import static com.shitu.location.epathmap.utils.EpConstants.PERIOD_UPDATE_LOCATION_SHARE;

/**
 * author:liufei
 * time:2017/12/20
 */
public class EpathMapActivity extends BaseEpathActivity<EpathPresenter> implements View.OnClickListener,
        EpathView, SwipeRefreshLayout.OnRefreshListener {

    private RelativeLayout rlTop;
    private RelativeLayout rlBottom;
    private LinearLayout llEyeLocationAll;
    private FrameLayout flMap;
    private ImageView ivBackPosition;
    private TextView tvTitle, tvWatchFloor;
    private ImageView ivLockCenter, ivZoomIn, ivZoomOut, ivSearch, ivCompass,
            ivEyeLocation, ivShare;
    private EditText etSearch;
    private ProgressDialog progressDialog;
    private RegionDialog regionDialog;
    private RegionSearchDialog regionSearchDialog;
    private NavPreTopDialog navPreTopDialog;
    private NavPreBottomDialog navPreBottomDialog;
    private NavTopDialog navTopDialog;
    //    private NavBottomDialog navBottomDialog;
    private NavBottomNewDialog navBottomNewDialog;
    private NavFinishTopDialog navFinishTopDialog;
    private NavFinishBottomDialog navFinishBottomDialog;
    private boolean isShowFinishDialog = true;
    private MyLocationDialog myLocationDialog;
    private LocShareDialog2 locShareDialog;
    private LocShareNameDialog locShareNameDialog;
    private VerifyCompassDialog verifyCompassDialog;
    private ScanfBluetoothDialog scanfBluetoothDialog;
    private ConfirmDialog confirmExitNavDialog;
    private ShareDialog shareDialog;
    private WheelPicker wheelPicker;
    private TextView tvNogro;
    private LinearLayout llFloor;
    private TextView tvFloor, tvBuilding;
    private ProgressBar progressBar;
    private LinearLayout llLogo;
    private RelativeLayout rlScale;
    private TextView tvScale;
    private TextView tvUsedTime;
    private FrameLayout flLSR;
    private SwipeRefreshLayout swipeLayout;
    private RecyclerView recyclerView;
    private LinearLayout llSetParam;
    private TextView tvSelectContent;
    private EditText etParam1;
    private TextView tvOther;
    private SeekBar sbPlayProgress;
    private Button btnStart;
    private Button btnStop;
    private RelativeLayout flSetting;
    private FrameLayout flSettingBg;
    private ImageView ivCancelSetting;
    private ImageView ivTrumpet;
    private ImageView ivStartSetting;


    private List<SAILS.GeoNode> navGeoNodes;
    public static final String REQUEST_ID = "map_id",REQUEST_TARGET_NAME = "request_target_name", REQUEST_TARGET_ID = "request_target_id",
            REQUEST_SHARE_LOC_GROUP_ID = "group_id",
            REQUEST_SHARE_LOC_LAT = "lat", REQUEST_SHARE_LOC_LNG = "lng",
            REQUEST_SHARE_LOC_NAME = "loc_name", REQUEST_SHARE_LOC_FLOOR = "loc_floor",
            RESULT_SEARCH_CONTENT = "result_search_content", RESULT_SELECT_REGION = "result_select_region",
            RESULT_SEARCH_RESULT = "result_search_result", RESULT_SELECT_MY_LOCATION = "result_select_my_location";
    private static final int REQUEST_EP_SEARCH = 1;
    private boolean isLocationStart = false, isVolumeOn = true, isRouteSuccess = false,
            isFirstQueryMap = true, isFirstLocationFix = true, isInThisMap = false, istimeLocationFix = false,
            isFirstGotoNextFloor = true, isLocationSharing = false;
    private int navMode = NAV_MODE_BLE_GPS, navStatus = NAV_STATUS_DEFAULT;
    private int totalDistance, currentDistance;
    private double userNavigatingZoom;
    private String totalTime, requestType = RESULT_SELECT_MY_LOCATION, startMyLocFloorDescription = "",
            startMyLocBuildingName = "", targetRegionFrom = MixpanelConstants.NAVIGATION_TARGET_FROM_REGION_CLICK, currentBuildingName;

    private SAILS sails;
    private SAILSMapView sailsMapView;
    private PathRoutingManager pathRoutingManager;
    private MarkerManager markerManager;
    private LocationRegion startRegion, targetRegion;
    private LocationRegionData friendRegionData;
    private ListOverlay listOverlay;
    private List<OverlayItem> overlayItems;
    private NavigationHandler navigationHandler;
    private LinkedHashMap<Integer, Floor> floorNumbers = new LinkedHashMap<>();
    private int seekBarProgress;
    private List<PhotoData> photoList;
    private boolean isStartSearchActivity = false;
    private boolean isMultiFloor;
    private LocationShare mLocationShare;
    private ListOverlay myLocationOverlay;
    private List<OverlayItem> myLocationOverlayItems;
    private String lastBuilding = null;
    private int lockmode;
    private long showLogoCurrentTime;
    private long showLogoLastTime;
    private ObjectAnimator animatorLogo;
    private String currentViewFloor;
    private TextOverlay textOverlay;
    private ListOverlay swtichFloorNumberOverlay;
    private List<OverlayItem> swtichFloorNumberOverlayItems;
    private Marker virtualMarker;
    private Marker switchMarkerFirst;
    private Marker switchMarkerLast;
    private boolean isResume;
    private ArrayList<AndroidLSRData> androidLSRDatas;
    private BaseRecyclerAdapter adapter;
    private TextView tvDebughelper;
    private TextView tvExiteDebug;
    private int drawingCacheBackgroundColor;
    private long playerTimestamp;
    private boolean isPlaying;
    private List<NavigationData> currentFloorFirstData;
    private List<NavigationData> currentFloorLastData;
    private ArrayList<Marker> switchMarkerLastList;

    private ArrayList<Marker> switchMarkerFirstList;
    private ImageView ivFindOrStopCar;
    private boolean isFindOrStopEnable;
    private ImageView ivStopOk;
    /**
     *
     */
    private ImageView ivRepunchClock;

    private StopCarCenterDialog stopCarCenterDialog;
    private CarCheckData carCheckDatas;

    private FindCarCenterDialog findCarCenterDialog;

    private boolean isUploadStopCarDataing = false;
    private CenterDialog reCarCheckDialog;
    private CenterDialog confirmStopCar;
    private ListOverlay myCarLocationOverlay;
    private List<OverlayItem> myCarLocationOverlayItems;
    private boolean flagIsFindCaring = false;
    private int scanCarCheckTime;

    private UpdateLocShareTimerTask updateLocShareTimerTask;
    private ProgressDialog progressDialogRestartBle;
    private ImageView ivStartSplash;
    private TextView tvSignalStrength;

    private LinearLayout llSignalStrength;
    private ImageView ivBlueth;
    private TextView tvSignalNotification;
    //    private RelativeLayout rlSignalStrength;
//    private ImageView ivCloseSignal;
    private boolean isShowSignalStrength = true, isResetMapByRegion = true;
    private TextView isFirstLocationNotification;
    private SAILS.SignalStatus signalStatus;
    private SAILS.SignalStatus sailsSignalStatus;
    private TextView tvAr;
    private CameraPreview svRealView;
    private ShadeLayout slMap;
    private FrameLayout flRealView;
    private ImageView ivDerection;
    private RotateXImageView ivRealViewNorth;
    private RelativeLayout rlRegion;
    private boolean isDoNotReset;
    private Button btnChangeHeight;
    private boolean isExpend;
    private boolean isMapExpending;
    private FrameLayout flRealViewCompass;
    private int maxTopClip;
//    private GuideLineView guideLineView;
    private int ZoomLevel;
    private float arNavigationZoomLevel = 22;
    private ImageView ivRemind;
    private RelativeLayout rlRoot;
    private PopupWindow popupAccessbilityWindow;
    private TextView tvAccessbilityNavigation;
    private View btnAccessbilityExit;
    private boolean isPreDirectionSoWrong;
    private long preHandleNearTime = -1L;
    private final long HANDLE_NEAR_LIMIT = 5000;
    private boolean isNoRealTimeShare;

    @Override
    protected int getLayoutId() {
        return R.layout.activity_map;
    }

    @Override
    protected void initView(Bundle saveInstanceState) {

        initSetting();
        setSwipeBackEnable(false);

        rlRoot = ((RelativeLayout) findViewById(R.id.rl_root));

        rlTop = (RelativeLayout) findViewById(R.id.rl_top);
        rlBottom = (RelativeLayout) findViewById(R.id.rl_bottom);
        tvTitle = (TextView) findViewById(R.id.tv_title);
        flMap = (FrameLayout) findViewById(R.id.fl_map);
//        tvTitle = (TextView) findViewById(R.id.tv_title);
        ivLockCenter = (ImageView) findViewById(R.id.iv_lock_center);
        ivZoomIn = (ImageView) findViewById(R.id.iv_zoom_in);
        ivTrumpet = (ImageView) findViewById(R.id.iv_trumpet);
        ivStartSplash = (ImageView) findViewById(R.id.iv_start_splash);
        ivZoomOut = (ImageView) findViewById(R.id.iv_zoom_out);
        ivCompass = (ImageView) findViewById(R.id.iv_compass);
        wheelPicker = (WheelPicker) findViewById(R.id.wheelPicker);
        ivSearch = (ImageView) findViewById(R.id.iv_search);
        llLogo = (LinearLayout) findViewById(R.id.ll_logo);
        etSearch = (EditText) findViewById(R.id.et_search);
        tvNogro = (TextView) findViewById(R.id.tv_nogro);
        tvBuilding = (TextView) findViewById(R.id.tv_building);
        tvFloor = (TextView) findViewById(R.id.tv_floor);
        ivShare = (ImageView) findViewById(R.id.iv_share);
        llFloor = (LinearLayout) findViewById(R.id.ll_floor);
        llEyeLocationAll = (LinearLayout) findViewById(R.id.ll_eye_location_all);
        tvWatchFloor = (TextView) findViewById(R.id.tv_watch_floor);
        rlScale = (RelativeLayout) findViewById(R.id.rl_scale);
        tvScale = (TextView) findViewById(R.id.tv_scale);
        ivEyeLocation = (ImageView) findViewById(R.id.iv_eye_location);
        ivBackPosition = (ImageView) findViewById(R.id.iv_back_position);
        progressBar = (ProgressBar) findViewById(R.id.progressBar);
        flLSR = (FrameLayout) findViewById(R.id.fl_LSR);
        swipeLayout = (SwipeRefreshLayout) findViewById(R.id.swipe_layout);
        recyclerView = (RecyclerView) findViewById(R.id.recyclerView);
        llSetParam = (LinearLayout) findViewById(R.id.ll_set_param);
        tvSelectContent = (TextView) findViewById(R.id.tv_select_content);
        tvDebughelper = (TextView) findViewById(R.id.tv_debug_helper);
        etParam1 = (EditText) findViewById(R.id.et_param1);
        tvOther = (TextView) findViewById(R.id.tv_other);
        tvExiteDebug = (TextView) findViewById(R.id.tv_exite_debug);
        sbPlayProgress = (SeekBar) findViewById(R.id.sb_play_progress);
        btnStart = (Button) findViewById(R.id.btn_start);
        btnStop = (Button) findViewById(R.id.btn_stop);
        tvUsedTime = (TextView) findViewById(R.id.tv_used_time);
        ivFindOrStopCar = (ImageView) findViewById(R.id.iv_find_or_stop_car);
        showFindOrStopView(View.VISIBLE);
        ivRepunchClock = (ImageView) findViewById(R.id.iv_repunch_clock);

        rlRegion = ((RelativeLayout) findViewById(R.id.rl_region));

        ivRemind = ((ImageView) findViewById(R.id.iv_remind));
        ivRemind.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showAccessbilityNavigation();
            }
        });


        isFirstLocationNotification = (TextView) findViewById(R.id.tv_signal_notification);
        tvSignalStrength = (TextView) findViewById(R.id.tv_signal_strength);

        llSignalStrength = (LinearLayout) findViewById(R.id.ll_signal_strength);

//        rlSignalStrength = (RelativeLayout) findViewById(R.id.rl_signal_strength);

//        ivCloseSignal = (ImageView) findViewById(R.id.iv_close_signal);

        ivTrumpet.setOnClickListener(v -> {
            if (isVolumeOn) {
                voiceManager.stopSpeaking();
                stopSpeaking();
                isVolumeOn = false;
                ivTrumpet.setImageResource(R.drawable.ic_trumpet_close);
                ivTrumpet.setContentDescription(getString(R.string.epath_turn_on_voice));
            } else {
                isVolumeOn = true;
                ivTrumpet.setImageResource(R.drawable.ic_trumpet_open);
                ivTrumpet.setContentDescription(getString(R.string.epath_turn_off_voice));
            }
        });

//        ivCloseSignal.setOnClickListener(view -> {
//            rlSignalStrength.setVisibility(View.GONE);
//            tvSignalStrength.setVisibility(View.GONE);
//            isShowSignalStrength = false;
//        });

        tvSignalStrength.setOnClickListener(view -> {
            tvSignalStrength.setVisibility(View.GONE);
            isShowSignalStrength = false;
        });
        /**
         * 重新打卡
         */
        ivRepunchClock.setOnClickListener(v -> {
            if (navStatus == NAV_STATUS_DEFAULT || navStatus == NAV_STATUS_SHOW_REGION_INFO) {


                reCarCheckDialog = new CenterDialog(context, getString(R.string.epath_update_car_position), v1 -> {

                    if (isLocationFix()) {
                        LocationRegionData locationRegionData = getNearLocationRegionData();
                        reCarCheckDialog.dismiss();

//                        updateCarMessage(locationRegionData);

                        stopCarDialog(locationRegionData).show();

                    } else {
                        T.showShort(R.string.epath_locate_failed_and_retry);
                    }
                }, v12 -> reCarCheckDialog.dismiss());
                reCarCheckDialog.show();
            }
        });

        ivFindOrStopCar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                queryCarMessage();
                if (carCheckDatas.isHasStop() == true && carCheckDatas.getFinish() == false && (navStatus == NAV_STATUS_DEFAULT || navStatus == NAV_STATUS_SHOW_REGION_INFO)) {
                    //找车
                    if (findCarCenterDialog == null) {
                        findCar(carCheckDatas);
                    } else {
                        findCar(carCheckDatas);
                    }
                    findCarCenterDialog.show();
                    return;
                } else if (carCheckDatas.isHasStop() == false && carCheckDatas.getFinish() == false && (navStatus == NAV_STATUS_DEFAULT || navStatus == NAV_STATUS_SHOW_REGION_INFO)) {
                    if (isLocationFix()) {
                        //停车，上传服务器数据
                        if (confirmStopCar == null) {
                            newCenterDialog();
                        }
                        confirmStopCar.show();
                    } else {
                        T.showShort(R.string.epath_locate_failed_and_retry);
                        return;
                    }
                } else {
                    T.showShort(R.string.epath_wrong_click_status);
                }

            }
        });


        if (BuildConfig.DEBUG) {
            flLSR.setVisibility(View.VISIBLE);
        } else {
            flLSR.setVisibility(View.GONE);
        }
        sbPlayProgress.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                sails.LSPSetPercentage(seekBar.getProgress());
            }
        });
        btnStart.setOnClickListener(new View.OnClickListener() {
            private int sbProgress;

            @Override
            public void onClick(View v) {
                if (isPlaying == false) {
                    btnStart.setText(getString(R.string.epath_pause));
                    sails.LSPPlay();
//                    sails.LSPSetPercentage((float) (sbProgress*1.0/100));
                    isPlaying = true;
                } else {
                    sbProgress = sbPlayProgress.getProgress();
                    sails.LSPPause();
                    isPlaying = false;
                    btnStart.setText(getString(R.string.epath_start));
                }
            }
        });
        btnStop.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                sails.LSPStop();
                sbPlayProgress.setProgress(0);
                btnStart.setText(getString(R.string.epath_start));
                isPlaying = false;
            }
        });

        recyclerView.setLayoutManager(new LinearLayoutManager(context));
        swipeLayout.setColorSchemeResources(R.color.colorAccent);
        swipeLayout.setProgressViewOffset(false, -20, 150);
        swipeLayout.setOnRefreshListener(this);

        tvExiteDebug.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                flLSR.setBackgroundColor(drawingCacheBackgroundColor);
                tvDebughelper.setVisibility(View.VISIBLE);
                llSetParam.setVisibility(View.GONE);
                swipeLayout.setVisibility(View.GONE);
            }
        });

        tvDebughelper.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                drawingCacheBackgroundColor = flLSR.getDrawingCacheBackgroundColor();
                flLSR.setBackgroundColor(context.getResources().getColor(R.color.white));
                tvDebughelper.setVisibility(View.GONE);
                llSetParam.setVisibility(View.VISIBLE);
                swipeLayout.setVisibility(View.GONE);
            }
        });
        tvSelectContent.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                swipeLayout.setVisibility(View.VISIBLE);
                llSetParam.setVisibility(View.GONE);
                tvSelectContent.setText(project.getName());
                presenter.queryAndroidLSR(androidLSRDatas, project.getBuildingId(), project.getName());
            }
        });


        etSearch.setFocusable(false);
        etSearch.setFocusableInTouchMode(false);
        etSearch.setOnClickListener(this);
        ivSearch.setOnClickListener(this);
        ivCompass.setOnClickListener(this);
        ivZoomIn.setOnClickListener(this);
        ivZoomOut.setOnClickListener(this);
        ivLockCenter.setOnClickListener(this);
        ivShare.setOnClickListener(this);
        findViewById(R.id.iv_back).setOnClickListener(this);
        findViewById(R.id.iv_footprint).setOnClickListener(this);
        findViewById(R.id.iv_loc_share).setOnClickListener(this);

        ivBackPosition.setOnClickListener(this);

        regionDialog = new RegionDialog(context, rlRegion, goLoc -> {
            /**
             * “去这里”按钮
             */
            if (sails != null && pathRoutingManager != null) {
                isResetMapByRegion = false;
                dimissFindCar();
                navStatus = NAV_STATUS_SHOW_PRE_INFO;
                updateNavStatus();
            }
        }, sendLoc -> {
            String title = regionDialog.getRegionName();
            String description = project.getName() + "(" + regionDialog.getFloorName() + ")";
            String url = Constants.SHARE_URL + "?map_id=" + project.getObjectId() + "&loc_name="
                    + title + "&loc_floor=" + targetRegion.getFloorName() + "&lat=" + targetRegion.getCenterLatitude()
                    + "&lng=" + targetRegion.getCenterLongitude() + "&app_name=" + Constants.getAppName(context) + "&pkg_name=" +
                    getPackageName() + "&scheme=" + EpathMapSDK.app.getScheme();
            shareDialog = new ShareDialog(context, url, title, description, null, ShareDialog.TYPE_LOC_REGION, v -> {
                navStatus = NAV_STATUS_DEFAULT;
                updateNavStatus();
            });
            shareDialog.show(flMap);
            ObjectAnimator.ofFloat(rlBottom, "translationY", rlBottom.getTranslationY(), -shareDialog.getHeight())
                    .setDuration(300).start();
            regionDialog.dismiss();
            MixpanelEvent.locShareLocRegion(title);
        }, () -> {
            if (isResetMapByRegion) {
                onBackPressed();
            }
            isResetMapByRegion = true;
        });
        navPreTopDialog = new NavPreTopDialog(context, start -> {
            if (friendRegionData != null || isLocationSharing) {
                return;
            }
            isStartSearchActivity = true;
            showRegionSearchDialog(false);

            startActivityForResult(com.shitu.epathmap.ui.activity.EpSearchActivity.getIntent(context, project.getObjectId(),
                    com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_START), REQUEST_EP_SEARCH);
        }, target -> {
            if (friendRegionData != null || isLocationSharing) {
                return;
            }
            isStartSearchActivity = true;
            showRegionSearchDialog(false);

            startActivityForResult(com.shitu.epathmap.ui.activity.EpSearchActivity.getIntent(context, project.getObjectId(),
                    com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET), REQUEST_EP_SEARCH);
        }, back -> {
            onBackPressed();
        }, exchange -> {
            if (startRegion == PathRoutingManager.MY_LOCATION) {
                T.showShort(R.string.epath_cannot_exchange_my_location);
            } else if (startRegion != null && targetRegion != null) {
                LocationRegion temp = startRegion;
                startRegion = targetRegion;
                targetRegion = temp;
                overlayItems.clear();
                setStartLocationRegionMarker(startRegion);
                setTargetLocationRegionMarker(targetRegion, false);
                showPathRoute();
                wheelPicker.setSelectedItemPosition(getPositionByFloorName(getRegionFloorName(startRegion)));
                navPreTopDialog.setStartFloor(getRegionFloorDescription(startRegion));
                navPreBottomDialog.setBtnNavEnable(false);
                navPreTopDialog.setStartRegion(startRegion.getName());
                navPreTopDialog.setTargetRegion(targetRegion);
                navPreBottomDialog.setBtnNavEnable(false);
            }
        });
//        sails.setOnFloorChangeListener();
//        sailsMapView.setOnFloorChangedListener();
        navPreBottomDialog = new NavPreBottomDialog(context, new NavPreBottomDialog.OnNavBtnClickListener() {
            @Override
            public void onNavStart() {
                if (startRegion == null) {
                    T.showShort(R.string.epath_no_start_region);
                    return;
                }
                if (!isRouteSuccess) {
                    T.showShort(R.string.epath_path_route_fail);
                    return;
                }
                if (hasPermission(Manifest.permission.WRITE_EXTERNAL_STORAGE)) {
                    initBaiduVioce();
                } else {
                    requestPermission(MY_PERMISSIONS_REQUEST_ACCESS_FINE_WRITE_SD_AND_RECORD_AUDIO_BAIDU,
                            Manifest.permission.WRITE_EXTERNAL_STORAGE);
                }
                navMode = NAV_MODE_BLE_GPS;
                if (project != null && project.isWiFi()) {
                    navMode = NAV_MODE_WIFI_GPS;
                }
                navStatus = NAV_STATUS_NAVIGATING;
                updateNavStatus();
                startNavTimerTask();
                voiceManager.textToVoice(NavContentHandler.getNavString(NavContentHandler.NAV_GO_ALONG), true);
                volumeIsTooLow();
            }

            @Override
            public void onArStart() {
                if(hasPermission(Manifest.permission.CAMERA)){

                    onNavStart();
                    controlAr();

                }else{
                    requestPermission(MY_PERMISSIONS_REQUEST_CAMERA,Manifest.permission.CAMERA);
                }
            }

            @Override
            public void onSimStart() {
                if (startRegion == null) {
                    T.showShort(R.string.epath_no_start_region);
                    return;
                }
                if (!isRouteSuccess) {
                    T.showShort(R.string.epath_path_route_fail);
                    return;
                }
                if (hasPermission(Manifest.permission.WRITE_EXTERNAL_STORAGE)) {
                    initBaiduVioce();
                } else {
                    requestPermission(MY_PERMISSIONS_REQUEST_ACCESS_FINE_WRITE_SD_AND_RECORD_AUDIO_BAIDU,
                            Manifest.permission.WRITE_EXTERNAL_STORAGE);
                }
                navMode = NAV_MODE_SIMULATION;
                navStatus = NAV_STATUS_NAVIGATING;
                updateNavStatus();
                startNavTimerTask();
                voiceManager.textToVoice(NavContentHandler.getNavString(NavContentHandler.NAV_GO_ALONG), true);
                volumeIsTooLow();
            }
        }, new NavPreBottomDialog.OnFloorModeSelectListener() {
            @Override
            public void escalatorMode() {
                if (pathRoutingManager != null) {
                    pathRoutingManager.setRouteMode(PathRoutingManager.ESCALATOR_AND_STAIR_FIRST);
                    pathRoutingManager.enableHandler();
                }
            }

            @Override
            public void elevatorMode() {
                if (pathRoutingManager != null) {
                    pathRoutingManager.setRouteMode(PathRoutingManager.ELEVATOR_FIRST);
                    pathRoutingManager.enableHandler();
                }
            }
        });
        navTopDialog = new NavTopDialog(context);
        navBottomNewDialog = new NavBottomNewDialog(context, closeClick ->
                onBackPressed(),
                continueClick -> {
                    cancelCenterLockTimerTask();
                    navStatus = NAV_STATUS_NAVIGATING;
                    updateNavStatus();
                });
//        navBottomDialog = new NavBottomDialog(context,
////                checked -> {
////                    isVolumeOn = checked;
////                    if (!isVolumeOn) {
////                        stopSpeaking();
////                    }
////                },
////                closeClick -> {
////                    onBackPressed();
////                },
////                continueClick -> {
////                    cancelCenterLockTimerTask();
////                    navStatus = NAV_STATUS_NAVIGATING;
////                    updateNavStatus();
////                });
        navFinishTopDialog = new NavFinishTopDialog(context);
        navFinishBottomDialog = new NavFinishBottomDialog(context, v -> {
            updateFeedBack(true);
            onBackPressed();
            // 因为设置NAV_STATUS_DEFAULT 无法回到的当前的位置
//            onClickChangeMode();
        }, v -> {
            updateFeedBack(false);
            onBackPressed();
            // 因为设置NAV_STATUS_DEFAULT 无法回到的当前的位置
//            onClickChangeMode();
        });
        verifyCompassDialog = new VerifyCompassDialog(context);
        progressDialogRestartBle = new ProgressDialog(context, getString(R.string.epath_restart_ble), true);
        scanfBluetoothDialog = new ScanfBluetoothDialog(context, v -> {
            //重启蓝牙
            scanfBluetoothDialog.dismiss();
            progressDialogRestartBle.show();
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    if (progressDialogRestartBle.isShowing()) {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                T.showShort(R.string.epath_please_handle_restrat_ble);
                            }
                        });
                        progressDialogRestartBle.dismiss();
                        sails.startLocatingEngine();
                    }

                }
            }, 5000);
            sails.resetBLEProcedure(() -> runOnUiThread(() -> {
                progressDialogRestartBle.dismiss();
                sails.startLocatingEngine();
            }));
        });

        scanfBluetoothDialog.show(flMap, navStatus);


        tvAr = ((TextView) findViewById(R.id.tv_ar));
        tvAr.setOnClickListener(this);

        flRealView = ((FrameLayout) findViewById(R.id.fl_real_view));
        flRealView.setOnClickListener(this);
        svRealView = ((CameraPreview) findViewById(R.id.cp_real_view));

        svRealView.setmStateListener(new CameraPreview.PreviewStateListener() {
            @Override
            public void onStart() {
                isPreview = true;
            }

            @Override
            public void onStop() {
                isPreview = false;
            }
        });

        ivDerection = ((ImageView) findViewById(R.id.iv_direction));
//        ivDerection.setImageResource(R.drawable.ic_gif_derection_bian);
        ImageLoader.loadGif(context,R.drawable.gif_derection,ivDerection);
        ivRealViewNorth = ((RotateXImageView) findViewById(R.id.iv_real_view_compass));
        slMap = ((ShadeLayout) findViewById(R.id.sl_map));
        flRealViewCompass = ((FrameLayout) findViewById(R.id.fl_real_view_compass));

//        guideLineView = ((GuideLineView) findViewById(R.id.glv));

        FrameLayout.LayoutParams svRealViewLayoutParams = (FrameLayout.LayoutParams) svRealView.getLayoutParams();
        svRealViewLayoutParams.height = 1920 -  (int) DeviceUtils.dpToPixel(this,80);

        btnChangeHeight = ((Button) findViewById(R.id.btn_change_height));
        btnChangeHeight.setOnClickListener(this);
    }



    private void initSetting() {
        setFindOrStopEnable(false);
    }

    @Override
    protected void onStart() {
        super.onStart();
        if(needToRecoverVolume){
            isVolumeOn = true;
        }
        if(svRealView!=null){
            svRealView.onStart();
        }
    }

    private boolean needToRecoverVolume = false;

    @Override
    protected void onStop(){
        super.onStop();
        if(voiceManager != null && isVolumeOn) {
            voiceManager.stopSpeaking();
            stopSpeaking();
            isVolumeOn = false;
            needToRecoverVolume = true;
        }
        if(svRealView != null){
            svRealView.onStop();
        }
    }

    /**
     * 停车对话框
     */
    private void newCenterDialog() {
        confirmStopCar = new CenterDialog(context, getString(R.string.epath_is_the_car_ready), new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (isLocationFix()) {
                    LocationRegionData locationRegionData = getLocationRegionData();
                    isUploadStopCarDataing = true;
                    confirmStopCar.dismiss();
                    stopCar(locationRegionData);
                } else {
                    T.showShort(R.string.epath_locate_failed_and_retry);
                    return;
                }
            }

        }, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                confirmStopCar.dismiss();
            }
        });
    }

    private LocationRegionData getLocationRegionData() {
        LocationRegionData locationRegionData = new LocationRegionData();
        List<LocationRegion> currentInRegions = sails.getCurrentInRegions();
        for (int i = 0; i < currentInRegions.size(); i++) {
            LocationRegion locationRegion = currentInRegions.get(i);
            String type = locationRegion.type;
            if (type != null && !type.equals("parking") && !type.equals("parking") && !type.equals("freedom") && !type.equals("boundary") && !type.equals("lock")) {
                L.e("ssss", "最近region" + locationRegion.updatedLength + "" + locationRegion.label);
                locationRegionData.setName(locationRegion.label);
                locationRegionData.setFloorName(locationRegion.getFloorName());
                locationRegionData.setLatitude(sails.getLatitude());
                locationRegionData.setLongitude(sails.getLongitude());
                return locationRegionData;
            } else if (type == null) {
                L.e("ssss", "最近region" + locationRegion.updatedLength + "" + locationRegion.label);
                locationRegionData.setName(locationRegion.label);
                locationRegionData.setFloorName(locationRegion.getFloorName());
                locationRegionData.setLatitude(sails.getLatitude());
                locationRegionData.setLongitude(sails.getLongitude());
                return locationRegionData;
            }
        }
        if (TextUtils.isEmpty(locationRegionData.getFloorName())) {
            LocationRegionData nearLocationRegionData = getNearLocationRegionData();
            return nearLocationRegionData;
        }

        return locationRegionData;

    }

    private LocationRegionData getNearLocationRegionData() {
        LocationRegionData locationRegionData = new LocationRegionData();

        List<LocationRegion> locationRegionList = sails.getLocationRegionList(sails.getFloor());
        List<LocationRegion> locationRegions = sails.sortLocationRegionsByPathLength(locationRegionList);
        for (int i = 0; i < locationRegions.size(); i++) {
            LocationRegion locationRegion = locationRegions.get(i);
            String type = locationRegion.type;
            if (type != null && !type.equals("parking") && !type.equals("freedom") && !type.equals("boundary") && !type.equals("lock")) {
                L.e("ssss", "最近region" + locationRegion.updatedLength + "" + locationRegion.label);
                locationRegionData.setName(locationRegion.label);
                locationRegionData.setFloorName(locationRegion.getFloorName());
                locationRegionData.setLatitude(sails.getLatitude());
                locationRegionData.setLongitude(sails.getLongitude());
                return locationRegionData;
            } else if (type == null) {
                L.e("ssss", "最近region" + locationRegion.updatedLength + "" + locationRegion.label);
                locationRegionData.setName(locationRegion.label);
                locationRegionData.setFloorName(locationRegion.getFloorName());
                locationRegionData.setLatitude(sails.getLatitude());
                locationRegionData.setLongitude(sails.getLongitude());
                return locationRegionData;
            }
        }

        return locationRegionData;


    }


    private void findCar(CarCheckData carCheckData) {

        findCarCenterDialog = new FindCarCenterDialog(context, carCheckData, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (carCheckData != null) {
                    List<LocationRegion> list = new ArrayList<>();
                    if (carCheckData.getLongitude() != 0 && carCheckData.getLatitude() != 0) {
                        LocationRegion locationRegion = new LocationRegion(getString(R.string.epath_love_car_position),
                                carCheckData.getLongitude(), carCheckData.getLatitude(), carCheckData.getFloor(), sails);
                        list.add(locationRegion);
                    } else {
                        L.e("ddd", "location == null");
                    }


                    flagIsFindCaring = true;
                    initTargetLocationRegion(list, false);
                    navStatus = NAV_STATUS_SHOW_PRE_INFO;
                    updateNavStatus();
                    showRlBottomAnimation();
                    findCarCenterDialog.dismiss();
                }
            }
        }, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
//                findCarCenterDialog.dismiss();
                upLoadStopCarData();
            }
        });


    }

    private void upLoadStopCarData() {
        if (carCheckDatas != null) {
            carCheckDatas.clear();
            SpUtils.setCarCheckDatas(context, "", project.getObjectId());
            findCarCenterDialog.dismiss();
            queryCarMessage();
        } else {
            T.showShort(R.string.epath_search_data_wrong);
        }
    }


    private StopCarCenterDialog stopCarDialog(LocationRegionData locationRegionData) {
        stopCarCenterDialog = new StopCarCenterDialog(context, locationRegionData.getName(), sails.getFloor(), "", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //上传服务器
                if (isLocationFix()) {
                    LocationRegionData locationRegionData1 = getLocationRegionData();
                    updateCarMessage(locationRegionData1);
                } else {
                    T.showShort(R.string.epath_update_parking_record_failed);
                }

            }
        }, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //取消
            }
        });
        return stopCarCenterDialog;
    }

    private void updateCarMessage(LocationRegionData locationRegionData) {
        if (isLocationFix()) {
            if (stopCarCenterDialog != null) {
                stopCarCenterDialog.setCarFloor(sails.getFloor());
                stopCarCenterDialog.setCarResgion(locationRegionData.getName());
                stopCarCenterDialog.upDataTime();
                stopCarCenterDialog.setTitle(getString(R.string.epath_parking_record_successful));
                storyCarMessage(locationRegionData);
                T.showLong(R.string.epath_update_parking_record_successful);
                queryCarMessage();
            } else {
                storyCarMessage(locationRegionData);
                T.showLong(R.string.epath_update_parking_record_successful);
                queryCarMessage();
            }
        } else {
            L.e("lll", "没有定位");
        }
    }

    private void stopCar(LocationRegionData locationRegionData) {
        stopCarDialog(locationRegionData);
        storyCarMessage(locationRegionData);
        //显示对象
        stopCarCenterDialog.setCarFloor(sails.getFloor());
        stopCarCenterDialog.setCarResgion(locationRegionData.getName());
        stopCarCenterDialog.upDataTime();
        stopCarCenterDialog.setTitle(getString(R.string.epath_parking_record_successful));


        queryCarMessage();

        stopCarCenterDialog.show();
    }


    private void sendFeedBackEvent(boolean isExit) {
        String startLocation;
        //&& isLocationFix()
        if (startRegion == PathRoutingManager.MY_LOCATION) {
            startLocation = MixpanelConstants.FEEDBACK_NAVIGATION_START_FROM_MY_LOCATION;
        } else {
            startLocation = startRegion.getName();
        }
        MixpanelEvent.updateFeedBack(navFinishBottomDialog.getScore(), navFinishBottomDialog.getComments(),
                navFinishBottomDialog.getContent(), navMode == NAV_MODE_SIMULATION, startLocation,
                targetRegion.getName(), totalDistance, EpUtils.getDistanceTime(countTime), isExit);
    }

    private void updateFeedBack(boolean isExit) {
        sendFeedBackEvent(isExit);
        FeedBack feedBack = new FeedBack();
        feedBack.put(FeedBack.SCORE, navFinishBottomDialog.getScore());
        feedBack.put(FeedBack.COMMENTS, navFinishBottomDialog.getComments());
        feedBack.put(FeedBack.CONTENT, navFinishBottomDialog.getContent());
        feedBack.put(FeedBack.START_NAME, navFinishBottomDialog.getStartRegion());
        feedBack.put(FeedBack.TARGET_NAME, navFinishBottomDialog.getTargetRegion());
        feedBack.put(FeedBack.IS_SIMULATION, navMode == NAV_MODE_SIMULATION ? true : false);
        ParseObject parseObject = ParseObject.createWithoutData("MappingProject", project.getObjectId());
        feedBack.put(FeedBack.PROJECT, parseObject);
        feedBack.saveInBackground(new SaveCallback() {
            @Override
            public void done(ParseException e) {
                if (!isExit) {
                    if (e == null) {
                        T.showShort(R.string.epath_upload_feedback_is_successful);
                    } else {
                        T.showShort(R.string.epath_upload_feedback_is_failed);
                    }
                }
            }
        });
    }

    void initPlayerEngine(byte[] jsonData) {
        T.showShort(R.string.epath_data_loaded);
        String json = new String(jsonData);
        List<SensorElement> recordList = new ArrayList<>();
        new JsonToArrayListUtils(json, recordList).invoke();
        sails.LSPLoad(recordList);
        sails.LSPSetListener(new LocationSignalPlayerListener() {
            @Override
            public void onProgressChanged(float v, float v1, float v2) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        float progress = v * 100;
//                        L.e("ddd","progress"+progress+"");
                        sbPlayProgress.setProgress((int) progress);
                        sbPlayProgress.refreshDrawableState();
                        tvUsedTime.setText(getString(R.string.epath_make_use_of) + (int) v1 + "s");
                        float v3 = v1 + v2;
                        tvOther.setText(getString(R.string.epath_total_time) + (int) v3 + "s");
                    }
                });

            }
        });
        isPlaying = false;
        playerTimestamp = System.currentTimeMillis();
    }

    @Override
    protected void initData() {

        androidLSRDatas = new ArrayList<>();
        adapter = new BaseRecyclerAdapter(androidLSRDatas);
        AndroidLSRDataItem androidLSRDataItem = new AndroidLSRDataItem(context
                , new AndroidLSRDataItem.OnItemClickListener() {
            @Override
            public void onClick(AndroidLSRData item) {
                llSetParam.setVisibility(View.VISIBLE);
                swipeLayout.setVisibility(View.GONE);
                ParseFile myFile = item.getMyFile();
                myFile.getDataInBackground(new GetDataCallback() {
                    @Override
                    public void done(byte[] data, ParseException e) {
                        if (e == null) {
                            initPlayerEngine(data);
                            tvSelectContent.setText(item.getName());
                            // data has the bytes for the resume
                        } else {
//                            showErrorDialog(e.toString());
                        }
                    }
                });
            }
        }
        );

        adapter.addItemFactory(androidLSRDataItem);
        recyclerView.setAdapter(adapter);
        swipeLayout.setRefreshing(true);


        mHandler = new MyHandler(context);
        if (EpathMapSDK.context == null) {
            T.showShort(R.string.epath_init_epath_fail);
            finish();
            return;
        }
        //自己的位置的自定义marker
        myLocationOverlay = new ListOverlay();
        myLocationOverlayItems = myLocationOverlay.getOverlayItems();

        //自己的位置的自定义切换楼层marker
        swtichFloorNumberOverlay = new ListOverlay();
        swtichFloorNumberOverlayItems = swtichFloorNumberOverlay.getOverlayItems();

        myCarLocationOverlay = new ListOverlay();
        myCarLocationOverlayItems = myCarLocationOverlay.getOverlayItems();

        MixpanelEvent.timeKeepSDK();
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        String objectId = getIntent().getStringExtra(REQUEST_ID);
        L.e("ddd", "objectId " + objectId);
        if (EpathLocationSDK.app != null) {
            ParseQuery<Project> query = EpathMapSDK.app.getProjects().getQuery();
            query.whereEqualTo("visible", true);
            if (!EpathLocationSDK.debug) {
                query.whereEqualTo("isDebug", false);
            }
            query.setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK);
            query.findInBackground((objects, e) -> {
                if (e != null) {
                    e.printStackTrace();
                    if (e.getCode() != ParseException.CACHE_MISS && isFirstQueryMap) {
                        finish();
                    }
                    return;
                }
                if (!isFirstQueryMap) {
                    return;
                }
                isFirstQueryMap = false;
                for (int i = 0; i < objects.size(); i++) {
                    Project project = objects.get(i);
                    if (project.getObjectId().equals(objectId)) {
                        this.project = project;
                        break;
                    }
                }
                if (this.project == null) {
                    T.showShort(R.string.epath_no_permission_read_this_map);
                    finish();
                    return;
                }
                configs = project.getConfigs();
                initConfigs();
                MixpanelEvent.setProject(project);
                tvTitle.setText(project.getName());
                L.e("ddddd", "getBuildingId : projectname: " + project.getName());
                L.e("ddddd", "getBuildingId " + project.getBuildingId());
                List<IntentWrapper> listMatters = IntentWrapper.hasWhiteListMatters(EpathMapActivity.this, getString(R.string.epath_track_tracking_service));
                if (project.getBuildingIdBg() != null && listMatters.size() > 0) {
                    listMatters.clear();
                    int guideWhiteList = SpUtils.getGuideWhiteList(context);
                    if (guideWhiteList == 0) {
                        //没有初始化的弹出
                        flSetting.setVisibility(View.VISIBLE);
                        StatusBarCompat.setColor(EpathMapActivity.this, context.getResources().getColor(R.color.tvBlack9));
                    }
                }
                if (project.getBuildingId().isEmpty() || project.getToken().isEmpty()) {
                    T.showShort(R.string.epath_info_lack);
                    finish();
                    return;
                }
                if (hasPermission(Manifest.permission.ACCESS_FINE_LOCATION, Manifest.permission.WRITE_EXTERNAL_STORAGE)) {
                    //拥有了此权限
                    permissionGranted();
                } else {
                    //还没有对应权限
                    requestPermission(MY_PERMISSIONS_REQUEST_ACCESS_FINE_LOCATION, Manifest.permission.ACCESS_FINE_LOCATION, Manifest.permission.WRITE_EXTERNAL_STORAGE);
                }

            });
        } else {
            L.e(getPackageName(), getString(R.string.epath_init_epath_fail));
            finish();
            return;
        }
        if (project != null && !TextUtils.isEmpty(project.getBuildingId()) && !TextUtils.isEmpty(project.getName())) {
            presenter.queryAndroidLSR(androidLSRDatas, project.getBuildingId(), project.getName());
        }
    }

    private void initConfigs() {
        if(TextUtils.isEmpty(configs)){
            return;
        }
        Configs configs = new Gson().fromJson(this.configs, Configs.class);
        Configs.Function function = configs.getFunction();
        if(function!=null) {
            isShowFinishDialog = function.isShowNavFinishDialg();
            isNoRealTimeShare = function.isNoRealTimeShare();
        }
//        else{
//            for (Field declaredField : configs.getClass().getDeclaredFields()) {
//                Toast.makeText(context, declaredField.getName() + "   nullllllllll", Toast.LENGTH_SHORT).show();
//            }
//        }
    }

    @Override
    public void permissionGranted() {
        super.permissionGranted();
        initSails();
        loadCloudBuilding();
        initBaiduVioce();
        presenter.queryNavPhoto(project.getBuildingId());
        carCheckDatas = new CarCheckData();

        queryCarMessage();


        L.e("lll7", carCheckDatas.getFinish() + "finish == false");
    }

    /**
     * 定位的位置是否在地图上
     * @return
     */
    private boolean isLocationFix() {
        return sails != null && sails.isLocationFix() &&
                sailsMapView.isInMap(new GeoPoint(sails.getLatitude(), sails.getLongitude()));
    }

    @Override
    protected void onResume() {
        super.onResume();
        isResume = true;
        if (this.sails != null && isLocationStart) {
            if (isStartSearchActivity) {
                isStartSearchActivity = false;
            } else {
                this.sails.startLocatingEngine();
                if (isLocationFix() && navPreBottomDialog != null && navPreBottomDialog.isShowing()) {
                    navPreBottomDialog.setBtnNavEnable(true);
                }
            }
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        isResume = false;
        if (sails != null && !isStartSearchActivity) {
            if (sails.isLocationEngineStarted()) {
                isLocationStart = true;
            } else {
                isLocationStart = false;
            }
            isFirstLocationFix = true;
            if (mHandler != null) {
                mHandler.sendEmptyMessageDelayed(MSG_STOP_ENGINE, 30000);
            }

        }
    }

    @Override
    protected void onDestroy() {
        if (progressDialogRestartBle != null && progressDialogRestartBle.isShowing()) {
            progressDialogRestartBle.dismiss();
            progressDialogRestartBle = null;
        }
        if (mHandler != null) {
            mHandler.removeCallbacksAndMessages(null);
            mHandler = null;
        }
//        KeyboardUtils.fixInputMethodManagerLeak(this);
        if (sails != null) {
            sails.stopLocatingEngine();
            sails.cancelLoadingBuilding();
            sails.setOnLocationChangeEventListener(null);
            sails.setOnFloorChangeListener(null);
            sails.setBLEScanFailCallback(null);
            sails.setMagneticCalibrationCallback(null);
            sails.setSignalStatusChangeCallback(null);
            sails = null;
        }
        if (sailsMapView != null) {
            sailsMapView.setOnMoveListener(null);
            sailsMapView.setOnFloorChangedListener(null);
            sailsMapView.setOnZoomChangedListener(null);
            sailsMapView.setOnModeChangedListener(null);
            sailsMapView.setOnRegionClickListener(null);
            sailsMapView.setOnClickNothingListener(null);
            sailsMapView.setOnMapClickListener(null);
            sailsMapView.setViewChangedCallback(null);
        }
        if (pathRoutingManager != null) {
            pathRoutingManager.setOnRoutingUpdateListener(null);
        }
        DataHolder.getInstance().clearLocationRegions();
        flMap.removeAllViews();
        getWindow().clearFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        if (progressDialog != null) {
            progressDialog.dismiss();
        }
        if (timerUpdateLocShare != null) {
            timerUpdateLocShare.cancel();
            timerUpdateLocShare = null;
        }
        if (updateLocShareTimerTask != null) {
            updateLocShareTimerTask.cancel();
            updateLocShareTimerTask = null;
        }
        if (voiceManager != null) {
            voiceManager.destroy();
            voiceManager = null;
        }
        if (shareDialog != null) {
            shareDialog.dismiss();
        }
        if (locShareNameDialog != null) {
            locShareNameDialog.dismiss();
        }
        showLocShareDialog(false);
        showMyLocDialog(false);
        showRegionSearchDialog(false);
        verifyCompassDialog.dismiss();
        scanfBluetoothDialog.dismiss();
        navFinishTopDialog.dismiss();
        navFinishBottomDialog.dismiss();
        navTopDialog.dismiss();
        ivTrumpet.setVisibility(View.GONE);
//        navBottomDialog.dismiss();
        navPreTopDialog.dismiss();
        navPreBottomDialog.dismiss();
        regionDialog.dismiss();
        MixpanelEvent.timeKeepSDKTrack();
        if (navStatus == NAV_STATUS_NAVIGATING || navStatus == NAV_STATUS_NAVIGATING_PAUSE) {
            sendNavigationEvent();
        }
        MixpanelEvent.Mixpanel().flush();
        super.onDestroy();
    }

    @Override
    public void queryNavPhotoSuccess(List<PhotoData> list) {
//        for (PhotoData photoData : list) {
//            L.e("ddd","pic "+photoData.getUrl());
//        }
        this.photoList = list;
    }

    @Override
    public void queryPOIByContentSuccess(String content, ArrayList<LocationRegionData> searchRegionDatas) {
        MixpanelEvent.search(content, searchRegionDatas.size(), MixpanelConstants.SEARCH_FROM_MAP_VOICE);
        if (searchRegionDatas.size() == 0) {
            T.showShort(getString(R.string.epath_no_search_result, content));
        }else if(searchRegionDatas.size() == 1){
            ArrayList<LocationRegion> locationRegions = new ArrayList<>();
            LocationRegionData locationRegionData = searchRegionDatas.get(0);
            locationRegions.add(new LocationRegion(locationRegionData.getName(),locationRegionData.getLongitude(),locationRegionData.getLatitude(),locationRegionData.getFloorName(),sails));
            showDefaultRegions(locationRegions);
        } else{
            Intent intent = new Intent();
            intent.putExtra(EpathMapActivity.RESULT_SEARCH_CONTENT, content);
            intent.putExtra(EpathMapActivity.RESULT_SEARCH_RESULT, searchRegionDatas);
            intent.putExtra(REQUEST_TYPE, com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET);
            onActivityResult(REQUEST_EP_SEARCH, RESULT_OK, intent);
        }
    }

    @Override
    public void queryPOIByLinkSuccess(POI poi) {
        if (poi != null) {
            targetRegionFrom = MixpanelConstants.NAVIGATION_TARGET_FROM_LINK;
            MixpanelEvent.enterSDKMode(MixpanelConstants.ENTER_SDK_MODE_NAVIGATION, poi.getName(), poi.getLink());
            progressDialog = new ProgressDialog(context, getString(R.string.epath_positioning), true);
            progressDialog.show();
            new Handler().postDelayed(() -> progressDialog.dismiss(), 10000);
            List<LocationRegion> list = new ArrayList<>();
            LocationRegion locationRegion = new LocationRegion(poi.getName(),
                    poi.getLongitude(), poi.getLatitude(), poi.getFloorName(), sails);
            list.add(locationRegion);
            initTargetLocationRegion(list, false);
            navStatus = NAV_STATUS_SHOW_PRE_INFO;
            updateNavStatus();
            showRlBottomAnimation();
        }
    }

    @Override
    public void query24hGroupSuccess(List<String> groupIds0) {
        this.groupIds = groupIds0;
        String groupId = createGroupId();
        EpathUserInfo epUser = EpathMapSDK.epUser;
        String loginUserName = "";
        if (epUser != null && epUser.getName() != null) {
            loginUserName = epUser.getName();
        }
        locShareNameDialog = new LocShareNameDialog(context, loginUserName, new LocShareNameDialog.OnLocShareNameDialogCallback() {
            @Override
            public void cancel() {
                navStatus = NAV_STATUS_DEFAULT;
                updateNavStatus();
            }

            @Override
            public void onFinish(String userName) {
                createUserInGroup(groupId, userName, true);
            }
        });
        locShareNameDialog.show();
    }

    private void createUserInGroup(String groupId, String userName, boolean isOwner) {
        ParseObject parseObject = ParseObject.createWithoutData("MappingProject", project.getObjectId());
        LocationShare locationShare = new LocationShare();
        String floor = "1";
        if (isLocationFix()) {
            ParseGeoPoint parseGeoPoint = new ParseGeoPoint(sails.getLatitude(), sails.getLongitude());
            floor = sails.getFloor();
            locationShare.put(LocationShare.LOCATION, parseGeoPoint);
        }
        locationShare.put(LocationShare.FLOOR, floor);
        locationShare.put(LocationShare.DEVICE_ID, EpUtils.getDeviceID());
        locationShare.put(LocationShare.USER_NAME, userName);
        locationShare.put(LocationShare.GROUP_ID, groupId);
        locationShare.put(LocationShare.PROJECT, parseObject);
        locationShare.put(LocationShare.OWNER, isOwner);
        locationShare.saveInBackground(e -> {
            if (e != null) {
                e.printStackTrace();
                T.showShort(e.toString());
                if (isOwner) {
                    MixpanelEvent.locShareCreate(MixpanelConstants.LOC_SHARE_CREATE_RESULT_FAIL,
                            MixpanelConstants.LOC_SHARE_CREATE_RESULT_FAIL_PAGE_NAME);
                }
                return;
            }
            if (isOwner) {
                MixpanelEvent.locShareCreate(MixpanelConstants.LOC_SHARE_CREATE_RESULT_SUCCESS, null);
                presenter.queryMyGroup(project.getObjectId(), groupId, true);
                if (EpathMapSDK.getShareToWechatListener() != null) {
                    ivShare.setVisibility(View.VISIBLE);
                }
            } else {
                presenter.queryMyGroup(project.getObjectId(), groupId, true);
            }
        });
    }

    @Override
    public void queryGroupInfoSuccess(String groupId, List<LocationShare> locationShares) {
        for (LocationShare item : locationShares) {
            if (EpUtils.getDeviceID().equals(item.getDeviceId())) {
                mLocationShare = item;
                break;
            }
        }
        if (mLocationShare != null) {
            mLocationShare.put(LocationShare.IS_QUIT, false);
            mLocationShare.saveInBackground(e -> {
                if (e != null) {
                    e.printStackTrace();
                    T.showShort(e.getMessage());
                    return;
                }
                presenter.queryMyGroup(project.getObjectId(), groupId, true);

            });
        } else {
            String loginUserName = "";
            EpathUserInfo epUser = EpathMapSDK.epUser;
            if (epUser != null && epUser.getName() != null) {
                loginUserName = epUser.getName();
            }
            locShareNameDialog = new LocShareNameDialog(context, loginUserName, new LocShareNameDialog.OnLocShareNameDialogCallback() {
                @Override
                public void cancel() {
                    navStatus = NAV_STATUS_DEFAULT;
                    updateNavStatus();
                }

                @Override
                public void onFinish(String userName) {
                    createUserInGroup(groupId, userName, false);
                }
            });
            locShareNameDialog.show();
        }

    }

    List<LocationRegionData> friendsList = new ArrayList();
    List<LocationRegionData> friendsShowList = new ArrayList<>();

    @Override
    public void queryMyGroupSuccess(String groupId, List<LocationShare> locationShares) {
        friendsList = new ArrayList<>();
        LocationRegionData mLocationRegionData = null;
        for (LocationShare item : locationShares) {
            LocationRegionData data = new LocationRegionData();
            data.setObjectId(item.getObjectId());
            data.setName(item.getUserName());
            data.setDeviceId(item.getDeviceId());
            if (item.getLocation() != null) {
                GeoPoint geoPoint = new GeoPoint(item.getLocation().getLatitude(), item.getLocation().getLongitude());
                data.setLongitude(geoPoint.longitude);
                data.setLatitude(geoPoint.latitude);
                LocationRegion lr = sails.getInBuildingName(geoPoint.longitude, geoPoint.latitude);
                if (lr != null) {
                    data.setBuildingName(lr.label);
                }
            }
            data.setFloorName(item.getFloor());
            data.setUpdatedAt(item.getUpdatedAt());
            data.setCreateAt(item.getCreatedAt());
            data.setSelected(false);
            if (item.getDeviceId().equals(EpUtils.getDeviceID())) {
                data.setMe(true);
                mLocationShare = item;
                mLocationRegionData = data;
            } else {
                if (friendRegionData != null && friendRegionData.getObjectId().equals(data.getObjectId())) {
                    friendRegionData = data;
                }
                friendsList.add(data);
            }
        }
        if (friendsList.size() > 0) {
            ivShare.setVisibility(View.GONE);
        }
        for (int i = 0; i < friendsList.size(); i++) {
            LocationRegionData lr = friendsList.get(i);
            if (lr.getLatitude() == 0 || lr.getLongitude() == 0) {
                lr.setActive(false);
                continue;
            }
            int minutes = DateUtils.minutesBetween(new Date(), lr.getUpdatedAt());
            if (minutes >= 1) {
                lr.setActive(false);
                continue;
            }
        }

        friendsShowList = new ArrayList<>();
        friendsShowList.addAll(friendsList);
        friendsShowList.add(0, mLocationRegionData);

        showLocShareMarker(friendsList, -1);
        if (locShareDialog == null) {
            sailsMapView.setMode(SAILSMapView.GENERAL);
            if (isLocationFix()) {
                sailsMapView.setMode(sailsMapView.getMode() | SAILSMapView.LOCATION_CENTER_LOCK);
            }
            locShareDialog = new LocShareDialog2(context, friendsShowList, close -> {
                onBackPressed();
            }, share -> {
                if (shareDialog != null && shareDialog.isShowing()) {
                    return;
                }
                if (mLocationShare != null && !TextUtils.isEmpty(mLocationShare.getGroupId())) {
                    String url = Constants.SHARE_URL + "?map_id=" + project.getObjectId() + "&group_id="
                            + mLocationShare.getGroupId() + "&app_name=" + Constants.getAppName(context) + "&pkg_name=" +
                            getPackageName() + "&scheme=" + EpathMapSDK.app.getScheme();
                    String title = Constants.SHARE_LOC_TITLE;
                    String description = project.getName();
                    shareDialog = new ShareDialog(context, url, title, description, null, ShareDialog.TYPE_LOC_SHARE, v0 -> {
                        showRlBottomAnimation();
                    });
                    shareDialog.show(flMap);
                    ObjectAnimator.ofFloat(rlBottom, "translationY", rlBottom.getTranslationY(), -shareDialog.getHeight())
                            .setDuration(300).start();
                }
            }, position -> {
                if (position > 0) {
                    LocationRegionData locationRegionData = friendsShowList.get(position);
                    showLocShareMarker(friendsList, position - 1);
                    String name = locationRegionData.getName();
                    if (!locationRegionData.isActive()) {
                        name += getString(R.string.epath_offline);
                    }
                    targetRegion = new LocationRegion(name,
                            locationRegionData.getLongitude(), locationRegionData.getLatitude(), locationRegionData.getFloorName(), sails);
                    pathRoutingManager.setTargetRegion(targetRegion);
                    regionDialog.setBottomVisible(false);
                    navStatus = NAV_STATUS_SHOW_REGION_INFO;
                    updateNavStatus();
                } else if (isLocationFix()) {
                    showRegionDialog(false);
                    navStatus = NAV_STATUS_DEFAULT;
                    showRlBottomAnimation();
                    sailsMapView.setMode(sailsMapView.getMode() | SAILSMapView.LOCATION_CENTER_LOCK);
                }
            });
            showLocShareDialog(true);
            isLocationSharing = true;
            if (myLocationDialog != null) {
                myLocationDialog.dismiss();
            }
            dimissFindCar();
            showRlBottomAnimation();
            startUpdateLocShareTimerTask();
        } else {
            isLocationSharing = true;
            locShareDialog.notifyDataSetChanged(friendsShowList);
        }

    }

    @Override
    public void queryAndroidLSRSuccess(ArrayList<AndroidLSRData> androidLSRDatas) {
        swipeLayout.setRefreshing(false);
        adapter.notifyDataSetChanged();
    }

    //计算导航的真实耗时
    private Timer timerNav;
    private int countTime = 0;

    @Override
    public void onRefresh() {
        swipeLayout.setRefreshing(true);
        presenter.queryAndroidLSR(androidLSRDatas, project.getBuildingId(), project.getName());
    }

    private class NavTimerTask extends TimerTask {
        @Override
        public void run() {
            countTime++;
            if (navStatus == NAV_STATUS_FINISH || navStatus == NAV_STATUS_DEFAULT) {
                timerNav.cancel();
            }
        }
    }

    private void startNavTimerTask() {
        countTime = 0;
        timerNav = new Timer();
        timerNav.schedule(new NavTimerTask(), 1000, 1000);
    }

    //暂停后延迟居中
    private Timer timerCenterLock;
    //暂停后延迟center_lock
    public static final int DELAY_ON_PAUSE_TO_CENTER = 3;
    private int countTimeCenterLock = DELAY_ON_PAUSE_TO_CENTER;

    private static class CenterLockTimerTask extends TimerTask {

        @Override
        public void run() {
            mHandler.sendEmptyMessage(MSG_CENTER_LOCK);
        }
    }

    private void startCenterLockTimerTask() {
        cancelCenterLockTimerTask();
        countTimeCenterLock = DELAY_ON_PAUSE_TO_CENTER;
        timerCenterLock = new Timer();
        timerCenterLock.schedule(new CenterLockTimerTask(), 100, 1000);
    }

    private void cancelCenterLockTimerTask() {
        if (timerCenterLock != null) {
            timerCenterLock.cancel();
        }
    }


    //模拟导航移动模拟点
    private Timer timerNavSimu;
    private static final int NAV_SIM_SPEED_DEFAULT = 100;
    private int navSimSpeed = NAV_SIM_SPEED_DEFAULT;

    private static class NavSimuTimerTask extends TimerTask {

        @Override
        public void run() {
            if (mHandler != null) {
                mHandler.sendEmptyMessage(MSG_NAV_SIMU);
            }

        }
    }

    private void startNavSimuTimerTask() {
        if (timerNavSimu != null) {
            timerNavSimu.cancel();
        }
        /**
         * 根据导航总距离调整模拟导航速度
         */
        int distance = pathRoutingManager.getPathDistance();
        if(BuildConfig.DEBUG){
            navSimSpeed = NAV_SIM_SPEED_DEFAULT / (distance/100 + 1);
        }else {
            switch (distance / 100) {
                case 0:
                    navSimSpeed = NAV_SIM_SPEED_DEFAULT;
                    break;
                case 1:
                    navSimSpeed = NAV_SIM_SPEED_DEFAULT / 2;
                    break;
                case 2:
                    navSimSpeed = NAV_SIM_SPEED_DEFAULT / 3;
                    break;
                default:
                    navSimSpeed = NAV_SIM_SPEED_DEFAULT / 4;
                    break;
            }
        }

        timerNavSimu = new Timer();
        timerNavSimu.schedule(new NavSimuTimerTask(), 100, navSimSpeed);
    }

    //定时上传位置共享
    private Timer timerUpdateLocShare;

    private static class UpdateLocShareTimerTask extends TimerTask {
        @Override
        public void run() {
            if (mHandler != null) {
                mHandler.sendEmptyMessage(MSG_UPDATE_LOCATION_SHARE);
            }

        }
    }

    private void startUpdateLocShareTimerTask() {
        timerUpdateLocShare = new Timer();
        updateLocShareTimerTask = new UpdateLocShareTimerTask();
        timerUpdateLocShare.schedule(updateLocShareTimerTask, PERIOD_UPDATE_LOCATION_SHARE, PERIOD_UPDATE_LOCATION_SHARE);
    }

    private static MyHandler mHandler;
    private static final int MSG_UPDATE_LOCATION_SHARE = 0;
    private static final int MSG_CENTER_LOCK = 1;
    private static final int MSG_NAV_SIMU = 2;
    private static final int MSG_STOP_ENGINE = 3;
    private static final int MSG_FIRST_LOCATION_FIX = 4;

    private static class MyHandler extends Handler {
        private WeakReference<Context> reference;

        public MyHandler(Context context) {
            reference = new WeakReference<>(context);
        }

        @Override
        public void handleMessage(Message msg) {
            EpathMapActivity ac = (EpathMapActivity) reference.get();
            if (ac != null) {
                switch (msg.what) {
                    case MSG_UPDATE_LOCATION_SHARE:
                        if (ac.navStatus == NAV_STATUS_DEFAULT || ac.navStatus == NAV_STATUS_SHOW_REGION_INFO ||
                                ac.navStatus == NAV_STATUS_SHOW_PRE_INFO) {
                            if (ac.isLocationSharing && ac.mLocationShare != null) {
                                ac.updateGroup();
                                ac.presenter.queryMyGroup(ac.project.getObjectId(), ac.mLocationShare.getGroupId(), false);
                            } else if (ac.timerUpdateLocShare != null) {
                                ac.timerUpdateLocShare.cancel();
                            }
                        }
                        break;
                    case MSG_CENTER_LOCK:
                        if (!ac.sailsMapView.isCenterLock() && ac.navStatus == NAV_STATUS_NAVIGATING_PAUSE) {
                            if (ac.countTimeCenterLock == 0) {
                                ac.countTimeCenterLock = DELAY_ON_PAUSE_TO_CENTER;
                                ac.navStatus = NAV_STATUS_NAVIGATING;
                                ac.updateNavStatus();
                            } else {
//                                ac.navBottomDialog.pause(ac.countTimeCenterLock + "");
                                ac.navBottomNewDialog.pause(ac.countTimeCenterLock + "");
                                ac.countTimeCenterLock--;
                            }
                        } else if (ac.timerCenterLock != null) {
                            ac.timerCenterLock.cancel();
                        }
                        break;
                    case MSG_NAV_SIMU:
                        if (ac.navStatus == NAV_STATUS_NAVIGATING) {
                            if (ac.navGeoNodes != null && ac.navGeoNodes.size() > 1 &&
                                    ac.navGeoNodes.get(0).floornumber != ac.navGeoNodes.get(1).floornumber) {
                                new Handler().postDelayed(() -> {
                                    ac.runSimulationNavigation();
                                }, 3000);
                            } else {
                                ac.runSimulationNavigation();
                            }
                        } else if (ac.navStatus != NAV_STATUS_NAVIGATING_PAUSE && ac.timerNavSimu != null) {
                            ac.timerNavSimu.cancel();
                        }
                        break;
                    case MSG_STOP_ENGINE:
                        if (ac.isResume == false && ac.sails != null) {
                            ac.sails.stopLocatingEngine();
                        }
                        break;
                    case MSG_FIRST_LOCATION_FIX:

                        break;
                }
            }
        }
    }


    /**
     * desc:宣告SAILS與 SAILSMapView物件
     */
    private void initSails() {
//        if (  progressDialogRestartBle!= null &&progressDialogRestartBle.isShowing()){
//            progressDialogRestartBle.dismiss();
//        }
        sails = new SAILS(EpathMapSDK.context);
        sails.setServerURL(Constants.CLOUD_SERVER_URL);
        LocationRegion.FONT_LANGUAGE = LocationRegion.NORMAL;
        sailsMapView = new SAILSMapView(EpathMapSDK.context);
        sailsMapView.setSAILSEngine(sails);
        sailsMapView.setOutsourcingPath(new File(Environment.getExternalStorageDirectory(), "ecsgroup").toString());
        flMap.addView(sailsMapView);
        sails.setSignalStatusChangeCallback(new SAILS.SignalStatusChangeCallback() {
            @Override
            public void onStatusChange(SAILS.SignalStatus signalStatus) {
                if ((navStatus == NAV_STATUS_NAVIGATING || navStatus == NAV_STATUS_NAVIGATING_PAUSE) && navTopDialog != null && navMode == NAV_MODE_BLE_GPS) {
                    navTopDialog.setSignal(signalStatus);
                }
                sailsSignalStatus = signalStatus;
                L.e("ddd", "---onStatusChange----");
                showSignalStrength(signalStatus);
            }
        });
//        if (!sails.hasGyro()) {
//            tvNogro.setVisibility(View.VISIBLE);
//        }
        sailsMapView.setOnZoomChangedListener(b -> {
            if (navStatus == NAV_STATUS_NAVIGATING || navStatus == NAV_STATUS_NAVIGATING_PAUSE) {
                userNavigatingZoom = getZoomLevel();
            }
            showScaleAnimation(lockmode);
        });
        sails.setBLEScanFailCallback(errorCode -> {
            if (navStatus == NAV_STATUS_DEFAULT) {
                scanfBluetoothDialog.show(flMap, navStatus);
            }
            // show dialog and show error code
        });

        sails.setOnLocationChangeEventListener(new SAILS.OnLocationChangeEventListener() {
            int count;
            LocationRegion lastLR;

            @Override
            public void OnLocationChange() {
                if (isLocationFix()) { //显示楼变化
                    LocationRegion currentLR = sails.getCurrentInBuildingName();
                    if (isFirstLocationFix && currentLR != null) {
                        //第一次定位成功播报信息
                        currentBuildingName = sails.getCurrentInBuildingName().label;
                        showFloorChangeAnimation();
                    } else if (lastLR != null && currentLR != null && !lastLR.label.equals(currentLR.label)) {
                        showFloorChangeAnimation();
                    }
                    if (currentLR != null) {
                        lastLR = currentLR;
                    }

                    if(myLocationDialog != null && myLocationDialog.isShowing()){
                        if(System.currentTimeMillis() - preHandleNearTime > HANDLE_NEAR_LIMIT){
                            preHandleNearTime = System.currentTimeMillis();
                            new Thread(){
                                @Override
                                public void run() {
                                    String regionName = getNearestLocationRegion();
                                    mHandler.post(new Runnable() {
                                        @Override
                                        public void run() {
                                            myLocationDialog.setNearRegion(regionName);
                                        }
                                    });
                                }
                            }.start();
                        }
                    }


                    scanCarCheckTime++;
                    if (scanCarCheckTime == 29) {
                        scanCarCheckTime = 0;
                        if (carCheckDatas.getFinish() == false && carCheckDatas.isHasStop() == false && navStatus == NAV_STATUS_DEFAULT && !isLocationSharing) {
                            LocationRegion inParkingArea = sails.isInParkingArea(sails.getLongitude(), sails.getLatitude(), sails.getFloor());
                            if (inParkingArea != null) {
                                ivFindOrStopCar.setImageResource(R.drawable.ic_stop_car);
                                ivRepunchClock.setVisibility(View.GONE);
                                showFindOrStopView(View.VISIBLE);
                            }

                        } else if (carCheckDatas.getFinish() == false && carCheckDatas.isHasStop() == true && navStatus == NAV_STATUS_DEFAULT && !isLocationSharing) {
                            ivFindOrStopCar.setImageResource(R.drawable.ic_findcar);
                            ivRepunchClock.setVisibility(View.VISIBLE);
                            showFindOrStopView(View.VISIBLE);
                            showCarMarker();

                        }
                    }

                }
                if (sailsMapView.isCenterLock()
                        && isLocationFix()
                        && !sails.getFloor().equals(sailsMapView.getCurrentBrowseFloorName())) {
                    sailsMapView.loadCurrentLocationFloorMap();
                    if(isPreview){
                        sailsMapView.getMapViewPosition().setZoomLevel(arNavigationZoomLevel);
                    }else {
                        sailsMapView.getMapViewPosition()
                                .setZoomLevel(Float.parseFloat(project.getNavigationZoom() + ""));
                    }
                }

                if (isLocationFix()) {
                    boolean sailsIsInThisMap = sailsMapView.isInMap(new GeoPoint(sails.getLatitude(), sails.getLongitude()));
                    if (sailsIsInThisMap != isInThisMap) {
                        isInThisMap = sailsIsInThisMap;
                        MixpanelEvent.isInThisMap(isInThisMap);
                    }
                    if (!istimeLocationFix) {
                        MixpanelEvent.timeLocationFixTrack();
                        istimeLocationFix = true;
                    }
                    //第一次定位成功
                    if (isFirstLocationFix) {
                        if (!sailsMapView.isCenterLock()) {
                            sailsMapView.setMode(SAILSMapView.LOCATION_CENTER_LOCK | SAILSMapView.FOLLOW_PHONE_HEADING);
                        }
                        sailsMapView.getMapViewPosition()
                                .setZoomLevel(Float.parseFloat(project.getNavigationZoom() + ""));

                        if (floorNumbers.size() > 1) {
                            wheelPicker.setVisibility(View.VISIBLE);
                            wheelPicker.setSelectedItemPosition(getPositionByFloorName(sails.getFloor()));
                        }
                        String loc = getString(R.string.epath_you_are_in);
                        if (currentBuildingName != null) {
                            loc += currentBuildingName;
                            loc += " ";
                        }
                        showFloorChangeAnimation();
                        if (EpathMapSDK.getShareToWechatListener() != null) {
                            loc += convertFloorName(sails.getFloorDescription(sails.getFloor()));
                            if (myLocationDialog == null && navMode != NAV_MODE_SIMULATION) {
                                myLocationDialog = new MyLocationDialog(context, findViewById(R.id.ll_my_loc), loc, sendMyLocClick -> {
                                    if (!isLocationFix()) {
                                        T.showShort(R.string.epath_not_in_this_building);
                                        return;
                                    }
                                    MixpanelEvent.locShareMyLocation();
                                    myLocationDialog.dismiss();
                                    showRlBottomAnimation();    //底部动画方法
                                    String title = getString(R.string.epath_friend_position);
                                    String description = project.getName() + "(" + convertFloorName(sails.getFloorDescription(sails.getFloor())) + ")";
                                    String url = Constants.SHARE_URL + "?map_id=" + project.getObjectId() + "&loc_name="
                                            + title + "&loc_floor=" + sails.getFloor() + "&lat=" + sails.getLatitude()
                                            + "&lng=" + sails.getLongitude() + "&app_name=" + Constants.getAppName(context) + "&pkg_name=" +
                                            getPackageName() + "&scheme=" + EpathMapSDK.app.getScheme();

                                    shareDialog = new ShareDialog(context, url, title, description, null, ShareDialog.TYPE_MY_LOCATION, v -> {
                                        navStatus = NAV_STATUS_DEFAULT;
                                        updateNavStatus();
                                    });
                                    shareDialog.show(flMap);
                                    ObjectAnimator.ofFloat(rlBottom, "translationY", rlBottom.getTranslationY(), -shareDialog.getHeight())
                                            .setDuration(300).start();
                                }, locShareClick -> {
                                    if (!isLocationFix()) {
                                        T.showShort(R.string.epath_not_in_this_building);
                                        return;
                                    }
                                    myLocationDialog.dismiss();
                                    showRlBottomAnimation();
                                    createGroup();
                                });
                                myLocationDialog.setBottomSheetSlideListener(state -> {
                                    switch (state) {
                                        case BottomSheetBehavior.STATE_COLLAPSED:
                                        case BottomSheetBehavior.STATE_EXPANDED:
                                            showRlBottomAnimation();
                                            break;
                                    }
                                });
                            }
                            if (navStatus == NAV_STATUS_DEFAULT && !isLocationSharing) {
                                showMyLocDialog(true);
                            }
                        }
//                        showFloorChangeAnimation();
                        //在navPredialog显示后定位完成&& requestType.equals(RESULT_SELECT_MY_LOCATION)
                        //startRegion == PathRoutingManager.MY_LOCATION &&
                        if (navStatus == NAV_STATUS_SHOW_PRE_INFO) {
                            String startRegion = navPreTopDialog.getStartRegion();
                            if (isLocationFix() && !TextUtils.isEmpty(startRegion) && !getString(R.string.epath_my_position).equals(startRegion)) {
                                ConfirmCenterDialog confirmCenterDialog = new ConfirmCenterDialog(context, getString(R.string.epath_confirm), getString(R.string.epath_cancel), getString(R.string.epath_set_my_position_to_start_point));
                                confirmCenterDialog.setLeftClickListener(new View.OnClickListener() {
                                    @Override
                                    public void onClick(View v) {
                                        progressDialog.dismiss();
                                        setStartLocationRegionMarker(PathRoutingManager.MY_LOCATION);
                                        showPathRoute();
                                        navPreBottomDialog.setBtnNavEnable(true);
                                        navPreTopDialog.setStartRegion(getString(R.string.epath_my_location));
                                        navPreTopDialog.setStartFloor(sails.getFloorDescription(sails.getFloor()));
                                        confirmCenterDialog.dismiss();
                                    }
                                });
                                confirmCenterDialog.setRightClickListener(new View.OnClickListener() {
                                    @Override
                                    public void onClick(View v) {
                                        confirmCenterDialog.dismiss();
                                    }
                                });
                                confirmCenterDialog.show();

                            } else if (TextUtils.isEmpty(startRegion)) {
                                setStartLocationRegionMarker(PathRoutingManager.MY_LOCATION);
                                showPathRoute();
                                navPreBottomDialog.setBtnNavEnable(true);
                                navPreTopDialog.setStartRegion(getString(R.string.epath_my_location));
                                navPreTopDialog.setStartFloor(sails.getFloorDescription(sails.getFloor()));
                            } else {
                                navPreBottomDialog.setBtnNavEnable(false);
                                navPreTopDialog.setStartRegion(startRegion);
                            }
                        }
                        if (navMode != NAV_MODE_SIMULATION && !sails.getFloor().equals(sailsMapView.getCurrentBrowseFloorName())
                                && requestType == RESULT_SELECT_MY_LOCATION) {
                            navMode = NAV_MODE_BLE_GPS;
                            if (project != null && project.isWiFi()) {
                                navMode = NAV_MODE_WIFI_GPS;
                            }
                            updateNavMode();
                        }
                        llSignalStrength.setVisibility(View.GONE);
                        isFirstLocationFix = false;
                    }

//                } else if (!isLocationFix() && isFirstLocationFix && rlSignalStrength.getVisibility() == View.GONE) {
                } else if (!isLocationFix() && isFirstLocationFix && tvSignalStrength.getVisibility() == View.GONE) {

//                    mHandler.sendEmptyMessageDelayed(MSG_STOP_ENGINE, 30000);
                    if (llSignalStrength.getVisibility() == View.GONE && mHandler != null) {
                        llSignalStrength.setVisibility(View.VISIBLE);
                        mHandler.postDelayed(() -> {
                            llSignalStrength.setVisibility(View.GONE);
                            //经过20s 定位定位失败
                            isFirstLocationFix = false;
                            showSignalStrength(sailsSignalStatus);
//                              T.showLong("定位失败,请稍后重试!");
                        }, 10000);
                    }
                }



            }
        });


        sails.setOnFloorChangeListener(s -> {
            L.e("change", "sails.setOnFloorChangeListener");
            runOnUiThread(() -> {
                if (myLocationDialog != null) {
                    String loc = getString(R.string.epath_you_are_in);
                    if (currentBuildingName != null) {
                        loc += currentBuildingName;
                        loc+=" ";
                    }
                    loc += convertFloorName(sails.getFloorDescription(sails.getFloor()));
                    myLocationDialog.setLoc(loc);
                    showMyLocationChangeAnimation();
                }
                if (navStatus == NAV_STATUS_DEFAULT || navStatus == NAV_STATUS_SHOW_REGION_INFO) {
                    showCarMarker();
                }
                if (navStatus == NAV_STATUS_NAVIGATING || navStatus == NAV_STATUS_NAVIGATING_PAUSE) {
                    navTopDialog.setElevatorVisible(false);
                    if (navMode != NAV_MODE_SIMULATION) {
                        if (pathRoutingManager != null) {
                            pathRoutingManager.enableHandler();
                        }
                        if(isPreview){
                            sailsMapView.setAnimationToZoom(arNavigationZoomLevel);
                        }else {
                            sailsMapView.setAnimationToZoom(Float.parseFloat(project.getNavigationZoom() + ""));
                        }
                    }
                }
                //防止第一次设置的时候对显示楼层
                if (sailsMapView.isCenterLock() && !isFirstLocationFix) {
                    //
                    wheelPicker.setSelectedItemPosition(getPositionByFloorName(sails.getFloor()));
                    showFloorChangeAnimation();
                }
            });

        });
        sailsMapView.setOnMapClickListener(new SAILSMapView.OnMapClickListener() {
            @Override
            public boolean onClick(int i, int i1) {
                int x = i - sailsMapView.getWidth() / 2;
                int y = i1 - sailsMapView.getHeight() / 2;
                String floor = sailsMapView.getCurrentBrowseFloorName();
                if (virtualMarker != null) {
                    boolean inMarker = virtualMarker.isInMarker(x, y);
                    if (inMarker) {
                        onClickChangeMode();
                        return true;
                    }
                }
                if (currentFloorFirstData != null
                        && switchMarkerFirstList != null
                        && currentFloorFirstData.size() == switchMarkerFirstList.size()) {
                    for (int i2 = 0; i2 < currentFloorFirstData.size(); i2++) {
                        NavigationData navigationData = currentFloorFirstData.get(i2);
                        if (navigationData != null && navigationData.getPreFloor() != null) {
                            boolean inMarker = switchMarkerFirstList.get(i2).isInMarker(x, y);
                            if (inMarker) {
                                L.e("ddd", "marker First");
                                wheelPicker.setSelectedItemPosition(getPositionByFloorName(navigationData.getPreFloor()));
                                sailsMapView.loadFloorMap(navigationData.getPreFloor());
                                new Handler().postDelayed(() -> {
                                    sailsMapView.setMode(SAILSMapView.GENERAL);
                                    int width = DensityUtils.getScreenWidth(context) - DensityUtils.dp2px(context, 160);
                                    sailsMapView.autoSetMapZoomAndView(pathRoutingManager.getCurrentFloorRoutingPathNodes(), width);
                                    sailsMapView.setRotationAngle((float) project.getAngle());
                                }, 500);
                                return true;
                            }
                        }
                    }
                }


//                sailsMapView.setOnRegionClickListener();
                if (currentFloorLastData != null && switchMarkerLastList != null && currentFloorLastData.size() == switchMarkerLastList.size()) {
                    //switchMarkerFirstList
                    for (int i2 = 0; i2 < currentFloorLastData.size(); i2++) {
                        NavigationData navigationData = currentFloorLastData.get(i2);
                        if (navigationData != null && navigationData.getToFloor() != null) {
                            boolean inMarker = switchMarkerLastList.get(i2).isInMarker(x, y);
                            if (inMarker) {
                                L.e("ddd", "marker last");
                                wheelPicker.setSelectedItemPosition(getPositionByFloorName(navigationData.getToFloor()));
                                sailsMapView.loadFloorMap(navigationData.getToFloor());
                                new Handler().postDelayed(() -> {
                                    sailsMapView.setMode(SAILSMapView.GENERAL);
                                    int width = DensityUtils.getScreenWidth(context) - DensityUtils.dp2px(context, 160);
                                    sailsMapView.autoSetMapZoomAndView(pathRoutingManager.getCurrentFloorRoutingPathNodes(), width);
                                    sailsMapView.setRotationAngle((float) project.getAngle());
                                }, 500);
                                return true;
                            }
                        }
                    }
                }


                return false;

            }
        });
        sailsMapView.setLocationMarker(R.drawable.loc_point_arrow, R.drawable.loc_point_arrow, null, 75);
        sailsMapView.setOnModeChangedListener(lockmode -> {
            this.lockmode = lockmode;
            showScaleAnimation(lockmode);
            if (((lockmode & SAILSMapView.LOCATION_CENTER_LOCK) == SAILSMapView.LOCATION_CENTER_LOCK) &&
                    ((lockmode & SAILSMapView.FOLLOW_PHONE_HEADING) == SAILSMapView.FOLLOW_PHONE_HEADING)) {
                if (navStatus != NAV_STATUS_NAVIGATING && navStatus != NAV_STATUS_NAVIGATING_PAUSE) {
                    sailsMapView.setLocationMarker(R.drawable.loc_point_sector, R.drawable.loc_point_sector, null, 75);
                }
                ivLockCenter.setImageResource(R.drawable.loc_lock_center3);

                if (isLocationFix() && floorNumbers.size() > 1) {
                    wheelPicker.setSelectedItemPosition(getPositionByFloorName(sails.getFloor()));
                }
                if (navStatus == NAV_STATUS_NAVIGATING_PAUSE) {
                    cancelCenterLockTimerTask();
                    navStatus = NAV_STATUS_NAVIGATING;
                    updateNavStatus();
                }

            } else if ((lockmode & SAILSMapView.LOCATION_CENTER_LOCK) == SAILSMapView.LOCATION_CENTER_LOCK) {
                if (navStatus != NAV_STATUS_NAVIGATING && navStatus != NAV_STATUS_NAVIGATING_PAUSE) {
                    sailsMapView.setLocationMarker(R.drawable.loc_point_arrow, R.drawable.loc_point_arrow, null, 75);
                }
                ivLockCenter.setImageResource(R.drawable.loc_lock_center2);
                if (sails != null && isLocationFix() && floorNumbers.size() > 1) {
                    if (floorNumbers != null && wheelPicker != null) {
                        wheelPicker.setSelectedItemPosition(getPositionByFloorName(sails.getFloor()));
                    }
                }
                if (navStatus == NAV_STATUS_NAVIGATING_PAUSE) {
                    cancelCenterLockTimerTask();
                    navStatus = NAV_STATUS_NAVIGATING;
                    updateNavStatus();
                }
            } else {
                if (isLocationFix() && sails.getFloor().equals(currentViewFloor)) {
                    if (navStatus != NAV_STATUS_NAVIGATING && navStatus != NAV_STATUS_NAVIGATING_PAUSE) {
                        sailsMapView.setLocationMarker(R.drawable.loc_point_arrow, R.drawable.loc_point_arrow, null, 75);
                    }
                }
                ivLockCenter.setImageResource(R.drawable.loc_lock_center1);
                if (navStatus == NAV_STATUS_NAVIGATING) {
                    navStatus = NAV_STATUS_NAVIGATING_PAUSE;
//                    navBottomDialog.pause();
                    navBottomNewDialog.pause();
                }
            }
        });

//        sails.setOnFloorChangeListener();

        sailsMapView.setOnFloorChangedListener(new SAILSMapView.OnFloorChangedListener() {
            @Override
            public void onFloorChangedBefore(String s) {
                L.e("change", "s =" + s);
            }

            @Override
            public void onFloorChangedAfter(String s) {
                wheelPicker.setSelectedItemPosition(getPositionByFloorName(s));
                L.e("change", "sails.onFloorChangedAfter");
                currentViewFloor = s;
                showMyLocationChangeAnimation();
                if (navStatus == NAV_STATUS_DEFAULT || navStatus == NAV_STATUS_SHOW_REGION_INFO) {
                    showCarMarker();
                }
                if (navStatus == NAV_STATUS_SHOW_PRE_INFO || navStatus == NAV_STATUS_NAVIGATING ||
                        navStatus == NAV_STATUS_NAVIGATING_PAUSE) {
                    if (startRegion == null || targetRegion == null) {
                        return;
                    }
                    new Handler().postDelayed(() -> showMarkerAfterPathRoute(), 500);
                }
            }
        });
        sailsMapView.setViewChangedCallback(() -> {
            float angle = sailsMapView.getRotationAngle();
            ivCompass.setRotation(angle);
            if(isPreview) {
                ivRealViewNorth.setNorthAngle(angle);
            }

        });
        sailsMapView.setOnClickNothingListener(() -> {
            clickRegionEvent(MixpanelConstants.REGION_NAME_NOTHING);
            if (shareDialog != null && shareDialog.isShowing()) {
                shareDialog.dismiss();
                return;
            }

            /**
             * 注释以下三句是为了解决查看区域不能滑动问题
             */
//            if (navStatus == NAV_STATUS_SHOW_REGION_INFO) {
//                onBackPressed();
//            }
        });
        sailsMapView.setOnRegionClickListener(locationRegions -> {
//            scanfBluetoothDialog.show(flMap, navStatus);

            if (flagIsFindCaring) {
                T.showShort(R.string.epath_find_car_mode_click_prompt);
                return;
            }
            LocationRegion locationRegion = locationRegions.get(0);
            double centerLatitude = locationRegion.getCenterLatitude();
            double centerLongitude = locationRegion.getCenterLongitude();
            if (switchMarkerLast != null && switchMarkerFirst != null) {
                GeoPoint geoPoint = switchMarkerLast.getGeoPoint();
                GeoPoint geoPoint2 = switchMarkerFirst.getGeoPoint();
                if (geoPoint.latitude == centerLatitude && geoPoint.latitude == centerLongitude) {
                    return;
                }
                if (geoPoint2.latitude == centerLatitude && geoPoint2.latitude == centerLongitude) {
                    return;
                }
            }

            if (locationRegions != null && locationRegions.size() > 0) {
                if (!isLocationSharing && (navStatus == NAV_STATUS_DEFAULT ||
                        navStatus == NAV_STATUS_SHOW_REGION_INFO)) {
                    showDefaultRegions(locationRegions);

                } else if (!isLocationSharing && (navStatus == NAV_STATUS_SHOW_PRE_INFO)) {
                    if (locationRegions.get(0) == targetRegion || startRegion != null && locationRegions.get(0) == startRegion) {
                        return;
                    }
                    String content = "";
                    if (locationRegion != null && !TextUtils.isEmpty(locationRegion.getName())) {
                        content = locationRegion.getName();
                    } else {
                        content = getString(R.string.epath_this_position);
                    }
                    ConfirmCenterDialog confrimCenterDialog = new ConfirmCenterDialog(context, null, null, getString(R.string.epath_should_set_ponit_to,content));
                    confrimCenterDialog.setLeftClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            swtichFloorNumberOverlayItems.clear();
                            overlayItems.clear();
                            setStartLocationRegionMarker(locationRegions.get(0));
                            showPathRoute();
                            navPreTopDialog.setStartFloor(getRegionFloorDescription(startRegion));
                            if (startRegion.getName().equals(getString(R.string.epath_my_position))) {
                                navPreBottomDialog.setBtnNavEnable(true);
                            } else {
                                navPreBottomDialog.setBtnNavEnable(false);
                            }
                            navPreTopDialog.setStartRegion(startRegion.getName());
                            confrimCenterDialog.dismiss();
                        }
                    });
                    confrimCenterDialog.setRightClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            swtichFloorNumberOverlayItems.clear();
                            overlayItems.clear();
                            markerManager.clear();
                            initTargetLocationRegion(locationRegions, false);
//                                setTargetLocationRegionMarker(targetRegion);
                            if (targetRegion != null && startRegion != null) {
                                showPathRoute();
                                wheelPicker.setSelectedItemPosition(getPositionByFloorName(getRegionFloorName(startRegion)));
                            } else {
                                String regionFloorName = getRegionFloorName(targetRegion);
                                int positionByFloorName = getPositionByFloorName(regionFloorName);
                                wheelPicker.setSelectedItemPosition(positionByFloorName);
                            }
                            navPreTopDialog.setTargetRegion(targetRegion);
                            confrimCenterDialog.dismiss();
                        }
                    });
                    confrimCenterDialog.show();
                } else if (isLocationSharing) {
                    if (shareDialog != null) {
                        shareDialog.dismiss();
                    }

                    /**
                     * 注释以下五句是为了解决查看区域不能滑动问题
                     */
//                    if (navStatus == NAV_STATUS_SHOW_REGION_INFO) {
//                        navStatus = NAV_STATUS_DEFAULT;
//                        showRegionDialog(false);
//                        showRlBottomAnimation();
//                    } else

                        if (navStatus == NAV_STATUS_DEFAULT) {
                        new ConfirmDialog(context, getString(R.string.epath_confirm_region_unclick), new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                            }
                        });
                    }
                }
                if (targetRegion != null) {
                    clickRegionEvent(targetRegion.getName());
                }

            }

        });
        flMap.post(() -> {
            sails.setMagneticCalibrationCallback(new SAILS.NeedMagneticCalibrationCallback() {
                @Override
                public void onNeedCalibration(int i) {
                    //一旦指南针精度不高,马上回到初始状态,但是在导航过程中也会退出导航的 延迟以显示在最上层
                    if (navStatus == NAV_STATUS_DEFAULT) {
                        new Handler().postDelayed(() -> verifyCompassDialog.show(flMap, navStatus), 500);
                    }

                }

                @Override
                public void onFinishCalibration() {
                    verifyCompassDialog.dismiss();
                }

                @Override
                public void onCalibrationTiltAngleUpdated(float v, float v1, List<Integer> list, int i) {
                    if (navStatus == NAV_STATUS_DEFAULT) {
                        verifyCompassDialog.setParam(v, v1, list);
                    }
                }
            });
        });
        sailsMapView.setOnMoveListener((i, i1) -> {
//            L.d("ddd", sailsMapView.getMapViewPosition().getCenter().latitude +
//            "," + sailsMapView.getMapViewPosition().getCenter().longitude);
//            L.d("ddd", "angle:" + sailsMapView.getRotationAngle());
            showScaleAnimation(lockmode);
            if (navStatus == NAV_STATUS_NAVIGATING_PAUSE) {
                startCenterLockTimerTask();
            }
        });
    }

    private void showDefaultRegions(List<LocationRegion> locationRegions) {
        sailsMapView.setMode(SAILSMapView.GENERAL);
        targetRegionFrom = MixpanelConstants.NAVIGATION_TARGET_FROM_REGION_CLICK;
        initTargetLocationRegion(locationRegions, false);
        navStatus = NAV_STATUS_SHOW_REGION_INFO;
        updateNavStatus();
    }

    private void showSignalStrength(SAILS.SignalStatus signalStatus) {
        if (isShowSignalStrength) {
            if (signalStatus == SAILS.SignalStatus.STRONG_BEACON_SIGNAL) {
//                rlSignalStrength.setVisibility(View.GONE);
                tvSignalStrength.setVisibility(View.GONE);
                tvSignalStrength.setText(getString(R.string.epath_signal_weakness_hint));
            } else if (signalStatus == SAILS.SignalStatus.WEAK_BEACON_SIGNAL && llSignalStrength.getVisibility() == View.GONE) {
//                rlSignalStrength.setVisibility(View.VISIBLE);
                tvSignalStrength.setVisibility(View.VISIBLE);
                tvSignalStrength.setText(getString(R.string.epath_signal_weakness_hint));
            } else if (signalStatus == SAILS.SignalStatus.NO_BEACON_GPS_IN_MAP && llSignalStrength.getVisibility() == View.GONE) {
//                rlSignalStrength.setVisibility(View.VISIBLE);
                tvSignalStrength.setVisibility(View.VISIBLE);
                tvSignalStrength.setText(getString(R.string.epath_signal_weakness_hint));
            } else if (signalStatus == SAILS.SignalStatus.NO_BEACON_GPS_OUT_MAP && llSignalStrength.getVisibility() == View.GONE) {
//                rlSignalStrength.setVisibility(View.VISIBLE);
                tvSignalStrength.setVisibility(View.VISIBLE);
                tvSignalStrength.setText(getString(R.string.epath_no_signal_hint));
            } else if (signalStatus == SAILS.SignalStatus.STATUS_UNAVAILABLE && llSignalStrength.getVisibility() == View.GONE) {
//                rlSignalStrength.setVisibility(View.VISIBLE);
                tvSignalStrength.setVisibility(View.VISIBLE);
                tvSignalStrength.setText(getString(R.string.epath_no_signal_hint));
            }
        }
    }

    private void showCarMarker() {
        String floor = carCheckDatas.getFloor();
        myCarLocationOverlayItems.clear();
        if (sailsMapView.getDynamicOverlays().contains(myCarLocationOverlay)) {
            sailsMapView.getDynamicOverlays().remove(myCarLocationOverlay);
        }

        if (!isLocationSharing && currentViewFloor != null && currentViewFloor.equals(floor) && carCheckDatas.getLongitude() != 0 && carCheckDatas.getLatitude() != 0) {
            Drawable drawable = getResources().getDrawable(R.drawable.ico_car);
            Bitmap bitmap = BitmapUtils.drawableToBitmap(drawable, context);
//            bitmap = BitmapUtils.setScale(bitmap, 1.2f);
            Marker myCarMarker = new Marker(new GeoPoint(carCheckDatas.getLatitude(), carCheckDatas.getLongitude()),
                    Marker.boundCenterBottom(drawable));
            myCarLocationOverlayItems.add(myCarMarker);
            sailsMapView.getDynamicOverlays().add(myCarLocationOverlay);
        }
    }

    private void clickRegionEvent(String name) {
        String status;
        switch (navStatus) {
            case NAV_STATUS_SHOW_REGION_INFO:
                status = MixpanelConstants.REGION_PAGE_STATUS_SHOW_REGION;
                break;
            case NAV_STATUS_SHOW_PRE_INFO:
                status = MixpanelConstants.REGION_PAGE_STATUS_PRE_NAV;
                break;
            case NAV_STATUS_NAVIGATING:
                status = MixpanelConstants.REGION_PAGE_STATUS_NAVIGATING;
                break;
            case NAV_STATUS_NAVIGATING_PAUSE:
                status = MixpanelConstants.REGION_PAGE_STATUS_NAVIGATING_PAUSE;
                break;
            case NAV_STATUS_SHOW_SEARCH_RESULT:
                status = MixpanelConstants.REGION_PAGE_STATUS_SHOW_SEARCH;
                break;
            case NAV_STATUS_DEFAULT:
            default:
                status = MixpanelConstants.REGION_PAGE_STATUS_DEFAULT;
                break;

        }
        if (isLocationSharing) {
            status = MixpanelConstants.REGION_PAGE_STATUS_LOCATION_SHARE;
        }
        MixpanelEvent.clickRegion(name, status);
    }

    private void showMarkerAfterPathRoute() {
        overlayItems.clear();
        if (getRegionFloorName(startRegion) != null && getRegionFloorName(startRegion).equals(sailsMapView.getCurrentBrowseFloorName())) {
            GeoPoint startPoint = new GeoPoint(startRegion.getCenterLatitude(), startRegion.getCenterLongitude());
            Marker startMarker = new Marker(startPoint, Marker.boundCenterBottom(getResources().getDrawable(R.drawable.loc_point_start)));
            overlayItems.add(startMarker);
        }
        if (targetRegion != null && targetRegion.getFloorName().equals(sailsMapView.getCurrentBrowseFloorName()) && !flagIsFindCaring) {
            GeoPoint targetPoint = new GeoPoint(targetRegion.getCenterLatitude(), targetRegion.getCenterLongitude());
            Marker targetMarker = new Marker(targetPoint, Marker.boundCenterBottom(getResources().getDrawable(R.drawable.loc_point_target)));
            overlayItems.add(targetMarker);
        }
        swtichFloorNumberOverlayItems.clear();
        if (sailsMapView.getDynamicOverlays().contains(swtichFloorNumberOverlay)) {
            sailsMapView.getDynamicOverlays().remove(swtichFloorNumberOverlay);
        }

        loadSwitchMarker();
        if (sailsMapView.getDynamicOverlays().contains(listOverlay)) {
            sailsMapView.getDynamicOverlays().remove(listOverlay);
        }
        sailsMapView.getDynamicOverlays().add(listOverlay);
    }


    /**
     * desc:從SAILS Cloud 載入室內定位專案
     */
    private void loadCloudBuilding() {
        if (!sails.hasCached(project.getBuildingId())) {
            MixpanelEvent.timeLoadMap();
            progressDialog = new ProgressDialog(context, getString(R.string.epath_loadCloudBuilding), 100);
            progressDialog.show();
        } else {
            progressDialog = new ProgressDialog(context, getString(R.string.epath_loadCloudBuilding), false);
            progressDialog.show();
        }


        L.e("ddddd", "getBuildingId" + project.getBuildingId());
        sails.loadCloudBuilding(project.getToken(), project.getBuildingId(), new SAILS.OnLoadStatusCallback() {
            boolean hasCached = false;

            @Override
            public void onCacheLoaded() {
                hasCached = true;
                sails.setGPSFloorLayer(project.getGpsFloorlayer() + "");
                runOnUiThread(() -> {
                    progressDialog.dismiss();
                    mapViewInitial();
                    engineLocationProcedure();
                });

            }

            @Override
            public void onNetworkLoadingProgress(boolean loadSuccess, int i) {
                if (!hasCached) {
                    progressDialog.setProgress(i);
                } else if (hasCached && getIntent().getStringExtra(REQUEST_TARGET_ID) == null && getIntent().getStringExtra(REQUEST_TARGET_NAME) == null) {
                    runOnUiThread(() -> {
                        progressBar.setVisibility(View.VISIBLE);
                        progressBar.setProgress(i);
                    });
                }
                if (loadSuccess && hasCached && getIntent().getStringExtra(REQUEST_TARGET_ID) == null && getIntent().getStringExtra(REQUEST_TARGET_NAME) == null) {//未传target_id更新地图
                    runOnUiThread(() -> {
                        progressBar.setVisibility(View.GONE);
                        progressBar.setProgress(0);
//                        engineLocationProcedure();
                    });
//                    runOnUiThread(() -> {
//                        saveCurrentStatus();
//                        progressBar.setVisibility(View.GONE);
//                        progressBar.setProgress(0);
//                        progressDialog = new ProgressDialog(context, getString(R.string.epath_refreshCloudBuilding), false);
//                        progressDialog.show();
//                        engineLocationProcedure();
//                    });
////                    599b9f7c19fa91598eac3041
//                    sails.refreshCloudBuilding(project.getBuildingId(), new SAILS.OnFinishCallback() {
//                        @Override
//                        public void onSuccess(String s) {
//                            runOnUiThread(() -> {
//                                mapViewInitial();
//                                engineLocationProcedure();
//                                reloadStatus();
//                                progressDialog.dismiss();
//                            });
//
//                        }
//
//                        @Override
//                        public void onFailed(String s) {
//                            runOnUiThread(() -> {
//                                T.showShort(s);
//                                progressDialog.dismiss();
//                            });
//                        }
//                    });
                } else if (loadSuccess && !hasCached) {
                    MixpanelEvent.timeLoadMapTrack(true);
                    sails.setGPSFloorLayer(project.getGpsFloorlayer() + "");
                    progressDialog.dismiss();
                    runOnUiThread(() -> {
                        mapViewInitial();
                        engineLocationProcedure();
                    });
                }
            }

            @Override
            public void onNetworkLoadingFailed(String s) {
//                T.showShort("load map fail");
                L.e("sails", "load map fail");
                MixpanelEvent.timeLoadMapTrack(false);
                runOnUiThread(() -> {
                    T.showShort(s);
                    progressDialog.dismiss();
                });
            }
        });

    }

    private void reloadStatus() {
        navStatus = NAV_STATUS_DEFAULT;
        updateNavStatus();
    }

    private void saveCurrentStatus() {
        // TODO: 2017/5/25 保存状态

    }

    private void mapViewInitial() {
        if (!sails.getFloorNameList().isEmpty()) {
            if (project.getFloorName() != null) {
                sailsMapView.loadFloorMap(project.getFloorName());
            }
            /**
             * 移动地图Y轴距离
             */
            sailsMapView.setNavigationModeYOffsetHeightRatio(0.14);
            sailsMapView.getMapViewPosition().setZoomLevel(Float.parseFloat(project.getZoom() + ""));
            sailsMapView.setAnimatingToRotationAngle((float) project.getAngle());
            userNavigatingZoom = project.getNavigationZoom();
            moveMaptoCenter();
            initWheelView();
            initRoutingManger();
            //预设目的地
            String targetId = getIntent().getStringExtra(REQUEST_TARGET_ID);
            String targetName = getIntent().getStringExtra(REQUEST_TARGET_NAME);
            if (!TextUtils.isEmpty(targetId)) {
                presenter.queryPOIByLink(project.getObjectId(), targetId,
                        new ProgressDialog(context, getString(R.string.epath_searching), true));
            } else if(!TextUtils.isEmpty(targetName)){
                presenter.queryPOIByContent(project.getObjectId(),targetName);
            }else {
                MixpanelEvent.enterSDKMode(MixpanelConstants.ENTER_SDK_MODE_HOME,
                        null, null);
            }
            //邀请加入位置共享
            String mapId = getIntent().getStringExtra(REQUEST_ID);
            String groupId = getIntent().getStringExtra(REQUEST_SHARE_LOC_GROUP_ID);
            String name = getIntent().getStringExtra(REQUEST_SHARE_LOC_NAME);
            String floor = getIntent().getStringExtra(REQUEST_SHARE_LOC_FLOOR);
            String lat = getIntent().getStringExtra(REQUEST_SHARE_LOC_LAT);
            String lng = getIntent().getStringExtra(REQUEST_SHARE_LOC_LNG);
            if (!TextUtils.isEmpty(mapId) && !TextUtils.isEmpty(groupId)) {
                new ConfirmDialog(context, getString(R.string.epath_join_position_share_group), (dialog, which) -> {
                    presenter.queryGroupInfo(project.getObjectId(), groupId);
                    if (myLocationDialog != null) {
                        myLocationDialog.dismiss();
                    }
                    showRlBottomAnimation();
                }, (dialog, which) -> {
                });
            } else if (!TextUtils.isEmpty(mapId) && !TextUtils.isEmpty(name) && !TextUtils.isEmpty(floor) &&
                    !TextUtils.isEmpty(lat) && !TextUtils.isEmpty(lng)) {
                LocationRegionData lr = new LocationRegionData(name, floor, Double.parseDouble(lng), Double.parseDouble(lat));
                showSearchResult(lr, REQUEST_TYPE_TARGET, true);
                regionDialog.setBottomVisible(false);
            }
        }
    }

    private void initWheelView() {
        List<String> descList = sails.getFloorDescList();
        List<String> nameList = sails.getFloorNameList();
        Collections.reverse(descList);
        Collections.reverse(nameList);
        if (descList.size() > 1 && nameList.size() > 1) {
            for (int i = 0; i < descList.size() && i < nameList.size(); i++) {
                Floor floor = new Floor();
                floor.setName(nameList.get(i));
                floor.setDescription(descList.get(i));
                floorNumbers.put(i, floor);
            }
            if(floorNumbers.size() > 1) {
                wheelPicker.setVisibility(View.VISIBLE);
            }
            wheelPicker.setData(descList);
            wheelPicker.setSelectedItemPosition(getPositionByFloorName(project.getFloorName()));
            wheelPicker.setOnItemSelectedListener((picker, data, position) -> {
                //路径规划状态下显示路径
                String floorName = floorNumbers.get(position).getName();
                if (navStatus == NAV_STATUS_SHOW_PRE_INFO && pathRoutingManager.isRoutingSuccess()) {
                    List<SAILS.GeoNode> geoNodes = pathRoutingManager.getCurrentAllPathNodes();
                    boolean isCurrentFloorHasRoutePath = false;
                    for (int i = 0; geoNodes != null && i < geoNodes.size(); i++) {
                        SAILS.GeoNode geoNode = geoNodes.get(i);
                        if (geoNode.floornumber == Integer.valueOf(floorName)) {
                            isCurrentFloorHasRoutePath = true;
                            break;
                        }
                    }
                    if (isCurrentFloorHasRoutePath) {
                        sailsMapView.loadFloorMap(floorName);
                        new Handler().postDelayed(() -> {
                            sailsMapView.setMode(SAILSMapView.GENERAL);
                            int width = DensityUtils.getScreenWidth(context) - DensityUtils.dp2px(context, 160);
                            sailsMapView.autoSetMapZoomAndView(pathRoutingManager.getCurrentFloorRoutingPathNodes(), width);
                            sailsMapView.setRotationAngle((float) project.getAngle());

                        }, 500);
                    } else {
                        showMapCenter(floorName);
                    }

                } else if (navStatus == NAV_STATUS_SHOW_SEARCH_RESULT) {
                    showSearchResultByFloor(data.toString());
                }
                //非路径规划状态下显示点为中心 || !isCurrentFloorHasRoutePath
                else {
                    showMapCenter(floorName);
                }
            });
        }

    }

    private void showMapCenter(String floorName) {
        GeoPoint geoPoint = sailsMapView.getMapViewPosition().getCenter();
        double zoomLevel = getZoomLevel();
        float angle = sailsMapView.getRotationAngle();
        if (geoPoint != null && geoPoint.latitude != 0 && geoPoint.longitude != 0) {
            sailsMapView.loadFloorMap(floorName);
            sailsMapView.getMapViewPosition().setZoomLevel((float) zoomLevel);
            sailsMapView.setRotationAngle(angle);
            sailsMapView.getMapViewPosition().setCenter(geoPoint);

        } else {
            sailsMapView.loadFloorMap(floorName);
            sailsMapView.getMapViewPosition().setZoomLevel(Float.parseFloat(project.getNavigationZoom() + ""));
            sailsMapView.setAnimatingToRotationAngle((float) project.getAngle());
            moveMaptoCenter();
        }
    }

    private void showFloorChangeAnimation() {
        llEyeLocationAll.setVisibility(View.GONE);
        llFloor.setVisibility(View.VISIBLE);
        tvFloor.setVisibility(View.VISIBLE);
        tvFloor.setText(convertFloorName(sails.getFloorDescription(sails.getFloor())));


        if (sails.getCurrentInBuildingName() != null && sails.getCurrentInBuildingName().label != null) {
            if (!TextUtils.isEmpty(currentBuildingName) && !currentBuildingName.equals(sails.getCurrentInBuildingName().label)) {
                if (voiceManager != null) {
                    String currentBuilding = sails.getCurrentInBuildingName().label;
                    if (lastBuilding == null || !lastBuilding.equals(currentBuilding)) {
                        lastBuilding = currentBuilding;
                        voiceManager.textToVoice(getString(R.string.epath_arrive) + currentBuilding, true);
                    }
                }
            } else if (!TextUtils.isEmpty(currentBuildingName) && isFirstLocationFix && currentBuildingName.equals(sails.getCurrentInBuildingName().label)) {
                //第一次定位成功后
                if (voiceManager != null) {
                    String currentBuilding = sails.getCurrentInBuildingName().label;
                    if (lastBuilding == null || !lastBuilding.equals(currentBuilding)) {
                        lastBuilding = currentBuilding;
                        voiceManager.textToVoice(getString(R.string.epath_arrive) + currentBuilding, true);
                    }
                }
            }

//            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(
//                    ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
//            params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
//            params.addRule(RelativeLayout.CENTER_HORIZONTAL);
//            tvFloor.setLayoutParams(params);

            tvBuilding.setVisibility(View.VISIBLE);
            tvBuilding.setText(sails.getCurrentInBuildingName().label);
            currentBuildingName = sails.getCurrentInBuildingName().label;

        }
        ObjectAnimator.ofFloat(llFloor, "alpha", 1f, 0f)
                .setDuration(4000)
                .start();
    }

    private void showMyLocationChangeAnimation() {
        llFloor.setVisibility(View.VISIBLE);
        llEyeLocationAll.setVisibility(View.VISIBLE);
        tvBuilding.setVisibility(View.GONE);
        tvFloor.setVisibility(View.GONE);
        myLocationOverlayItems.clear();
        if (sailsMapView.getDynamicOverlays().contains(myLocationOverlay)) {
            sailsMapView.getDynamicOverlays().remove(myLocationOverlay);
        }
        //自定义车的图标
//        myCarLocationOverlayItems.clear();
//        if (sailsMapView.getDynamicOverlays().contains(myCarLocationOverlay)) {
//            sailsMapView.getDynamicOverlays().remove(myCarLocationOverlay);
//        }

//        if (TextUtils.isEmpty(carCheckDatas.getRegionName())) {
//            CarCheckData carCheckData = carCheckDatas;
//            String floor = carCheckData.getFloor();
//
//
//            if (floor != null && currentViewFloor.equals(floor) && carCheckData.getLatitude() != 0 && carCheckData.getLongitude() != 0) {
//                Drawable drawable = getResources().getDrawable(R.drawable.ico_car);
//                Bitmap bitmap = BitmapUtils.drawableToBitmap(drawable, context);
////                bitmap = BitmapUtils.setScale(bitmap, 1.2f);
//                Marker myCarMarker = new Marker(new GeoPoint(carCheckData.getLatitude(), carCheckData.getLongitude()),
//                        Marker.boundCenter(drawable));
//                myCarLocationOverlayItems.add(myCarMarker);
//                sailsMapView.getDynamicOverlays().add(myCarLocationOverlay);
//            }
//        }

//        loadSwitchMarker();
        if (sails.getFloor().equals(currentViewFloor)) {
            tvWatchFloor.setText(getString(R.string.epath_current_location) + sails.getFloor() + "F");
            ivEyeLocation.setBackground(context.getResources().getDrawable(R.drawable.marker_mylocation_black));
        } else {
            tvWatchFloor.setText(getString(R.string.epath_checking) + currentViewFloor + "F");
            if (isLocationFix() && navMode != NAV_MODE_SIMULATION) {
                //在模拟导航状态不显示,楼层的虚拟点位

                Drawable drawable = getResources().getDrawable(R.drawable.loc_point_translucent);
                virtualMarker = new Marker(new GeoPoint(sails.getLatitude(), sails.getLongitude()),
                        Marker.boundCenter(drawable));
                TextPaint textPaint = new TextPaint();
                textPaint.setAntiAlias(true);
                textPaint.setTextSize(30F);
                textPaint.setTextAlign(Paint.Align.CENTER);
                textPaint.setColor(GRAY);
                textOverlay = new TextOverlay(new GeoPoint(sails.getLatitude(), sails.getLongitude()), getString(R.string.epath_you_are_in2) + sails.getFloorNumber() + "F",
                        textPaint, textPaint);
                myLocationOverlayItems.add(virtualMarker);
                myLocationOverlayItems.add(textOverlay);
                sailsMapView.getDynamicOverlays().add(myLocationOverlay);

            }

            ivEyeLocation.setBackground(context.getResources().getDrawable(R.drawable.ic_eyes));
        }

        ObjectAnimator.ofFloat(llFloor, "alpha", 1f, 0f)
                .setDuration(4000)
                .start();
    }

    private void loadSwitchMarker() {
        swtichFloorNumberOverlayItems.clear();
        if (sailsMapView.getDynamicOverlays().contains(swtichFloorNumberOverlay)) {
            sailsMapView.getDynamicOverlays().remove(swtichFloorNumberOverlay);
        }


        Drawable drawableSwitch = getResources().getDrawable(R.drawable.ic_switch_floor);

        if (!TextUtils.isEmpty(currentViewFloor) && navigationHandler != null) {
            currentFloorFirstData = navigationHandler.getCurrentFloorFirstData(sails, Integer.parseInt(currentViewFloor));
            switchMarkerFirstList = new ArrayList<>();
            if (currentFloorFirstData != null) {
                for (int i = 0; i < currentFloorFirstData.size(); i++) {
                    NavigationData navigationData = currentFloorFirstData.get(i);
                    String toFloor2 = navigationData.getPreFloor();
                    L.e("ddd", "getPreFloor: " + toFloor2);
                    SAILS.GeoNode geoNodeFirst = navigationData.getGeoNode();
                    switchMarkerFirst = new Marker(new GeoPoint(geoNodeFirst.latitude, geoNodeFirst.longitude),
                            Marker.boundCenter(drawableSwitch));
                    switchMarkerFirstList.add(switchMarkerFirst);
                    swtichFloorNumberOverlayItems.add(switchMarkerFirst);
                }

            }

            currentFloorLastData = navigationHandler.getCurrentFloorLastData(Integer.parseInt(currentViewFloor));
            switchMarkerLastList = new ArrayList<>();
            if (currentFloorLastData != null) {
                for (int i = 0; i < currentFloorLastData.size(); i++) {
                    NavigationData navigationData = currentFloorLastData.get(i);
                    String toFloor = navigationData.getToFloor();
                    L.e("ddd", "toFloor: " + toFloor);
                    SAILS.GeoNode geoNodeLast = navigationData.getGeoNode();
                    switchMarkerLast = new Marker(new GeoPoint(geoNodeLast.latitude, geoNodeLast.longitude),
                            Marker.boundCenter(drawableSwitch));
                    switchMarkerLastList.add(switchMarkerLast);
                    swtichFloorNumberOverlayItems.add(switchMarkerLast);
                }
            }
        }

        sailsMapView.getDynamicOverlays().add(swtichFloorNumberOverlay);
    }


    private void showScaleAnimation(int lockmode) {
        ivBackPosition.setVisibility(View.INVISIBLE);
        llLogo.setVisibility(View.INVISIBLE);
        rlScale.setVisibility(View.VISIBLE);
        double zoomLevel = getZoomLevel();
        int pow = (int) Math.pow(2, 22 - zoomLevel);
        String scale = (2.5 * pow) + "";
        if (scale.lastIndexOf(".0") != -1) {
            tvScale.setText(scale.substring(0, scale.lastIndexOf(".0")) + getString(R.string.epath_meter));
        } else {
            tvScale.setText(scale + getString(R.string.epath_meter));
        }


        if (animatorLogo == null) {
            animatorLogo = ObjectAnimator.ofFloat(rlScale, "alpha", 1f, 0f)
                    .setDuration(2000);
        }
        animatorLogo
                .addListener(new Animator.AnimatorListener() {
                    @Override
                    public void onAnimationStart(Animator animation) {

                    }

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        ivBackPosition.setVisibility(View.INVISIBLE);
                        if (((lockmode & SAILSMapView.LOCATION_CENTER_LOCK) == SAILSMapView.LOCATION_CENTER_LOCK) &&
                                ((lockmode & SAILSMapView.FOLLOW_PHONE_HEADING) == SAILSMapView.FOLLOW_PHONE_HEADING) && isLocationFix()) {
                            if (isLocationFix()) {
                                llLogo.setVisibility(View.VISIBLE);
                                ivBackPosition.setVisibility(View.INVISIBLE);
                            } else {
                                llLogo.setVisibility(View.INVISIBLE);
                                ivBackPosition.setVisibility(View.VISIBLE);
                            }

                        } else if ((lockmode & SAILSMapView.LOCATION_CENTER_LOCK) == SAILSMapView.LOCATION_CENTER_LOCK) {
                            if (isLocationFix()) {
                                llLogo.setVisibility(View.VISIBLE);
                                ivBackPosition.setVisibility(View.INVISIBLE);
                            } else {
                                if (isLocationFix()) {
                                    llLogo.setVisibility(View.INVISIBLE);
                                    ivBackPosition.setVisibility(View.VISIBLE);
                                }
                            }
                        } else {
                            if (isLocationFix()) {
                                llLogo.setVisibility(View.INVISIBLE);
                                ivBackPosition.setVisibility(View.VISIBLE);
                            } else {
                                llLogo.setVisibility(View.VISIBLE);
                                ivBackPosition.setVisibility(View.INVISIBLE);
                            }
                        }
                    }

                    @Override
                    public void onAnimationCancel(Animator animation) {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation) {

                    }
                });

        showLogoCurrentTime = System.currentTimeMillis();
        showLogoLastTime = 0;
        if (showLogoCurrentTime - showLogoLastTime > 2500) {
            showLogoLastTime = showLogoCurrentTime;
            animatorLogo.start();
        } else {
            showLogoLastTime = showLogoCurrentTime;
        }
    }

    private int getPositionByFloorName(String floorName) {
        if (floorNumbers != null && floorName != null) {
            for (Integer position : floorNumbers.keySet()) {
                Floor floor = floorNumbers.get(position);
                if (floor != null && floor.getName() != null && floorName.equals(floor.getName())) {
                    return position;
                }
            }
        }
        return 0;
    }

    /**
     * 设置路径颜色，的配置
     */
    private void initRoutingManger() {
        pathRoutingManager = sailsMapView.getRoutingManager();
        //路径颜色设置
        pathRoutingManager.getPathPaint().setColor(0x00b0ff);
        pathRoutingManager.getPathPaint().setStyle(Paint.Style.STROKE);
        pathRoutingManager.getPathPaint().setAlpha(255);
        pathRoutingManager.getPathPaint().setStrokeWidth(8 * ScreenDensity.density);
        pathRoutingManager.getPathPaint().setStrokeJoin(Paint.Join.ROUND);
        pathRoutingManager.getPathPaint().setStrokeCap(Paint.Cap.ROUND);
        pathRoutingManager.getPathPaint().setFilterBitmap(true);
        pathRoutingManager.getPathPaint().setAntiAlias(true);
        pathRoutingManager.getPathStrokePaint().setColor(0xffffff);
        pathRoutingManager.getPathStrokePaint().setStyle(Paint.Style.STROKE);
        pathRoutingManager.getPathStrokePaint().setAlpha(200);
        pathRoutingManager.getPathStrokePaint().setStrokeWidth(13 * ScreenDensity.density);
        pathRoutingManager.getPathStrokePaint().setStrokeJoin(Paint.Join.ROUND);
        pathRoutingManager.getPathStrokePaint().setStrokeCap(Paint.Cap.ROUND);
        pathRoutingManager.getPathStrokePaint().setFilterBitmap(true);
        pathRoutingManager.getPathStrokePaint().setAntiAlias(true);
        pathRoutingManager.setRouteMode(PathRoutingManager.ELEVATOR_FIRST);
        pathRoutingManager.locationRegionCrossable(true);
        markerManager = sailsMapView.getMarkerManager();
        listOverlay = new ListOverlay();
        overlayItems = listOverlay.getOverlayItems();



        //路径规划监听 有可能返回不成功
        pathRoutingManager.setOnRoutingUpdateListener(new PathRoutingManager.OnRoutingUpdateListener() {

            @Override
            public void onArrived(LocationRegion locationRegion) {
                if (navMode != NAV_MODE_SIMULATION
                        && sails.getFloorNumber() == targetRegion.getFloorNumber()
                        && (navStatus == NAV_STATUS_NAVIGATING || navStatus == NAV_STATUS_NAVIGATING_PAUSE)) {
                    if (isVolumeOn) {
                        voiceManager.turnOn();
                        voiceManager.textToVoice(NavContentHandler.getNavString(NavContentHandler.NAV_REACH_REAL), true);
                    }
                    navStatus = NAV_STATUS_FINISH;
                    updateNavStatus();
                }
                if (navMode == NAV_MODE_SIMULATION
                        && sails.getFloorNumber() == targetRegion.getFloorNumber()
                        && (navStatus == NAV_STATUS_NAVIGATING || navStatus == NAV_STATUS_NAVIGATING_PAUSE)) {
                    if (isVolumeOn) {
                        voiceManager.turnOn();
                        voiceManager.textToVoice(NavContentHandler.getNavString(NavContentHandler.NAV_REACH_SIMU), true);
                    }
                    navStatus = NAV_STATUS_FINISH;
                    updateNavStatus();
                }
            }

            @Override
            public void onRouteSuccess() {
                isRouteSuccess = true;
                new Handler().postDelayed(() -> {
                    if (navStatus == NAV_STATUS_NAVIGATING || navStatus == NAV_STATUS_NAVIGATING_PAUSE) {
                        navStatus = NAV_STATUS_NAVIGATING;
                        updateNavStatus();
                    } else if (navStatus == NAV_STATUS_SHOW_PRE_INFO) {
                        navPreBottomDialog.isShowNavHint(true);


                        float translationY = rlBottom.getTranslationY();
                        ObjectAnimator.ofFloat(rlBottom, "translationY", translationY, -DensityUtils.dp2px(context, 180))
                                .setDuration(300).start();

                        sailsMapView.setMode(SAILSMapView.GENERAL);
                        int width = DensityUtils.getScreenWidth(context) - DensityUtils.dp2px(context, 160);
                        sailsMapView.autoSetMapZoomAndView(pathRoutingManager.getCurrentFloorRoutingPathNodes(), width);
                        sailsMapView.setAnimatingToRotationAngle((float) project.getAngle());
                        isMultiBuildingFloor();

                        if (navigationHandler != null) {
                            navigationHandler.clear();
                        }
                        List<SAILS.GeoNode> currentAllPathNodes = pathRoutingManager.getCurrentAllPathNodes();

                        if (currentAllPathNodes == null) {
                            return;
                        }
                        if (currentAllPathNodes.size() < 10000) {
                            navigationHandler = new NavigationHandler(sails, currentAllPathNodes);
                        } else {
                            //有待测试
                            T.showShort(R.string.epath_locate_unusual);
                            navStatus = NAV_STATUS_DEFAULT;
                            updateNavStatus();
                            return;
                        }

                    }
//                    loadSwitchMarker();
                }, 100);

                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        loadSwitchMarker();
                    }
                }, 500);


            }

            @Override
            public void onRouteFail() {

                isRouteSuccess = false;
                navPreBottomDialog.isShowNavHint(false);
            }

            @Override
            public void onPathDrawFinish() {
            }

            @Override
            public void onTotalDistanceRefresh(int i) {
                if (navStatus == NAV_STATUS_SHOW_PRE_INFO) {
                    if (startRegion == PathRoutingManager.MY_LOCATION && isLocationFix()) {
                        if (sails.getFloorNumber() == targetRegion.getFloorNumber()) {
                        } else {
                            if (pathRoutingManager.getRouteMode() == PathRoutingManager.ESCALATOR_AND_STAIR_FIRST) {
                                navPreBottomDialog.changeFloorMode(true);
                            } else {
                                navPreBottomDialog.changeFloorMode(false);
                            }
                        }
                    } else {
                        if (getRegionFloorNumber(startRegion) == targetRegion.getFloorNumber()) {
                        } else {
                            if (pathRoutingManager.getRouteMode() == PathRoutingManager.ESCALATOR_AND_STAIR_FIRST) {
                                navPreBottomDialog.changeFloorMode(true);
                            } else {
                                navPreBottomDialog.changeFloorMode(false);
                            }
                        }
                    }
                    totalDistance = i;
                    totalTime = EpUtils.getDistanceTime((double) i);
                    navPreBottomDialog.setHintDistance(totalDistance + getString(R.string.epath_meter));
                    navPreBottomDialog.setHintTime(getString(R.string.epath_approximately) + " " + totalTime);
                } else if (navStatus == NAV_STATUS_NAVIGATING || navStatus == NAV_STATUS_NAVIGATING_PAUSE) {
                    currentDistance = i;

                    if (i > 10000) {
                        //有待测试
//                        T.showLong("gps 定位异常 !");
//                        navStatus = NAV_STATUS_DEFAULT;
//                        updateNavStatus();
                        return;
                    }
                    if (navStatus == NAV_STATUS_NAVIGATING) {
//                        String hint = "剩余" + i + "米  耗时约" + EpUtils.getDistanceTime((double) i);
                        String distanceHint = getString(R.string.epath_surplus_distance,i);
                        String timeHint = getString(R.string.epath_using_time_approximately) + EpUtils.getDistanceTime((double) i);
                        navBottomNewDialog.setHintDistance(distanceHint);
                        navBottomNewDialog.setHintTime(timeHint);
                        navBottomNewDialog.continueNav();
//                        navBottomDialog.setHint(hint);
                    }

                    String myLocationFloor = "";
                    String floorName = "";
                    String addressName = "";
                    if (sails.getCurrentInBuildingName() != null) {
//                        myLocationFloor += sails.getCurrentInBuildingName().label + sails.getFloorDescription(sails.getFloor());
                        floorName = sails.getFloorDescription(sails.getFloor());
                        addressName = sails.getCurrentInBuildingName().label;
                    } else {
//                        myLocationFloor += sails.getFloorDescription(sails.getFloor());
                        floorName = sails.getFloorDescription(sails.getFloor());
                        addressName = sails.getFloorDescription(sails.getFloor());
                    }
                    if (targetRegion != null) {
                        String name = "";
                    }
                    if (startRegion != null) {
                        addressName = startRegion.label;
                    }
                    navBottomNewDialog.setCurrentLocation(floorName, addressName);
//                    navBottomDialog.setMyLocationFloor(myLocationFloor);

                    /*导航中信息更新*/
                    SAILS.GeoNode currentGeoNode = new SAILS.GeoNode(sails.getLongitude(), sails.getLatitude());
                    currentGeoNode.floornumber = sails.getFloorNumber();
                    if(navigationHandler == null) {
                        return;
                    }
                    NavigationData navigationData = navigationHandler.getNavigationData(currentGeoNode, sails, pathRoutingManager.getCurrentAllPathNodes()
                            , myLocationOverlayItems, myLocationOverlay, sailsMapView, context, navMode);

                    if(isPreview){
//                        guideLineView.updatePath(sails, pathRoutingManager.getCurrentAllPathNodes());
                        setIvDerectionHint(navigationData);
                    }
                    if (sails.getCurrentInBuildingName() == null && sailsMapView.isCenterLock()
                            && userNavigatingZoom == project.getNavigationZoom()
                            && getZoomLevel() != project.getNavigationZoom() - 1) {
                        new Handler().postDelayed(() -> {
                            if (sails.getCurrentInBuildingName() == null && sailsMapView.isCenterLock()
                                    && userNavigatingZoom == project.getNavigationZoom()
                                    && getZoomLevel() != project.getNavigationZoom() - 1) {
                                //sailsMapView.getMapViewPosition().setZoomLevel((Float.parseFloat(project.getNavigationZoom() - 1 + "")));
                                if(isPreview){
                                    sailsMapView.setAnimationToZoom(arNavigationZoomLevel - 1);
                                }else {
                                    sailsMapView.setAnimationToZoom(Float.parseFloat(project.getNavigationZoom() - 1 + ""));
                                }
                            }
                        }, 500);
                    } else if (sails.getCurrentInBuildingName() != null && sailsMapView.isCenterLock()
                            && (userNavigatingZoom == project.getNavigationZoom() - 1 || userNavigatingZoom == project.getNavigationZoom())
                            && getZoomLevel() != project.getNavigationZoom()) {
                        //sailsMapView.getMapViewPosition().setZoomLevel((Float.parseFloat(project.getNavigationZoom() + "")));
                        if(isPreview){
                            sailsMapView.setAnimationToZoom(arNavigationZoomLevel);
                        }else {
                            sailsMapView.setAnimationToZoom(Float.parseFloat(project.getNavigationZoom() + ""));
                        }
                    }
                    if (navigationData != null) {
                        L.d("ddd", navigationData.toString());
                        if (navigationData.getNavigationText() != null &&
                                !navigationData.getNavigationText().startsWith(getString(R.string.epath_arrive)) ||
                                navigationData.getNavigationText() == null) {
                            navTopDialog.setHint(navigationData);
                            showAccessbilityText(navigationData);

                            doArMapExpand(navigationData);
                        }
                        showFloorPhoto(navigationData);
                        if (navigationData.isForcePlay() && isVolumeOn) {
                            if (navigationData.getVoicePointIndex() == INDEX_UPDOWN &&
                                    navigationData.getVoicePoints().get(navigationData.getVoicePointIndex())
                                            .getPlayStatus() == NavigationData.STATUS_READY) {
                                voiceManager.textToVoiceFloor(navigationData.getNavigationVoiceText(), true);
                                navigationData.getVoicePoints()
                                        .get(navigationData.getVoicePointIndex()).setPlayStatus(NavigationData.STATUS_PLAYED);
                                navigationHandler.setNavigationData(navigationData);

                            }
                            if (navigationData.getNaviDirection() == DIRECTION_NEAR_DESTINATION &&
                                    navigationData.getVoicePoints().get(navigationData.getVoicePointIndex())
                                            .getPlayStatus() == NavigationData.STATUS_READY) {
                                voiceManager.textToVoice(navigationData.getNavigationVoiceText(), true);
                                navigationData.getVoicePoints()
                                        .get(navigationData.getVoicePointIndex()).setPlayStatus(NavigationData.STATUS_PLAYED);
                                navigationHandler.setNavigationData(navigationData);

                            }
                            if (navigationData.getVoicePointIndex() == INDEX_TURN_ROUND && navigationData.getVoicePoints().get(INDEX_TURN_ROUND)
                                    .getPlayStatus() == NavigationData.STATUS_READY) {
                                vibrate();
                                voiceManager.textToVoice(navigationData.getNavigationVoiceText(), true);
                                navigationData.getVoicePoints()
                                        .get(navigationData.getVoicePointIndex()).setPlayStatus(NavigationData.STATUS_PLAYED);
                                navigationHandler.setNavigationData(navigationData);

                            }

                        } else if (!navigationData.isForcePlay() && isVolumeOn &&
                                navigationData.getVoicePointIndex() == INDEX_NEXT_FLOOR && isFirstGotoNextFloor) {
                            isFirstGotoNextFloor = false;
                            new Handler().postDelayed(() -> {
                                if (navigationData.getVoicePointIndex() == INDEX_NEXT_FLOOR) {
                                    SAILS.GeoNode geoNode = navigationData.getGeoNode();
                                    if (isLocationFix() && sails.getFloorNumber() != geoNode.floornumber) {
                                        return;
                                    }
                                    isFirstGotoNextFloor = true;
                                    navTopDialog.setHint(navigationData);
                                    showAccessbilityText(navigationData);

                                    doArMapExpand(navigationData);
                                    if (navigationData.getVoicePoints().get(navigationData.getVoicePointIndex())
                                            .getPlayStatus() == NavigationData.STATUS_READY) {
                                        voiceManager.textToVoiceFloor(navigationData.getNavigationVoiceText(), false);
                                        navigationData.getVoicePoints()
                                                .get(navigationData.getVoicePointIndex()).setPlayStatus(NavigationData.STATUS_PLAYED);
                                        navigationHandler.setNavigationData(navigationData);
                                    }
                                }
                            }, 5000);
                        } else if (!navigationData.isForcePlay() && isVolumeOn && navigationData.getVoicePointIndex() != INDEX_NEXT_FLOOR &&
                                navigationData.getVoicePoints().get(navigationData
                                        .getVoicePointIndex()).getPlayStatus() == NavigationData.STATUS_READY) {
                            boolean isSuccess = voiceManager.textToVoice(navigationData.getNavigationVoiceText(), false);
                            int status = NavigationData.STATUS_FAILED;
                            if (isSuccess) {
                                status = NavigationData.STATUS_PLAYED;
                            }
                            navigationData.getVoicePoints()
                                    .get(navigationData.getVoicePointIndex()).setPlayStatus(status);
                            navigationHandler.setNavigationData(navigationData);

                        }
                    }
                    /*导航中信息更新*/

                    if ((i < EpConstants.REACH_REAL_DISTANCE) && navMode != NAV_MODE_SIMULATION
                            && sails.getFloorNumber() == targetRegion.getFloorNumber() && isVolumeOn) {
                        voiceManager.turnOn();
                        voiceManager.textToVoice(NavContentHandler.getNavString(NavContentHandler.NAV_REACH_REAL), true);
                        navStatus = NAV_STATUS_FINISH;
                        updateNavStatus();
                    }
                    if ((i < EpConstants.REACH_SIMULATION_DISTANCE) && navMode == NAV_MODE_SIMULATION
                            && sails.getFloorNumber() == targetRegion.getFloorNumber() && isVolumeOn) {
                        voiceManager.turnOn();
                        voiceManager.textToVoice(NavContentHandler.getNavString(NavContentHandler.NAV_REACH_SIMU), true);
                        navStatus = NAV_STATUS_FINISH;
                        updateNavStatus();
                    }
                } else if (navStatus == NAV_STATUS_FINISH) {
//                    String myLocationFloor = "";
                    String floorName = "";
                    String addressName = "";
                    if (sails.getCurrentInBuildingName() != null) {
//                        myLocationFloor += sails.getCurrentInBuildingName().label + sails.getFloorDescription(sails.getFloor());
                        floorName = sails.getFloorDescription(sails.getFloor());
                        addressName = sails.getCurrentInBuildingName().label;
                    } else {
//                        myLocationFloor += sails.getFloorDescription(sails.getFloor());
                        floorName = convertFloorName(sails.getFloorDescription(sails.getFloor()));
                    }
                    if(startRegion != null){
                        addressName = startRegion.label;
                    }
//                    navBottomDialog.setMyLocationFloor(myLocationFloor);
                    navBottomNewDialog.setCurrentLocation(floorName, addressName);
                }
            }

            @Override
            public void onReachNearestTransferDistanceRefresh(int i, int i1) {
            }

            @Override
            public void onSwitchFloorInfoRefresh(List<PathRoutingManager.SwitchFloorInfo> list, int i) {
            }

            @Override
            public void onPathRearranged() {
                if (navMode != NAV_MODE_SIMULATION) {
                    pathRoutingManager.enableHandler();
                    String text = getString(R.string.epath_route_replanning);
                    T.showShort(text);
                    if (isVolumeOn) {
                        voiceManager.textToVoice(text, true);
                    }
                }
            }
        });

    }

    private static final int DERECTION_STRAIGHT = 0;
    private static final int DERECTION_LEFT = 1;
    private static final int DERECTION_RIGHT = 2;
    private int derection_type = 0;
    /**
     * 设置实景方向提示
     * @param data
     */
    private void setIvDerectionHint(NavigationData data) {
        String navText = data.getNavigationText();
        if (TextUtils.isEmpty(navText)) {//null显示上一次
            return;
        }
        int type = 0;
        if (navText.contains(NavContentHandler.getDirectionString(EpConstants.DIRECTION_LEFT))) {
            type = DERECTION_LEFT;
        } else if (navText.contains(NavContentHandler.getDirectionString(EpConstants.DIRECTION_STRAIGHT_LEFT))) {
            type = DERECTION_LEFT;
        } else if (navText.contains(NavContentHandler.getDirectionString(EpConstants.DIRECTION_BEHIND_LEFT))) {
            type = DERECTION_LEFT;
        } else if (navText.contains(NavContentHandler.getDirectionString(EpConstants.DIRECTION_RIGHT))) {
            type = DERECTION_RIGHT;
        } else if (navText.contains(NavContentHandler.getDirectionString(EpConstants.DIRECTION_BEHIND_RIGHT))) {
            type = DERECTION_RIGHT;
        } else if (navText.contains(NavContentHandler.getDirectionString(EpConstants.DIRECTION_STRAIGHT_RIGHT))) {
            type = DERECTION_RIGHT;
        } else if (navText.contains(NavContentHandler.getDirectionString(EpConstants.DIRECTION_STRAIGHT))) {
            type = DERECTION_STRAIGHT;
        } else {
            type = DERECTION_STRAIGHT;
        }
        if(type != derection_type){
            derection_type = type;
            if(derection_type == DERECTION_LEFT){
                ImageLoader.loadGif(context,R.drawable.gif_derection_left,ivDerection);
            }else if(derection_type == DERECTION_RIGHT){
                ImageLoader.loadGif(context,R.drawable.gif_derection_right,ivDerection);
            }else{
                ImageLoader.loadGif(context,R.drawable.gif_derection,ivDerection);
            }
        }
    }


    /**
     * 在实景导航中，控制地图展开收回
     */
    private void doArMapExpand(NavigationData navigationData) {
        if(!isPreview) {
            return;
        }
        String navText = navigationData.getNavigationText();
        if(navText == null){
            return;
        }
        if(navText.contains("转") || navText.contains("向")){
            doMapExpend(true);

        }else{
            doMapExpend(false);

        }
    }

    private double getZoomLevel() {
        float zoomLevel = sailsMapView.getMapViewPosition().getZoomLevel();
        return Double.valueOf(new DecimalFormat("#.0").format(zoomLevel));
    }

    private void isMultiBuildingFloor() {
        isMultiFloor = false;//是否为多楼层
        boolean showMultiFloor = false;
        if (startRegion.getFloorNumber() != targetRegion.getFloorNumber()) {
            isMultiFloor = true;
        }
        JSONArray escalatorFirst = project.getEscalatorFirst();
        if (escalatorFirst != null && escalatorFirst.length() != 0) {
            for (int k = 0; k < escalatorFirst.length(); k++) {
                try {
                    int floorMode = (int) escalatorFirst.get(k);
                    if (targetRegion.getFloorNumber() == floorMode && isMultiFloor) {
                        showMultiFloor = true;
                        break;
                    }
                    if (k == escalatorFirst.length() - 1) {
                        showMultiFloor = false;
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        } else {
            showMultiFloor = false;
        }
        L.e("hjxDebug", "showMultiFloor : "+showMultiFloor);
        boolean showMultiFloorView = false;//是否显示多楼层选择的界面
        List<SAILS.GeoNode> currentAllPathNodes = pathRoutingManager.getCurrentAllPathNodes();
        if (currentAllPathNodes != null) {
            for (SAILS.GeoNode currentAllPathNode : currentAllPathNodes) {
                LocationRegion belongsRegion = currentAllPathNode.BelongsRegion;
                if (belongsRegion != null) {
                    String subtype = belongsRegion.subtype;
                    if (subtype != null) {
                        switch (subtype) {
                            case EpConstants.STAIR:
                            case EpConstants.ESCALATOR:
                                //只有在模式对应相等的时候才显示多楼层
                                if (pathRoutingManager.getRouteMode() == PathRoutingManager.ESCALATOR_AND_STAIR_FIRST && showMultiFloor) {
                                    showMultiFloorView = true;
                                }
                                break;
                            case EpConstants.ELEVATOR:
                                //只有在模式对应相等的时候才显示多楼层
                                if (pathRoutingManager.getRouteMode() == PathRoutingManager.ELEVATOR_FIRST && showMultiFloor) {
                                    showMultiFloorView = true;
                                }
                                break;
                        }
                    }
                }
            }
        }
        if (showMultiFloorView) {
            navPreBottomDialog.setMultiFloor(true);
        } else {
            navPreBottomDialog.setMultiFloor(false);
            showMultiBuldingFloorText();
        }
    }

    /**
     * 显示启动导航底部弹窗，展示相关的数据， epath_dialog_nav_pre_bo
     */
    private void showMultiBuldingFloorText() {
        LocationRegion start = sails.getInBuildingName(startRegion.getCenterLongitude(),
                startRegion.getCenterLatitude());
        if (startRegion == PathRoutingManager.MY_LOCATION && isLocationFix()) {
            start = sails.getCurrentInBuildingName();
        }

        LocationRegion target = sails.getInBuildingName(targetRegion.getCenterLongitude(),
                targetRegion.getCenterLatitude());
        if (start != null && target != null && start.label.equals(target.label)) {//同楼
            if (isMultiFloor) {
//                navPreBottomDialog.setHintFloor("到" + targetRegion.getFloorDescription());
                navPreBottomDialog.setBourn(convertFloorName(targetRegion.getFloorDescription()));
            } else if (!isMultiFloor) {
                navPreBottomDialog.setHintFloor(getString(R.string.epath_same_floor));
            }

        } else if (start != null && target != null && !start.label.equals(target.label)) {//不同楼
//            navPreBottomDialog.setHintFloor("到" + target.label
//                    + targetRegion.getFloorDescription());
            navPreBottomDialog.setBourn(target.label
                    + convertFloorName(targetRegion.getFloorDescription()));

        } else if (isMultiFloor) {//多楼层
//            navPreBottomDialog.setHintFloor("到" + targetRegion.getFloorDescription());
            navPreBottomDialog.setBourn(convertFloorName(targetRegion.getFloorDescription()));

        } else if (!isMultiFloor) {//同楼层
            navPreBottomDialog.setHintFloor(getString(R.string.epath_same_floor));
        }
    }

    //设置起始点
    private void setStartLocationRegionMarker(LocationRegion locationRegion) {
        startRegion = locationRegion;
        if (startRegion == PathRoutingManager.MY_LOCATION) {
            startMyLocFloorDescription = convertFloorName(sails.getFloorDescription(sails.getFloor()));
            if (sails.getCurrentInBuildingName() != null && sails.getCurrentInBuildingName().label != null) {
                startMyLocBuildingName = sails.getCurrentInBuildingName().label;
            }
        }
        pathRoutingManager.setStartRegion(startRegion);
        markerManager.setLocationRegionMarker(startRegion,
                Marker.boundCenterBottom(getResources().getDrawable(R.drawable.loc_point_start)));
    }

    //设置终点
    private void setTargetLocationRegionMarker(LocationRegion locationRegion, boolean fromShare) {
        targetRegion = locationRegion;
        pathRoutingManager.setTargetRegion(targetRegion);
        int resourceId = R.drawable.loc_point_mark;
        if (startRegion == null && fromShare) {
            resourceId = R.drawable.loc_point_shank;
        } else if (startRegion != null) {
            resourceId = R.drawable.loc_point_target;
        }
        markerManager.setLocationRegionMarker(targetRegion,
                Marker.boundCenterBottom(getResources().getDrawable(resourceId)));

    }

    private void initTargetLocationRegion(List<LocationRegion> locationRegions, boolean fromShare) {
        if (locationRegions.size() > 0) {
            LocationRegion locationRegion = locationRegions.get(0);
            if (overlayItems != null) {
                overlayItems.clear();
            }
            if (markerManager != null) {
                markerManager.clear();
            }

            setTargetLocationRegionMarker(locationRegion, fromShare);

            if (startRegion == null && !sailsMapView.getCurrentBrowseFloorName().equals(locationRegion.getFloorName())) {
                sailsMapView.loadFloorMap(locationRegion.getFloorName());
                wheelPicker.setSelectedItemPosition(getPositionByFloorName(locationRegion.getFloorName()));
            }
            if (startRegion == null) {
                GeoPoint geoPoint = new GeoPoint(locationRegion.getCenterLatitude(), locationRegion.getCenterLongitude());
                sailsMapView.setAnimationMoveMapTo(geoPoint);
                sailsMapView.getMapViewPosition().setZoomLevel(Float.parseFloat(project.getNavigationZoom() + ""));
            }

        } else {
            T.showShort(R.string.epath_cannot_find_target_region);
        }
    }

    private void showPathRoute() {
        if (startRegion == null || targetRegion == null) {
            return;
        }
        overlayItems.clear();
        sails.clearRouteCache();
        //显示好友
        if (friendRegionData != null && sailsMapView.getCurrentBrowseFloorName().equals(friendRegionData.getFloorName())) {
            overlayItems.add(new Marker(new GeoPoint(friendRegionData.getLatitude(), friendRegionData.getLongitude()),
                    Marker.boundCenterBottom(getResources().getDrawable(R.drawable.loc_point_friend))));
        }
        if (getRegionFloorName(startRegion) != null && getRegionFloorName(startRegion).equals(sailsMapView.getCurrentBrowseFloorName())) {
            GeoPoint startPoint = new GeoPoint(startRegion.getCenterLatitude(), startRegion.getCenterLongitude());
            Marker startMarker = new Marker(startPoint, Marker.boundCenterBottom(getResources().getDrawable(R.drawable.loc_point_start)));
            overlayItems.add(startMarker);
        }

        if ((getRegionFloorName(startRegion) != null && targetRegion.getFloorName().equals(getRegionFloorName(startRegion)) ||
                startRegion == PathRoutingManager.MY_LOCATION && targetRegion.getFloorName().equals(sails.getFloor())) && !flagIsFindCaring) {
            GeoPoint targetPoint = new GeoPoint(targetRegion.getCenterLatitude(), targetRegion.getCenterLongitude());
            Marker targetMarker = new Marker(targetPoint, Marker.boundCenterBottom(getResources().getDrawable(R.drawable.loc_point_target)));
            overlayItems.add(targetMarker);
        }
        JSONArray escalatorFirst = project.getEscalatorFirst();
        if (escalatorFirst != null && escalatorFirst.length() != 0) {
            for (int k = 0; k < escalatorFirst.length(); k++) {
                try {
                    int floorMode = (int) escalatorFirst.get(k);
                    if (targetRegion.getFloorNumber() == floorMode) {
                        pathRoutingManager.setRouteMode(PathRoutingManager.ESCALATOR_AND_STAIR_FIRST);
                        break;
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        pathRoutingManager.enableHandler();
        if (sailsMapView.getDynamicOverlays().contains(listOverlay)) {
            sailsMapView.getDynamicOverlays().remove(listOverlay);
        }
        sailsMapView.getDynamicOverlays().add(listOverlay);
    }

    private void engineLocationProcedure() {
        if (sails != null) {
            if (sails.isLocationEngineStarted()) {
                sailsMapView.setLocatorMarkerVisible(false);
                sailsMapView.invalidate();
                sails.stopLocatingEngine();
                sailsMapView.setMode(SAILSMapView.GENERAL);
            } else {
                sails.setGPSThresholdParameter(project.getInToOut(), project.getOutToIn(), project.getPowerThreshold()); //in_to_out,out_to_in,beacon min power
                sails.setEnvironmentIsHighBeaconDensity(true);//v1.51
                updateNavMode();
//                sails.setSpeedFactor(5.0);
                sails.startLocatingEngine();
                MixpanelEvent.timeLocationFix();
                MixpanelEvent.isInThisMap(isInThisMap);
            }
        }

        new Thread(new Runnable() {
            @Override
            public void run() {
                ArrayList<LocationRegionData> allReginList = getAllRegionList();
                DataHolder.getInstance().setLocationRegions(allReginList);
            }
        }).start();

    }

    private void initNavigation() {
        NavContentHandler.init(getApplication().getResources());
        sails.startLocatingEngine();
        if (navMode == NAV_MODE_SIMULATION) {
            navGeoNodes = navigationHandler.productMockNodesForMultiFloor(sails);
        }


        if (navGeoNodes != null && navMode == NAV_MODE_SIMULATION && navGeoNodes.size() > 0) {
            SAILS.GeoNode geoNode = navGeoNodes.get(0);
            sails.setSimulationFloor(geoNode.floornumber + "");
            sails.setSimulationLongitude(geoNode.longitude);
            sails.setSimulationLatitude(geoNode.latitude);

            startNavSimuTimerTask();
        }
    }

    private void runSimulationNavigation() {
        if (isLocationFix() && navStatus == NAV_STATUS_NAVIGATING && navMode == NAV_MODE_SIMULATION) {
            if (navGeoNodes != null && navGeoNodes.size() > 0) {
                SAILS.GeoNode geoNode = navGeoNodes.get(0);
                sails.setSimulationFloor(geoNode.floornumber + "");
                sails.setSimulationLongitude(geoNode.longitude);
                sails.setSimulationLatitude(geoNode.latitude);
                SAILS.GeoNode bearGeoNode;
                if (navGeoNodes.size() >= 15) {
                    bearGeoNode = navGeoNodes.get(14);
                } else {
                    bearGeoNode = navGeoNodes.get(navGeoNodes.size() - 1);
                }
                if (bearGeoNode != null && geoNode != null && bearGeoNode.floornumber == geoNode.floornumber) {
                    double bearAngle = SAILS.GetBearDegree(geoNode.longitude, geoNode.latitude,
                            bearGeoNode.longitude, bearGeoNode.latitude);
                    sails.setSimulationUserHeading(bearAngle);
                }
                navGeoNodes.remove(0);
            }
        }
    }


    /**
     * 显示楼梯图片
     * @param navigationData
     */
    private void showFloorPhoto(NavigationData navigationData) {
        if(isPreview){
            //实景导航中不显示
            navTopDialog.setElevatorVisible(false);
            return;
        }
        try {
            int currentFloorLastSelf = navigationHandler.getCurrentFloorLastSelf(sails.getFloorNumber());
            String navText = navigationData.getNavigationText();
            if (navText != null && navText.contains(NavContentHandler.getFloor()) && currentFloorLastSelf != 0) {
                String imageURL = "";
                for (PhotoData photoData : photoList) {
                    if (photoData.getSelfId() == currentFloorLastSelf) {
                        imageURL = photoData.getUrl();
                        break;
                    }
                }
//                navTopDialog.setIvElevator(imageURL,navText.contains("上") ,navigationData.getToFloor());
                navTopDialog.setIvElevator(imageURL,navText.contains(NavContentHandler.getDirectionString(EpConstants.DIRECTION_UPSTAIRS)) ,navigationData.getToFloor());
            } else {
                navTopDialog.setElevatorVisible(false);
            }

        } catch (Exception e) {
            L.e("ddd", e.toString());
            e.printStackTrace();
            runOnUiThread(() -> T.showShort(R.string.epath_stairs_img_load_failed));
        }
    }

    /**
     * 移动到地图中心点
     */
    private void moveMaptoCenter() {
        ParseGeoPoint parseGeoPoint = project.getCenterPoint();
        if (parseGeoPoint != null && parseGeoPoint.getLongitude() != 0D &&
                parseGeoPoint.getLatitude() != 0D) {
            sailsMapView.setAnimationMoveMapTo(new GeoPoint(parseGeoPoint.getLatitude(), parseGeoPoint.getLongitude()));
        }
    }

    private void updateNavStatus() {

        switch (navStatus) {
            case NAV_STATUS_DEFAULT:
                showLocShareDialog(false);
                tvAr.setVisibility(View.GONE);
                controlAr();
                mLocationShare = null;
                locShareDialog = null;
                isLocationSharing = false;
                etSearch.setText("");
                startRegion = null;
                targetRegion = null;
                friendRegionData = null;
                flagIsFindCaring = false;
                userNavigatingZoom = project.getNavigationZoom();
                sailsMapView.setLocationMarker(R.drawable.loc_point_sector, R.drawable.loc_point_sector, null, 75);
                if (pathRoutingManager != null) {
                    pathRoutingManager.disableHandler();
                }
                if (overlayItems != null) {
                    overlayItems.clear();
                }
                if (swtichFloorNumberOverlayItems != null) {
                    swtichFloorNumberOverlayItems.clear();
                    if (sailsMapView.getDynamicOverlays().contains(swtichFloorNumberOverlay)) {
                        sailsMapView.getDynamicOverlays().remove(swtichFloorNumberOverlay);
                    }
                }
                if (markerManager != null) {
                    markerManager.clear();
                }
                navMode = NAV_MODE_BLE_GPS;
                if (project != null && project.isWiFi()) {
                    navMode = NAV_MODE_WIFI_GPS;
                }
                updateNavMode();
                isFirstLocationFix = true;
                if (floorNumbers.size() > 1) {
                    wheelPicker.setVisibility(View.VISIBLE);
                    wheelPicker.setSelectedItemPosition(getPositionByFloorName(project.getFloorName()));
                }
                showRegionDialog(false);
                showRegionSearchDialog(false);
                showNavPreDialog(false);
                showNavDialog(false);
                showNavFinishDialog(false);
                ivRemind.setVisibility(View.GONE);

                queryCarMessage();

                if (!isLocationFix() && !isDoNotReset) {
                    sailsMapView.loadFloorMap(project.getFloorName());
                    sailsMapView.getMapViewPosition().setZoomLevel(Float.parseFloat(project.getZoom() + ""));
                    sailsMapView.setAnimatingToRotationAngle((float) project.getAngle());
                    moveMaptoCenter();
                    showRlBottomAnimation();
                }else{
                    isDoNotReset = false;
                }
                break;
            case NAV_STATUS_SHOW_REGION_INFO:   //点击目标，触发导航提示
                if (shareDialog != null) {
                    shareDialog.dismiss();
                }
                if (targetRegion != null) {
                    sailsMapView.setMode(SAILSMapView.GENERAL);
                    showRegionDialog(true);
                    showMyLocDialog(false);
                    showRlBottomAnimation();
                }
//                dimissFindCar();
                break;
            case NAV_STATUS_SHOW_SEARCH_RESULT:
                showRegionSearchDialog(true);
                showMyLocDialog(false);
                showRlBottomAnimation();
                dimissFindCar();
                break;
            case NAV_STATUS_SHOW_PRE_INFO:      //触发 去这里的 导航操作
                if (isLocationFix() && startRegion == null) {
                    setStartLocationRegionMarker(PathRoutingManager.MY_LOCATION);
                }
                showPathRoute();
                showLocShareDialog(false);
                showRegionDialog(false);
                showNavPreDialog(true);
                showMyLocDialog(false);
                showRlBottomAnimation();
                break;
            case NAV_STATUS_NAVIGATING:
                wheelPicker.setVisibility(View.GONE);
//                if(isAccessibilitySettingsOn(this)){
                    ivRemind.setVisibility(View.VISIBLE);
//                }
                showRlBottomAnimation();
                showNavPreDialog(false);
                showNavDialog(true);
                sailsMapView.setLocationMarker(R.drawable.loc_point_nav, R.drawable.loc_point_nav, null, 50);
                if (navMode == NAV_MODE_SIMULATION) {
                    sails.setSimulationLongitude(startRegion.getCenterLongitude());
                    sails.setSimulationLatitude(startRegion.getCenterLatitude());
                    sails.setSimulationFloor(startRegion.getFloorName());
                    pathRoutingManager.setStartRegion(PathRoutingManager.MY_LOCATION);
                }else{
                    tvAr.setVisibility(View.VISIBLE);
                }
                updateNavMode();
                initNavigation();
                break;
            case NAV_STATUS_FINISH:
                if (confirmExitNavDialog != null && confirmExitNavDialog.isShowing()) {
                    confirmExitNavDialog.dismiss();
                }
//                hideAccessbilityNavigation();
                sendNavigationEvent();
                showRlBottomAnimation();
                pathRoutingManager.disableHandler();
                overlayItems.clear();
                sailsMapView.setLocationMarker(R.drawable.loc_point_arrow, R.drawable.loc_point_arrow, null, 75);
//                navFinishTopDialog.setDistanceAndTime("距离" + totalDistance + "米  耗时" + EpUtils.getDistanceTime(countTime));
                navFinishBottomDialog.setDistanceAndTime(getString(R.string.epath_nav_finish_distance_hint,totalDistance), getString(R.string.epath_using_time) + EpUtils.getDistanceTime(countTime));
                String startRegionText;
                String targetRegionText;
                if (startRegion == PathRoutingManager.MY_LOCATION && isLocationFix()) {
//                    startRegionText = "我的位置";
                    startRegionText = "";
                    if (!TextUtils.isEmpty(startMyLocBuildingName)) {
                        startRegionText += "    " + startMyLocBuildingName;
                    }
                    startRegionText += "(" + startMyLocFloorDescription + ")";
                } else {
                    startRegionText = startRegion.getName();
                    if (sails.getInBuildingName(startRegion.getCenterLongitude(), startRegion.getCenterLatitude()) != null) {
                        startRegionText += "    " + sails.getInBuildingName(startRegion.getCenterLongitude(), startRegion.getCenterLatitude()).label;
                    }
                    startRegionText += "(" + convertFloorName(startRegion.getFloorDescription()) + ")";
                }
                navFinishBottomDialog.setStartRegion(startRegionText);
                targetRegionText = targetRegion.getName();
                if (sails.getInBuildingName(targetRegion.getCenterLongitude(), targetRegion.getCenterLatitude()) != null) {
                    targetRegionText += "    " + sails.getInBuildingName(targetRegion.getCenterLongitude(), targetRegion.getCenterLatitude()).label;
                }
                targetRegionText += "(" + convertFloorName(targetRegion.getFloorDescription()) + ")";
                navFinishBottomDialog.setTargetRegion(targetRegionText);
                showNavFinishDialog(true);
                if (flagIsFindCaring && navMode == NAV_MODE_BLE_GPS && !isLocationSharing) {
                    upLoadStopCarData();
                }
                vibrate();
                break;
        }
    }

    // To check if service is enabled
    private boolean isAccessibilitySettingsOn(Context mContext) {
        int accessibilityEnabled = 0;
        final String service = "com.google.android.marvin.talkback/com.google.android.marvin.talkback.TalkBackService";
        try {
            accessibilityEnabled = Settings.Secure.getInt(
                    mContext.getApplicationContext().getContentResolver(),
                    android.provider.Settings.Secure.ACCESSIBILITY_ENABLED);
        } catch (Settings.SettingNotFoundException e) {
        }
        TextUtils.SimpleStringSplitter mStringColonSplitter = new TextUtils.SimpleStringSplitter(':');

        if (accessibilityEnabled == 1) {
            String settingValue = Settings.Secure.getString(
                    mContext.getApplicationContext().getContentResolver(),
                    Settings.Secure.ENABLED_ACCESSIBILITY_SERVICES);
            if (settingValue != null) {
                mStringColonSplitter.setString(settingValue);
                while (mStringColonSplitter.hasNext()) {
                    String accessibilityService = mStringColonSplitter.next();

                    if (accessibilityService.equalsIgnoreCase(service)) {
                        return true;
                    }
                }
            }
        } else {
        }

        return false;
    }


    private void dimissFindCar() {
        myCarLocationOverlayItems.clear();
        if (sailsMapView.getDynamicOverlays().contains(myCarLocationOverlay)) {
            sailsMapView.getDynamicOverlays().remove(myCarLocationOverlay);
        }


        ivRepunchClock.setVisibility(View.GONE);
        showFindOrStopView(View.GONE);
        myCarLocationOverlayItems.clear();
        if (sailsMapView.getDynamicOverlays().contains(myCarLocationOverlay)) {
            sailsMapView.getDynamicOverlays().remove(myCarLocationOverlay);
        }
    }

    private void sendNavigationEvent() {
        if (startRegion == null || targetRegion == null) {
            return;
        }
        double percent = 0;
        if (navStatus == NAV_STATUS_FINISH) {
            percent = 1;
        } else {
            if (currentDistance <= totalDistance) {
                percent = 1 - (double) currentDistance / (double) totalDistance;
            }
        }
        String startLocation;
        if (startRegion == PathRoutingManager.MY_LOCATION && isLocationFix()) {
            startLocation = MixpanelConstants.NAVIGATION_START_FROM_MY_LOCATION;
        } else {
            startLocation = startRegion.getName();
        }
        MixpanelEvent.navigation(navMode == NAV_MODE_SIMULATION, startLocation, targetRegion.getName(),
                totalDistance, EpUtils.getDistanceTime(countTime), percent, targetRegionFrom);

    }

    /**
     * 使用绿色，区分标识，改方法用于驱动底层地图动画,比如打开dialog时，地图上移
     */
    private void showRlBottomAnimation() {
        float translationY = rlBottom.getTranslationY();
        switch (navStatus) {
            case NAV_STATUS_SHOW_REGION_INFO:  //点击目标，触发导航提示
                ObjectAnimator.ofFloat(rlBottom, "translationY", translationY, -DensityUtils.dp2px(context, 150))
                        .setDuration(300).start();
                break;
            case NAV_STATUS_SHOW_SEARCH_RESULT: //搜索结果
                ObjectAnimator.ofFloat(rlBottom, "translationY", translationY, -regionSearchDialog.getCurrentHeight())
                        .setDuration(300).start();
                break;
            case NAV_STATUS_SHOW_PRE_INFO:  //点击 去这里的操作，打开的dialog，触发的移动
                ObjectAnimator.ofFloat(rlBottom, "translationY", translationY, -DensityUtils.dp2px(context, 95))
                        .setDuration(300).start();
                break;
            case NAV_STATUS_NAVIGATING: //首次定位，弹出来分享的页面
                ObjectAnimator.ofFloat(rlBottom, "translationY", translationY, -DensityUtils.dp2px(context, 185))
                        .setDuration(300).start();
                break;
            case NAV_STATUS_FINISH:
                ObjectAnimator.ofFloat(rlBottom, "translationY", translationY, 0F)
                        .setDuration(300).start();
                break;
            case NAV_STATUS_DEFAULT:    //打开地图页面，默认打开的，显示当前位置和分享的 窗口
                float y = 0f;
                if (myLocationDialog != null) {
                    y = -myLocationDialog.getCurrentHeight();
                }
                ObjectAnimator.ofFloat(rlBottom, "translationY", translationY, y)
                        .setDuration(300).start();
                break;
        }
    }

    /**
     * 默认情况下点击一个区块的弹窗
     * @param show
     */
    private void showRegionDialog(boolean show) {
        if (show) {
            regionDialog.setRegionName(targetRegion.getName());
            String floorName = getString(R.string.epath_on_the);
            LocationRegion target = sails.getInBuildingName(targetRegion.getCenterLongitude(),
                    targetRegion.getCenterLatitude());
            if (target != null) {
                floorName += target.label;
            }
            floorName += convertFloorName(targetRegion.getFloorDescription());
            regionDialog.setFloorName(floorName);
            regionDialog.show(flMap);

        } else {
            regionDialog.dismiss();
        }
    }

    private String convertFloorName(String floorName){
        if(TextUtils.isEmpty(floorName)){
            return "";
        }
        return floorName.replace("L","Level ");
    }

    private void showRegionSearchDialog(boolean show) {
        if (regionSearchDialog == null) {
            return;
        }
        if (show) {
            regionSearchDialog.show();
        } else {
            regionSearchDialog.dismiss();
        }

    }

    private void showMyLocDialog(boolean show) {
        if (myLocationDialog == null) {
            return;
        }
        if (!isLocationFix()) {
            myLocationDialog.dismiss();
            return;
        }
        if (show) {
            myLocationDialog.setShareLocEnable(!isNoRealTimeShare);
            myLocationDialog.show();
        } else {
            myLocationDialog.dismiss();
        }

    }

    private void showLocShareDialog(boolean show) {
        if (locShareDialog == null) {
            return;
        }
        if (show) {
            locShareDialog.show(flMap);
            rlTop.setVisibility(View.INVISIBLE);
        } else {
            locShareDialog.dismiss();
            ivShare.setVisibility(View.GONE);
            rlTop.setVisibility(View.VISIBLE);
        }

    }

    private void showNavPreDialog(boolean show) {
        if (show) {
            if (startRegion == PathRoutingManager.MY_LOCATION && isLocationFix()) {
                navPreBottomDialog.setBtnNavEnable(true);
                navPreTopDialog.setStartRegion(getString(R.string.epath_my_location));
                navPreTopDialog.setStartFloor(sails.getFloorDescription(sails.getFloor()));
            } else {
                if (startRegion != null) {
                    navPreBottomDialog.setBtnNavEnable(false);
                }
                navPreTopDialog.setStartRegion(startRegion);
            }
            if (isLocationFix() && startRegion != null) {
                navPreBottomDialog.setBtnNavEnable(true);
            }

            navPreTopDialog.setTargetRegion(targetRegion);
            navPreTopDialog.show(flMap);
            navPreBottomDialog.show(flMap);
            rlTop.setVisibility(View.INVISIBLE);

            showFindOrStopView(View.GONE);
            ivRepunchClock.setVisibility(View.GONE);

            if (flagIsFindCaring) {
                navPreTopDialog.setEnableStartRegion(false);
                navPreTopDialog.setEnableTargetRegion(false);
                navPreTopDialog.setExchangeVisibel(false);
            } else {
                navPreTopDialog.setEnableStartRegion(true);
                navPreTopDialog.setEnableTargetRegion(true);
                navPreTopDialog.setExchangeVisibel(true);
            }

        } else {
            navPreTopDialog.dismiss();
            navPreBottomDialog.dismiss();
            rlTop.setVisibility(View.VISIBLE);
        }

    }

    /**
     * 展示导航底部的图片
     *
     * @param show
     */
    private void showNavDialog(boolean show) {
        if (show) {
            navTopDialog.show(flMap);
            ivTrumpet.setVisibility(View.VISIBLE);
//            navBottomDialog.show(flMap);
            navBottomNewDialog.show(flMap);

            String targetRegionText = "";
            String floorText = "";
            String addressName = "";
            if (targetRegion != null && sails.getInBuildingName(targetRegion.getCenterLongitude(), targetRegion.getCenterLatitude()) != null) {
                LocationRegion locationRegion = sails.getInBuildingName(targetRegion.getCenterLongitude(), targetRegion.getCenterLatitude());
                targetRegionText += locationRegion.label;
                floorText = locationRegion.getFloorDescription();
                addressName = locationRegion.label;
            }
            /**
             * 设置目的名称
             */
            if (targetRegion != null) {
                targetRegionText += targetRegion.getName();
                floorText = targetRegion.getFloorDescription();
                addressName = targetRegion.label;
//                targetRegionText += targetRegion.getFloorDescription() + " " + targetRegion.getName();
            }
//            navBottomDialog.setTarget(targetRegionText);
            navBottomNewDialog.setBourn(floorText, addressName);
            navTopDialog.setBourn(getString(R.string.epath_destination_in) + targetRegionText);
            rlTop.setVisibility(View.INVISIBLE);
        } else {
            navTopDialog.dismiss();
            ivTrumpet.setVisibility(View.GONE);
//            navBottomDialog.dismiss();
            navBottomNewDialog.dismiss();
            ivTrumpet.setImageResource(R.drawable.ic_trumpet_open);
            ivTrumpet.setContentDescription(getString(R.string.epath_turn_off_voice));

            rlTop.setVisibility(View.VISIBLE);
        }
    }

    private void showNavFinishDialog(boolean show) {
        if (show) {
            if(isPreview){
                controlAr();
            }
            showNavDialog(false);
            rlTop.setVisibility(View.INVISIBLE);
            if(isShowFinishDialog) {
                navFinishTopDialog.show(flMap);
                navFinishBottomDialog.show();
            }else{

                        if(tvAccessbilityNavigation != null) {
                            if(navMode == NAV_MODE_SIMULATION){
                                tvAccessbilityNavigation.setText(getString(R.string.epath_nav_reach_simu));
                            }else{
                                tvAccessbilityNavigation.setText(getString(R.string.epath_nav_reach_real));
                            }
                            if(btnAccessbilityExit!=null){
                                btnAccessbilityExit.setOnClickListener(new View.OnClickListener() {
                                    @Override
                                    public void onClick(View v) {
                                        hideAccessbilityNavigation();
                                        mHandler.postDelayed(new Runnable() {
                                            @Override
                                            public void run() {
                                                updateFeedBack(true);
                                                onBackPressed();
                                            }
                                        },500);
                                    }
                                });
                            }
                        }else{
                            mHandler.postDelayed(new Runnable() {
                                @Override
                                public void run() {
                            updateFeedBack(true);
                            onBackPressed();
                                }
                                },500);

                    }


            }
            ivTrumpet.setImageResource(R.drawable.ic_trumpet_open);
            ivTrumpet.setContentDescription(getString(R.string.epath_turn_off_voice));
            isVolumeOn = true;
            ivCompass.setVisibility(View.GONE);
//            navFinishTopDialog.setDistanceAndTime("距离" + totalDistance + "米  耗时" + EpUtils.getTimeStr(countTime));
            navFinishBottomDialog.setDistanceAndTime(getString(R.string.epath_nav_finish_distance_hint,totalDistance), getString(R.string.epath_using_time) + EpUtils.getDistanceTime(countTime));
        } else {
            navFinishTopDialog.dismiss();
            navFinishBottomDialog.dismiss();
            ivCompass.setVisibility(View.VISIBLE);
        }
    }

    private void updateNavMode() {
        if (sails != null && sailsMapView != null) {
            switch (navMode) {
                case NAV_MODE_SIMULATION:
                    sails.setMode(SAILS.SIMULATION | SAILS.WITH_GPS);
                    break;
                case NAV_MODE_BLE_GPS:
                    sails.setMode(SAILS.BLE_GFP_IMU | SAILS.WITH_GPS);
                    break;
                case NAV_MODE_WIFI_GPS:
                    sails.setMode(SAILS.WIFI_GFP_IMU | SAILS.WITH_GPS);
                    break;
            }
            sailsMapView.setLocatorMarkerVisible(true);
            if (sails.isInThisBuilding()) {
                sailsMapView.setMode(SAILSMapView.LOCATION_CENTER_LOCK | SAILSMapView.FOLLOW_PHONE_HEADING);
            } else {
                sailsMapView.setMode(SAILSMapView.GENERAL);
            }
        }
    }

    private void setLocSharingDefault() {
        targetRegion = null;
        startRegion = null;
        if (pathRoutingManager != null) {
            pathRoutingManager.disableHandler();
        }
        if (overlayItems != null) {
            overlayItems.clear();
        }
        if (markerManager != null) {
            markerManager.clear();
        }
        sailsMapView.setLocationMarker(R.drawable.loc_point_sector, R.drawable.loc_point_sector, null, 75);
        navMode = NAV_MODE_BLE_GPS;
        if (project != null && project.isWiFi()) {
            navMode = NAV_MODE_WIFI_GPS;
        }
        updateNavMode();
        isFirstLocationFix = true;
        if (floorNumbers.size() > 1) {
            wheelPicker.setVisibility(View.VISIBLE);
            wheelPicker.setSelectedItemPosition(getPositionByFloorName(project.getFloorName()));
        }
        if (!isLocationFix()) {
            sailsMapView.loadFloorMap(project.getFloorName());
            sailsMapView.getMapViewPosition().setZoomLevel(Float.parseFloat(project.getZoom() + ""));
            sailsMapView.setAnimatingToRotationAngle((float) project.getAngle());
            moveMaptoCenter();
        }
        showLocShareDialog(true);
    }

    @Override
    public void onBackPressed() {
        switch (navStatus) {
            case NAV_STATUS_SHOW_REGION_INFO:
                navStatus = NAV_STATUS_DEFAULT;
                if (isLocationSharing) {
                    showRegionDialog(false);
                    setLocSharingDefault();
                    showRlBottomAnimation();
                } else {
                    isDoNotReset = true;
                    updateNavStatus();
                }
                break;
            case NAV_STATUS_SHOW_SEARCH_RESULT:
                navStatus = NAV_STATUS_DEFAULT;
                updateNavStatus();
                break;
            case NAV_STATUS_SHOW_PRE_INFO:
                if (flagIsFindCaring) {
                    flagIsFindCaring = false;
                }
                navStatus = NAV_STATUS_DEFAULT;
                if (isLocationSharing) {
                    showNavPreDialog(false);
                    setLocSharingDefault();
                    showRlBottomAnimation();
                } else {
                    updateNavStatus();
                }
                break;
            case NAV_STATUS_NAVIGATING:
            case NAV_STATUS_NAVIGATING_PAUSE:
                if (navMode == NAV_MODE_SIMULATION) {
                    cancelCenterLockTimerTask();
                    navStatus = NAV_STATUS_NAVIGATING_PAUSE;
//                    navBottomDialog.pause();
                    navBottomNewDialog.pause();
                }
                confirmExitNavDialog = new ConfirmDialog(context, getString(R.string.epath_confirm_exit_navigation), (dialog, which) -> {
                    if (navStatus == NAV_STATUS_NAVIGATING || navStatus == NAV_STATUS_NAVIGATING_PAUSE) {
                        sendNavigationEvent();
                    }
                    navStatus = NAV_STATUS_DEFAULT;
                    if (isLocationSharing) {
                        wheelPicker.setVisibility(View.VISIBLE);
                        navTopDialog.dismiss();
                        ivTrumpet.setVisibility(View.GONE);
//                        navBottomDialog.dismiss();
                        navBottomNewDialog.dismiss();
                        ivTrumpet.setImageResource(R.drawable.ic_trumpet_open);
                        ivTrumpet.setContentDescription(getString(R.string.epath_turn_off_voice));
                        setLocSharingDefault();
                        showRlBottomAnimation();
                    } else {
                        updateNavStatus();
                    }
                }, (dialog, which) -> {
                    navStatus = NAV_STATUS_NAVIGATING;
                    updateNavStatus();
                });
                break;
            case NAV_STATUS_FINISH:
                navStatus = NAV_STATUS_DEFAULT;
                if (isLocationSharing) {
                    wheelPicker.setVisibility(View.VISIBLE);
                    showNavFinishDialog(false);
                    setLocSharingDefault();
                    showRlBottomAnimation();
                } else {
                    updateNavStatus();
                }
                break;
            case NAV_STATUS_DEFAULT:
            default:
                if (shareDialog != null && shareDialog.isShowing()) {
                    shareDialog.dismiss();
                    return;
                }
                if (isLocationSharing) {
                    new ConfirmDialog(context, getString(R.string.epath_confirm_exit_group), (dialog, which) -> {
                        if (mLocationShare != null) {
                            mLocationShare.put(LocationShare.IS_QUIT, true);
                            mLocationShare.saveInBackground(e -> {
                                T.showShort(R.string.epath_stop_loc_share);
                                navStatus = NAV_STATUS_DEFAULT;
                                updateNavStatus();
                            });
                        } else {
                            T.showShort(R.string.epath_stop_loc_share);
                            navStatus = NAV_STATUS_DEFAULT;
                            updateNavStatus();
                        }
                    }, (dialog, which) -> {
                    });
                    return;
                }
//                new ConfirmDialog(context, getString(R.string.epath_confirm_exit_map), (dialog, which) -> {
//                    finish();
//                }, (dialog, which) -> {
//                    dialog.dismiss();
//                });
                finish();
                break;
        }
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.iv_back) {
            onBackPressed();
            return;
        }
        if (project == null || sails == null || sailsMapView == null) {
            return;
        }
        if (v.getId() == R.id.iv_compass) {
            sailsMapView.setAnimatingToRotationAngle(0);
            sailsMapView.setMode(SAILSMapView.GENERAL);
        } else if (v.getId() == R.id.iv_zoom_in) {
            sailsMapView.zoomIn();
        } else if (v.getId() == R.id.iv_zoom_out) {
            sailsMapView.zoomOut();
        } else if (v.getId() == R.id.et_search) {
            if (isLocationSharing || pathRoutingManager == null) {
                return;
            }
            etSearch.setText("");
            navStatus = NAV_STATUS_DEFAULT;
            if (overlayItems != null) {
                overlayItems.clear();
            }
            if (markerManager != null) {
                markerManager.clear();
            }
            showRegionDialog(false);
            showRegionSearchDialog(false);
            showRlBottomAnimation();
            isStartSearchActivity = true;


            startActivityForResult(com.shitu.epathmap.ui.activity.EpSearchActivity.getIntent(context, project.getObjectId(),
                    com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET), REQUEST_EP_SEARCH);
        } else if (v.getId() == R.id.iv_search) {
            if (isLocationSharing || pathRoutingManager == null) {
                return;
            }
            CrashReport.testJavaCrash();
            if (hasPermission(Manifest.permission.WRITE_EXTERNAL_STORAGE, Manifest.permission.RECORD_AUDIO)) {
                startSpeechDialig();
            } else {
                requestPermission(MY_PERMISSIONS_REQUEST_ACCESS_FINE_WRITE_SD_AND_RECORD_AUDIO, Manifest.permission.WRITE_EXTERNAL_STORAGE, Manifest.permission.RECORD_AUDIO);
            }
        } else if (v.getId() == R.id.iv_lock_center || v.getId() == R.id.iv_back_position) {
            onClickChangeMode();
        } else if (v.getId() == R.id.iv_share) {
            if (isLocationSharing) {
                String url = Constants.SHARE_URL + "?map_id=" + project.getObjectId() + "&group_id="
                        + mLocationShare.getGroupId() + "&app_name=" + Constants.getAppName(context) + "&pkg_name=" +
                        getPackageName() + "&scheme=" + EpathMapSDK.app.getScheme();
                String title = Constants.SHARE_LOC_TITLE;
                String description = project.getName();
                shareDialog = new ShareDialog(context, url, title, description, null, ShareDialog.TYPE_LOC_SHARE, v0 -> {
                    showRlBottomAnimation();
                });
                shareDialog.show(flMap);
                ObjectAnimator.ofFloat(rlBottom, "translationY", rlBottom.getTranslationY(), -shareDialog.getHeight())
                        .setDuration(300).start();
            }
        } else if (v.getId() == R.id.iv_footprint) {
            if (project != null) {
                com.shitu.epathmap.ui.activity.EpFootprintActivity.start(context, project.getObjectId());
            }
        } else if (v.getId() == R.id.iv_loc_share) {
            if (navStatus == NAV_STATUS_DEFAULT) {
                new LocShareJoinDialog(context, groupId -> {
                    presenter.queryGroupInfo(project.getObjectId(), groupId);
                    if (myLocationDialog != null) {
                        myLocationDialog.dismiss();
                    }
                }, dismiss -> {
                    navStatus = NAV_STATUS_DEFAULT;
                    updateNavStatus();
                }).show();
            }
        } else if(v.getId() == R.id.tv_ar){
            if(hasPermission(Manifest.permission.CAMERA)){

                controlAr();

            }else{
                requestPermission(MY_PERMISSIONS_REQUEST_CAMERA,Manifest.permission.CAMERA);
            }
        } else if(v.getId() == R.id.btn_change_height){
            doMapExpend(!isExpend);
        } else if(v.getId() == R.id.fl_real_view){
            if(isPreview){
                if(navBottomNewDialog.isShowing()) {
                    navBottomNewDialog.dismiss();
                }else{
                    navBottomNewDialog.show(flMap);
                }

            }
        }
    }


    /**
     * 控制地图高度
     */
    private void doMapExpend(boolean expand) {
        if(isMapExpending  ||  expand == isExpend){
            return;
        }

//        int baseBottomMargin = (int) DeviceUtils.dpToPixel(this, 128);

        if(!isExpend){

            ValueAnimator animator = ValueAnimator.ofInt(maxTopClip, 0);
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
                @Override
                public void onAnimationUpdate(ValueAnimator animation) {
                    Integer currentValue = (Integer) animation.getAnimatedValue();

                    slMap.setTopClipMargin(currentValue);

//                    FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams) flRealViewCompass.getLayoutParams();
//                    lp.bottomMargin = baseBottomMargin + (maxTopClip - currentValue);
//                    flRealViewCompass.requestLayout();

                }
            });

            animator.addListener(new Animator.AnimatorListener() {
                @Override
                public void onAnimationStart(Animator animation) {

                }

                @Override
                public void onAnimationEnd(Animator animation) {
                    isMapExpending = false;
                    isExpend = true;
                }

                @Override
                public void onAnimationCancel(Animator animation) {

                }

                @Override
                public void onAnimationRepeat(Animator animation) {

                }
            });
            animator.setDuration(2000);

            if(isMapExpending){
                return;
            }

            isMapExpending = true;

            animator.start();


        }else{

            ValueAnimator animator = ValueAnimator.ofInt(0, maxTopClip);
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
                @Override
                public void onAnimationUpdate(ValueAnimator animation) {
                    Integer currentValue = (Integer) animation.getAnimatedValue();

                    slMap.setTopClipMargin(currentValue);

//                    FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams) flRealViewCompass.getLayoutParams();
//                    lp.bottomMargin = baseBottomMargin + (maxTopClip - currentValue);
//                    flRealViewCompass.requestLayout();

                }
            });

            animator.addListener(new Animator.AnimatorListener() {
                @Override
                public void onAnimationStart(Animator animation) {

                }

                @Override
                public void onAnimationEnd(Animator animation) {
                    isMapExpending = false;
                    isExpend = false;
                }

                @Override
                public void onAnimationCancel(Animator animation) {

                }

                @Override
                public void onAnimationRepeat(Animator animation) {

                }
            });

            animator.setDuration(2000);

            if(isMapExpending){
                return;
            }

            isMapExpending = true;

            animator.start();

        }
    }

    /**
     * 控制实景导航开关
     */
    private void controlAr() {
        if(isPreview || tvAr.getVisibility() == View.GONE){

            flRealView.setVisibility(View.GONE);

            isPreview = false;

            navBottomNewDialog.showControls(true);

            slMap.setOpenClip(false);
            slMap.setIsOpenIntercept(false);

            isMapExpending = false;
            isExpend = false;


            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) slMap.getLayoutParams();
            params.topMargin = 0;
            params.bottomMargin = 0;

//            int baseBottomMargin = (int) DeviceUtils.dpToPixel(this, 96);
//            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams) flRealViewCompass.getLayoutParams();
//            lp.bottomMargin = baseBottomMargin;
//            flRealViewCompass.requestLayout();




            tvAr.setTextColor(getResources().getColor(R.color.colorPrimary));
            tvAr.setText(getString(R.string.epath_open_outdoor_scene));
            tvAr.setBackground(getResources().getDrawable(R.drawable.epath_border_white_circle));

            if(!(navBottomNewDialog.isShowing())){
                navBottomNewDialog.show(flMap);
            }

//            guideLineView.stopDraw();

            ivCompass.setVisibility(View.VISIBLE);
            rlScale.setVisibility(View.VISIBLE);
            ivTrumpet.setVisibility(View.VISIBLE);
            ivLockCenter.setVisibility(View.VISIBLE);
            ivZoomOut.setVisibility(View.VISIBLE);
            ivZoomIn.setVisibility(View.VISIBLE);

        }else {

            navBottomNewDialog.showControls(false);

            tvAr.setTextColor(Color.WHITE);
            tvAr.setText(getString(R.string.epath_close_outdoor_scene));
            tvAr.setBackground(getResources().getDrawable(R.drawable.epath_border_red_circle));


            maxTopClip = (int) DeviceUtils.dpToPixel(this, 88);
            slMap.setOpenClip(true);
            slMap.setIsOpenIntercept(true);
            slMap.setTopClipMargin(maxTopClip);

            int topMargin = (int) DeviceUtils.dpToPixel(this, 328);
//            int bottomMargin = (int) DeviceUtils.dpToPixel(this, 72);

            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) slMap.getLayoutParams();
            params.topMargin = topMargin;
//            params.bottomMargin = bottomMargin;



            flRealView.setVisibility(View.VISIBLE);


            ImageLoader.loadGif(this,R.drawable.gif_derection,ivDerection);

            ivCompass.setVisibility(View.GONE);
            rlScale.setVisibility(View.GONE);
            ivTrumpet.setVisibility(View.GONE);
            ivLockCenter.setVisibility(View.GONE);
            ivZoomOut.setVisibility(View.GONE);
            ivZoomIn.setVisibility(View.GONE);

//            guideLineView.startDraw(sailsMapView);


            if (sailsMapView.isCenterLock()) {
                if ((sailsMapView.getMode() & SAILSMapView.FOLLOW_PHONE_HEADING) != SAILSMapView.FOLLOW_PHONE_HEADING) {
                    //if map control mode is follow phone heading, then set mode to location center lock when button click.
                    if (navStatus != NAV_STATUS_SHOW_SEARCH_RESULT) {
                        sailsMapView.setMode(sailsMapView.getMode() | SAILSMapView.FOLLOW_PHONE_HEADING);
                    }
                }
            }

            sailsMapView.setAnimationToZoom(22);

            isPreview = true;
        }
    }

    private boolean isPreview;


    private void onClickChangeMode() {
        myLocationOverlayItems.clear();
        if (!sails.isInThisBuilding()) {
            T.showShort(R.string.epath_not_in_this_building);
            sailsMapView.setMode(SAILSMapView.GENERAL);
            return;
        }
        if (sailsMapView.isCenterLock()) {
            if ((sailsMapView.getMode() & SAILSMapView.FOLLOW_PHONE_HEADING) == SAILSMapView.FOLLOW_PHONE_HEADING) {
                //if map control mode is follow phone heading, then set mode to location center lock when button click.
                sailsMapView.setMode(sailsMapView.getMode() & ~SAILSMapView.FOLLOW_PHONE_HEADING);
            } else {
                if (navStatus != NAV_STATUS_SHOW_SEARCH_RESULT) {
                    sailsMapView.setMode(sailsMapView.getMode() | SAILSMapView.FOLLOW_PHONE_HEADING);
                }
            }
        } else {
            //if map control mode is none, then set mode to loction center lock when button click.
            sailsMapView.setMode(sailsMapView.getMode() | SAILSMapView.LOCATION_CENTER_LOCK);
        }
    }

    private ArrayList<LocationRegionData> getAllRegionList() {
        ArrayList<LocationRegionData> AllLocationRegionList = new ArrayList<>();
        List<String> floorNameList = sails.getFloorNameList();
        if (floorNameList != null) {
            for (int i = 0; i < floorNameList.size(); i++) {
                String s = floorNameList.get(i);
                List<LocationRegion> locationRegionList = sails.getLocationRegionList(s);
                if (locationRegionList != null) {
                    for (LocationRegion locationRegion : locationRegionList) {
                        String buildingName = "";
                        if (sails.getInBuildingName(locationRegion.getCenterLongitude(), locationRegion.getCenterLatitude()) != null) {
                            buildingName = sails.getInBuildingName(locationRegion.getCenterLongitude(), locationRegion.getCenterLatitude()).label;
                        }
                        if (locationRegion.type != null) {
                            String type = locationRegion.type;
                            if (type.equals("freedom") || type.equals("boundary") || type.equals("lock")) {
                                continue;
                            }
                        }
                        LocationRegionData locationRegionData = new LocationRegionData(locationRegion.getName(), buildingName,
                                locationRegion.getFloorName(), locationRegion.type, locationRegion.subtype,
                                locationRegion.getCenterLongitude(), locationRegion.getCenterLatitude());
                        AllLocationRegionList.add(locationRegionData);
                    }
                }
            }

        }
        if (AllLocationRegionList.size() == 0) {
            AllLocationRegionList = DataHolder.getInstance().getLocationRegions();
        }
        return AllLocationRegionList;
    }

    //显示poi
    private void showSearchResult(LocationRegionData regionData, String type, boolean fromShare) {
        LocationRegion locationRegion = new LocationRegion(regionData.getName(),
                regionData.getLongitude(), regionData.getLatitude(), regionData.getFloorName(), sails);
        if (type.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_START) && targetRegion != null &&
                regionData.getLatitude() == targetRegion.getCenterLatitude() &&
                regionData.getLongitude() == targetRegion.getCenterLongitude()) {
            T.showShort(R.string.epath_cannot_same_target);
            return;
        }
        if (type.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET) && startRegion != null &&
                regionData.getLatitude() == startRegion.getCenterLatitude() &&
                regionData.getLongitude() == startRegion.getCenterLongitude()) {
            T.showShort(R.string.epath_cannot_same_target);
            return;
        }
        if (type.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET)) {
            List<LocationRegion> locationRegions = new ArrayList<>();
            locationRegions.add(locationRegion);
            initTargetLocationRegion(locationRegions, fromShare);
            if (startRegion != null) {
                setStartLocationRegionMarker(startRegion);
            }
            navPreTopDialog.setTargetRegion(targetRegion);
            if (navStatus == NAV_STATUS_DEFAULT || navStatus == NAV_STATUS_SHOW_REGION_INFO) {
                navStatus = NAV_STATUS_SHOW_REGION_INFO;
                updateNavStatus();
                showRlBottomAnimation();
            } else if (navStatus == NAV_STATUS_SHOW_PRE_INFO) {
                navStatus = NAV_STATUS_SHOW_PRE_INFO;
                updateNavStatus();
                showRlBottomAnimation();
            }
        } else if (type.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_START)) {
            overlayItems.clear();
            markerManager.clear();
            setStartLocationRegionMarker(locationRegion);
            showPathRoute();
            wheelPicker.setSelectedItemPosition(getPositionByFloorName(getRegionFloorName(startRegion)));
            navPreTopDialog.setStartFloor(getRegionFloorDescription(startRegion));
            if (getString(R.string.epath_my_position).equals(startRegion.getName())) {
                navPreBottomDialog.setBtnNavEnable(true);
            } else {
                navPreBottomDialog.setBtnNavEnable(false);
            }
            navPreTopDialog.setStartRegion(startRegion.getName());

        }
    }

    //显示搜寻列表pois
    private void showSearchResult(List<LocationRegionData> regionDatas, int centerPosition) {
        if ((navStatus == NAV_STATUS_DEFAULT || navStatus == NAV_STATUS_SHOW_REGION_INFO ||
                isLocationSharing) && startRegion == null) {
            if (regionDatas != null && regionDatas.size() >= 0) {
                overlayItems.clear();
                markerManager.clear();
                if (centerPosition >= 0) {
                    LocationRegionData regionData = regionDatas.get(centerPosition);
                    sailsMapView.setMode(SAILSMapView.GENERAL);
                    if (!regionData.getFloorName().equals(sailsMapView.getCurrentBrowseFloorName())) {
                        wheelPicker.setSelectedItemPosition(getPositionByFloorName(regionData.getFloorName()));
                        sailsMapView.loadFloorMap(regionData.getFloorName());
                        sailsMapView.getMapViewPosition().setZoomLevel(Float.parseFloat(project.getNavigationZoom() + ""));
                    }
                    sailsMapView.setAnimationMoveMapTo(new GeoPoint(regionData.getLatitude(), regionData.getLongitude()));
                }
                for (LocationRegionData regionData : regionDatas) {
                    if (regionData.getFloorName().equals(sailsMapView.getCurrentBrowseFloorName())) {
                        GeoPoint geoPoint = new GeoPoint(regionData.getLatitude(), regionData.getLongitude());
                        Drawable drawable = getResources().getDrawable(R.drawable.loc_point_friend);
                        Marker marker = new Marker(geoPoint, Marker.boundCenterBottom(drawable));
                        overlayItems.add(marker);

                    }
                }
                if (sailsMapView.getDynamicOverlays().contains(listOverlay)) {
                    sailsMapView.getDynamicOverlays().remove(listOverlay);
                }
                sailsMapView.getDynamicOverlays().add(listOverlay);
            }
        }

    }

    //显示位置共享markers
    private void showLocShareMarker(List<LocationRegionData> regionDatas, int centerPosition) {
        if ((navStatus == NAV_STATUS_DEFAULT || navStatus == NAV_STATUS_SHOW_REGION_INFO) && isLocationSharing) {
            if (regionDatas != null && regionDatas.size() >= 0) {
                overlayItems.clear();
                markerManager.clear();
                if (centerPosition >= 0) {
                    LocationRegionData regionData = regionDatas.get(centerPosition);
                    sailsMapView.setMode(SAILSMapView.GENERAL);
                    if (!regionData.getFloorName().equals(sailsMapView.getCurrentBrowseFloorName())) {
                        wheelPicker.setSelectedItemPosition(getPositionByFloorName(regionData.getFloorName()));
                        sailsMapView.loadFloorMap(regionData.getFloorName());
                        sailsMapView.getMapViewPosition().setZoomLevel(Float.parseFloat(project.getNavigationZoom() + ""));
                    }
                    sailsMapView.setAnimationMoveMapTo(new GeoPoint(regionData.getLatitude(), regionData.getLongitude()));
                }
                for (int i = 0; i < regionDatas.size(); i++) {
                    LocationRegionData regionData = regionDatas.get(i);
                    if (regionData.getLatitude() == 0 || regionData.getLongitude() == 0) {
                        continue;
                    }
                    Drawable drawable = getResources().getDrawable(R.drawable.loc_point_other);
                    int color = getResources().getColor(R.color.tvOrg1);
                    if (regionData.isActive() && !regionData.getFloorName().equals(sailsMapView.getCurrentBrowseFloorName())) {
                        drawable = getResources().getDrawable(R.drawable.loc_point_other_translucent);
                        color = getResources().getColor(R.color.tvOrgTranslucent);
                    } else if (!regionData.isActive() && regionData.getFloorName().equals(sailsMapView.getCurrentBrowseFloorName())) {
                        drawable = getResources().getDrawable(R.drawable.loc_point_other_offline);
                        color = getResources().getColor(R.color.tvGrey3);
                    } else if (!regionData.isActive() && !regionData.getFloorName().equals(sailsMapView.getCurrentBrowseFloorName())) {
                        drawable = getResources().getDrawable(R.drawable.loc_point_other_offline_translucent);
                        color = getResources().getColor(R.color.tvGreyTranslucent);
                    }
                    Marker marker = new Marker(new GeoPoint(regionData.getLatitude(), regionData.getLongitude()),
                            Marker.boundCenter(drawable));
                    TextPaint textPaintName = new TextPaint();
                    textPaintName.setAntiAlias(true);
                    textPaintName.setTextSize(DensityUtils.dp2px(context, 12));
                    textPaintName.setTextAlign(Paint.Align.CENTER);
                    textPaintName.setColor(color);
                    String name = regionData.getName();
                    if (name.length() > 4) {
                        name = name.substring(0, 3) + "...";
                    }
                    name += "(" + regionData.getFloorName() + "F)";
                    TextOverlay textOverlayName = new TextOverlay(new GeoPoint(regionData.getLatitude(), regionData.getLongitude()),
                            name + " -  -  -  -  -  -  -  ", textPaintName, textPaintName);
                    overlayItems.add(marker);
                    overlayItems.add(textOverlayName);
                }
                if (sailsMapView.getDynamicOverlays().contains(listOverlay)) {
                    sailsMapView.getDynamicOverlays().remove(listOverlay);
                }
                sailsMapView.getDynamicOverlays().add(listOverlay);
            }
        }

    }

    private void showSearchResultByFloor(String currentFloor) {
        if (searchResult == null || searchResult.size() == 0) {
            return;
        }
        if (currentFloor.contains("F")) {
            currentFloor = currentFloor.replace("F", "");
        }
        if (overlayItems != null) {
            overlayItems.clear();
        }
        if (markerManager != null) {
            markerManager.clear();
        }
        //显示搜索结果点
        for (int i = 0; i < searchResult.size(); i++) {
            LocationRegionData regionData0 = searchResult.get(i);
            if (regionData0.getFloorName().equals(currentFloor)) {
                GeoPoint geoPoint = new GeoPoint(regionData0.getLatitude(), regionData0.getLongitude());
                Drawable drawable = getResources().getDrawable(R.drawable.loc_point_search);
                Marker marker = new Marker(geoPoint, Marker.boundCenterBottom(drawable));
                overlayItems.add(marker);
            }
        }
        LocationRegionData lrData = searchResult.get(searchResultCheckPosition);
        if (lrData != null && lrData.getFloorName().equals(currentFloor)) {
            overlayItems.add(new Marker(new GeoPoint(lrData.getLatitude(), lrData.getLongitude()),
                    Marker.boundCenterBottom(getResources().getDrawable(R.drawable.loc_point_target))));
        }
        if (sailsMapView.getDynamicOverlays().contains(listOverlay)) {
            sailsMapView.getDynamicOverlays().remove(listOverlay);
        }
        sailsMapView.getDynamicOverlays().add(listOverlay);
    }

    private void showSearchResultCenter(int position, String type, boolean showPath) {
        if (searchResult == null || searchResult.size() == 0) {
            return;
        }
        searchResultCheckPosition = position;
        LocationRegionData regionData = searchResult.get(position);
        if (type.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_START) && targetRegion != null &&
                regionData.getLatitude() == targetRegion.getCenterLatitude() &&
                regionData.getLongitude() == targetRegion.getCenterLongitude()) {
            T.showShort(R.string.epath_cannot_same_target);
            return;
        }
        if (type.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET) && startRegion != null &&
                regionData.getLatitude() == startRegion.getCenterLatitude() &&
                regionData.getLongitude() == startRegion.getCenterLongitude()) {
            T.showShort(R.string.epath_cannot_same_target);
            return;
        }
        sailsMapView.setMode(SAILSMapView.GENERAL);
        //显示所有搜寻结果 并移动到选中locationRegion
        if (!showPath && (navStatus == NAV_STATUS_DEFAULT || navStatus == NAV_STATUS_SHOW_REGION_INFO ||
                navStatus == NAV_STATUS_SHOW_SEARCH_RESULT ||
                navStatus == NAV_STATUS_SHOW_PRE_INFO && !pathRoutingManager.isRoutingSuccess())) {
            if (!regionData.getFloorName().equals(sailsMapView.getCurrentBrowseFloorName())) {
                wheelPicker.setSelectedItemPosition(getPositionByFloorName(regionData.getFloorName()));
//                wheelPicker.setOnWheelChangeListener();
                sailsMapView.loadFloorMap(regionData.getFloorName());
                sailsMapView.getMapViewPosition().setZoomLevel(Float.parseFloat(project.getNavigationZoom() + ""));
            }
            if (overlayItems != null) {
                overlayItems.clear();
            }
            if (markerManager != null) {
                markerManager.clear();
            }
            //显示搜索结果点
            for (int i = 0; i < searchResult.size(); i++) {
                LocationRegionData regionData0 = searchResult.get(i);
                if (regionData0.getFloorName().equals(sailsMapView.getCurrentBrowseFloorName())) {
                    GeoPoint geoPoint = new GeoPoint(regionData0.getLatitude(), regionData0.getLongitude());
                    Drawable drawable = getResources().getDrawable(R.drawable.loc_point_search);
                    Marker marker = new Marker(geoPoint, Marker.boundCenterBottom(drawable));
                    overlayItems.add(marker);
                }
            }
            //显示已经确定的起始点目的地
            if (startRegion != null && startRegion.getFloorName().equals(sailsMapView.getCurrentBrowseFloorName())
                    && !(startRegion.getCenterLatitude() == regionData.getLatitude() &&
                    startRegion.getCenterLongitude() == regionData.getLongitude()) &&
                    type.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET)) {
                overlayItems.add(new Marker(new GeoPoint(startRegion.getCenterLatitude(), startRegion.getCenterLongitude()),
                        Marker.boundCenterBottom(getResources().getDrawable(R.drawable.loc_point_start))));
            }
            if (targetRegion != null && targetRegion.getFloorName().equals(sailsMapView.getCurrentBrowseFloorName())
                    && !(targetRegion.getCenterLatitude() == regionData.getLatitude() &&
                    targetRegion.getCenterLongitude() == regionData.getLongitude()) &&
                    type.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_START)) {
                overlayItems.add(new Marker(new GeoPoint(targetRegion.getCenterLatitude(), targetRegion.getCenterLongitude()),
                        Marker.boundCenterBottom(getResources().getDrawable(R.drawable.loc_point_target))));
            }
            //选中的起始点和目的地 防止覆盖 显示在最上层
            for (int i = 0; i < searchResult.size(); i++) {
                LocationRegionData regionData0 = searchResult.get(i);
                if (regionData0.getFloorName().equals(sailsMapView.getCurrentBrowseFloorName())) {
                    GeoPoint geoPoint = new GeoPoint(regionData0.getLatitude(), regionData0.getLongitude());
                    if (i == position && type.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_START)) {
                        Drawable drawable = getResources().getDrawable(R.drawable.loc_point_start);
                        Marker marker = new Marker(geoPoint, Marker.boundCenterBottom(drawable));
                        overlayItems.add(marker);
                    } else if (i == position && type.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET)) {
                        Drawable drawable = getResources().getDrawable(R.drawable.loc_point_target);
                        Marker marker = new Marker(geoPoint, Marker.boundCenterBottom(drawable));
                        overlayItems.add(marker);
                    }
                }
            }

            if (sailsMapView.getDynamicOverlays().contains(listOverlay)) {
                sailsMapView.getDynamicOverlays().remove(listOverlay);
            }
            sailsMapView.getDynamicOverlays().add(listOverlay);
            sailsMapView.setAnimationMoveMapTo(new GeoPoint(regionData.getLatitude(), regionData.getLongitude()));

        }
        //路径规划成功后地图移动到选择的locationRegion
        else if (!showPath && navStatus == NAV_STATUS_SHOW_PRE_INFO && pathRoutingManager.isRoutingSuccess()) {
            LocationRegion locationRegion = new LocationRegion(regionData.getName(),
                    regionData.getLongitude(), regionData.getLatitude(), regionData.getFloorName(), sails);
            if (type.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_START)) {
                overlayItems.clear();
                markerManager.clear();
                setStartLocationRegionMarker(locationRegion);
                showPathRoute();
                wheelPicker.setSelectedItemPosition(getPositionByFloorName(getRegionFloorName(startRegion)));
                navPreTopDialog.setStartFloor(getRegionFloorDescription(startRegion));
                if (startRegion.getName().equals(getString(R.string.epath_my_position))) {
                    navPreBottomDialog.setBtnNavEnable(true);
                } else {
                    navPreBottomDialog.setBtnNavEnable(false);
                }
                navPreTopDialog.setStartRegion(startRegion.getName());

            } else if (type.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET)) {
                List<LocationRegion> locationRegions = new ArrayList<>();
                locationRegions.add(locationRegion);
                initTargetLocationRegion(locationRegions, false);
                navPreTopDialog.setTargetRegion(targetRegion);
                wheelPicker.setSelectedItemPosition(getPositionByFloorName(targetRegion.getFloorName()));
                sailsMapView.loadFloorMap(targetRegion.getFloorName());
                new Handler().postDelayed(() -> {
                    sailsMapView.setMode(SAILSMapView.GENERAL);
                    int width = DensityUtils.getScreenWidth(context) - DensityUtils.dp2px(context, 160);
                    sailsMapView.autoSetMapZoomAndView(pathRoutingManager.getCurrentFloorRoutingPathNodes(), width);
                    sailsMapView.setRotationAngle((float) project.getAngle());
                }, 500);
//                sailsMapView.loadFloorMap(targetRegion.getFloorName());
//                sailsMapView.setAnimationMoveMapTo(new GeoPoint(targetRegion.getCenterLatitude(), targetRegion.getCenterLongitude()));
//                sailsMapView.getMapViewPosition().setZoomLevel(Float.parseFloat(project.getNavigationZoom() + ""));
                showMarkerAfterPathRoute();
            }

        }
        //1.显示路径规划结果 2.第一次设定目的地
        else if (showPath) {
            LocationRegion locationRegion = new LocationRegion(regionData.getName(),
                    regionData.getLongitude(), regionData.getLatitude(), regionData.getFloorName(), sails);
            if (type.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_START)) {
                overlayItems.clear();
                markerManager.clear();
                setStartLocationRegionMarker(locationRegion);
                showPathRoute();
                wheelPicker.setSelectedItemPosition(getPositionByFloorName(getRegionFloorName(startRegion)));
                navPreTopDialog.setStartFloor(getRegionFloorDescription(startRegion));
                if (startRegion.getName().equals(getString(R.string.epath_my_position))) {
                    navPreBottomDialog.setBtnNavEnable(true);
                } else {
                    navPreBottomDialog.setBtnNavEnable(false);
                }
                navPreTopDialog.setStartRegion(startRegion.getName());

            } else if (type.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET)) {
                List<LocationRegion> locationRegions = new ArrayList<>();
                locationRegions.add(locationRegion);
                initTargetLocationRegion(locationRegions, false);
                navPreTopDialog.setTargetRegion(targetRegion);
                navStatus = NAV_STATUS_SHOW_PRE_INFO;
                updateNavStatus();
                showRlBottomAnimation();
            }

        }
    }

    private void showPathAndFriend() {
        if (pathRoutingManager.isRoutingSuccess()) {
            overlayItems.clear();
            markerManager.clear();
            if (friendRegionData != null && sailsMapView.getCurrentBrowseFloorName().equals(friendRegionData.getFloorName())) {
                overlayItems.add(new Marker(new GeoPoint(friendRegionData.getLatitude(), friendRegionData.getLongitude()),
                        Marker.boundCenterBottom(getResources().getDrawable(R.drawable.loc_point_friend))));
            }
            if (getRegionFloorName(startRegion) != null && sailsMapView.getCurrentBrowseFloorName().equals(getRegionFloorName(startRegion))) {
                overlayItems.add(new Marker(new GeoPoint(startRegion.getCenterLatitude(), startRegion.getCenterLongitude()),
                        Marker.boundCenterBottom(getResources().getDrawable(R.drawable.loc_point_start))));
            }
            if (targetRegion != null && sailsMapView.getCurrentBrowseFloorName().equals(targetRegion.getFloorName())) {
                overlayItems.add(new Marker(new GeoPoint(targetRegion.getCenterLatitude(), targetRegion.getCenterLongitude()),
                        Marker.boundCenterBottom(getResources().getDrawable(R.drawable.loc_point_target))));
            }
            if (sailsMapView.getDynamicOverlays().contains(listOverlay)) {
                sailsMapView.getDynamicOverlays().remove(listOverlay);
            }
            sailsMapView.getDynamicOverlays().add(listOverlay);
        }


    }

    private int getRegionFloorNumber(LocationRegion startRegion) {
        if (startRegion == null)
            return Integer.MAX_VALUE;
        if (startRegion == PathRoutingManager.MY_LOCATION) {
            return sails.getFloorNumber();
        } else
            return startRegion.getFloorNumber();
    }

    private String getRegionFloorName(LocationRegion startRegion) {
        if (startRegion == null)
            return null;

        if (startRegion == PathRoutingManager.MY_LOCATION) {
            return sails.getFloor();
        } else {
            return startRegion.getFloorName();
        }
    }

    private String getRegionFloorDescription(LocationRegion startRegion) {
        if (startRegion == null) {
            return null;
        }


        if (startRegion == PathRoutingManager.MY_LOCATION) {
            return sails.getFloorDescription(sails.getFloor());
        } else {
            return startRegion.getFloorDescription();
        }
    }

    ArrayList<LocationRegionData> searchResult;
    int searchResultCheckPosition;

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == REQUEST_EP_SEARCH && resultCode == RESULT_OK) {
            if (data == null) {
                T.showShort(getString(R.string.epath_no_search_result_hint));
                return;
            }
            requestType = data.getStringExtra(REQUEST_TYPE);
            etSearch.setText(data.getStringExtra(RESULT_SEARCH_CONTENT));
            LocationRegionData regionData = data.getParcelableExtra(RESULT_SELECT_REGION);
            searchResult = data.getParcelableArrayListExtra(RESULT_SEARCH_RESULT);
            if (requestType.equals(RESULT_SELECT_MY_LOCATION)) {
                if (isLocationFix()) {
                    overlayItems.clear();
                    markerManager.clear();
                    setStartLocationRegionMarker(PathRoutingManager.MY_LOCATION);
                    showPathRoute();
                    wheelPicker.setSelectedItemPosition(getPositionByFloorName(getRegionFloorName(startRegion)));
                    navPreBottomDialog.setBtnNavEnable(true);
                    navPreTopDialog.setStartRegion(getString(R.string.epath_my_location));
                    navPreTopDialog.setStartFloor(sails.getFloorDescription(sails.getFloor()));
                }
                return;
            }
            if (regionData != null) {
                if (requestType.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET)) {
                    targetRegionFrom = MixpanelConstants.NAVIGATION_TARGET_FROM_SEARCH;
                }
                showSearchResult(regionData, requestType, false);
            } else if (searchResult != null && searchResult.size() > 0) {
                List<LocationRegion> locationRegions = new ArrayList<>();
                for (LocationRegionData item : searchResult) {
                    LocationRegion locationRegion = new LocationRegion(item.getName(),
                            item.getLongitude(), item.getLatitude(), item.getFloorName(), sails);
                    locationRegions.add(locationRegion);
                }
                List<LocationRegionData> sbsf = new ArrayList<>();//同楼同层
                List<LocationRegionData> sbdf = new ArrayList<>();//同楼不同层
                List<LocationRegionData> others = new ArrayList<>();
                if (isLocationFix()) {
                    locationRegions = sails.sortLocationRegionsByPathLength(locationRegions);
                    LocationRegion myLocLR = sails.getInBuildingName(sails.getLongitude(), sails.getLatitude());
                    //不在楼里面按距离排序 在楼里面同楼同层》同楼不同层》距离
                    for (int i = 0; i < locationRegions.size(); i++) {
                        LocationRegion lr = locationRegions.get(i);
                        LocationRegionData lrData = new LocationRegionData(lr.getName(), lr.getFloorName(),
                                lr.getCenterLongitude(), lr.getCenterLatitude());
                        lrData.setDistanceTemp(lr.updatedLength);
                        LocationRegion buildingLR = sails.getInBuildingName(lr.getCenterLongitude(), lr.getCenterLatitude());
                        if (buildingLR != null && buildingLR.label != null) {
                            lrData.setBuildingName(buildingLR.label);
                        }
                        if (buildingLR != null && buildingLR.label != null && myLocLR != null && myLocLR.label != null &&
                                myLocLR.label.equals(buildingLR.label) &&
                                sails.getFloor().equals(lrData.getFloorName())) {
                            sbsf.add(lrData);
                        } else if (buildingLR != null && buildingLR.label != null && myLocLR != null && myLocLR.label != null &&
                                myLocLR.label.equals(buildingLR.label) &&
                                !sails.getFloor().equals(lrData.getFloorName())) {
                            sbdf.add(lrData);
                        } else {
                            others.add(lrData);
                        }
                    }
                } else {
                    for (int i = 0; i < locationRegions.size(); i++) {
                        LocationRegion lr = locationRegions.get(i);
                        LocationRegionData lrData = new LocationRegionData(lr.getName(), lr.getFloorName(),
                                lr.getCenterLongitude(), lr.getCenterLatitude());
                        LocationRegion buildingLR = sails.getInBuildingName(lr.getCenterLongitude(), lr.getCenterLatitude());
                        if (buildingLR != null && buildingLR.label != null) {
                            lrData.setBuildingName(buildingLR.label);
                        }
                        others.add(lrData);
                    }
                }
                searchResult.clear();
                searchResult.addAll(sbsf);
                searchResult.addAll(sbdf);
                searchResult.addAll(others);
                if (searchResult.size() > 0 && isLocationFix()) {
                    searchResult.get(0).setFirst(true);
                    if (searchResult.get(0).getFloorName().equals(sails.getFloor())) {
                        searchResult.get(0).setSameFloor(true);
                    }
                }
                showSearchResultCenter(0, requestType, false);
                LinearLayout view = (LinearLayout) findViewById(R.id.ll_region_search);
                String goType = requestType.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_START) ? getApplicationContext().getResources().getString(R.string.epath_set_out) :
                        getApplicationContext().getResources().getString(R.string.epath_go_here);
                regionSearchDialog = new RegionSearchDialog(context, view,
                        searchResult, goType, position -> {
                    if (requestType.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET)) {
                        targetRegionFrom = MixpanelConstants.NAVIGATION_TARGET_FROM_SEARCH;
                    }
                    showSearchResultCenter(position, requestType, false);
                }, navPosition -> {
                    if (requestType.equals(com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET)) {
                        targetRegionFrom = MixpanelConstants.NAVIGATION_TARGET_FROM_SEARCH;
                    }
                    showSearchResultCenter(navPosition, requestType, true);
                });
                regionSearchDialog.setOnDismissListener(state -> {
                    switch (state) {
                        case BottomSheetBehavior.STATE_HIDDEN:
                            if (navStatus == NAV_STATUS_DEFAULT || navStatus == NAV_STATUS_SHOW_SEARCH_RESULT ||
                                    navStatus == NAV_STATUS_SHOW_REGION_INFO) {
                                navStatus = NAV_STATUS_DEFAULT;
                                updateNavStatus();
                            } else if (navStatus == NAV_STATUS_SHOW_PRE_INFO) {
                                showRlBottomAnimation();
                                overlayItems.clear();
                                markerManager.clear();
                                if (targetRegion != null) {
                                    List<LocationRegion> locationRegions0 = new ArrayList<>();
                                    locationRegions0.add(targetRegion);
                                    initTargetLocationRegion(locationRegions0, false);
                                }
                                if (startRegion != null) {
                                    setStartLocationRegionMarker(startRegion);
                                }
                                showPathRoute();
                                navPreBottomDialog.show(flMap);
                            }
                            break;
                        case BottomSheetBehavior.STATE_COLLAPSED:
                        case BottomSheetBehavior.STATE_EXPANDED:
                            showRlBottomAnimation();
                            break;

                    }
                });
                regionSearchDialog.show();
                if (navStatus == NAV_STATUS_SHOW_PRE_INFO) {
                    ObjectAnimator.ofFloat(rlBottom, "translationY", rlBottom.getTranslationY(), -regionSearchDialog.getCurrentHeight())
                            .setDuration(300).start();
                    navPreBottomDialog.gone();
                } else {
                    navStatus = NAV_STATUS_SHOW_SEARCH_RESULT;
                    updateNavStatus();
                }

            }
        }
    }

    private List<String> groupIds = new ArrayList<>(); //同一地图下24小时内创建的id号

    private boolean existedId(String groupId) {
        boolean isExisted = false;
        for (String id : groupIds) {
            if (id.equals(groupId)) {
                isExisted = true;
                break;
            }
        }
        return isExisted;
    }

    private String createGroupId() {
        String groupId = EpUtils.getRadomGroupId();
        while (existedId(groupId)) {
            groupId = EpUtils.getRadomGroupId();
        }
        return groupId;
    }

    private void createGroup() {
        if (!isLocationFix()) {
            T.showShort(R.string.epath_no_position_cannot_create_group);
            MixpanelEvent.locShareCreate(MixpanelConstants.LOC_SHARE_CREATE_RESULT_FAIL,
                    MixpanelConstants.LOC_SHARE_CREATE_RESULT_FAIL_PAGE_NAME);
            return;
        }
        presenter.query24hGroup(project.getObjectId());
    }

    private void updateGroup() {
        if (mLocationShare == null || !sails.isLocationEngineStarted()) {
            return;
        }
        if (isLocationFix()) {
            ParseGeoPoint parseGeoPoint = new ParseGeoPoint(sails.getLatitude(), sails.getLongitude());
            String floor = sails.getFloor();
            mLocationShare.put(LocationShare.FLOOR, floor);
            mLocationShare.put(LocationShare.LOCATION, parseGeoPoint);
            mLocationShare.put(LocationShare.IS_QUIT, false);
            mLocationShare.saveInBackground(e -> {
                if (e != null) {
                    e.printStackTrace();
                    return;
                }
            });
        }
    }

    @Override
    public void doSDCardAndRecordAudio() {
        startSpeechDialig();
    }

    public void startSpeechDialig() {
        navStatus = NAV_STATUS_DEFAULT;
        overlayItems.clear();
        markerManager.clear();
        showRegionDialog(false);
        showRegionSearchDialog(false);
        showRlBottomAnimation();
        startSpeechDialog(result -> {
            etSearch.setText("");
            presenter.queryPOIByContent(project.getObjectId(), result);
        });
    }

    private void exitGroup() {
        if (mLocationShare != null) {
            mLocationShare.put(LocationShare.IS_QUIT, true);
            mLocationShare.saveInBackground(e -> {
                if (e != null) {
                    e.printStackTrace();
                    T.showShort(e.toString());
                }
                EpUtils.clearClipboard(context);
                navStatus = NAV_STATUS_DEFAULT;
                updateNavStatus();
            });

        }
    }


    private void storyCarMessage(LocationRegionData locationRegionData) {
        //拼接对象
        CarCheckData carCheck = new CarCheckData();
        carCheck.setProject(project.getObjectId());
        carCheck.setRegionName(locationRegionData.getName());
        carCheck.setFloor(sails.getFloor());
        carCheck.setFinish(false);
        carCheck.setHasStop(true);
        carCheck.setCreateAt(new Date());
        carCheck.setUpdatedAt(new Date());
        if (locationRegionData != null) {
            carCheck.setLatitude(locationRegionData.getLatitude());
            carCheck.setLongitude(locationRegionData.getLongitude());
        } else {
            T.showShort(R.string.epath_open_failed);
        }
        SpUtils.setCarCheckDatas(context, new Gson().toJson(carCheck), project.getObjectId());
    }

    /**
     * 改变车信息
     */
    public void queryCarMessage() {
        String json = SpUtils.getCarCheckDatas(context, project.getObjectId());
        if (!TextUtils.isEmpty(json)) {
            CarCheckData carCheckData = new Gson().fromJson(json, CarCheckData.class);
            carCheckDatas = carCheckData;
        }
        queryCarCheckSuccess();
    }

    /**
     * 改变车图标的方法
     */

    public void queryCarCheckSuccess() {
        //自定义车的图标
        myCarLocationOverlayItems.clear();
        if (sailsMapView.getDynamicOverlays().contains(myCarLocationOverlay)) {
            sailsMapView.getDynamicOverlays().remove(myCarLocationOverlay);
        }

        if (carCheckDatas.getFinish() == false && carCheckDatas.isHasStop() == true) {
            // 没有结束 已经停车
            L.e("sssss1", "findcar");
//            ivFindOrStopCar.setImageDrawable(getResources().getDrawable(R.drawable.ic_findcar));
            ivFindOrStopCar.setImageResource(R.drawable.ic_findcar);
            ivRepunchClock.setVisibility(View.VISIBLE);
            showFindOrStopView(View.VISIBLE);
            showCarMarker();

        } else if (carCheckDatas.getFinish() == false && carCheckDatas.isHasStop() == false) {
            //false
            // 没有停车
            L.e("sssss2", "stopcar");
//            ivFindOrStopCar.setImageDrawable(getResources().getDrawable(R.drawable.dialog_stop_car));
            ivFindOrStopCar.setImageResource(R.drawable.ic_stop_car);
            ivRepunchClock.setVisibility(View.GONE);
            showFindOrStopView(View.VISIBLE);
//            ivFindOrStopCar.setVisibility(View.VISIBLE);
        }
    }



    public boolean isFindOrStopEnable() {
        return isFindOrStopEnable;
    }

    public void setFindOrStopEnable(boolean findOrStopEnable) {
        isFindOrStopEnable = findOrStopEnable;
    }

    public void showFindOrStopView(int visibility){
        if(isFindOrStopEnable){
            ivFindOrStopCar.setVisibility(visibility);
        }else{
            ivFindOrStopCar.setVisibility(View.GONE);
        }
    }

    private void showAccessbilityNavigation() {
        voiceManager.turnOff();
        View accessbilityView = LayoutInflater.from(this).inflate(R.layout.popup_accessibility_navigation, rlRoot, false);

        btnAccessbilityExit = accessbilityView.findViewById(R.id.btn_exit);
        btnAccessbilityExit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                hideAccessbilityNavigation();
            }
        });

        tvAccessbilityNavigation = accessbilityView.findViewById(R.id.tv_navigation_show);

        popupAccessbilityWindow = new PopupWindow(accessbilityView,ViewGroup.LayoutParams.MATCH_PARENT,ViewGroup.LayoutParams.MATCH_PARENT);
        popupAccessbilityWindow.setBackgroundDrawable(null);
        popupAccessbilityWindow.setFocusable(true);
        popupAccessbilityWindow.setOutsideTouchable(true);

        popupAccessbilityWindow.showAtLocation(rlRoot,Gravity.BOTTOM,0,0);
    }

    private void hideAccessbilityNavigation(){
        voiceManager.turnOn();
        if(popupAccessbilityWindow!=null){
            popupAccessbilityWindow.dismiss();
            popupAccessbilityWindow = null;
            tvAccessbilityNavigation = null;
            btnAccessbilityExit = null;
        }
    }


    /**
     * 获取用户方向与某个建筑物的方位角度
     */
    private double getDegreeDiff(double userHeading, SAILS.GeoNode userGeoNode, SAILS.GeoNode biildingGeoNode) {
        double bearAngle1 = SAILS.GetBearDegree(userGeoNode.longitude, userGeoNode.latitude, biildingGeoNode.longitude, biildingGeoNode.latitude);
        double bearDiff = bearAngle1 - userHeading;
        if (bearDiff < 0) {
            bearDiff += 360;
        }
        return bearDiff;
    }

    private String getNearestLocationRegion() {
        if(!sails.isInThisBuilding() || !isLocationFix()){
            return null;
        }
        List<LocationRegion> locationRegionList = sails.getCurrentInRegions();
        String lr;
        if (locationRegionList != null && locationRegionList.size() > 0) {
            LocationRegion locationRegion = locationRegionList.get(0);
            String type = locationRegion.type;
            if (type != null && (type.equals("freedom") || type.equals("boundary") || type.equals("lock"))) {
                lr = getNearestLocationRegionFromAll();
            } else {
                lr = locationRegionList.get(0).label;
            }
        } else {
            lr = getNearestLocationRegionFromAll();
        }
        return lr;
    }

    private String getNearestLocationRegionFromAll() {
        String lr = "";
        ArrayList<LocationRegion> allRegionList = getNearFloorRegionList();
        if (sails.isInThisBuilding() && allRegionList != null) {
            List<LocationRegion> locationRegions = sails.sortLocationRegionsByPathLength(allRegionList);
            if (locationRegions != null && locationRegions.size() > 0) {
                lr = locationRegions.get(0).label;
            }
        }
        return lr;
    }

    private ArrayList<LocationRegion> getNearFloorRegionList() {
        ArrayList<LocationRegion> AllLocationRegionList = new ArrayList<>();

                List<LocationRegion> locationRegionList = sails.getLocationRegionList(sails.getFloor());
                if (locationRegionList != null) {
                    for (LocationRegion locationRegion : locationRegionList) {
                        if (locationRegion.type != null) {
                            String type = locationRegion.type;
                            if (type.equals("freedom") || type.equals("boundary") || type.equals("lock")) {
                                continue;
                            }
                        }
                        AllLocationRegionList.add(locationRegion);
                    }
        }
        return AllLocationRegionList;
    }


    private void showAccessbilityText(NavigationData navData) {
        if(tvAccessbilityNavigation!=null){
            int bearDiff = navData.getBearDiff();

            if(bearDiff<45 || bearDiff >315){
                if(!TextUtils.isEmpty(navData.getNavigationText())) {
                    String voiceText = navData.getNavigationVoiceText();
                    if(!TextUtils.isEmpty(voiceText) && voiceText.contains(getString(R.string.epath_floor_change_key))){
                        if(voiceText.contains(getString(R.string.epath_escalator).toLowerCase()) && navData.getDistance()>1.5){
                            List<SAILS.GeoNode> nodes = pathRoutingManager.getCurrentAllPathRoundNodes();
                            double degreeDiff = getDegreeDiff(sails.getUserHeading(), new SAILS.GeoNode(sails.getLongitude(), sails.getLatitude()), nodes.get(nodes.size() - 1));
                            String escalatorHint = degreeToEscalatorHint(degreeDiff);
                            tvAccessbilityNavigation.setText(voiceText+escalatorHint);
                        }else{
                            tvAccessbilityNavigation.setText(voiceText);
                        }
                    }else{
                        tvAccessbilityNavigation.setText(navData.getNavigationText());
                    }
                }
            }else{
                if(bearDiff<135){//偏向右边了，提示左转
                    tvAccessbilityNavigation.setText(NavContentHandler.getDirectionString(EpConstants.DIRECTION_LEFT));
                }else if(bearDiff>225){//偏向左边了，提示右转
                    tvAccessbilityNavigation.setText(NavContentHandler.getDirectionString(EpConstants.DIRECTION_RIGHT));
                }else if(bearDiff<180){//方向反了，提示向左后方调头
                    tvAccessbilityNavigation.setText(NavContentHandler.getDirectionString(EpConstants.DIRECTION_BEHIND_LEFT));
                }else{//方向反了，提示向右后方调头
                    tvAccessbilityNavigation.setText(NavContentHandler.getDirectionString(EpConstants.DIRECTION_BEHIND_RIGHT));
                }
            }

            boolean isDirectionSoWrong;
            if(bearDiff<90 || bearDiff >270){
                isDirectionSoWrong = false;
            }else{
                isDirectionSoWrong = true;
            }

            if(isDirectionSoWrong != isPreDirectionSoWrong){
                isPreDirectionSoWrong = isDirectionSoWrong;
                if(isPreDirectionSoWrong){
                    vibrate();
                }
            }
        }
    }

    private String degreeToEscalatorHint(double degreeDiff) {
//        int i = ((int) (degreeDiff + 15)) / 30;
//        i = i == 0?12:i;
        int directionResId;
        L.e("hjxError",degreeDiff+"");
        if(degreeDiff<30 || degreeDiff > 330){
            directionResId = R.string.epath_direction_ahead;
        }else if(degreeDiff<=330 && degreeDiff >= 300){
            directionResId = R.string.epath_direction_left_front;
        }else if(degreeDiff>=30 && degreeDiff<=60){
            directionResId = R.string.epath_direction_right_front;
        }else if(degreeDiff>180){
            directionResId = R.string.epath_direction_left;
        }else{
            directionResId = R.string.epath_direction_right;
        }
        return getString(R.string.epath_hint_escalator,getString(directionResId));
    }


}
