/*
 * Decompiled with CFR 0.152.
 */
package com.shitu.epathmap.utils.voice.baidu;

import android.content.Context;
import com.baidu.tts.chainofresponsibility.logger.LoggerProxy;
import com.baidu.tts.client.SpeechError;
import com.baidu.tts.client.SpeechSynthesizer;
import com.baidu.tts.client.SpeechSynthesizerListener;
import com.baidu.tts.client.SynthesizerTool;
import com.baidu.tts.client.TtsMode;
import com.shitu.epathmap.EpathMapSDK;
import com.shitu.epathmap.utils.voice.SpeechListener;
import com.shitu.epathmap.utils.voice.Speecher;
import com.shitu.location.epathmap.EpathLocationSDK;
import com.shitu.location.epathmap.utils.L;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

public class BaiduSpeecher
implements SpeechSynthesizerListener,
Speecher {
    private String mSampleDirPath;
    private static String SAMPLE_DIR_NAME = "baiduTTS";
    private static final String SPEECH_FEMALE_MODEL_NAME = "bd_etts_common_speech_f7_mand_eng_high_am-mix_v3.0.0_20170512.dat";
    private static final String SPEECH_MALE_MODEL_NAME = "bd_etts_speech_male.dat";
    private static final String TEXT_MODEL_NAME = "bd_etts_text.dat";
    private static final String ENGLISH_SPEECH_FEMALE_MODEL_NAME = "bd_etts_speech_female_en.dat";
    private static final String ENGLISH_SPEECH_MALE_MODEL_NAME = "bd_etts_speech_male_en.dat";
    private static final String ENGLISH_TEXT_MODEL_NAME = "bd_etts_text_en.dat";
    public SpeechListener speechListener;
    private SpeechSynthesizer mSpeechSynthesizer;
    private Context context;

    public BaiduSpeecher(Context context) {
        this.context = context.getApplicationContext();
        this.initialEnv();
        this.initialTts();
    }

    private void initialTts() {
        this.mSpeechSynthesizer = SpeechSynthesizer.getInstance();
        this.mSpeechSynthesizer.setContext(EpathLocationSDK.context);
        this.mSpeechSynthesizer.setSpeechSynthesizerListener(this);
        this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_TTS_TEXT_MODEL_FILE, this.mSampleDirPath + "/" + TEXT_MODEL_NAME);
        this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_TTS_SPEECH_MODEL_FILE, this.mSampleDirPath + "/" + SPEECH_FEMALE_MODEL_NAME);
        if (EpathLocationSDK.appIdBD != null && EpathLocationSDK.apiKeyBD != null && EpathLocationSDK.secretKeyBD != null) {
            this.mSpeechSynthesizer.setAppId(EpathLocationSDK.appIdBD);
            this.mSpeechSynthesizer.setAppId(EpathLocationSDK.appIdBD);
            this.mSpeechSynthesizer.setApiKey(EpathLocationSDK.apiKeyBD, EpathLocationSDK.secretKeyBD);
        } else {
            this.mSpeechSynthesizer.setAppId("10467288");
            this.mSpeechSynthesizer.setApiKey("8eMSAqDrvtILjnPWZSLer0SD", "7159e6acffa07870ae618ca3eb8ed256");
        }
        this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_VOLUME, "9");
        this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_SPEAKER, "0");
        this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_MIX_MODE, SpeechSynthesizer.MIX_MODE_HIGH_SPEED_SYNTHESIZE);
        int n2 = this.mSpeechSynthesizer.initTts(TtsMode.MIX);
        int n3 = this.mSpeechSynthesizer.loadEnglishModel(this.mSampleDirPath + "/" + ENGLISH_TEXT_MODEL_NAME, this.mSampleDirPath + "/" + ENGLISH_SPEECH_FEMALE_MODEL_NAME);
        this.toPrint("loadEnglishModel result=" + n3);
        LoggerProxy.printable(true);
        this.printEngineInfo();
    }

    @Override
    public int speak(String string2) {
        return this.mSpeechSynthesizer.speak(string2);
    }

    @Override
    public int speak(String string2, String string3) {
        return this.mSpeechSynthesizer.speak(string2, string3);
    }

    @Override
    public int pause() {
        return this.mSpeechSynthesizer.pause();
    }

    @Override
    public int resume() {
        return this.mSpeechSynthesizer.resume();
    }

    @Override
    public int stop() {
        return this.mSpeechSynthesizer.stop();
    }

    @Override
    public void release() {
        this.mSpeechSynthesizer.release();
    }

    @Override
    public void setSpeechListener(SpeechListener speechListener) {
        this.speechListener = speechListener;
    }

    private void initialEnv() {
        if (this.mSampleDirPath == null) {
            String string2 = this.context.getFilesDir().getAbsolutePath();
            L.e((String)"sdcardPath:", (String)string2);
            SAMPLE_DIR_NAME = "baiduTTS" + EpathMapSDK.c;
            this.mSampleDirPath = string2 + "/" + SAMPLE_DIR_NAME;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                block11: {
                    int n2;
                    String string2;
                    File file;
                    String string3;
                    InputStream inputStream;
                    String string4;
                    File file2;
                    block10: {
                        BaiduSpeecher.this.makeDir(BaiduSpeecher.this.mSampleDirPath);
                        file2 = new File(BaiduSpeecher.this.mSampleDirPath);
                        try {
                            string4 = BaiduSpeecher.this.mSampleDirPath + "/" + BaiduSpeecher.SPEECH_FEMALE_MODEL_NAME;
                            inputStream = BaiduSpeecher.this.context.getResources().getAssets().open(BaiduSpeecher.SPEECH_FEMALE_MODEL_NAME);
                            string3 = BaiduSpeecher.getAsseFiletMD5(inputStream);
                            L.e((String)"asset SPEECH_FEMALE_MODEL_NAME ==  ", (String)string3);
                            BaiduSpeecher.this.copyFromAssetsToSdcard(false, BaiduSpeecher.SPEECH_FEMALE_MODEL_NAME, string4);
                            if (file2.exists()) {
                                file = new File(string4);
                                string2 = BaiduSpeecher.getFileMD5(file);
                                for (n2 = 0; n2 < 5; ++n2) {
                                    if (string2.equals(string3)) {
                                        L.e((String)"asset", (String)"SPEECH_FEMALE_MODEL_NAME \u6821\u9a8c\u6210\u529f");
                                        break block10;
                                    }
                                    L.e((String)"asset", (String)("SPEECH_FEMALE_MODEL_NAME \u6821\u9a8c\u5931\u8d25,\u6b63\u5728\u91cd\u65b0copy " + n2 + "\u6b21\u6570"));
                                    BaiduSpeecher.this.copyFromAssetsToSdcard(true, BaiduSpeecher.SPEECH_FEMALE_MODEL_NAME, string4);
                                    string2 = BaiduSpeecher.getFileMD5(file);
                                }
                                break block10;
                            }
                            L.e((String)"desSpeech", (String)"\u4e0d\u5b58\u5728");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    try {
                        string4 = BaiduSpeecher.this.mSampleDirPath + "/" + BaiduSpeecher.TEXT_MODEL_NAME;
                        inputStream = BaiduSpeecher.this.context.getResources().getAssets().open(BaiduSpeecher.TEXT_MODEL_NAME);
                        string3 = BaiduSpeecher.getAsseFiletMD5(inputStream);
                        L.e((String)"asset TEXT_MODEL_NAME ==  ", (String)string3);
                        BaiduSpeecher.this.copyFromAssetsToSdcard(false, BaiduSpeecher.TEXT_MODEL_NAME, string4);
                        if (file2.exists()) {
                            file = new File(string4);
                            string2 = BaiduSpeecher.getFileMD5(file);
                            for (n2 = 0; n2 < 5; ++n2) {
                                if (string2.equals(string3)) {
                                    L.e((String)"asset", (String)"TEXT_MODEL_NAME \u6821\u9a8c\u6210\u529f");
                                    break block11;
                                }
                                L.e((String)"asset", (String)("TEXT_MODEL_NAME \u6821\u9a8c\u5931\u8d25,\u6b63\u5728\u91cd\u65b0copy " + n2 + "\u6b21\u6570"));
                                BaiduSpeecher.this.copyFromAssetsToSdcard(true, BaiduSpeecher.TEXT_MODEL_NAME, string4);
                                string2 = BaiduSpeecher.getFileMD5(file);
                            }
                            break block11;
                        }
                        L.e((String)"desText", (String)"\u4e0d\u5b58\u5728");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }).start();
    }

    private static String getFileMD5(File file) throws NoSuchAlgorithmException, IOException {
        int n2;
        if (!file.isFile()) {
            return null;
        }
        byte[] byArray = new byte[1024];
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        FileInputStream fileInputStream = new FileInputStream(file);
        while ((n2 = fileInputStream.read(byArray, 0, 1024)) != -1) {
            messageDigest.update(byArray, 0, n2);
        }
        fileInputStream.close();
        BigInteger bigInteger = new BigInteger(1, messageDigest.digest());
        return bigInteger.toString(16);
    }

    private static String getAsseFiletMD5(InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        int n2;
        byte[] byArray = new byte[1024];
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        InputStream inputStream2 = inputStream;
        while ((n2 = inputStream2.read(byArray, 0, 1024)) != -1) {
            messageDigest.update(byArray, 0, n2);
        }
        inputStream2.close();
        BigInteger bigInteger = new BigInteger(1, messageDigest.digest());
        return bigInteger.toString(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFromAssetsToSdcard(boolean bl2, String string2, String string3) {
        File file = new File(string3);
        if (bl2 || !bl2 && !file.exists()) {
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                inputStream = this.context.getResources().getAssets().open(string2);
                String string4 = string3;
                fileOutputStream = new FileOutputStream(string4);
                byte[] byArray = new byte[1024];
                int n2 = 0;
                while ((n2 = inputStream.read(byArray, 0, 1024)) >= 0) {
                    fileOutputStream.write(byArray, 0, n2);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private void makeDir(String string2) {
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private void printEngineInfo() {
        this.toPrint("EngineVersioin=" + SynthesizerTool.getEngineVersion());
        this.toPrint("EngineInfo=" + SynthesizerTool.getEngineInfo());
        String string2 = SynthesizerTool.getModelInfo(this.mSampleDirPath + "/" + TEXT_MODEL_NAME);
        this.toPrint("textModelInfo=" + string2);
        String string3 = SynthesizerTool.getModelInfo(this.mSampleDirPath + "/" + SPEECH_FEMALE_MODEL_NAME);
        this.toPrint("speechModelInfo=" + string3);
    }

    public void toPrint(String string2) {
        L.d((String)"kdxf---", (String)string2);
    }

    @Override
    public void onSynthesizeStart(String string2) {
        this.toPrint("onSynthesizeStart utteranceId=" + string2);
    }

    @Override
    public void onSynthesizeDataArrived(String string2, byte[] byArray, int n2) {
        this.toPrint("onSynthesizeDataArrived");
    }

    @Override
    public void onSynthesizeFinish(String string2) {
        this.toPrint("onSynthesizeFinish utteranceId=" + string2);
    }

    @Override
    public void onSpeechStart(String string2) {
        if (this.speechListener != null) {
            this.speechListener.onSpeechStart();
        }
        if (!Locale.getDefault().getLanguage().equals("zh")) {
            this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_SPEED, "6");
        } else {
            this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_SPEED, "5");
        }
        this.toPrint("onSpeechStart utteranceId=" + string2);
    }

    @Override
    public void onSpeechProgressChanged(String string2, int n2) {
        this.toPrint("onSpeechProgressChanged" + n2);
    }

    @Override
    public void onSpeechFinish(String string2) {
        if (this.speechListener != null) {
            this.speechListener.onSpeechFinish();
        }
        this.toPrint("onSpeechFinish utteranceId=" + string2);
    }

    @Override
    public void onError(String string2, SpeechError speechError) {
        if (this.speechListener != null) {
            this.speechListener.onError();
        }
        this.toPrint("onSpeechFinish utteranceId=" + speechError.toString());
    }
}

