package com.shitu.epathmap.ui.adapter;

import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.shitu.epathmap.R;
import com.shitu.epathmap.ui.utils.GridSpacingItemDecoration;
import com.shitu.location.epathmap.model.bean.LocationRegionData;
import com.shitu.location.epathmap.model.bean.LocationRegionTagData;

import java.util.ArrayList;
import java.util.List;

import static com.shitu.epathmap.EpathMapSDK.context;

/**
 * Created by thinkpad on 2017/12/13.
 */

public class FloorBarConsoleAdapter extends BaseQuickAdapter<LocationRegionTagData, BaseViewHolder> {
    OnItemClickListener onItemClickListener;

    public FloorBarConsoleAdapter(int layoutResId, @Nullable List<LocationRegionTagData> data, OnItemClickListener onItemClickListener) {

        super(layoutResId, data);
        this.onItemClickListener = onItemClickListener;
    }

    @Override
    protected void convert(BaseViewHolder helper, LocationRegionTagData item) {
        helper.setText(R.id.tv_type, item.getName())
                .addOnClickListener(R.id.fl_more);
        helper.getView(R.id.fl_more).setContentDescription("Show more in "+item.getName());

//        Glide.with(mContext).load(item.getIconUrl()).crossFade().into((ImageView) helper.getView(R.id.iv_type));

        RecyclerView recyclerViewBar = helper.getView(R.id.recyclerViewBar);

        if (recyclerViewBar.getLayoutManager() == null) {
            recyclerViewBar.setLayoutManager(new GridLayoutManager(context, 4,
                    GridLayoutManager.VERTICAL,
                    false));
            recyclerViewBar.setHasFixedSize(true);
            recyclerViewBar.addItemDecoration(new GridSpacingItemDecoration(4,
                    context.getResources().getDimensionPixelOffset(R.dimen.epath_space),
                    true));
//            int width = DensityUtils.dp2px(context, 11);
//            recyclerViewBar.addItemDecoration(new DividerItemGridDecoration(width, 4));
        }

        List<LocationRegionData> locationRegionData = new ArrayList<>();
        List<LocationRegionData> locationRegionData1 = item.getLocationRegionDatas();
        if (locationRegionData1 != null) {
            for (LocationRegionData regionData : locationRegionData1) {
                if (locationRegionData.size() < 8)
                    locationRegionData.add(regionData);
            }
        }

//        locationRegionData.addAll(item.getLocationRegionDatas());
        FloorBarAdapter floorBarAdapter = new FloorBarAdapter(R.layout.item_floor_bar, locationRegionData);
        floorBarAdapter.openLoadAnimation();
        floorBarAdapter.setOnItemClickListener((adapter, view, position) ->
                onItemClickListener.onClick(locationRegionData.get(position))
        );
        recyclerViewBar.setAdapter(floorBarAdapter);
    }

    public interface OnItemClickListener {
        void onClick(LocationRegionData item);
    }
}
