/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.speech;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface SynthesizerListener
extends IInterface {
    public void onSpeakBegin() throws RemoteException;

    public void onSpeakPaused() throws RemoteException;

    public void onSpeakResumed() throws RemoteException;

    public void onCompleted(int var1) throws RemoteException;

    public void onSpeakProgress(int var1, int var2, int var3) throws RemoteException;

    public void onBufferProgress(int var1, int var2, int var3, String var4) throws RemoteException;

    public void onEvent(int var1, int var2, int var3, Bundle var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements SynthesizerListener {
        private static final String DESCRIPTOR = "com.iflytek.speech.SynthesizerListener";
        static final int TRANSACTION_onSpeakBegin = 1;
        static final int TRANSACTION_onSpeakPaused = 2;
        static final int TRANSACTION_onSpeakResumed = 3;
        static final int TRANSACTION_onCompleted = 4;
        static final int TRANSACTION_onSpeakProgress = 5;
        static final int TRANSACTION_onBufferProgress = 6;
        static final int TRANSACTION_onEvent = 7;

        public Stub() {
            Stub stub = this;
            stub.attachInterface(stub, DESCRIPTOR);
        }

        public static SynthesizerListener asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof SynthesizerListener) {
                return (SynthesizerListener)iInterface;
            }
            return new Proxy(iBinder);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int n2, Parcel object, Parcel parcel, int n3) throws RemoteException {
            switch (n2) {
                case 1598968902: {
                    parcel.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    object.enforceInterface(DESCRIPTOR);
                    this.onSpeakBegin();
                    return true;
                }
                case 2: {
                    object.enforceInterface(DESCRIPTOR);
                    this.onSpeakPaused();
                    return true;
                }
                case 3: {
                    object.enforceInterface(DESCRIPTOR);
                    this.onSpeakResumed();
                    return true;
                }
                case 4: {
                    object.enforceInterface(DESCRIPTOR);
                    n2 = object.readInt();
                    this.onCompleted(n2);
                    return true;
                }
                case 5: {
                    object.enforceInterface(DESCRIPTOR);
                    n2 = object.readInt();
                    int n4 = object.readInt();
                    n3 = object.readInt();
                    this.onSpeakProgress(n2, n4, n3);
                    return true;
                }
                case 6: {
                    object.enforceInterface(DESCRIPTOR);
                    n2 = object.readInt();
                    int n5 = object.readInt();
                    n3 = object.readInt();
                    object = object.readString();
                    this.onBufferProgress(n2, n5, n3, (String)object);
                    return true;
                }
                case 7: {
                    object.enforceInterface(DESCRIPTOR);
                    n2 = object.readInt();
                    int n6 = object.readInt();
                    n3 = object.readInt();
                    object = 0 != object.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(object) : null;
                    this.onEvent(n2, n6, n3, (Bundle)object);
                    return true;
                }
            }
            return super.onTransact(n2, object, parcel, n3);
        }

        private static class Proxy
        implements SynthesizerListener {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void onSpeakBegin() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onSpeakPaused() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onSpeakResumed() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onCompleted(int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n2);
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onSpeakProgress(int n2, int n3, int n4) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onBufferProgress(int n2, int n3, int n4, String string) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    parcel.writeString(string);
                    this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onEvent(int n2, int n3, int n4, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(7, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

