/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import android.text.TextUtils;
import com.baidu.tts.loopj.AsyncHttpClient;
import com.baidu.tts.loopj.Base64OutputStream;
import com.baidu.tts.loopj.JsonValueInterface;
import com.baidu.tts.loopj.RequestParams;
import com.baidu.tts.loopj.ResponseHandlerInterface;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonStreamerEntity
implements HttpEntity {
    private static final String LOG_TAG = "JsonStreamerEntity";
    private static final UnsupportedOperationException ERR_UNSUPPORTED = new UnsupportedOperationException("Unsupported operation in this implementation.");
    private static final int BUFFER_SIZE = 4096;
    private final byte[] buffer = new byte[4096];
    private static final byte[] JSON_TRUE = "true".getBytes();
    private static final byte[] JSON_FALSE = "false".getBytes();
    private static final byte[] JSON_NULL = "null".getBytes();
    private static final byte[] STREAM_NAME = JsonStreamerEntity.escape("name");
    private static final byte[] STREAM_TYPE = JsonStreamerEntity.escape("type");
    private static final byte[] STREAM_CONTENTS = JsonStreamerEntity.escape("contents");
    private static final Header HEADER_JSON_CONTENT = new BasicHeader("Content-Type", "application/json");
    private static final Header HEADER_GZIP_ENCODING = new BasicHeader("Content-Encoding", "gzip");
    private final Map<String, Object> jsonParams = new HashMap<String, Object>();
    private final Header contentEncoding;
    private final byte[] elapsedField;
    private final ResponseHandlerInterface progressHandler;

    public JsonStreamerEntity(ResponseHandlerInterface responseHandlerInterface, boolean bl2, String string) {
        this.progressHandler = responseHandlerInterface;
        this.contentEncoding = bl2 ? HEADER_GZIP_ENCODING : null;
        this.elapsedField = TextUtils.isEmpty((CharSequence)string) ? null : JsonStreamerEntity.escape(string);
    }

    public void addPart(String string, Object object) {
        this.jsonParams.put(string, object);
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isStreaming() {
        return false;
    }

    public long getContentLength() {
        return -1L;
    }

    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    public Header getContentType() {
        return HEADER_JSON_CONTENT;
    }

    public void consumeContent() throws IOException, UnsupportedOperationException {
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw ERR_UNSUPPORTED;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalStateException("Output stream cannot be null.");
        }
        long l2 = System.currentTimeMillis();
        outputStream = this.contentEncoding != null ? new GZIPOutputStream(outputStream, 4096) : outputStream;
        outputStream.write(123);
        Set<String> set = this.jsonParams.keySet();
        int n2 = set.size();
        if (n2 > 0) {
            int n3 = 0;
            for (String string : set) {
                ++n3;
                try {
                    Object object = this.jsonParams.get(string);
                    outputStream.write(JsonStreamerEntity.escape(string));
                    outputStream.write(58);
                    if (object == null) {
                        outputStream.write(JSON_NULL);
                        continue;
                    }
                    boolean bl2 = object instanceof RequestParams.FileWrapper;
                    if (bl2 || object instanceof RequestParams.StreamWrapper) {
                        outputStream.write(123);
                        if (bl2) {
                            this.writeToFromFile(outputStream, (RequestParams.FileWrapper)object);
                        } else {
                            this.writeToFromStream(outputStream, (RequestParams.StreamWrapper)object);
                        }
                        outputStream.write(125);
                        continue;
                    }
                    if (object instanceof JsonValueInterface) {
                        outputStream.write(((JsonValueInterface)object).getEscapedJsonValue());
                        continue;
                    }
                    if (object instanceof JSONObject) {
                        outputStream.write(object.toString().getBytes());
                        continue;
                    }
                    if (object instanceof JSONArray) {
                        outputStream.write(object.toString().getBytes());
                        continue;
                    }
                    if (object instanceof Boolean) {
                        outputStream.write((Boolean)object != false ? JSON_TRUE : JSON_FALSE);
                        continue;
                    }
                    if (object instanceof Long) {
                        outputStream.write(("" + ((Number)object).longValue()).getBytes());
                        continue;
                    }
                    if (object instanceof Double) {
                        outputStream.write(("" + ((Number)object).doubleValue()).getBytes());
                        continue;
                    }
                    if (object instanceof Float) {
                        outputStream.write(("" + ((Number)object).floatValue()).getBytes());
                        continue;
                    }
                    if (object instanceof Integer) {
                        outputStream.write(("" + ((Number)object).intValue()).getBytes());
                        continue;
                    }
                    outputStream.write(JsonStreamerEntity.escape(object.toString()));
                }
                finally {
                    if (this.elapsedField == null && n3 >= n2) continue;
                    outputStream.write(44);
                }
            }
            long l3 = System.currentTimeMillis() - l2;
            if (this.elapsedField != null) {
                outputStream.write(this.elapsedField);
                outputStream.write(58);
                outputStream.write(String.valueOf(l3).getBytes());
            }
            AsyncHttpClient.log.i(LOG_TAG, "Uploaded JSON in " + Math.floor(l3 / 1000L) + " seconds");
        }
        outputStream.write(125);
        outputStream.flush();
        AsyncHttpClient.silentCloseOutputStream(outputStream);
    }

    private void writeToFromStream(OutputStream outputStream, RequestParams.StreamWrapper streamWrapper) throws IOException {
        int n2;
        this.writeMetaData(outputStream, streamWrapper.name, streamWrapper.contentType);
        Base64OutputStream base64OutputStream = new Base64OutputStream(outputStream, 18);
        while ((n2 = streamWrapper.inputStream.read(this.buffer)) != -1) {
            base64OutputStream.write(this.buffer, 0, n2);
        }
        AsyncHttpClient.silentCloseOutputStream(base64OutputStream);
        this.endMetaData(outputStream);
        if (streamWrapper.autoClose) {
            AsyncHttpClient.silentCloseInputStream(streamWrapper.inputStream);
        }
    }

    private void writeToFromFile(OutputStream outputStream, RequestParams.FileWrapper fileWrapper) throws IOException {
        int n2;
        this.writeMetaData(outputStream, fileWrapper.file.getName(), fileWrapper.contentType);
        long l2 = 0L;
        long l3 = fileWrapper.file.length();
        FileInputStream fileInputStream = new FileInputStream(fileWrapper.file);
        Base64OutputStream base64OutputStream = new Base64OutputStream(outputStream, 18);
        while ((n2 = fileInputStream.read(this.buffer)) != -1) {
            base64OutputStream.write(this.buffer, 0, n2);
            this.progressHandler.sendProgressMessage(l2 += (long)n2, l3);
        }
        AsyncHttpClient.silentCloseOutputStream(base64OutputStream);
        this.endMetaData(outputStream);
        AsyncHttpClient.silentCloseInputStream(fileInputStream);
    }

    private void writeMetaData(OutputStream outputStream, String string, String string2) throws IOException {
        outputStream.write(STREAM_NAME);
        outputStream.write(58);
        outputStream.write(JsonStreamerEntity.escape(string));
        outputStream.write(44);
        outputStream.write(STREAM_TYPE);
        outputStream.write(58);
        outputStream.write(JsonStreamerEntity.escape(string2));
        outputStream.write(44);
        outputStream.write(STREAM_CONTENTS);
        outputStream.write(58);
        outputStream.write(34);
    }

    private void endMetaData(OutputStream outputStream) throws IOException {
        outputStream.write(34);
    }

    static byte[] escape(String string) {
        if (string == null) {
            return JSON_NULL;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append('\"');
        int n2 = string.length();
        int n3 = -1;
        block9: while (++n3 < n2) {
            char c2 = string.charAt(n3);
            switch (c2) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block9;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block9;
                }
            }
            if (c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f' || c2 >= '\u2000' && c2 <= '\u20ff') {
                String string2 = Integer.toHexString(c2);
                stringBuilder.append("\\u");
                int n4 = 4 - string2.length();
                for (int i2 = 0; i2 < n4; ++i2) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string2.toUpperCase(Locale.US));
                continue;
            }
            stringBuilder.append(c2);
        }
        stringBuilder.append('\"');
        return stringBuilder.toString().getBytes();
    }
}

