package com.shitu.epathmap.ui.widget;

import android.app.Dialog;
import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;

import com.shitu.epathmap.R;

public class FinishFindCarCenterDialog {
    private Dialog dialog;
    private View contentView;
    private Context context;

    private ImageView ivCloseFindCar;
    private TextView tvConfirm;
    private TextView tvCancle;


    public FinishFindCarCenterDialog(Context context,
                                     View.OnClickListener findCarOnClickListener,
                                     View.OnClickListener cancleOnclickListener
    ) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.dialog_finish_find_car, null);



        ivCloseFindCar = (ImageView) contentView.findViewById(R.id.iv_close_find_car);
        tvConfirm = (TextView) contentView.findViewById(R.id.tv_confirm);
        tvCancle = (TextView) contentView.findViewById(R.id.tv_cancle);

        ivCloseFindCar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });

        tvConfirm.setOnClickListener(findCarOnClickListener);
        tvCancle.setOnClickListener(cancleOnclickListener);
        dialog = new Dialog(context);
        dialog.setContentView(contentView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.MATCH_PARENT));
        dialog.setCanceledOnTouchOutside(true);
        Window win = dialog.getWindow();
        win.getDecorView().setPadding(20, 20, 20, 20);
        WindowManager.LayoutParams lp = win.getAttributes();
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        win.setAttributes(lp);
        win.setGravity(Gravity.CENTER);
        dialog.setCancelable(true);
    }


    public void show() {
        if (dialog.isShowing()) {
            return;
        }
        dialog.show();
    }

    public void dismiss() {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }


}
