/*
 * Decompiled with CFR 0.152.
 */
package com.shitu.epathmap.utils.voice;

import android.content.Context;
import android.text.TextUtils;
import com.shitu.epathmap.R;
import com.shitu.epathmap.utils.NumUtil;
import com.shitu.epathmap.utils.voice.SpeechListener;
import com.shitu.epathmap.utils.voice.Speecher;
import com.shitu.epathmap.utils.voice.SpeecherFactory;
import com.shitu.location.epathmap.utils.L;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class VoiceManager
implements SpeechListener {
    Context context;
    private Speecher speecher;
    ArrayList<String> speakList = new ArrayList();
    private TimerSpeakTask task;
    private boolean isStartFlag = false;
    private String lastBuilding;
    static long temp = 0L;
    static Date curentTime = null;
    private Boolean isPlaying = Boolean.FALSE;
    private long timeStep;
    private String asseFiletMD5Speech;
    private String asseFiletMD5Text;
    private ScheduledExecutorService scheduledThreadPool;
    private boolean isMute;
    private static volatile VoiceManager instance;

    private VoiceManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VoiceManager getInstance(Context context, String string2) {
        if (instance != null) return instance;
        Class<VoiceManager> clazz = VoiceManager.class;
        synchronized (VoiceManager.class) {
            if (instance != null) return instance;
            instance = new VoiceManager(context, string2);
            temp = System.currentTimeMillis() - 5000L;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return instance;
        }
    }

    private VoiceManager(Context context, String string2) {
        this.context = context;
        this.scheduledThreadPool = Executors.newScheduledThreadPool(1);
        this.task = new TimerSpeakTask();
        this.startNavTimerTask();
        this.speecher = SpeecherFactory.provideSpeecher(context, string2, this);
    }

    private void startNavTimerTask() {
        this.scheduledThreadPool.scheduleAtFixedRate(this.task, 0L, 100L, TimeUnit.MILLISECONDS);
        this.isStartFlag = true;
    }

    public void stopSpeaking() {
        if (this.speecher != null) {
            this.speecher.stop();
        }
    }

    @Override
    public void onSpeechFinish() {
        curentTime = new Date();
        temp = curentTime.getTime();
        this.isPlaying = Boolean.FALSE;
    }

    @Override
    public void onError() {
        curentTime = new Date();
        this.isPlaying = Boolean.FALSE;
        temp = curentTime.getTime();
    }

    @Override
    public void onSpeechStart() {
        this.isPlaying = Boolean.TRUE;
    }

    public boolean textToVoice(String string2) {
        if (!this.isPlaying.booleanValue()) {
            curentTime = new Date();
            this.timeStep = curentTime.getTime() - temp;
            if (this.timeStep > 3000L) {
                this.speakList.add(string2);
                return true;
            }
            return false;
        }
        return false;
    }

    public void kdxfTextToVoice(String string2) {
        if (this.runSpeak(string2, "" + curentTime) < 0) {
            this.toPrint("error,please look up error code in doc or URL:http://yuyin.baidu.com/docs/tts/122 ");
        }
    }

    public void clear() {
        this.speakList.clear();
    }

    public void destroy() {
        this.speecher.release();
        this.scheduledThreadPool.shutdown();
        this.isStartFlag = false;
        instance = null;
    }

    public boolean textToVoice(String string2, boolean bl2) {
        if (bl2) {
            this.clear();
            this.speecher.stop();
            if (this.runSpeak(string2, null) < 0) {
                this.toPrint("error,please look up error code in doc or URL:http://yuyin.baidu.com/docs/tts/122 ");
            }
            return true;
        }
        return this.textToVoice(string2);
    }

    private String replaceNumberIfEn(String string2) {
        if (!Locale.getDefault().getLanguage().equals("zh")) {
            if (string2.contains("120")) {
                string2 = string2.replace("120", "One hundred and twenty");
            } else if (string2.contains("45")) {
                string2 = string2.replace("45", "Forty-five");
            }
            String string3 = Pattern.compile("[^0-9]").matcher(string2).replaceAll("").trim();
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                String string4 = string3;
                return string2.replace(string4, NumUtil.analyze(string4));
            }
        }
        return string2;
    }

    public boolean textToVoiceFloor(String string2, boolean bl2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            string2 = string2.replace("-", this.context.getString(R.string.epath_negative));
        }
        if (bl2) {
            this.clear();
            this.speecher.stop();
            if (this.runSpeak(string2, null) < 0) {
                this.toPrint("error,please look up error code in doc or URL:http://yuyin.baidu.com/docs/tts/122 ");
            }
            return true;
        }
        return this.textToVoice(string2);
    }

    private int runSpeak(String string2, String string3) {
        if (this.isMute) {
            return -1;
        }
        return this.speecher.speak(string2, string3);
    }

    public void toPrint(String string2) {
        L.d((String)"kdxf---", (String)string2);
    }

    public void turnOff() {
        if (this.speecher != null) {
            this.speecher.stop();
            this.isMute = true;
        }
    }

    public void turnOn() {
        if (this.speecher != null) {
            this.clear();
            this.isMute = false;
        }
    }

    private class TimerSpeakTask
    extends TimerTask {
        private TimerSpeakTask() {
        }

        @Override
        public void run() {
            if (!VoiceManager.this.speakList.isEmpty()) {
                VoiceManager.this.kdxfTextToVoice(VoiceManager.this.speakList.remove(0));
            }
        }
    }
}

